#include <PickVarInfo.h>
#include <DataNode.h>
#include <stdio.h>

//
// Enum conversion methods for PickVarInfo::Centering
//

static const char *Centering_strings[] = {
"Nodal", "Zonal", "None"
};

std::string
PickVarInfo::Centering_ToString(PickVarInfo::Centering t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Centering_strings[index];
}

std::string
PickVarInfo::Centering_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Centering_strings[index];
}

bool
PickVarInfo::Centering_FromString(const std::string &s, PickVarInfo::Centering &val)
{
    val = PickVarInfo::Nodal;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Centering_strings[i])
        {
            val = (Centering)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: PickVarInfo::PickVarInfo
//
// Purpose: 
//   Constructor for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickVarInfo::PickVarInfo() : AttributeSubject("sss*d*s*d*bisi*s*i*b")
{
    mixVar = false;
    centering = None;
    treatAsASCII = false;
}

// ****************************************************************************
// Method: PickVarInfo::PickVarInfo
//
// Purpose: 
//   Copy constructor for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickVarInfo::PickVarInfo(const PickVarInfo &obj) : AttributeSubject("sss*d*s*d*bisi*s*i*b")
{
    variableName = obj.variableName;
    variableType = obj.variableType;
    names = obj.names;
    values = obj.values;
    mixNames = obj.mixNames;
    mixValues = obj.mixValues;
    mixVar = obj.mixVar;
    centering = obj.centering;
    miscMessage = obj.miscMessage;
    numMatsPerZone = obj.numMatsPerZone;
    matNames = obj.matNames;
    numSpecsPerMat = obj.numSpecsPerMat;
    treatAsASCII = obj.treatAsASCII;

    SelectAll();
}

// ****************************************************************************
// Method: PickVarInfo::~PickVarInfo
//
// Purpose: 
//   Destructor for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickVarInfo::~PickVarInfo()
{
    // nothing here
}

// ****************************************************************************
// Method: PickVarInfo::operator = 
//
// Purpose: 
//   Assignment operator for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickVarInfo::operator = (const PickVarInfo &obj)
{
    variableName = obj.variableName;
    variableType = obj.variableType;
    names = obj.names;
    values = obj.values;
    mixNames = obj.mixNames;
    mixValues = obj.mixValues;
    mixVar = obj.mixVar;
    centering = obj.centering;
    miscMessage = obj.miscMessage;
    numMatsPerZone = obj.numMatsPerZone;
    matNames = obj.matNames;
    numSpecsPerMat = obj.numSpecsPerMat;
    treatAsASCII = obj.treatAsASCII;

    SelectAll();
}

// ****************************************************************************
// Method: PickVarInfo::operator == 
//
// Purpose: 
//   Comparison operator == for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickVarInfo::operator == (const PickVarInfo &obj) const
{
    // Create the return value
    return ((variableName == obj.variableName) &&
            (variableType == obj.variableType) &&
            (names == obj.names) &&
            (values == obj.values) &&
            (mixNames == obj.mixNames) &&
            (mixValues == obj.mixValues) &&
            (mixVar == obj.mixVar) &&
            (centering == obj.centering) &&
            (miscMessage == obj.miscMessage) &&
            (numMatsPerZone == obj.numMatsPerZone) &&
            (matNames == obj.matNames) &&
            (numSpecsPerMat == obj.numSpecsPerMat) &&
            (treatAsASCII == obj.treatAsASCII));
}

// ****************************************************************************
// Method: PickVarInfo::operator != 
//
// Purpose: 
//   Comparison operator != for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickVarInfo::operator != (const PickVarInfo &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PickVarInfo::TypeName
//
// Purpose: 
//   Type name method for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
PickVarInfo::TypeName() const
{
    return "PickVarInfo";
}

// ****************************************************************************
// Method: PickVarInfo::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickVarInfo::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PickVarInfo *tmp = (const PickVarInfo *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PickVarInfo::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PickVarInfo::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PickVarInfo(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PickVarInfo::NewInstance
//
// Purpose: 
//   NewInstance method for the PickVarInfo class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PickVarInfo::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PickVarInfo(*this);
    else
        retval = new PickVarInfo;

    return retval;
}

// ****************************************************************************
// Method: PickVarInfo::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickVarInfo::SelectAll()
{
    Select(0, (void *)&variableName);
    Select(1, (void *)&variableType);
    Select(2, (void *)&names);
    Select(3, (void *)&values);
    Select(4, (void *)&mixNames);
    Select(5, (void *)&mixValues);
    Select(6, (void *)&mixVar);
    Select(7, (void *)&centering);
    Select(8, (void *)&miscMessage);
    Select(9, (void *)&numMatsPerZone);
    Select(10, (void *)&matNames);
    Select(11, (void *)&numSpecsPerMat);
    Select(12, (void *)&treatAsASCII);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PickVarInfo::SetVariableName(const std::string &variableName_)
{
    variableName = variableName_;
    Select(0, (void *)&variableName);
}

void
PickVarInfo::SetVariableType(const std::string &variableType_)
{
    variableType = variableType_;
    Select(1, (void *)&variableType);
}

void
PickVarInfo::SetNames(const stringVector &names_)
{
    names = names_;
    Select(2, (void *)&names);
}

void
PickVarInfo::SetValues(const doubleVector &values_)
{
    values = values_;
    Select(3, (void *)&values);
}

void
PickVarInfo::SetMixNames(const stringVector &mixNames_)
{
    mixNames = mixNames_;
    Select(4, (void *)&mixNames);
}

void
PickVarInfo::SetMixValues(const doubleVector &mixValues_)
{
    mixValues = mixValues_;
    Select(5, (void *)&mixValues);
}

void
PickVarInfo::SetMixVar(bool mixVar_)
{
    mixVar = mixVar_;
    Select(6, (void *)&mixVar);
}

void
PickVarInfo::SetCentering(PickVarInfo::Centering centering_)
{
    centering = centering_;
    Select(7, (void *)&centering);
}

void
PickVarInfo::SetMiscMessage(const std::string &miscMessage_)
{
    miscMessage = miscMessage_;
    Select(8, (void *)&miscMessage);
}

void
PickVarInfo::SetNumMatsPerZone(const intVector &numMatsPerZone_)
{
    numMatsPerZone = numMatsPerZone_;
    Select(9, (void *)&numMatsPerZone);
}

void
PickVarInfo::SetMatNames(const stringVector &matNames_)
{
    matNames = matNames_;
    Select(10, (void *)&matNames);
}

void
PickVarInfo::SetNumSpecsPerMat(const intVector &numSpecsPerMat_)
{
    numSpecsPerMat = numSpecsPerMat_;
    Select(11, (void *)&numSpecsPerMat);
}

void
PickVarInfo::SetTreatAsASCII(bool treatAsASCII_)
{
    treatAsASCII = treatAsASCII_;
    Select(12, (void *)&treatAsASCII);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
PickVarInfo::GetVariableName() const
{
    return variableName;
}

std::string &
PickVarInfo::GetVariableName()
{
    return variableName;
}

const std::string &
PickVarInfo::GetVariableType() const
{
    return variableType;
}

std::string &
PickVarInfo::GetVariableType()
{
    return variableType;
}

const stringVector &
PickVarInfo::GetNames() const
{
    return names;
}

stringVector &
PickVarInfo::GetNames()
{
    return names;
}

const doubleVector &
PickVarInfo::GetValues() const
{
    return values;
}

doubleVector &
PickVarInfo::GetValues()
{
    return values;
}

const stringVector &
PickVarInfo::GetMixNames() const
{
    return mixNames;
}

stringVector &
PickVarInfo::GetMixNames()
{
    return mixNames;
}

const doubleVector &
PickVarInfo::GetMixValues() const
{
    return mixValues;
}

doubleVector &
PickVarInfo::GetMixValues()
{
    return mixValues;
}

bool
PickVarInfo::GetMixVar() const
{
    return mixVar;
}

PickVarInfo::Centering
PickVarInfo::GetCentering() const
{
    return Centering(centering);
}

const std::string &
PickVarInfo::GetMiscMessage() const
{
    return miscMessage;
}

std::string &
PickVarInfo::GetMiscMessage()
{
    return miscMessage;
}

const intVector &
PickVarInfo::GetNumMatsPerZone() const
{
    return numMatsPerZone;
}

intVector &
PickVarInfo::GetNumMatsPerZone()
{
    return numMatsPerZone;
}

const stringVector &
PickVarInfo::GetMatNames() const
{
    return matNames;
}

stringVector &
PickVarInfo::GetMatNames()
{
    return matNames;
}

const intVector &
PickVarInfo::GetNumSpecsPerMat() const
{
    return numSpecsPerMat;
}

intVector &
PickVarInfo::GetNumSpecsPerMat()
{
    return numSpecsPerMat;
}

bool
PickVarInfo::GetTreatAsASCII() const
{
    return treatAsASCII;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PickVarInfo::SelectVariableName()
{
    Select(0, (void *)&variableName);
}

void
PickVarInfo::SelectVariableType()
{
    Select(1, (void *)&variableType);
}

void
PickVarInfo::SelectNames()
{
    Select(2, (void *)&names);
}

void
PickVarInfo::SelectValues()
{
    Select(3, (void *)&values);
}

void
PickVarInfo::SelectMixNames()
{
    Select(4, (void *)&mixNames);
}

void
PickVarInfo::SelectMixValues()
{
    Select(5, (void *)&mixValues);
}

void
PickVarInfo::SelectMiscMessage()
{
    Select(8, (void *)&miscMessage);
}

void
PickVarInfo::SelectNumMatsPerZone()
{
    Select(9, (void *)&numMatsPerZone);
}

void
PickVarInfo::SelectMatNames()
{
    Select(10, (void *)&matNames);
}

void
PickVarInfo::SelectNumSpecsPerMat()
{
    Select(11, (void *)&numSpecsPerMat);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickVarInfo::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
PickVarInfo::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "variableName";
        case 1:  return "variableType";
        case 2:  return "names";
        case 3:  return "values";
        case 4:  return "mixNames";
        case 5:  return "mixValues";
        case 6:  return "mixVar";
        case 7:  return "centering";
        case 8:  return "miscMessage";
        case 9:  return "numMatsPerZone";
        case 10:  return "matNames";
        case 11:  return "numSpecsPerMat";
        case 12:  return "treatAsASCII";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PickVarInfo::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PickVarInfo::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_string;
        case 2:  return FieldType_stringVector;
        case 3:  return FieldType_doubleVector;
        case 4:  return FieldType_stringVector;
        case 5:  return FieldType_doubleVector;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_enum;
        case 8:  return FieldType_string;
        case 9:  return FieldType_intVector;
        case 10:  return FieldType_stringVector;
        case 11:  return FieldType_intVector;
        case 12:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PickVarInfo::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
PickVarInfo::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "string";
        case 2:  return "stringVector";
        case 3:  return "doubleVector";
        case 4:  return "stringVector";
        case 5:  return "doubleVector";
        case 6:  return "bool";
        case 7:  return "enum";
        case 8:  return "string";
        case 9:  return "intVector";
        case 10:  return "stringVector";
        case 11:  return "intVector";
        case 12:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PickVarInfo::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jul 22 12:07:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickVarInfo::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PickVarInfo &obj = *((const PickVarInfo*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (variableName == obj.variableName);
        }
        break;
    case 1:
        {  // new scope
        retval = (variableType == obj.variableType);
        }
        break;
    case 2:
        {  // new scope
        retval = (names == obj.names);
        }
        break;
    case 3:
        {  // new scope
        retval = (values == obj.values);
        }
        break;
    case 4:
        {  // new scope
        retval = (mixNames == obj.mixNames);
        }
        break;
    case 5:
        {  // new scope
        retval = (mixValues == obj.mixValues);
        }
        break;
    case 6:
        {  // new scope
        retval = (mixVar == obj.mixVar);
        }
        break;
    case 7:
        {  // new scope
        retval = (centering == obj.centering);
        }
        break;
    case 8:
        {  // new scope
        retval = (miscMessage == obj.miscMessage);
        }
        break;
    case 9:
        {  // new scope
        retval = (numMatsPerZone == obj.numMatsPerZone);
        }
        break;
    case 10:
        {  // new scope
        retval = (matNames == obj.matNames);
        }
        break;
    case 11:
        {  // new scope
        retval = (numSpecsPerMat == obj.numSpecsPerMat);
        }
        break;
    case 12:
        {  // new scope
        retval = (treatAsASCII == obj.treatAsASCII);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickVarInfo::PrintSelf
//
// Purpose: 
//   Prints the contents of this class to the passed stream. 
//
// Modifications:
//   Kathleen Bonnell, Thu Jun 26 09:31:56 PDT 2003
//   Logic changed in order to support node picking. Info from material var's 
//   now handled differently. 
//   
//   Kathleen Bonnell, Thu Nov 20 10:18:54 PST 2003
//   Support species variableType. 
// 
// ****************************************************************************

void
PickVarInfo::PrintSelf(ostream &os)
{
    int i, j, k, nMats, matOffset, mixOffset;
    os << variableName.c_str() << ":  ";
    switch (centering)
    {
        case Nodal:  os << "nodal " ; break;
        case Zonal:  os << "zonal " ; break;
        case None : break;
    }
    if (!(names.empty() && mixNames.empty()))
    {  
        if (variableType == "material")
        {
            mixOffset = 0; 
            for (i = 0; i < numMatsPerZone.size(); i++)
            {
                if (names.size() > 0)
                    os << "    " << names[i].c_str() << "\n";
                nMats = numMatsPerZone[i];
                for (j = 0; j < nMats; j++)
                {
                    if (names.size() > 0)
                        os << "    "; 
                    os << "    " << mixNames[j+mixOffset].c_str();
                    if (mixValues[j+mixOffset] < 1.)
                        os << " = " << mixValues[j+mixOffset];
                    os << "\n";
                }
                mixOffset += nMats;
            }
        }
        else if (variableType == "species")
        {
            matOffset = 0;
            mixOffset = 0; 
            for (i = 0; i < numMatsPerZone.size(); i++)
            {
                if (names.size() > 0)
                {
                    os << "    " << names[i].c_str();
                    if (values.size() > 0)
                        os << " = " << values[i] << "\n";
                }
                nMats = numMatsPerZone[i];
                for (j = 0; j < nMats; j++)
                {
                    os << "    " << matNames[j+matOffset].c_str() << "\n";
                    int nSpecs = numSpecsPerMat[j+matOffset];
                    for (k = 0; k < nSpecs; k++)
                    {
                        os << "        " << mixNames[k+mixOffset].c_str();
                        os << " =  " << mixValues[k+mixOffset] << "\n";
                    }
                    mixOffset += nSpecs;
                }
                matOffset += nMats;
            }
        }
        else 
        {
            mixOffset = 0; 
            for (i = 0; i < names.size(); i++)
            {
                os << "    " << names[i].c_str() << " = ";
                if (values.size() > names.size())
                {
                    int stride = values.size() / names.size();
                    os << "(";
                    for (j = 0; j < stride; j++)
                    {
                        os << values[i*stride + j] << ", " ;
                    }
                    os << ")\n";
                }
                else if (values.size() == names.size())
                {
                    os << values[i] << "\n" ;
                }
                if (mixVar)
                {
                    nMats = numMatsPerZone[i]; 
                    for (j = 0; j < nMats; j++)
                    {
                        os << "        " << mixNames[j+mixOffset].c_str();
                        os << " = " <<  mixValues[j+mixOffset] << "\n";
                    }
                    mixOffset += nMats;
                }
            }
        }
    }
    else if (!miscMessage.empty())
    {
        os << "    " << miscMessage.c_str() << "\n";
    }
    else
    {
        os << "    No Information Found\n";
    }
}


// ****************************************************************************
// Method: PickVarInfo::CreateOutputString
//
// Purpose: 
//   Creates a single output string containing all the information gathered 
//   from a pick.
//
// Modifications:
//   Kathleen Bonnell, Thu Jun 26 09:31:56 PDT 2003
//   Logic changed in order to support node picking. Info from material vars 
//   now handled differently. 
//   
//   Hank Childs, Mon Sep 22 11:19:22 PDT 2003
//   Extend for tensors.
//
//   Kathleen Bonnell, Thu Nov 20 10:18:54 PST 2003
//   Support species variableType. 
// 
//   Kathleen Bonnell, Wed Dec 17 15:19:46 PST 2003 
//   Added arg 'type' indicating the type of pick that generated this info. 
// 
//   Kathleen Bonnell, Tue Jun  1 16:42:46 PDT 2004
//   Added DomainNode and DomainZone as pick types.
// 
//   Kathleen Bonnell, Thu Jun 10 17:31:37 PDT 2004 
//   Reduce whitespace for material vars. 
// 
//   Kathleen Bonnell, Thu Jul 22 12:06:53 PDT 2004 
//   Cast values to char if treatAsASCII is true.
// 
// ****************************************************************************
void
PickVarInfo::CreateOutputString(std::string &os, const std::string &type)
{
    int i, j, k;
    int matOffset = 0, mixOffset = 0;
    int nMats;
    char buff[256];
    os = variableName;
    os +=  ":  ";
    bool centeringsMatch = false;
    switch (centering)
    {
        case Nodal:  os += "<nodal> " ; 
                     if (type == "Node" || type == "DomainNode")
                         centeringsMatch = true;
                     break;
        case Zonal:  os += "<zonal> " ; 
                     if (type == "Zone" || type == "DomainZone") 
                         centeringsMatch = true;
                     break;
        case None :  if (variableType == "material" &&
                         numMatsPerZone.size() == 1 && numMatsPerZone[0] == 1)
                         ;         
                     else
                         os += "\n";         
                     break;
    }
    if (!(names.empty() && mixNames.empty()))
    {  
        if (variableType == "material")
        {
            mixOffset  = 0;
            std::string spacing;
            if (numMatsPerZone.size() == 1 && numMatsPerZone[0] == 1)
            {
                if (names.size() > 0)
                {
                    SNPRINTF(buff, 256, "%s ", names[0].c_str());
                    os += buff; 
                }
                SNPRINTF(buff, 256, "%s ", mixNames[mixOffset].c_str());
                os += buff;
                if (mixValues[mixOffset] < 1.)
                {
                    SNPRINTF(buff, 256, "= %g", mixValues[mixOffset]);
                    os += buff;
                }
                os += "\n";
            }
            else
            {
                for (i = 0; i < numMatsPerZone.size(); i++)
                {
                    nMats = numMatsPerZone[i];
                    if (names.size() > 0)
                    {
                        SNPRINTF(buff, 256, "    %s", names[i].c_str());
                        os += buff; 
                        if (nMats == 1)
                            spacing = "  ";
                        else
                        {
                            os += "\n"; 
                            spacing = "        ";
                        }
                    }
                    else
                        spacing = "    ";
                    for (j = 0; j < nMats; j++)
                    {
                        SNPRINTF(buff, 256, "%s%s ", spacing.c_str(), 
                                 mixNames[j+mixOffset].c_str());
                        os += buff;
                        if (mixValues[j+mixOffset] < 1.)
                        {
                            SNPRINTF(buff, 256, "= %g", mixValues[j+mixOffset]);
                            os += buff;
                        }
                        os += "\n";
                    }
                    mixOffset += nMats;
                }
            }
        }
        else if (variableType == "species")
        {
            os += "\n";
            matOffset  = 0;
            mixOffset  = 0;
            std::string spacing1;
            std::string spacing2;
            for (i = 0; i < numMatsPerZone.size(); i++)
            {
                if (names.size() > 0)
                {
                    if (values.size() > 0)
                    {
                        SNPRINTF(buff, 256, "    %s = %g\n", names[i].c_str(),
                                 values[i]);
                    }
                    else
                    {
                        SNPRINTF(buff, 256, "    %s\n", names[i].c_str());
                    }
                    os += buff; 
                    spacing1 = "        ";
                    spacing2 = "            ";
                }
                else
                {
                    spacing1 = "    ";
                    spacing2 = "        ";
                }
                nMats = numMatsPerZone[i];
                for (j = 0; j < nMats; j++)
                {
                    SNPRINTF(buff, 256, "%s%s\n", spacing1.c_str(), 
                             matNames[j+matOffset].c_str());
                    os += buff;
                    int nSpecs = numSpecsPerMat[j+matOffset];
                    for (k = 0; k < nSpecs; k++)
                    {
                        SNPRINTF(buff, 256, "%s%s  ", spacing2.c_str(), 
                                 mixNames[k+mixOffset].c_str());
                        os += buff;
                        SNPRINTF(buff, 256, "= %g\n", mixValues[k+mixOffset]);
                        os += buff;
                    }
                    os += "\n";
                    mixOffset += nSpecs;
                }
                matOffset += nMats;
            }
        }
        else
        {
            if (!centeringsMatch)
               os += "\n";
            mixOffset  = 0;
            for (i = 0; i < names.size(); i++)
            {
                if (!centeringsMatch)
                {
                    SNPRINTF(buff, 256, "    %s ", names[i].c_str());
                    os += buff;
                }
                if (variableType == "vector")
                {
                    int stride = values.size() / names.size();
                    SNPRINTF(buff, 256, "= (%g", values[i*stride]);
                    os += buff;
                    for (int j = 1; j < stride-1; j++) 
                    {
                        SNPRINTF(buff, 256, ",%g", values[i*stride+j]);
                        os += buff;
                    }
                    SNPRINTF(buff, 256, ") mag = %g\n", values[i*stride+stride-1]);
                    os += buff; 
                }
                else if (variableType == "scalar")
                {
                    if (!treatAsASCII)
                    {
                        SNPRINTF(buff, 256, "= %g\n", values[i]);
                    }
                    else 
                    {
                        SNPRINTF(buff, 256, "= %c\n", (char) values[i]);
                    }
                    os += buff;
                }
                else if (variableType == "tensor")
                {
                    int buf_len = strlen(buff);
                    int ncomps = values.size() / names.size();
                    PrintTensor(os, values, i, ncomps, buf_len);
                }
                else if (variableType == "symm_tensor")
                {
                    int buf_len = strlen(buff);
                    int ncomps = values.size() / names.size();
                    PrintSymmetricTensor(os, values, i, ncomps, buf_len);
                }
                else 
                {
                    os += "\n";
                }
                if (mixVar)
                {
                    nMats = numMatsPerZone[i];
                    for (j = 0; j < nMats; j++)
                    {
                        SNPRINTF(buff, 256, "        material %s = ", 
                                 mixNames[j+mixOffset].c_str());
                        os += buff;
                        SNPRINTF(buff, 256, "%g\n", mixValues[j+mixOffset]);
                        os += buff;
                    }
                    mixOffset += nMats;
                }
            }
        }
    }
    else if (!miscMessage.empty())
    {
        SNPRINTF(buff, 256, "    %s\n", miscMessage.c_str());
        os += buff;
    }
    else
    {
        SNPRINTF(buff, 256, "    No Information Found\n"); 
        os += buff;
    }
}


// ****************************************************************************
// Method: PickVarInfo::PrintTensor
//
// Purpose: 
//     Prints the information out for a tensor.
//
// Programmer: Hank Childs
// Creation:   September 22, 2003
// ****************************************************************************

void
PickVarInfo::PrintTensor(std::string &os, const std::vector<double> &values,
                         int tuple, int ncomps, int buff_len)
{
    int  j;

    int offset = tuple*ncomps;
    if (ncomps == 2)  // 2D tensor
    {
        char line[256];
        sprintf(line, "(%g, %g)\n", values[offset], values[offset+1]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";
        sprintf(line, "(%g, %g)\n", values[offset+2], values[offset+3]);
        os += line;
    }
    else if (ncomps == 9) // 3D tensor
    {
        char line[256];
        sprintf(line, "(%g, %g, %g)\n", values[offset], values[offset+1],
                                        values[offset+2]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";

        sprintf(line, "(%g, %g, %g)\n", values[offset+3], values[offset+4],
                                        values[offset+5]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";

        sprintf(line, "(%g, %g, %g)\n", values[offset+6], values[offset+7],
                                        values[offset+8]);
        os += line;
    }
}


// ****************************************************************************
// Method: PickVarInfo::PrintSymmetricTensor
//
// Purpose: 
//     Prints the information out for a tensor.
//
// Programmer: Hank Childs
// Creation:   September 22, 2003
// ****************************************************************************

void
PickVarInfo::PrintSymmetricTensor(std::string &os,
         const std::vector<double> &values, int tuple, int ncomps, int buff_len)
{
    int  j;

    int offset = tuple*ncomps;
    if (ncomps == 2)  // 2D tensor
    {
        char line[256];
        sprintf(line, "(%g, %g)\n", values[offset], values[offset+1]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";
        sprintf(line, "(%g, %g)\n", values[offset+2], values[offset+3]);
        os += line;
    }
    else if (ncomps == 9) // 3D tensor
    {
        char line[256];
        sprintf(line, "(%g, %g, %g)\n", values[offset], values[offset+1],
                                        values[offset+2]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";

        sprintf(line, "(%g, %g, %g)\n", values[offset+3], values[offset+4],
                                        values[offset+5]);
        os += line;
        for (j = 0 ; j < buff_len ; j++)
            os += " ";

        sprintf(line, "(%g, %g, %g)\n", values[offset+6], values[offset+7],
                                        values[offset+8]);
        os += line;
    }
}


// ****************************************************************************
// Method: PickVarInfo::HasInfo
//
// Purpose: 
//    Returns true if the info has been filled in, false otherwise.
//
// Programmer: Kathleen Bonnell
// Creation:   March 2, 2004
// ****************************************************************************

bool
PickVarInfo::HasInfo()
{
    return (!(names.empty() && mixNames.empty()));
}
        

