#include <PickAttributes.h>
#include <DataNode.h>
#include <stdio.h>
#include <float.h>
#include <PickVarInfo.h>

//
// Enum conversion methods for PickAttributes::PickType
//

static const char *PickType_strings[] = {
"Zone", "Node", "CurveZone", 
"CurveNode", "DomainZone", "DomainNode"
};

std::string
PickAttributes::PickType_ToString(PickAttributes::PickType t)
{
    int index = int(t);
    if(index < 0 || index >= 6) index = 0;
    return PickType_strings[index];
}

std::string
PickAttributes::PickType_ToString(int t)
{
    int index = (t < 0 || t >= 6) ? 0 : t;
    return PickType_strings[index];
}

bool
PickAttributes::PickType_FromString(const std::string &s, PickAttributes::PickType &val)
{
    val = PickAttributes::Zone;
    for(int i = 0; i < 6; ++i)
    {
        if(s == PickType_strings[i])
        {
            val = (PickType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: PickAttributes::PickAttributes
//
// Purpose: 
//   Constructor for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickAttributes::PickAttributes() : AttributeSubject("s*bbbbbbbbbsbiiii*iissFFFFFFsii*s*s*s*s*s*ba*s*bsbbbbbbssi*bbbbbii*bb")
{
    variables.push_back("default");
    displayIncidentElements = true;
    showNodeId = true;
    showNodeDomainLogicalCoords = false;
    showNodeBlockLogicalCoords = false;
    showNodePhysicalCoords = false;
    showZoneId = true;
    showZoneDomainLogicalCoords = false;
    showZoneBlockLogicalCoords = false;
    clearWindow = false;
    fulfilled = false;
    pickType = Zone;
    domain = -1;
    elementNumber = -1;
    timeStep = -1;
    dimension = -1;
    pickPoint[0] = 0;
    pickPoint[1] = 0;
    pickPoint[2] = 0;
    cellPoint[0] = 0;
    cellPoint[1] = 0;
    cellPoint[2] = 0;
    nodePoint[0] = 0;
    nodePoint[1] = 0;
    nodePoint[2] = 0;
    plotBounds[0] = 0;
    plotBounds[1] = 0;
    plotBounds[2] = 0;
    plotBounds[3] = 0;
    plotBounds[4] = 0;
    plotBounds[5] = 0;
    rayPoint1[0] = 0;
    rayPoint1[1] = 0;
    rayPoint1[2] = 0;
    rayPoint2[0] = 0;
    rayPoint2[1] = 0;
    rayPoint2[2] = 0;
    realElementNumber = -1;
    needTransformMessage = false;
    doTimeCurve = false;
    error = false;
    matSelected = false;
    needActualCoords = false;
    conciseOutput = false;
    showTimeStep = true;
    showMeshName = true;
    includeGhosts = false;
    elementIsGhost = false;
    requiresGlyphPick = false;
    locationSuccessful = false;
    displayGlobalIds = false;
    globalElement = -1;
    elementIsGlobal = false;
    displayPickLetter = true;
}

// ****************************************************************************
// Method: PickAttributes::PickAttributes
//
// Purpose: 
//   Copy constructor for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickAttributes::PickAttributes(const PickAttributes &obj) : AttributeSubject("s*bbbbbbbbbsbiiii*iissFFFFFFsii*s*s*s*s*s*ba*s*bsbbbbbbssi*bbbbbii*bb")
{
    AttributeGroupVector::const_iterator pos;
    int i;

    variables = obj.variables;
    displayIncidentElements = obj.displayIncidentElements;
    showNodeId = obj.showNodeId;
    showNodeDomainLogicalCoords = obj.showNodeDomainLogicalCoords;
    showNodeBlockLogicalCoords = obj.showNodeBlockLogicalCoords;
    showNodePhysicalCoords = obj.showNodePhysicalCoords;
    showZoneId = obj.showZoneId;
    showZoneDomainLogicalCoords = obj.showZoneDomainLogicalCoords;
    showZoneBlockLogicalCoords = obj.showZoneBlockLogicalCoords;
    clearWindow = obj.clearWindow;
    pickLetter = obj.pickLetter;
    fulfilled = obj.fulfilled;
    pickType = obj.pickType;
    domain = obj.domain;
    elementNumber = obj.elementNumber;
    incidentElements = obj.incidentElements;
    timeStep = obj.timeStep;
    dimension = obj.dimension;
    databaseName = obj.databaseName;
    activeVariable = obj.activeVariable;
    pickPoint[0] = obj.pickPoint[0];
    pickPoint[1] = obj.pickPoint[1];
    pickPoint[2] = obj.pickPoint[2];

    cellPoint[0] = obj.cellPoint[0];
    cellPoint[1] = obj.cellPoint[1];
    cellPoint[2] = obj.cellPoint[2];

    nodePoint[0] = obj.nodePoint[0];
    nodePoint[1] = obj.nodePoint[1];
    nodePoint[2] = obj.nodePoint[2];

    for(i = 0; i < 6; ++i)
        plotBounds[i] = obj.plotBounds[i];

    rayPoint1[0] = obj.rayPoint1[0];
    rayPoint1[1] = obj.rayPoint1[1];
    rayPoint1[2] = obj.rayPoint1[2];

    rayPoint2[0] = obj.rayPoint2[0];
    rayPoint2[1] = obj.rayPoint2[1];
    rayPoint2[2] = obj.rayPoint2[2];

    meshInfo = obj.meshInfo;
    realElementNumber = obj.realElementNumber;
    realIncidentElements = obj.realIncidentElements;
    pnodeCoords = obj.pnodeCoords;
    dnodeCoords = obj.dnodeCoords;
    bnodeCoords = obj.bnodeCoords;
    dzoneCoords = obj.dzoneCoords;
    bzoneCoords = obj.bzoneCoords;
    needTransformMessage = obj.needTransformMessage;
    // *** Copy the varInfo field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = varInfo.begin(); pos != varInfo.end(); ++pos)
        delete *pos;
    varInfo.clear();
    if(obj.varInfo.size() > 0)
        varInfo.reserve(obj.varInfo.size());
    // Duplicate the varInfo from obj.
    for(pos = obj.varInfo.begin(); pos != obj.varInfo.end(); ++pos)
    {
        PickVarInfo *oldPickVarInfo = (PickVarInfo *)(*pos);
        PickVarInfo *newPickVarInfo = new PickVarInfo(*oldPickVarInfo);
        varInfo.push_back(newPickVarInfo);
    }

    invalidVars = obj.invalidVars;
    doTimeCurve = obj.doTimeCurve;
    errorMessage = obj.errorMessage;
    error = obj.error;
    matSelected = obj.matSelected;
    needActualCoords = obj.needActualCoords;
    conciseOutput = obj.conciseOutput;
    showTimeStep = obj.showTimeStep;
    showMeshName = obj.showMeshName;
    blockPieceName = obj.blockPieceName;
    groupPieceName = obj.groupPieceName;
    ghosts = obj.ghosts;
    includeGhosts = obj.includeGhosts;
    elementIsGhost = obj.elementIsGhost;
    requiresGlyphPick = obj.requiresGlyphPick;
    locationSuccessful = obj.locationSuccessful;
    displayGlobalIds = obj.displayGlobalIds;
    globalElement = obj.globalElement;
    globalIncidentElements = obj.globalIncidentElements;
    elementIsGlobal = obj.elementIsGlobal;
    displayPickLetter = obj.displayPickLetter;

    SelectAll();
}

// ****************************************************************************
// Method: PickAttributes::~PickAttributes
//
// Purpose: 
//   Destructor for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickAttributes::~PickAttributes()
{
    AttributeGroupVector::iterator pos;

    // Destroy the varInfo field.
    for(pos = varInfo.begin(); pos != varInfo.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: PickAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickAttributes& 
PickAttributes::operator = (const PickAttributes &obj)
{
    if (this == &obj) return *this;
    AttributeGroupVector::const_iterator pos;
    int i;

    variables = obj.variables;
    displayIncidentElements = obj.displayIncidentElements;
    showNodeId = obj.showNodeId;
    showNodeDomainLogicalCoords = obj.showNodeDomainLogicalCoords;
    showNodeBlockLogicalCoords = obj.showNodeBlockLogicalCoords;
    showNodePhysicalCoords = obj.showNodePhysicalCoords;
    showZoneId = obj.showZoneId;
    showZoneDomainLogicalCoords = obj.showZoneDomainLogicalCoords;
    showZoneBlockLogicalCoords = obj.showZoneBlockLogicalCoords;
    clearWindow = obj.clearWindow;
    pickLetter = obj.pickLetter;
    fulfilled = obj.fulfilled;
    pickType = obj.pickType;
    domain = obj.domain;
    elementNumber = obj.elementNumber;
    incidentElements = obj.incidentElements;
    timeStep = obj.timeStep;
    dimension = obj.dimension;
    databaseName = obj.databaseName;
    activeVariable = obj.activeVariable;
    pickPoint[0] = obj.pickPoint[0];
    pickPoint[1] = obj.pickPoint[1];
    pickPoint[2] = obj.pickPoint[2];

    cellPoint[0] = obj.cellPoint[0];
    cellPoint[1] = obj.cellPoint[1];
    cellPoint[2] = obj.cellPoint[2];

    nodePoint[0] = obj.nodePoint[0];
    nodePoint[1] = obj.nodePoint[1];
    nodePoint[2] = obj.nodePoint[2];

    for(i = 0; i < 6; ++i)
        plotBounds[i] = obj.plotBounds[i];

    rayPoint1[0] = obj.rayPoint1[0];
    rayPoint1[1] = obj.rayPoint1[1];
    rayPoint1[2] = obj.rayPoint1[2];

    rayPoint2[0] = obj.rayPoint2[0];
    rayPoint2[1] = obj.rayPoint2[1];
    rayPoint2[2] = obj.rayPoint2[2];

    meshInfo = obj.meshInfo;
    realElementNumber = obj.realElementNumber;
    realIncidentElements = obj.realIncidentElements;
    pnodeCoords = obj.pnodeCoords;
    dnodeCoords = obj.dnodeCoords;
    bnodeCoords = obj.bnodeCoords;
    dzoneCoords = obj.dzoneCoords;
    bzoneCoords = obj.bzoneCoords;
    needTransformMessage = obj.needTransformMessage;
    // *** Copy the varInfo field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = varInfo.begin(); pos != varInfo.end(); ++pos)
        delete *pos;
    varInfo.clear();
    if(obj.varInfo.size() > 0)
        varInfo.reserve(obj.varInfo.size());
    // Duplicate the varInfo from obj.
    for(pos = obj.varInfo.begin(); pos != obj.varInfo.end(); ++pos)
    {
        PickVarInfo *oldPickVarInfo = (PickVarInfo *)(*pos);
        PickVarInfo *newPickVarInfo = new PickVarInfo(*oldPickVarInfo);
        varInfo.push_back(newPickVarInfo);
    }

    invalidVars = obj.invalidVars;
    doTimeCurve = obj.doTimeCurve;
    errorMessage = obj.errorMessage;
    error = obj.error;
    matSelected = obj.matSelected;
    needActualCoords = obj.needActualCoords;
    conciseOutput = obj.conciseOutput;
    showTimeStep = obj.showTimeStep;
    showMeshName = obj.showMeshName;
    blockPieceName = obj.blockPieceName;
    groupPieceName = obj.groupPieceName;
    ghosts = obj.ghosts;
    includeGhosts = obj.includeGhosts;
    elementIsGhost = obj.elementIsGhost;
    requiresGlyphPick = obj.requiresGlyphPick;
    locationSuccessful = obj.locationSuccessful;
    displayGlobalIds = obj.displayGlobalIds;
    globalElement = obj.globalElement;
    globalIncidentElements = obj.globalIncidentElements;
    elementIsGlobal = obj.elementIsGlobal;
    displayPickLetter = obj.displayPickLetter;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: PickAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickAttributes::operator == (const PickAttributes &obj) const
{
    int i;

    // Compare the pickPoint arrays.
    bool pickPoint_equal = true;
    for(i = 0; i < 3 && pickPoint_equal; ++i)
        pickPoint_equal = (pickPoint[i] == obj.pickPoint[i]);

    // Compare the cellPoint arrays.
    bool cellPoint_equal = true;
    for(i = 0; i < 3 && cellPoint_equal; ++i)
        cellPoint_equal = (cellPoint[i] == obj.cellPoint[i]);

    // Compare the nodePoint arrays.
    bool nodePoint_equal = true;
    for(i = 0; i < 3 && nodePoint_equal; ++i)
        nodePoint_equal = (nodePoint[i] == obj.nodePoint[i]);

    // Compare the plotBounds arrays.
    bool plotBounds_equal = true;
    for(i = 0; i < 6 && plotBounds_equal; ++i)
        plotBounds_equal = (plotBounds[i] == obj.plotBounds[i]);

    // Compare the rayPoint1 arrays.
    bool rayPoint1_equal = true;
    for(i = 0; i < 3 && rayPoint1_equal; ++i)
        rayPoint1_equal = (rayPoint1[i] == obj.rayPoint1[i]);

    // Compare the rayPoint2 arrays.
    bool rayPoint2_equal = true;
    for(i = 0; i < 3 && rayPoint2_equal; ++i)
        rayPoint2_equal = (rayPoint2[i] == obj.rayPoint2[i]);

    bool varInfo_equal = (obj.varInfo.size() == varInfo.size());
    for(i = 0; (i < varInfo.size()) && varInfo_equal; ++i)
    {
        // Make references to PickVarInfo from AttributeGroup *.
        const PickVarInfo &varInfo1 = *((const PickVarInfo *)(varInfo[i]));
        const PickVarInfo &varInfo2 = *((const PickVarInfo *)(obj.varInfo[i]));
        varInfo_equal = (varInfo1 == varInfo2);
    }

    // Create the return value
    return ((variables == obj.variables) &&
            (displayIncidentElements == obj.displayIncidentElements) &&
            (showNodeId == obj.showNodeId) &&
            (showNodeDomainLogicalCoords == obj.showNodeDomainLogicalCoords) &&
            (showNodeBlockLogicalCoords == obj.showNodeBlockLogicalCoords) &&
            (showNodePhysicalCoords == obj.showNodePhysicalCoords) &&
            (showZoneId == obj.showZoneId) &&
            (showZoneDomainLogicalCoords == obj.showZoneDomainLogicalCoords) &&
            (showZoneBlockLogicalCoords == obj.showZoneBlockLogicalCoords) &&
            (clearWindow == obj.clearWindow) &&
            (pickLetter == obj.pickLetter) &&
            (fulfilled == obj.fulfilled) &&
            (pickType == obj.pickType) &&
            (domain == obj.domain) &&
            (elementNumber == obj.elementNumber) &&
            (incidentElements == obj.incidentElements) &&
            (timeStep == obj.timeStep) &&
            (dimension == obj.dimension) &&
            (databaseName == obj.databaseName) &&
            (activeVariable == obj.activeVariable) &&
            pickPoint_equal &&
            cellPoint_equal &&
            nodePoint_equal &&
            plotBounds_equal &&
            rayPoint1_equal &&
            rayPoint2_equal &&
            (meshInfo == obj.meshInfo) &&
            (realElementNumber == obj.realElementNumber) &&
            (realIncidentElements == obj.realIncidentElements) &&
            (pnodeCoords == obj.pnodeCoords) &&
            (dnodeCoords == obj.dnodeCoords) &&
            (bnodeCoords == obj.bnodeCoords) &&
            (dzoneCoords == obj.dzoneCoords) &&
            (bzoneCoords == obj.bzoneCoords) &&
            (needTransformMessage == obj.needTransformMessage) &&
            varInfo_equal &&
            (invalidVars == obj.invalidVars) &&
            (doTimeCurve == obj.doTimeCurve) &&
            (errorMessage == obj.errorMessage) &&
            (error == obj.error) &&
            (matSelected == obj.matSelected) &&
            (needActualCoords == obj.needActualCoords) &&
            (conciseOutput == obj.conciseOutput) &&
            (showTimeStep == obj.showTimeStep) &&
            (showMeshName == obj.showMeshName) &&
            (blockPieceName == obj.blockPieceName) &&
            (groupPieceName == obj.groupPieceName) &&
            (ghosts == obj.ghosts) &&
            (includeGhosts == obj.includeGhosts) &&
            (elementIsGhost == obj.elementIsGhost) &&
            (requiresGlyphPick == obj.requiresGlyphPick) &&
            (locationSuccessful == obj.locationSuccessful) &&
            (displayGlobalIds == obj.displayGlobalIds) &&
            (globalElement == obj.globalElement) &&
            (globalIncidentElements == obj.globalIncidentElements) &&
            (elementIsGlobal == obj.elementIsGlobal) &&
            (displayPickLetter == obj.displayPickLetter));
}

// ****************************************************************************
// Method: PickAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickAttributes::operator != (const PickAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PickAttributes::TypeName
//
// Purpose: 
//   Type name method for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
PickAttributes::TypeName() const
{
    return "PickAttributes";
}

// ****************************************************************************
// Method: PickAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PickAttributes *tmp = (const PickAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PickAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PickAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PickAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PickAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PickAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PickAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PickAttributes(*this);
    else
        retval = new PickAttributes;

    return retval;
}

// ****************************************************************************
// Method: PickAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickAttributes::SelectAll()
{
    Select(0, (void *)&variables);
    Select(1, (void *)&displayIncidentElements);
    Select(2, (void *)&showNodeId);
    Select(3, (void *)&showNodeDomainLogicalCoords);
    Select(4, (void *)&showNodeBlockLogicalCoords);
    Select(5, (void *)&showNodePhysicalCoords);
    Select(6, (void *)&showZoneId);
    Select(7, (void *)&showZoneDomainLogicalCoords);
    Select(8, (void *)&showZoneBlockLogicalCoords);
    Select(9, (void *)&clearWindow);
    Select(10, (void *)&pickLetter);
    Select(11, (void *)&fulfilled);
    Select(12, (void *)&pickType);
    Select(13, (void *)&domain);
    Select(14, (void *)&elementNumber);
    Select(15, (void *)&incidentElements);
    Select(16, (void *)&timeStep);
    Select(17, (void *)&dimension);
    Select(18, (void *)&databaseName);
    Select(19, (void *)&activeVariable);
    Select(20, (void *)pickPoint, 3);
    Select(21, (void *)cellPoint, 3);
    Select(22, (void *)nodePoint, 3);
    Select(23, (void *)plotBounds, 6);
    Select(24, (void *)rayPoint1, 3);
    Select(25, (void *)rayPoint2, 3);
    Select(26, (void *)&meshInfo);
    Select(27, (void *)&realElementNumber);
    Select(28, (void *)&realIncidentElements);
    Select(29, (void *)&pnodeCoords);
    Select(30, (void *)&dnodeCoords);
    Select(31, (void *)&bnodeCoords);
    Select(32, (void *)&dzoneCoords);
    Select(33, (void *)&bzoneCoords);
    Select(34, (void *)&needTransformMessage);
    Select(35, (void *)&varInfo);
    Select(36, (void *)&invalidVars);
    Select(37, (void *)&doTimeCurve);
    Select(38, (void *)&errorMessage);
    Select(39, (void *)&error);
    Select(40, (void *)&matSelected);
    Select(41, (void *)&needActualCoords);
    Select(42, (void *)&conciseOutput);
    Select(43, (void *)&showTimeStep);
    Select(44, (void *)&showMeshName);
    Select(45, (void *)&blockPieceName);
    Select(46, (void *)&groupPieceName);
    Select(47, (void *)&ghosts);
    Select(48, (void *)&includeGhosts);
    Select(49, (void *)&elementIsGhost);
    Select(50, (void *)&requiresGlyphPick);
    Select(51, (void *)&locationSuccessful);
    Select(52, (void *)&displayGlobalIds);
    Select(53, (void *)&globalElement);
    Select(54, (void *)&globalIncidentElements);
    Select(55, (void *)&elementIsGlobal);
    Select(56, (void *)&displayPickLetter);
}

// ****************************************************************************
// Method: PickAttributes::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
PickAttributes::CreateSubAttributeGroup(int)
{
    return new PickVarInfo;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickAttributes::CreateNode
//
// Purpose: 
//
// Modifications:
//   Kathleen Bonnell, Wed Jun  9 07:54:02 PDT 2004
//   Add doTimeCurve and conciseOutput, showTimeStep, showMeshName.
//   
// ****************************************************************************

bool
PickAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PickAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PickAttributes.
    DataNode *node = new DataNode("PickAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variables", variables));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayIncidentElements", displayIncidentElements));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showNodeId", showNodeId));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showNodeDomainLogicalCoords", 
                                    showNodeDomainLogicalCoords));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showNodeBlockLogicalCoords", 
                                    showNodeBlockLogicalCoords));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showNodePhysicalCoords", 
                                    showNodePhysicalCoords));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showZoneId", 
                                    showZoneId));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showZoneDomainLogicalCoords", 
                                    showZoneDomainLogicalCoords));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showZoneBlockLogicalCoords", 
                                    showZoneBlockLogicalCoords));
    }

    if(completeSave || !FieldsEqual(37, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("doTimeCurve", 
                                    doTimeCurve));
    }

    if(completeSave || !FieldsEqual(42, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("conciseOutput", conciseOutput));
    }

    if(completeSave || !FieldsEqual(43, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showTimeStep", showTimeStep));
    }

    if(completeSave || !FieldsEqual(44, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showMeshName", showMeshName));
    }

    if(completeSave || !FieldsEqual(52, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayGlobalIds", displayGlobalIds));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);

}
// ****************************************************************************
// Method: PickAttributes::SetFromNode
//
// Purpose: 
//
// Modifications:
//   Kathleen Bonnell, Wed Jun  9 07:54:02 PDT 2004
//   Add doTimeCurve and conciseOutput, showTimeStep, showMeshName.
//   
// ****************************************************************************

void
PickAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PickAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;

    if((node = searchNode->GetNode("variables")) != 0)
        SetVariables(node->AsStringVector());

    if((node = searchNode->GetNode("displayIncidentElements")) != 0)
        SetDisplayIncidentElements(node->AsBool());

    if((node = searchNode->GetNode("showNodeId")) != 0)
        SetShowNodeId(node->AsBool());
    if((node = searchNode->GetNode("showNodeDomainLogicalCoords")) != 0)
        SetShowNodeDomainLogicalCoords(node->AsBool());
    if((node = searchNode->GetNode("showNodeBlockLogicalCoords")) != 0)
        SetShowNodeBlockLogicalCoords(node->AsBool());
    if((node = searchNode->GetNode("showNodePhysicalCoords")) != 0)
        SetShowNodePhysicalCoords(node->AsBool());

    if((node = searchNode->GetNode("showZoneId")) != 0)
        SetShowZoneId(node->AsBool());
    if((node = searchNode->GetNode("showZoneDomainLogicalCoords")) != 0)
        SetShowZoneDomainLogicalCoords(node->AsBool());
    if((node = searchNode->GetNode("showZoneBlockLogicalCoords")) != 0)
        SetShowZoneBlockLogicalCoords(node->AsBool());

    if((node = searchNode->GetNode("doTimeCurve")) != 0)
        SetDoTimeCurve(node->AsBool());

    if((node = searchNode->GetNode("conciseOutput")) != 0)
        SetConciseOutput(node->AsBool());

    if((node = searchNode->GetNode("showTimeStep")) != 0)
        SetShowTimeStep(node->AsBool());

    if((node = searchNode->GetNode("showMeshName")) != 0)
        SetShowMeshName(node->AsBool());

    if((node = searchNode->GetNode("displayGlobalIds")) != 0)
        SetDisplayGlobalIds(node->AsBool());

    // Clear all the PickVarInfos.
    ClearPickVarInfos();

}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PickAttributes::SetVariables(const stringVector &variables_)
{
    variables = variables_;
    Select(0, (void *)&variables);
}

void
PickAttributes::SetDisplayIncidentElements(bool displayIncidentElements_)
{
    displayIncidentElements = displayIncidentElements_;
    Select(1, (void *)&displayIncidentElements);
}

void
PickAttributes::SetShowNodeId(bool showNodeId_)
{
    showNodeId = showNodeId_;
    Select(2, (void *)&showNodeId);
}

void
PickAttributes::SetShowNodeDomainLogicalCoords(bool showNodeDomainLogicalCoords_)
{
    showNodeDomainLogicalCoords = showNodeDomainLogicalCoords_;
    Select(3, (void *)&showNodeDomainLogicalCoords);
}

void
PickAttributes::SetShowNodeBlockLogicalCoords(bool showNodeBlockLogicalCoords_)
{
    showNodeBlockLogicalCoords = showNodeBlockLogicalCoords_;
    Select(4, (void *)&showNodeBlockLogicalCoords);
}

void
PickAttributes::SetShowNodePhysicalCoords(bool showNodePhysicalCoords_)
{
    showNodePhysicalCoords = showNodePhysicalCoords_;
    Select(5, (void *)&showNodePhysicalCoords);
}

void
PickAttributes::SetShowZoneId(bool showZoneId_)
{
    showZoneId = showZoneId_;
    Select(6, (void *)&showZoneId);
}

void
PickAttributes::SetShowZoneDomainLogicalCoords(bool showZoneDomainLogicalCoords_)
{
    showZoneDomainLogicalCoords = showZoneDomainLogicalCoords_;
    Select(7, (void *)&showZoneDomainLogicalCoords);
}

void
PickAttributes::SetShowZoneBlockLogicalCoords(bool showZoneBlockLogicalCoords_)
{
    showZoneBlockLogicalCoords = showZoneBlockLogicalCoords_;
    Select(8, (void *)&showZoneBlockLogicalCoords);
}

void
PickAttributes::SetClearWindow(bool clearWindow_)
{
    clearWindow = clearWindow_;
    Select(9, (void *)&clearWindow);
}

void
PickAttributes::SetPickLetter(const std::string &pickLetter_)
{
    pickLetter = pickLetter_;
    Select(10, (void *)&pickLetter);
}

void
PickAttributes::SetFulfilled(bool fulfilled_)
{
    fulfilled = fulfilled_;
    Select(11, (void *)&fulfilled);
}

void
PickAttributes::SetPickType(PickAttributes::PickType pickType_)
{
    pickType = pickType_;
    Select(12, (void *)&pickType);
}

void
PickAttributes::SetDomain(int domain_)
{
    domain = domain_;
    Select(13, (void *)&domain);
}

void
PickAttributes::SetElementNumber(int elementNumber_)
{
    elementNumber = elementNumber_;
    Select(14, (void *)&elementNumber);
}

void
PickAttributes::SetIncidentElements(const intVector &incidentElements_)
{
    incidentElements = incidentElements_;
    Select(15, (void *)&incidentElements);
}

void
PickAttributes::SetTimeStep(int timeStep_)
{
    timeStep = timeStep_;
    Select(16, (void *)&timeStep);
}

void
PickAttributes::SetDimension(int dimension_)
{
    dimension = dimension_;
    Select(17, (void *)&dimension);
}

void
PickAttributes::SetDatabaseName(const std::string &databaseName_)
{
    databaseName = databaseName_;
    Select(18, (void *)&databaseName);
}

void
PickAttributes::SetActiveVariable(const std::string &activeVariable_)
{
    activeVariable = activeVariable_;
    Select(19, (void *)&activeVariable);
}

void
PickAttributes::SetPickPoint(const float *pickPoint_)
{
    pickPoint[0] = pickPoint_[0];
    pickPoint[1] = pickPoint_[1];
    pickPoint[2] = pickPoint_[2];
    Select(20, (void *)pickPoint, 3);
}

void
PickAttributes::SetCellPoint(const float *cellPoint_)
{
    cellPoint[0] = cellPoint_[0];
    cellPoint[1] = cellPoint_[1];
    cellPoint[2] = cellPoint_[2];
    Select(21, (void *)cellPoint, 3);
}

void
PickAttributes::SetNodePoint(const float *nodePoint_)
{
    nodePoint[0] = nodePoint_[0];
    nodePoint[1] = nodePoint_[1];
    nodePoint[2] = nodePoint_[2];
    Select(22, (void *)nodePoint, 3);
}

void
PickAttributes::SetPlotBounds(const float *plotBounds_)
{
    for(int i = 0; i < 6; ++i)
        plotBounds[i] = plotBounds_[i];
    Select(23, (void *)plotBounds, 6);
}

void
PickAttributes::SetRayPoint1(const float *rayPoint1_)
{
    rayPoint1[0] = rayPoint1_[0];
    rayPoint1[1] = rayPoint1_[1];
    rayPoint1[2] = rayPoint1_[2];
    Select(24, (void *)rayPoint1, 3);
}

void
PickAttributes::SetRayPoint2(const float *rayPoint2_)
{
    rayPoint2[0] = rayPoint2_[0];
    rayPoint2[1] = rayPoint2_[1];
    rayPoint2[2] = rayPoint2_[2];
    Select(25, (void *)rayPoint2, 3);
}

void
PickAttributes::SetMeshInfo(const std::string &meshInfo_)
{
    meshInfo = meshInfo_;
    Select(26, (void *)&meshInfo);
}

void
PickAttributes::SetRealElementNumber(int realElementNumber_)
{
    realElementNumber = realElementNumber_;
    Select(27, (void *)&realElementNumber);
}

void
PickAttributes::SetRealIncidentElements(const intVector &realIncidentElements_)
{
    realIncidentElements = realIncidentElements_;
    Select(28, (void *)&realIncidentElements);
}

void
PickAttributes::SetPnodeCoords(const stringVector &pnodeCoords_)
{
    pnodeCoords = pnodeCoords_;
    Select(29, (void *)&pnodeCoords);
}

void
PickAttributes::SetDnodeCoords(const stringVector &dnodeCoords_)
{
    dnodeCoords = dnodeCoords_;
    Select(30, (void *)&dnodeCoords);
}

void
PickAttributes::SetBnodeCoords(const stringVector &bnodeCoords_)
{
    bnodeCoords = bnodeCoords_;
    Select(31, (void *)&bnodeCoords);
}

void
PickAttributes::SetDzoneCoords(const stringVector &dzoneCoords_)
{
    dzoneCoords = dzoneCoords_;
    Select(32, (void *)&dzoneCoords);
}

void
PickAttributes::SetBzoneCoords(const stringVector &bzoneCoords_)
{
    bzoneCoords = bzoneCoords_;
    Select(33, (void *)&bzoneCoords);
}

void
PickAttributes::SetNeedTransformMessage(bool needTransformMessage_)
{
    needTransformMessage = needTransformMessage_;
    Select(34, (void *)&needTransformMessage);
}

void
PickAttributes::SetInvalidVars(const stringVector &invalidVars_)
{
    invalidVars = invalidVars_;
    Select(36, (void *)&invalidVars);
}

void
PickAttributes::SetDoTimeCurve(bool doTimeCurve_)
{
    doTimeCurve = doTimeCurve_;
    Select(37, (void *)&doTimeCurve);
}

void
PickAttributes::SetErrorMessage(const std::string &errorMessage_)
{
    errorMessage = errorMessage_;
    Select(38, (void *)&errorMessage);
}

void
PickAttributes::SetError(bool error_)
{
    error = error_;
    Select(39, (void *)&error);
}

void
PickAttributes::SetMatSelected(bool matSelected_)
{
    matSelected = matSelected_;
    Select(40, (void *)&matSelected);
}

void
PickAttributes::SetNeedActualCoords(bool needActualCoords_)
{
    needActualCoords = needActualCoords_;
    Select(41, (void *)&needActualCoords);
}

void
PickAttributes::SetConciseOutput(bool conciseOutput_)
{
    conciseOutput = conciseOutput_;
    Select(42, (void *)&conciseOutput);
}

void
PickAttributes::SetShowTimeStep(bool showTimeStep_)
{
    showTimeStep = showTimeStep_;
    Select(43, (void *)&showTimeStep);
}

void
PickAttributes::SetShowMeshName(bool showMeshName_)
{
    showMeshName = showMeshName_;
    Select(44, (void *)&showMeshName);
}

void
PickAttributes::SetBlockPieceName(const std::string &blockPieceName_)
{
    blockPieceName = blockPieceName_;
    Select(45, (void *)&blockPieceName);
}

void
PickAttributes::SetGroupPieceName(const std::string &groupPieceName_)
{
    groupPieceName = groupPieceName_;
    Select(46, (void *)&groupPieceName);
}

void
PickAttributes::SetGhosts(const intVector &ghosts_)
{
    ghosts = ghosts_;
    Select(47, (void *)&ghosts);
}

void
PickAttributes::SetIncludeGhosts(bool includeGhosts_)
{
    includeGhosts = includeGhosts_;
    Select(48, (void *)&includeGhosts);
}

void
PickAttributes::SetElementIsGhost(bool elementIsGhost_)
{
    elementIsGhost = elementIsGhost_;
    Select(49, (void *)&elementIsGhost);
}

void
PickAttributes::SetRequiresGlyphPick(bool requiresGlyphPick_)
{
    requiresGlyphPick = requiresGlyphPick_;
    Select(50, (void *)&requiresGlyphPick);
}

void
PickAttributes::SetLocationSuccessful(bool locationSuccessful_)
{
    locationSuccessful = locationSuccessful_;
    Select(51, (void *)&locationSuccessful);
}

void
PickAttributes::SetDisplayGlobalIds(bool displayGlobalIds_)
{
    displayGlobalIds = displayGlobalIds_;
    Select(52, (void *)&displayGlobalIds);
}

void
PickAttributes::SetGlobalElement(int globalElement_)
{
    globalElement = globalElement_;
    Select(53, (void *)&globalElement);
}

void
PickAttributes::SetGlobalIncidentElements(const intVector &globalIncidentElements_)
{
    globalIncidentElements = globalIncidentElements_;
    Select(54, (void *)&globalIncidentElements);
}

void
PickAttributes::SetElementIsGlobal(bool elementIsGlobal_)
{
    elementIsGlobal = elementIsGlobal_;
    Select(55, (void *)&elementIsGlobal);
}

void
PickAttributes::SetDisplayPickLetter(bool displayPickLetter_)
{
    displayPickLetter = displayPickLetter_;
    Select(56, (void *)&displayPickLetter);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
PickAttributes::GetVariables() const
{
    return variables;
}

stringVector &
PickAttributes::GetVariables()
{
    return variables;
}

bool
PickAttributes::GetDisplayIncidentElements() const
{
    return displayIncidentElements;
}

bool
PickAttributes::GetShowNodeId() const
{
    return showNodeId;
}

bool
PickAttributes::GetShowNodeDomainLogicalCoords() const
{
    return showNodeDomainLogicalCoords;
}

bool
PickAttributes::GetShowNodeBlockLogicalCoords() const
{
    return showNodeBlockLogicalCoords;
}

bool
PickAttributes::GetShowNodePhysicalCoords() const
{
    return showNodePhysicalCoords;
}

bool
PickAttributes::GetShowZoneId() const
{
    return showZoneId;
}

bool
PickAttributes::GetShowZoneDomainLogicalCoords() const
{
    return showZoneDomainLogicalCoords;
}

bool
PickAttributes::GetShowZoneBlockLogicalCoords() const
{
    return showZoneBlockLogicalCoords;
}

bool
PickAttributes::GetClearWindow() const
{
    return clearWindow;
}

const std::string &
PickAttributes::GetPickLetter() const
{
    return pickLetter;
}

std::string &
PickAttributes::GetPickLetter()
{
    return pickLetter;
}

bool
PickAttributes::GetFulfilled() const
{
    return fulfilled;
}

PickAttributes::PickType
PickAttributes::GetPickType() const
{
    return PickType(pickType);
}

int
PickAttributes::GetDomain() const
{
    return domain;
}

int
PickAttributes::GetElementNumber() const
{
    return elementNumber;
}

const intVector &
PickAttributes::GetIncidentElements() const
{
    return incidentElements;
}

intVector &
PickAttributes::GetIncidentElements()
{
    return incidentElements;
}

int
PickAttributes::GetTimeStep() const
{
    return timeStep;
}

int
PickAttributes::GetDimension() const
{
    return dimension;
}

const std::string &
PickAttributes::GetDatabaseName() const
{
    return databaseName;
}

std::string &
PickAttributes::GetDatabaseName()
{
    return databaseName;
}

const std::string &
PickAttributes::GetActiveVariable() const
{
    return activeVariable;
}

std::string &
PickAttributes::GetActiveVariable()
{
    return activeVariable;
}

const float *
PickAttributes::GetPickPoint() const
{
    return pickPoint;
}

float *
PickAttributes::GetPickPoint()
{
    return pickPoint;
}

const float *
PickAttributes::GetCellPoint() const
{
    return cellPoint;
}

float *
PickAttributes::GetCellPoint()
{
    return cellPoint;
}

const float *
PickAttributes::GetNodePoint() const
{
    return nodePoint;
}

float *
PickAttributes::GetNodePoint()
{
    return nodePoint;
}

const float *
PickAttributes::GetPlotBounds() const
{
    return plotBounds;
}

float *
PickAttributes::GetPlotBounds()
{
    return plotBounds;
}

const float *
PickAttributes::GetRayPoint1() const
{
    return rayPoint1;
}

float *
PickAttributes::GetRayPoint1()
{
    return rayPoint1;
}

const float *
PickAttributes::GetRayPoint2() const
{
    return rayPoint2;
}

float *
PickAttributes::GetRayPoint2()
{
    return rayPoint2;
}

const std::string &
PickAttributes::GetMeshInfo() const
{
    return meshInfo;
}

std::string &
PickAttributes::GetMeshInfo()
{
    return meshInfo;
}

int
PickAttributes::GetRealElementNumber() const
{
    return realElementNumber;
}

const intVector &
PickAttributes::GetRealIncidentElements() const
{
    return realIncidentElements;
}

intVector &
PickAttributes::GetRealIncidentElements()
{
    return realIncidentElements;
}

const stringVector &
PickAttributes::GetPnodeCoords() const
{
    return pnodeCoords;
}

stringVector &
PickAttributes::GetPnodeCoords()
{
    return pnodeCoords;
}

const stringVector &
PickAttributes::GetDnodeCoords() const
{
    return dnodeCoords;
}

stringVector &
PickAttributes::GetDnodeCoords()
{
    return dnodeCoords;
}

const stringVector &
PickAttributes::GetBnodeCoords() const
{
    return bnodeCoords;
}

stringVector &
PickAttributes::GetBnodeCoords()
{
    return bnodeCoords;
}

const stringVector &
PickAttributes::GetDzoneCoords() const
{
    return dzoneCoords;
}

stringVector &
PickAttributes::GetDzoneCoords()
{
    return dzoneCoords;
}

const stringVector &
PickAttributes::GetBzoneCoords() const
{
    return bzoneCoords;
}

stringVector &
PickAttributes::GetBzoneCoords()
{
    return bzoneCoords;
}

bool
PickAttributes::GetNeedTransformMessage() const
{
    return needTransformMessage;
}

const AttributeGroupVector &
PickAttributes::GetVarInfo() const
{
    return varInfo;
}

AttributeGroupVector &
PickAttributes::GetVarInfo()
{
    return varInfo;
}

const stringVector &
PickAttributes::GetInvalidVars() const
{
    return invalidVars;
}

stringVector &
PickAttributes::GetInvalidVars()
{
    return invalidVars;
}

bool
PickAttributes::GetDoTimeCurve() const
{
    return doTimeCurve;
}

const std::string &
PickAttributes::GetErrorMessage() const
{
    return errorMessage;
}

std::string &
PickAttributes::GetErrorMessage()
{
    return errorMessage;
}

bool
PickAttributes::GetError() const
{
    return error;
}

bool
PickAttributes::GetMatSelected() const
{
    return matSelected;
}

bool
PickAttributes::GetNeedActualCoords() const
{
    return needActualCoords;
}

bool
PickAttributes::GetConciseOutput() const
{
    return conciseOutput;
}

bool
PickAttributes::GetShowTimeStep() const
{
    return showTimeStep;
}

bool
PickAttributes::GetShowMeshName() const
{
    return showMeshName;
}

const std::string &
PickAttributes::GetBlockPieceName() const
{
    return blockPieceName;
}

std::string &
PickAttributes::GetBlockPieceName()
{
    return blockPieceName;
}

const std::string &
PickAttributes::GetGroupPieceName() const
{
    return groupPieceName;
}

std::string &
PickAttributes::GetGroupPieceName()
{
    return groupPieceName;
}

const intVector &
PickAttributes::GetGhosts() const
{
    return ghosts;
}

intVector &
PickAttributes::GetGhosts()
{
    return ghosts;
}

bool
PickAttributes::GetIncludeGhosts() const
{
    return includeGhosts;
}

bool
PickAttributes::GetElementIsGhost() const
{
    return elementIsGhost;
}

bool
PickAttributes::GetRequiresGlyphPick() const
{
    return requiresGlyphPick;
}

bool
PickAttributes::GetLocationSuccessful() const
{
    return locationSuccessful;
}

bool
PickAttributes::GetDisplayGlobalIds() const
{
    return displayGlobalIds;
}

int
PickAttributes::GetGlobalElement() const
{
    return globalElement;
}

const intVector &
PickAttributes::GetGlobalIncidentElements() const
{
    return globalIncidentElements;
}

intVector &
PickAttributes::GetGlobalIncidentElements()
{
    return globalIncidentElements;
}

bool
PickAttributes::GetElementIsGlobal() const
{
    return elementIsGlobal;
}

bool
PickAttributes::GetDisplayPickLetter() const
{
    return displayPickLetter;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PickAttributes::SelectVariables()
{
    Select(0, (void *)&variables);
}

void
PickAttributes::SelectPickLetter()
{
    Select(10, (void *)&pickLetter);
}

void
PickAttributes::SelectIncidentElements()
{
    Select(15, (void *)&incidentElements);
}

void
PickAttributes::SelectDatabaseName()
{
    Select(18, (void *)&databaseName);
}

void
PickAttributes::SelectActiveVariable()
{
    Select(19, (void *)&activeVariable);
}

void
PickAttributes::SelectPickPoint()
{
    Select(20, (void *)pickPoint, 3);
}

void
PickAttributes::SelectCellPoint()
{
    Select(21, (void *)cellPoint, 3);
}

void
PickAttributes::SelectNodePoint()
{
    Select(22, (void *)nodePoint, 3);
}

void
PickAttributes::SelectPlotBounds()
{
    Select(23, (void *)plotBounds, 6);
}

void
PickAttributes::SelectRayPoint1()
{
    Select(24, (void *)rayPoint1, 3);
}

void
PickAttributes::SelectRayPoint2()
{
    Select(25, (void *)rayPoint2, 3);
}

void
PickAttributes::SelectMeshInfo()
{
    Select(26, (void *)&meshInfo);
}

void
PickAttributes::SelectRealIncidentElements()
{
    Select(28, (void *)&realIncidentElements);
}

void
PickAttributes::SelectPnodeCoords()
{
    Select(29, (void *)&pnodeCoords);
}

void
PickAttributes::SelectDnodeCoords()
{
    Select(30, (void *)&dnodeCoords);
}

void
PickAttributes::SelectBnodeCoords()
{
    Select(31, (void *)&bnodeCoords);
}

void
PickAttributes::SelectDzoneCoords()
{
    Select(32, (void *)&dzoneCoords);
}

void
PickAttributes::SelectBzoneCoords()
{
    Select(33, (void *)&bzoneCoords);
}

void
PickAttributes::SelectVarInfo()
{
    Select(35, (void *)&varInfo);
}

void
PickAttributes::SelectInvalidVars()
{
    Select(36, (void *)&invalidVars);
}

void
PickAttributes::SelectErrorMessage()
{
    Select(38, (void *)&errorMessage);
}

void
PickAttributes::SelectBlockPieceName()
{
    Select(45, (void *)&blockPieceName);
}

void
PickAttributes::SelectGroupPieceName()
{
    Select(46, (void *)&groupPieceName);
}

void
PickAttributes::SelectGhosts()
{
    Select(47, (void *)&ghosts);
}

void
PickAttributes::SelectGlobalIncidentElements()
{
    Select(54, (void *)&globalIncidentElements);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickAttributes::AddPickVarInfo
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickAttributes::AddPickVarInfo(const PickVarInfo &obj)
{
    PickVarInfo *newPickVarInfo = new PickVarInfo(obj);
    varInfo.push_back(newPickVarInfo);

    // Indicate that things have changed by selecting it.
    Select(35, (void *)&varInfo);
}

// ****************************************************************************
// Method: PickAttributes::ClearPickVarInfos
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickAttributes::ClearPickVarInfos()
{
    AttributeGroupVector::iterator pos;

    for(pos = varInfo.begin(); pos != varInfo.end(); ++pos)
        delete *pos;
    varInfo.clear();

    // Indicate that things have changed by selecting the list.
    Select(35, (void *)&varInfo);
}

// ****************************************************************************
// Method: PickAttributes::RemovePickVarInfo
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
PickAttributes::RemovePickVarInfo(int index)
{
    AttributeGroupVector::iterator pos = varInfo.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != varInfo.end())
    {
        delete *pos;
        varInfo.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(35, (void *)&varInfo);
}

// ****************************************************************************
// Method: PickAttributes::GetNumPickVarInfos
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

int
PickAttributes::GetNumPickVarInfos() const
{
    return varInfo.size();
}

// ****************************************************************************
// Method: PickAttributes::GetPickVarInfo
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickVarInfo &
PickAttributes::GetPickVarInfo(int i)
{
    return *((PickVarInfo *)varInfo[i]);
}

// ****************************************************************************
// Method: PickAttributes::GetPickVarInfo
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const PickVarInfo &
PickAttributes::GetPickVarInfo(int i) const
{
    return *((PickVarInfo *)varInfo[i]);
}

// ****************************************************************************
// Method: PickAttributes::operator []
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

PickVarInfo &
PickAttributes::operator [] (int i)
{
    return *((PickVarInfo *)varInfo[i]);
}

// ****************************************************************************
// Method: PickAttributes::operator []
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const PickVarInfo &
PickAttributes::operator [] (int i) const
{
    return *((PickVarInfo *)varInfo[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
PickAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "variables";
        case 1:  return "displayIncidentElement";
        case 2:  return "showNodeId";
        case 3:  return "showNodeDomainLogicalCorods";
        case 4:  return "showNodeBlocKLogicalCoords";
        case 5:  return "showNodePhysicalCoords";
        case 6:  return "showZoneId";
        case 7:  return "showZoneDomainLogicalCoords";
        case 8:  return "showZoneBlockLogicalCoords";
        case 9:  return "clearWindow";
        case 10:  return "pickLetter";
        case 11:  return "fulfilled";
        case 12:  return "pickType";
        case 13:  return "domain";
        case 14:  return "elementNumber";
        case 15:  return "incidentElements";
        case 16:  return "timeStep";
        case 17:  return "dimension";
        case 18:  return "databaseName";
        case 19:  return "activeVariable";
        case 20:  return "pickPoint";
        case 21:  return "cellPoint";
        case 22:  return "nodePoint";
        case 23:  return "plotBounds";
        case 24:  return "rayPoint1";
        case 25:  return "rayPoint2";
        case 26:  return "MeshInfo";
        case 27:  return "RealElementNumber";
        case 28:  return "RealIncidentElements";
        case 29:  return "pnodeCoords";
        case 30:  return "dnodeCoords";
        case 31:  return "bnodeCoords";
        case 32:  return "dzoneCoords";
        case 33:  return "bzoneCoords";
        case 34:  return "needTransformMessage";
        case 35:  return "varInfo";
        case 36:  return "invalidVars";
        case 37:  return "doTimeCurve";
        case 38:  return "errorMessage";
        case 39:  return "error";
        case 40:  return "matSelected";
        case 41:  return "needActualCoords";
        case 42:  return "conciseOutput";
        case 43:  return "showTimeStep";
        case 44:  return "showMeshName";
        case 45:  return "blockPieceName";
        case 46:  return "groupPieceName";
        case 47:  return "ghosts";
        case 48:  return "includeGhosts";
        case 49:  return "elementIsGhost";
        case 50:  return "requiresGlyphPick";
        case 51:  return "locationSuccessful";
        case 52:  return "displayGlobalIds";
        case 53:  return "globalElement";
        case 54:  return "globalIncidentElements";
        case 55:  return "elementIsGlobal";
        case 56:  return "displayPickLetter";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PickAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PickAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_stringVector;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_bool;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_string;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_enum;
        case 13:  return FieldType_int;
        case 14:  return FieldType_int;
        case 15:  return FieldType_intVector;
        case 16:  return FieldType_int;
        case 17:  return FieldType_int;
        case 18:  return FieldType_string;
        case 19:  return FieldType_string;
        case 20:  return FieldType_floatArray;
        case 21:  return FieldType_floatArray;
        case 22:  return FieldType_floatArray;
        case 23:  return FieldType_floatArray;
        case 24:  return FieldType_floatArray;
        case 25:  return FieldType_floatArray;
        case 26:  return FieldType_string;
        case 27:  return FieldType_int;
        case 28:  return FieldType_intVector;
        case 29:  return FieldType_stringVector;
        case 30:  return FieldType_stringVector;
        case 31:  return FieldType_stringVector;
        case 32:  return FieldType_stringVector;
        case 33:  return FieldType_stringVector;
        case 34:  return FieldType_bool;
        case 35:  return FieldType_attVector;
        case 36:  return FieldType_stringVector;
        case 37:  return FieldType_bool;
        case 38:  return FieldType_string;
        case 39:  return FieldType_bool;
        case 40:  return FieldType_bool;
        case 41:  return FieldType_bool;
        case 42:  return FieldType_bool;
        case 43:  return FieldType_bool;
        case 44:  return FieldType_bool;
        case 45:  return FieldType_string;
        case 46:  return FieldType_string;
        case 47:  return FieldType_intVector;
        case 48:  return FieldType_bool;
        case 49:  return FieldType_bool;
        case 50:  return FieldType_bool;
        case 51:  return FieldType_bool;
        case 52:  return FieldType_bool;
        case 53:  return FieldType_int;
        case 54:  return FieldType_intVector;
        case 55:  return FieldType_bool;
        case 56:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PickAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
PickAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "stringVector";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "bool";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "bool";
        case 9:  return "bool";
        case 10:  return "string";
        case 11:  return "bool";
        case 12:  return "enum";
        case 13:  return "int";
        case 14:  return "int";
        case 15:  return "intVector";
        case 16:  return "int";
        case 17:  return "int";
        case 18:  return "string";
        case 19:  return "string";
        case 20:  return "floatArray";
        case 21:  return "floatArray";
        case 22:  return "floatArray";
        case 23:  return "floatArray";
        case 24:  return "floatArray";
        case 25:  return "floatArray";
        case 26:  return "string";
        case 27:  return "int";
        case 28:  return "intVector";
        case 29:  return "stringVector";
        case 30:  return "stringVector";
        case 31:  return "stringVector";
        case 32:  return "stringVector";
        case 33:  return "stringVector";
        case 34:  return "bool";
        case 35:  return "attVector";
        case 36:  return "stringVector";
        case 37:  return "bool";
        case 38:  return "string";
        case 39:  return "bool";
        case 40:  return "bool";
        case 41:  return "bool";
        case 42:  return "bool";
        case 43:  return "bool";
        case 44:  return "bool";
        case 45:  return "string";
        case 46:  return "string";
        case 47:  return "intVector";
        case 48:  return "bool";
        case 49:  return "bool";
        case 50:  return "bool";
        case 51:  return "bool";
        case 52:  return "bool";
        case 53:  return "int";
        case 54:  return "intVector";
        case 55:  return "bool";
        case 56:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PickAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Dec 28 12:29:43 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
PickAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const PickAttributes &obj = *((const PickAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (variables == obj.variables);
        }
        break;
    case 1:
        {  // new scope
        retval = (displayIncidentElements == obj.displayIncidentElements);
        }
        break;
    case 2:
        {  // new scope
        retval = (showNodeId == obj.showNodeId);
        }
        break;
    case 3:
        {  // new scope
        retval = (showNodeDomainLogicalCoords == obj.showNodeDomainLogicalCoords);
        }
        break;
    case 4:
        {  // new scope
        retval = (showNodeBlockLogicalCoords == obj.showNodeBlockLogicalCoords);
        }
        break;
    case 5:
        {  // new scope
        retval = (showNodePhysicalCoords == obj.showNodePhysicalCoords);
        }
        break;
    case 6:
        {  // new scope
        retval = (showZoneId == obj.showZoneId);
        }
        break;
    case 7:
        {  // new scope
        retval = (showZoneDomainLogicalCoords == obj.showZoneDomainLogicalCoords);
        }
        break;
    case 8:
        {  // new scope
        retval = (showZoneBlockLogicalCoords == obj.showZoneBlockLogicalCoords);
        }
        break;
    case 9:
        {  // new scope
        retval = (clearWindow == obj.clearWindow);
        }
        break;
    case 10:
        {  // new scope
        retval = (pickLetter == obj.pickLetter);
        }
        break;
    case 11:
        {  // new scope
        retval = (fulfilled == obj.fulfilled);
        }
        break;
    case 12:
        {  // new scope
        retval = (pickType == obj.pickType);
        }
        break;
    case 13:
        {  // new scope
        retval = (domain == obj.domain);
        }
        break;
    case 14:
        {  // new scope
        retval = (elementNumber == obj.elementNumber);
        }
        break;
    case 15:
        {  // new scope
        retval = (incidentElements == obj.incidentElements);
        }
        break;
    case 16:
        {  // new scope
        retval = (timeStep == obj.timeStep);
        }
        break;
    case 17:
        {  // new scope
        retval = (dimension == obj.dimension);
        }
        break;
    case 18:
        {  // new scope
        retval = (databaseName == obj.databaseName);
        }
        break;
    case 19:
        {  // new scope
        retval = (activeVariable == obj.activeVariable);
        }
        break;
    case 20:
        {  // new scope
        // Compare the pickPoint arrays.
        bool pickPoint_equal = true;
        for(i = 0; i < 3 && pickPoint_equal; ++i)
            pickPoint_equal = (pickPoint[i] == obj.pickPoint[i]);

        retval = pickPoint_equal;
        }
        break;
    case 21:
        {  // new scope
        // Compare the cellPoint arrays.
        bool cellPoint_equal = true;
        for(i = 0; i < 3 && cellPoint_equal; ++i)
            cellPoint_equal = (cellPoint[i] == obj.cellPoint[i]);

        retval = cellPoint_equal;
        }
        break;
    case 22:
        {  // new scope
        // Compare the nodePoint arrays.
        bool nodePoint_equal = true;
        for(i = 0; i < 3 && nodePoint_equal; ++i)
            nodePoint_equal = (nodePoint[i] == obj.nodePoint[i]);

        retval = nodePoint_equal;
        }
        break;
    case 23:
        {  // new scope
        // Compare the plotBounds arrays.
        bool plotBounds_equal = true;
        for(i = 0; i < 6 && plotBounds_equal; ++i)
            plotBounds_equal = (plotBounds[i] == obj.plotBounds[i]);

        retval = plotBounds_equal;
        }
        break;
    case 24:
        {  // new scope
        // Compare the rayPoint1 arrays.
        bool rayPoint1_equal = true;
        for(i = 0; i < 3 && rayPoint1_equal; ++i)
            rayPoint1_equal = (rayPoint1[i] == obj.rayPoint1[i]);

        retval = rayPoint1_equal;
        }
        break;
    case 25:
        {  // new scope
        // Compare the rayPoint2 arrays.
        bool rayPoint2_equal = true;
        for(i = 0; i < 3 && rayPoint2_equal; ++i)
            rayPoint2_equal = (rayPoint2[i] == obj.rayPoint2[i]);

        retval = rayPoint2_equal;
        }
        break;
    case 26:
        {  // new scope
        retval = (meshInfo == obj.meshInfo);
        }
        break;
    case 27:
        {  // new scope
        retval = (realElementNumber == obj.realElementNumber);
        }
        break;
    case 28:
        {  // new scope
        retval = (realIncidentElements == obj.realIncidentElements);
        }
        break;
    case 29:
        {  // new scope
        retval = (pnodeCoords == obj.pnodeCoords);
        }
        break;
    case 30:
        {  // new scope
        retval = (dnodeCoords == obj.dnodeCoords);
        }
        break;
    case 31:
        {  // new scope
        retval = (bnodeCoords == obj.bnodeCoords);
        }
        break;
    case 32:
        {  // new scope
        retval = (dzoneCoords == obj.dzoneCoords);
        }
        break;
    case 33:
        {  // new scope
        retval = (bzoneCoords == obj.bzoneCoords);
        }
        break;
    case 34:
        {  // new scope
        retval = (needTransformMessage == obj.needTransformMessage);
        }
        break;
    case 35:
        {  // new scope
        bool varInfo_equal = (obj.varInfo.size() == varInfo.size());
        for(i = 0; (i < varInfo.size()) && varInfo_equal; ++i)
        {
            // Make references to PickVarInfo from AttributeGroup *.
            const PickVarInfo &varInfo1 = *((const PickVarInfo *)(varInfo[i]));
            const PickVarInfo &varInfo2 = *((const PickVarInfo *)(obj.varInfo[i]));
            varInfo_equal = (varInfo1 == varInfo2);
        }

        retval = varInfo_equal;
        }
        break;
    case 36:
        {  // new scope
        retval = (invalidVars == obj.invalidVars);
        }
        break;
    case 37:
        {  // new scope
        retval = (doTimeCurve == obj.doTimeCurve);
        }
        break;
    case 38:
        {  // new scope
        retval = (errorMessage == obj.errorMessage);
        }
        break;
    case 39:
        {  // new scope
        retval = (error == obj.error);
        }
        break;
    case 40:
        {  // new scope
        retval = (matSelected == obj.matSelected);
        }
        break;
    case 41:
        {  // new scope
        retval = (needActualCoords == obj.needActualCoords);
        }
        break;
    case 42:
        {  // new scope
        retval = (conciseOutput == obj.conciseOutput);
        }
        break;
    case 43:
        {  // new scope
        retval = (showTimeStep == obj.showTimeStep);
        }
        break;
    case 44:
        {  // new scope
        retval = (showMeshName == obj.showMeshName);
        }
        break;
    case 45:
        {  // new scope
        retval = (blockPieceName == obj.blockPieceName);
        }
        break;
    case 46:
        {  // new scope
        retval = (groupPieceName == obj.groupPieceName);
        }
        break;
    case 47:
        {  // new scope
        retval = (ghosts == obj.ghosts);
        }
        break;
    case 48:
        {  // new scope
        retval = (includeGhosts == obj.includeGhosts);
        }
        break;
    case 49:
        {  // new scope
        retval = (elementIsGhost == obj.elementIsGhost);
        }
        break;
    case 50:
        {  // new scope
        retval = (requiresGlyphPick == obj.requiresGlyphPick);
        }
        break;
    case 51:
        {  // new scope
        retval = (locationSuccessful == obj.locationSuccessful);
        }
        break;
    case 52:
        {  // new scope
        retval = (displayGlobalIds == obj.displayGlobalIds);
        }
        break;
    case 53:
        {  // new scope
        retval = (globalElement == obj.globalElement);
        }
        break;
    case 54:
        {  // new scope
        retval = (globalIncidentElements == obj.globalIncidentElements);
        }
        break;
    case 55:
        {  // new scope
        retval = (elementIsGlobal == obj.elementIsGlobal);
        }
        break;
    case 56:
        {  // new scope
        retval = (displayPickLetter == obj.displayPickLetter);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PickAttributes::PrintSelf
//
// Purpose: 
//   Prints the contents of this class to the passed stream. 
//
// Modifications:
//   Kathleen Bonnell, Thu Jun 26 09:31:56 PDT 2003
//   Reflect new member names (zoneNumber is now elementNumber, nodes is
//   now incidentElements).  Differentiate between zone pick and node pick.
//   
//   Kathleen Bonnell, Wed Jul 23 17:28:30 PDT 2003 
//   Don't print cellPoint if it is invalid (== FLT_MAX). 
//   
//   Kathleen Bonnell, Wed Sep 10 08:02:02 PDT 2003 
//   Added meshInfo. 
//   
//   Kathleen Bonnell, Tue Nov 18 10:06:40 PST 2003 
//   Support logical zone numbers. 
//   
//   Kathleen Bonnell, Wed Dec 17 15:19:46 PST 2003 
//   Support multiple types of coordinates. 
//   
//   Kathleen Bonnell, Tue Jun  1 16:44:44 PDT 2004 
//   Support new pick types 'DomainNode', 'DomainZone'. 
//   
//   Kathleen Bonnell, Wed Jun  9 12:24:09 PDT 2004 
//   Add conciseOutput.
//
// ****************************************************************************
void
PickAttributes::PrintSelf(ostream &os)
{
    int i;
    std::string fileName;
    int pos = databaseName.find_last_of('/');
    if (pos >= databaseName.size())
        fileName = databaseName;
    else
        fileName = databaseName.substr(pos+1) ;
    if (pickLetter.size() != 0)
        os << "\n" << pickLetter.c_str() << ":  ";
    else 
        os << "\n";
    os << fileName.c_str() << " ";
    os << "timestep " << timeStep << " ";
    if (meshInfo.empty())
    {
        if (domain != -1)
            os << "domain " << domain << "\n";
    }
    else
    {
        os << "\n" << meshInfo.c_str() << "\n";
    }
    os << "active variable:   " << activeVariable.c_str() << "\n";
    os << "selected variables: ";
    for (i = 0; i < variables.size(); i++)
        os << variables[i].c_str() << "  ";
    os << "\n";
    if (pickType == CurveNode)
    {
        os << "PickedPoint: <" << nodePoint[0] << ", " 
                               << nodePoint[1] << ", " 
                               << nodePoint[2] << ">\n";
    }
    else if (pickType == CurveZone)
    {
        os << "EndPoint1: <" << nodePoint[0] << ", " 
                             << nodePoint[1] << ", " 
                             << nodePoint[2] << ">\n";
        os << "EndPoint2: <" << cellPoint[0] << ", " 
                             << cellPoint[1] << ", " 
                             << cellPoint[2] << ">\n";
    }
    else if (cellPoint[0] != FLT_MAX)
    {
        if (!needTransformMessage)
        {
            os << "PickedPoint: <" << cellPoint[0] << ", " 
                                   << cellPoint[1] << ", " 
                                   << cellPoint[2] << ">\n";
        }
        else 
        {
            os << "PickedPoint:  (in transformed space) <" 
               << cellPoint[0] << ", " 
               << cellPoint[1] << ", " 
               << cellPoint[2] << ">\n";
        }
    }
    if (pickType == Zone || pickType == DomainZone)
    {
        os << "Zone " ;
        if (showZoneId)
        {
            if (!elementIsGhost)
                os<< elementNumber << " ";
            else 
                os<< elementNumber << "(ghost) ";
        }
        if (showZoneDomainLogicalCoords && !dzoneCoords.empty())
        {
            os << "d" << dzoneCoords[0].c_str();
        }
        if (showZoneBlockLogicalCoords && !bzoneCoords.empty())
        {
            os << " b" << bzoneCoords[0].c_str();
        }
        os << "\n";
    }
    else if (pickType == Node || pickType == DomainNode)
    {
        os << "Node ";
        if (showNodeId)
        {
            if (!elementIsGhost)
                os << elementNumber << " ";
            else 
                os << elementNumber << "(ghost) ";
        }
        if (showNodePhysicalCoords && !pnodeCoords.empty())
        {
            os << pnodeCoords[0].c_str() ;
        }
        if (showNodeDomainLogicalCoords && !dnodeCoords.empty())
        {
            os << dnodeCoords[0].c_str() ;
        }
        if (showNodeBlockLogicalCoords && !bnodeCoords.empty())
        {
            os << bnodeCoords[0].c_str() ;
        }
        os << "\n";
    }
    if (displayIncidentElements)
    {
        bool showId;
        if (pickType == Zone || pickType == DomainZone)
        {
            os << "Incident Nodes " ; 
            showId = showNodeId;
        }
        else if (pickType == Node || pickType == DomainNode)
        {
            os << "Incident Zones " ; 
            showId = showZoneId;
        }
        for (i = 0; i < incidentElements.size(); i++)
        {
            if (showId)
            {
                if (ghosts.size() > 0 && ghosts[i])
                    os << incidentElements[i] << "(ghost)  ";
                else 
                    os << incidentElements[i] << "  ";
            }
            if (pickType == Zone || pickType == DomainZone)
            {
                if (showNodePhysicalCoords && !pnodeCoords.empty())
                    os << " " << pnodeCoords[i].c_str() << "\n";
                if (showNodeDomainLogicalCoords && !dnodeCoords.empty())
                    os << " domain " << dnodeCoords[i].c_str() << "\n";
                if (showNodeBlockLogicalCoords && !bnodeCoords.empty())
                    os << " block " << bnodeCoords[i].c_str() << "\n";
            }
            else if (pickType == Node || pickType == DomainNode)
            {
                if (showZoneDomainLogicalCoords && !dzoneCoords.empty())
                    os << " domain " << dzoneCoords[i].c_str() << "\n";
                if (showZoneBlockLogicalCoords && !bzoneCoords.empty())
                    os << " block " << bzoneCoords[i].c_str() << "\n";
            }
        }
        os << "\n";
    }
    for (i = 0; i < varInfo.size(); i++)
        ((PickVarInfo*)varInfo[i])->PrintSelf(os);

    os << "RayPoint 1: <" << rayPoint1[0] << ", " 
                          << rayPoint1[1] << ", " 
                          << rayPoint1[2] << ">\n";
    os << "RayPoint 2: <" << rayPoint2[0] << ", " 
                          << rayPoint2[1] << ", " 
                          << rayPoint2[2] << ">\n";

    if (doTimeCurve)
        os << "Set up to create a time-curve.\n";

    if (conciseOutput)
        os << "Set up to create concise Output.\n";
}

// ****************************************************************************
// Method: PickAttributes::CreateOutputString
//
// Purpose: 
//   Creates a single output string containing all the information gathered
//   from a pick. 
//
// Modifications:
//   Kathleen Bonnell, Thu Jun 26 09:31:56 PDT 2003
//   Reflect new member names (zoneNumber is now elementNumber, nodes is
//   now incidentElements).  Differentiate between zone pick and node pick.
//   
//   Kathleen Bonnell, Wed Jul 23 17:28:30 PDT 2003 
//   Don't include cellPoint or pickLetter if invalid.
//   
//   Kathleen Bonnell, Wed Sep 10 08:02:02 PDT 2003 
//   Added meshInfo.  So that outputstring can be created with (default)
//   or without the 'pickletter', added argument withLetter.
//   
//   Kathleen Bonnell, Tue Nov 18 10:06:40 PST 2003 
//   Support logical zone numbers. 
//   
//   Kathleen Bonnell, Tue Dec  2 17:33:13 PST 2003 
//   Minor changes so that picking on Curves does not display unnecessary
//   information. 
//   
//   Kathleen Bonnell, Wed Dec 17 15:19:46 PST 2003 
//   Support multiple types of coordinates. 
//   
//   Kathleen Bonnell, Tue Mar 16 16:02:05 PST 2004 
//   Create message regarding invalid variables. 
//   
//   Kathleen Bonnell, Tue Jun  1 16:44:44 PDT 2004 
//   Support new pick types 'DomainNode', 'DomainZone'. 
//   
//   Kathleen Bonnell, Wed Jun  9 12:24:09 PDT 2004 
//   Added 'showTimeStep'. 
//
//   Mark C. Miller, Tue Aug 24 19:53:18 PDT 2004
//   Added block/group piece names
//   
// ****************************************************************************
void
PickAttributes::CreateOutputString(std::string &os, bool withLetter)
{
    if (error)
    {
        os = errorMessage;
        return;
    }

    if (!fulfilled)
        return;

    if (conciseOutput)
    {
        CreateConciseOutputString(os, withLetter); 
        return;
    }

    int i;
    char buff[512];
   
    std::string fileName; 
    int pos = databaseName.find_last_of('/');
    if (pos >= databaseName.size())
        fileName = databaseName;
    else
        fileName = databaseName.substr(pos+1) ;

    if (withLetter)
    {
        if (pickLetter.size() != 0)
            SNPRINTF(buff, 512, "\n%s:  ", pickLetter.c_str());
        else 
            SNPRINTF(buff, 512, "\n");
        os += buff;
    }
    os += fileName;

    std::string domStr = (blockPieceName == "" ? "domain" : blockPieceName);
    std::string grpStr = (groupPieceName == "" ? "group" : groupPieceName);

    if (showTimeStep)
    {
        SNPRINTF(buff, 512, "  timestep %d", timeStep);
        os += buff;
    }
    if (meshInfo.empty())
    {
        if (domain != -1)
        {
            SNPRINTF(buff, 512, "  %s %d\n", domStr.c_str(), domain);
            os += buff;
        }
        else 
            os += "\n";
    }
    else
    {
        SNPRINTF(buff, 512, "\n%s\n", meshInfo.c_str());
        os += buff;
    }
    if (pickType == CurveNode)
    {
        SNPRINTF(buff, 512, "Point: <%f, %f>\n", nodePoint[0], nodePoint[1]);
        os += buff;
    }
    else if (pickType == CurveZone)
    {
        SNPRINTF(buff, 512, "Point1: <%f, %f>\nPoint2: <%f, %f>\n", 
                  nodePoint[0], nodePoint[1], cellPoint[0], cellPoint[1]);
        os += buff;
    }
    else if (cellPoint[0] != FLT_MAX)
    {
        if (dimension == 2)
        {
            if (!needTransformMessage)
            {
                SNPRINTF(buff, 512, "Point: <%f, %f>\n",
                        cellPoint[0], cellPoint[1]);
            }
            else 
            {
                SNPRINTF(buff, 512, "Point: (in transformed space)\n        <%f, %f>\n",
                        cellPoint[0], cellPoint[1]);
            }
        }
        else 
        {
            if (!needTransformMessage)
            {
                SNPRINTF(buff, 512, "Point: <%f, %f, %f>\n",
                        cellPoint[0], cellPoint[1], cellPoint[2]);
            }
            else 
            {
                SNPRINTF(buff, 512, "Point: (in transformed space) \n       <%f, %f, %f>\n",
                        cellPoint[0], cellPoint[1], cellPoint[2]);
            }
        }
        os += buff;
    }
    bool showZoneCoords = (showZoneDomainLogicalCoords  && !dzoneCoords.empty()) || 
                          (showZoneBlockLogicalCoords && !bzoneCoords.empty());
    bool showNodeCoords = (showNodePhysicalCoords && !pnodeCoords.empty())||
                          (showNodeDomainLogicalCoords && !dnodeCoords.empty())|| 
                          (showNodeBlockLogicalCoords && !bnodeCoords.empty());
    if (pickType == Zone || pickType == DomainZone)
    {
        if (showZoneId || showZoneCoords)
            os += "Zone:  ";
        if (showZoneId)
        {
            if (!elementIsGhost) 
            {
                if (!displayGlobalIds || globalElement == -1) 
                    SNPRINTF(buff, 512, "%d", elementNumber);
                else 
                    SNPRINTF(buff, 512, "%d (global)", globalElement);
            }
            else 
                SNPRINTF(buff, 512, "%d(ghost)", elementNumber);
            os += buff;
        }
        if (showZoneDomainLogicalCoords & !dzoneCoords.empty()) 
        {
            SNPRINTF(buff, 512, " %s %s", domStr.c_str(), dzoneCoords[0].c_str());
            os += buff;
        }
        if (showZoneBlockLogicalCoords & !bzoneCoords.empty()) 
        {
            SNPRINTF(buff, 512, " %s %s", grpStr.c_str(), bzoneCoords[0].c_str());
            os += buff;
        }
        if (showZoneId || showZoneCoords)
            os += "\n";
    }
    else if (pickType == Node || pickType == DomainNode)
    {
        if (showNodeId || showNodeCoords)
            os += "Node:  ";
        if (showNodeId)
        {
            if (!elementIsGhost)
            {
                if (!displayGlobalIds || globalElement == -1)
                    SNPRINTF(buff, 512, "%d", elementNumber);
                else 
                    SNPRINTF(buff, 512, "%d (global)", globalElement);
            }
            else 
                SNPRINTF(buff, 512, "%d(ghost)", elementNumber);
            os += buff;
        }
        if (showNodePhysicalCoords & !pnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, " %s", pnodeCoords[0].c_str());
            os += buff;
        }
        if (showNodeDomainLogicalCoords & !dnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, " %s %s", domStr.c_str(), dnodeCoords[0].c_str());
            os += buff;
        }
        if (showNodeBlockLogicalCoords & !bnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, " %s %s", grpStr.c_str(), bnodeCoords[0].c_str());
            os += buff;
        }
        if (showNodeId || showNodeCoords)
            os += "\n";
    }
    if (displayIncidentElements)
    {
        bool showId;
        bool showGlobal = globalIncidentElements.size() == incidentElements.size();
        if (pickType == Zone || pickType == DomainZone)
        {
            if (!showGlobal)
                os += "Incident Nodes:  " ; 
            else 
                os += "Incident Nodes: (global)  " ; 
            if (showNodeCoords)
            {
                os += "\n    "; 
            }
            showId = showNodeId;
        }
        else if (pickType == Node || pickType == DomainNode)
        {
            if (!showGlobal)
                os += "Incident Zones:  " ; 
            else 
                os += "Incident Zones: (global)  " ; 
            if (showZoneCoords)
            {
                os += "\n    "; 
            }
            showId = showZoneId;
        }
        for (i = 0; i < incidentElements.size(); i++)
        {
            if (showId)
            {
                if (ghosts.size() > 0 && ghosts[i])
                    SNPRINTF(buff, 512, "%d(ghost)  ", incidentElements[i]);
                else if (showGlobal)
                    SNPRINTF(buff, 512, "%d  ", globalIncidentElements[i]);
                else 
                    SNPRINTF(buff, 512, "%d  ", incidentElements[i]);
                os += buff; 
            }
            if (pickType == Zone || pickType == DomainZone)
            {
                if (showNodePhysicalCoords & !pnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, " %s", pnodeCoords[i].c_str());
                    os += buff;
                }
                if (showNodeDomainLogicalCoords & !dnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, " %s %s", domStr.c_str(), dnodeCoords[i].c_str());
                    os += buff;
                }
                if (showNodeBlockLogicalCoords & !bnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, " %s %s", grpStr.c_str(), bnodeCoords[i].c_str());
                    os += buff;
                }
                if (showNodeCoords)
                {
                    os += "\n    "; 
                }
            }
            else if (pickType == Node || pickType == DomainNode)
            {
                if (showZoneDomainLogicalCoords & !dzoneCoords.empty()) 
                {
                    SNPRINTF(buff, 512, " %s %s", domStr.c_str(), dzoneCoords[i].c_str());
                    os += buff;
                }
                if (showZoneBlockLogicalCoords & !bzoneCoords.empty()) 
                {
                    SNPRINTF(buff, 512, " %s %s", grpStr.c_str(), bzoneCoords[i].c_str());
                    os += buff;
                }
                if (showZoneCoords)
                {
                    os += "\n    "; 
                }
            }
        }
        os += "\n";
    }

    for (i = 0; i < varInfo.size(); i++)
    {
        std::string iv;
        std::string pt = PickType_ToString(pickType);
        //
        // VarInfo does not append a newline char, but we need one here
        //
        ((PickVarInfo*)varInfo[i])->CreateOutputString(iv, pt);
        os += iv;
        os += "\n";
    }
    if (invalidVars.size() > 0)
    {
        os += "The following variables are invalid, and Pick ignored them:\n";
        for (i = 0; i < invalidVars.size(); i++)
        {
            os += "  " + invalidVars[i];
        }
        os += "\n";
    }
}

// ****************************************************************************
// Method: PickAttributes::PrepareForNewPick
//
// Purpose: 
//   Clear certain fields in preparation for new pick.  These are fields that
//   will get filled in during the pick process.
//
// Programmer: Kathleen Bonnell 
// Creation:   June 26, 2003 
//
// Modifications:
//   Kathleen Bonnell, Wed Sep 10 08:02:02 PDT 2003
//   Reset meshInfo.
//   
//   Kathleen Bonnell, Wed Sep 17 17:09:00 PDT 2003 
//   Reset realElementNumber, realIncidentElements.
//   
//   Kathleen Bonnell, Tue Nov 18 10:06:40 PST 2003 
//   Reset zoneCoords. 
//   
//   Kathleen Bonnell, Wed Dec 17 15:19:46 PST 2003 
//   Support new types of coordinates. 
//   
//   Kathleen Bonnell, Tue Mar 16 16:02:05 PST 2004
//   Clear invalidVars. 
//   
//   Kathleen Bonnell, Tue Jun  1 16:44:44 PDT 2004 
//   Reset matSelected and needActualCoords. 
//
//   Mark C. Miller, Tue Aug 24 19:37:14 PDT 2004
//   Added code to reset blockPieceName and groupPieceName
//
//   Kathleen Bonnell, Thu Oct 21 15:17:05 PDT 2004 
//   Reset requiresPickGlyph. 
//
// ****************************************************************************

void
PickAttributes::PrepareForNewPick()
{
    clearWindow  = false;
    fulfilled    = false;
    elementNumber   = -1;
    domain          = -1;
    dimension       = -1;
    pickPoint[0] = pickPoint[1] = pickPoint[2] = 0;
    cellPoint[0] = cellPoint[1] = cellPoint[2] = 0;
    nodePoint[0] = nodePoint[1] = nodePoint[2] = 0;
    needTransformMessage = false;

    if (!incidentElements.empty())
        incidentElements.clear();

    if (!pnodeCoords.empty())
        pnodeCoords.clear();

    if (!dnodeCoords.empty())
        dnodeCoords.clear();

    if (!bnodeCoords.empty())
        bnodeCoords.clear();

    if (!dzoneCoords.empty())
        dzoneCoords.clear();

    if (!bzoneCoords.empty())
        bzoneCoords.clear();

    realElementNumber = -1;
    if (!realIncidentElements.empty())
        realIncidentElements.clear();

    meshInfo = "";
    for (int i = 0; i < 6; ++i)
        plotBounds[i] = 0.;

    ClearPickVarInfos();

    if (!invalidVars.empty())
        invalidVars.clear();

    errorMessage = "";
    error = false;

    matSelected = false;

    needActualCoords = false;

    blockPieceName = "";
    groupPieceName = "";

    if (!ghosts.empty())
        ghosts.clear();

    includeGhosts = false;
    elementIsGhost = false;
    requiresGlyphPick = false;
    locationSuccessful = false;

    globalElement = -1;
    if (!globalIncidentElements.empty())
        globalIncidentElements.clear();
}

// ****************************************************************************
// Method: PickAttributes::CreateConciseOutputString
//
// Purpose: 
//   Creates a single output string containing all the information gathered
//   from a pick, condensed to use as little space as possible. 
//
// Programmer:  Kathleen Bonnell
// Creation:    June 9, 2004
//
// Modifications:
//
//   Mark C. Miller, Tue Aug 24 19:53:18 PDT 2004
//   Added block/group piece names
//   
// ****************************************************************************

void
PickAttributes::CreateConciseOutputString(std::string &os, bool withLetter)
{
    int i;
    char buff[512];
   
    std::string fileName; 
    int pos = databaseName.find_last_of('/');
    if (pos >= databaseName.size())
        fileName = databaseName;
    else
        fileName = databaseName.substr(pos+1) ;

    if (withLetter)
    {
        if (pickLetter.size() != 0)
            SNPRINTF(buff, 512, "\n%s:  ", pickLetter.c_str());
        else 
            SNPRINTF(buff, 512, "\n");
        os += buff;
    }
    os += fileName;
    if (showTimeStep)
    {
        SNPRINTF(buff, 512, "  timestep %d", timeStep);
        os += buff;
    }

    std::string domStr = (blockPieceName == "" ? "domain" : blockPieceName);

    if (meshInfo.empty()) 
    {
        if (domain != -1)
        {
            SNPRINTF(buff, 512, "  %s %d", domStr.c_str(), domain);
            os += buff;
        }
    }
    else
    {
        SNPRINTF(buff, 512, "  %s", meshInfo.c_str());
        os += buff;
    }
    if (pickType == CurveNode)
    {
        SNPRINTF(buff, 512, " at <%f, %f>\n", nodePoint[0], nodePoint[1]);
        os += buff;
    }
    else if (pickType == CurveZone)
    {
        SNPRINTF(buff, 512, " at <%f, %f> & <%f, %f>\n", 
                  nodePoint[0], nodePoint[1], cellPoint[0], cellPoint[1]);
        os += buff;
    }
    else if (cellPoint[0] != FLT_MAX)
    {
        if (dimension == 2)
        {
            SNPRINTF(buff, 512, " at <%f, %f>\n", cellPoint[0], cellPoint[1]);
        }
        else 
        {
            SNPRINTF(buff, 512, " at <%f, %f, %f>\n",
                        cellPoint[0], cellPoint[1], cellPoint[2]);
        }
        os += buff;
    }
    bool showZoneCoords = (showZoneDomainLogicalCoords  && !dzoneCoords.empty()) || 
                          (showZoneBlockLogicalCoords && !bzoneCoords.empty());
    bool showNodeCoords = (showNodePhysicalCoords && !pnodeCoords.empty())||
                          (showNodeDomainLogicalCoords && !dnodeCoords.empty())|| 
                          (showNodeBlockLogicalCoords && !bnodeCoords.empty());
    if (pickType == Zone || pickType == DomainZone)
    {
        if (showZoneId || showZoneCoords)
            os += "Zone: ";
        if (showZoneId)
        {
            if (!elementIsGhost)
            {
                if (globalElement == -1)
                    SNPRINTF(buff, 512, "%d ", elementNumber);
                else 
                    SNPRINTF(buff, 512, "%d (global) ", globalElement);
            }
            else 
                SNPRINTF(buff, 512, "%d(ghost) ", elementNumber);
            os += buff;
        }
        if (showZoneDomainLogicalCoords & !dzoneCoords.empty()) 
        {
            SNPRINTF(buff, 512, "%s ", dzoneCoords[0].c_str());
            os += buff;
        }
        if (showZoneBlockLogicalCoords & !bzoneCoords.empty()) 
        {
            SNPRINTF(buff, 512, "%s ", bzoneCoords[0].c_str());
            os += buff;
        }
    }
    else if (pickType == Node || pickType == DomainNode)
    {
        if (showNodeId || showNodeCoords)
            os += "Node: ";
        if (showNodeId)
        {
            if (!elementIsGhost)
            {
                if (globalElement == -1)
                    SNPRINTF(buff, 512, "%d ", elementNumber);
                else 
                    SNPRINTF(buff, 512, "%d (global) ", globalElement);
            }
            else 
                SNPRINTF(buff, 512, "%d(ghost) ", elementNumber);
            os += buff;
        }
        if (showNodePhysicalCoords & !pnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, "%s ", pnodeCoords[0].c_str());
            os += buff;
        }
        if (showNodeDomainLogicalCoords & !dnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, "%s ", dnodeCoords[0].c_str());
            os += buff;
        }
        if (showNodeBlockLogicalCoords & !bnodeCoords.empty()) 
        {
            SNPRINTF(buff, 512, "%s ", bnodeCoords[0].c_str());
            os += buff;
        }
    }
    if (displayIncidentElements)
    {
        bool showId;
        bool showGlobal = globalIncidentElements.size() == incidentElements.size();
        if (pickType == Zone || pickType == DomainZone)
        {
            os += "  Nodes: " ; 
            showId = showNodeId;
        }
        else if (pickType == Node || pickType == DomainNode)
        {
            os += "  Zones: " ; 
            showId = showZoneId;
        }
        if (showId && showGlobal)
            os += " (global) ";
        for (i = 0; i < incidentElements.size(); i++)
        {
            if (showId)
            {
                if (ghosts.size() > 0 && ghosts[i])
                    SNPRINTF(buff, 512, "%d(ghost) ", incidentElements[i]);
                else if (showGlobal) 
                    SNPRINTF(buff, 512, "%d ", globalIncidentElements[i]);
                else 
                    SNPRINTF(buff, 512, "%d ", incidentElements[i]);
                os += buff; 
            }
            if (pickType == Zone || pickType == DomainZone)
            {
                if (showNodePhysicalCoords & !pnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, "%s ", pnodeCoords[i].c_str());
                    os += buff;
                }
                if (showNodeDomainLogicalCoords & !dnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, "%s ", dnodeCoords[i].c_str());
                    os += buff;
                }
                if (showNodeBlockLogicalCoords & !bnodeCoords.empty()) 
                {
                    SNPRINTF(buff, 512, "%s ", bnodeCoords[i].c_str());
                    os += buff;
                }
            }
            else if (pickType == Node || pickType == DomainNode)
            {
                if (showZoneDomainLogicalCoords & !dzoneCoords.empty()) 
                {
                    SNPRINTF(buff, 512, "%s ", dzoneCoords[i].c_str());
                    os += buff;
                }
                if (showZoneBlockLogicalCoords & !bzoneCoords.empty()) 
                {
                    SNPRINTF(buff, 512, "%s ", bzoneCoords[i].c_str());
                    os += buff;
                }
            }
        }
        os += "\n";
    }

    for (i = 0; i < varInfo.size(); i++)
    {
        std::string iv;
        std::string pt = PickType_ToString(pickType);
        //
        // VarInfo does not append a newline char, but we need one here
        //
        ((PickVarInfo*)varInfo[i])->CreateOutputString(iv, pt);
        os += iv;
        os += "\n";
    }
    if (invalidVars.size() > 0)
    {
        os += "The following variables are invalid, and Pick ignored them:\n";
        for (i = 0; i < invalidVars.size(); i++)
        {
            os += "  " + invalidVars[i];
        }
        os += "\n";
    }
}

