#ifndef MESSAGEATTRIBUTES_H
#define MESSAGEATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: MessageAttributes
//
// Purpose:
//    This class contains attributes for sending messages.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API MessageAttributes : public AttributeSubject
{
public:
    enum Severity
    {
        Error,
        Warning,
        Message
    };

    MessageAttributes();
    MessageAttributes(const MessageAttributes &obj);
    virtual ~MessageAttributes();

    virtual void operator = (const MessageAttributes &obj);
    virtual bool operator == (const MessageAttributes &obj) const;
    virtual bool operator != (const MessageAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectText();

    // Property setting methods
    void SetText(const std::string &text_);
    void SetSeverity(Severity severity_);

    // Property getting methods
    const std::string &GetText() const;
          std::string &GetText();
    Severity          GetSeverity() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Severity_ToString(Severity);
    static bool Severity_FromString(const std::string &, Severity &);
protected:
    static std::string Severity_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    std::string text;
    int         severity;
};

#endif
