#include <MessageAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for MessageAttributes::Severity
//

static const char *Severity_strings[] = {
"Error", "Warning", "Message"
};

std::string
MessageAttributes::Severity_ToString(MessageAttributes::Severity t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Severity_strings[index];
}

std::string
MessageAttributes::Severity_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Severity_strings[index];
}

bool
MessageAttributes::Severity_FromString(const std::string &s, MessageAttributes::Severity &val)
{
    val = MessageAttributes::Error;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Severity_strings[i])
        {
            val = (Severity)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: MessageAttributes::MessageAttributes
//
// Purpose: 
//   Constructor for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MessageAttributes::MessageAttributes() : AttributeSubject("si")
{
    text = "";
    severity = Message;
}

// ****************************************************************************
// Method: MessageAttributes::MessageAttributes
//
// Purpose: 
//   Copy constructor for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MessageAttributes::MessageAttributes(const MessageAttributes &obj) : AttributeSubject("si")
{
    text = obj.text;
    severity = obj.severity;

    SelectAll();
}

// ****************************************************************************
// Method: MessageAttributes::~MessageAttributes
//
// Purpose: 
//   Destructor for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MessageAttributes::~MessageAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MessageAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MessageAttributes::operator = (const MessageAttributes &obj)
{
    text = obj.text;
    severity = obj.severity;

    SelectAll();
}

// ****************************************************************************
// Method: MessageAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MessageAttributes::operator == (const MessageAttributes &obj) const
{
    // Create the return value
    return ((text == obj.text) &&
            (severity == obj.severity));
}

// ****************************************************************************
// Method: MessageAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MessageAttributes::operator != (const MessageAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MessageAttributes::TypeName
//
// Purpose: 
//   Type name method for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
MessageAttributes::TypeName() const
{
    return "MessageAttributes";
}

// ****************************************************************************
// Method: MessageAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MessageAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MessageAttributes *tmp = (const MessageAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MessageAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MessageAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MessageAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MessageAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MessageAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MessageAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MessageAttributes(*this);
    else
        retval = new MessageAttributes;

    return retval;
}

// ****************************************************************************
// Method: MessageAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MessageAttributes::SelectAll()
{
    Select(0, (void *)&text);
    Select(1, (void *)&severity);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MessageAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MessageAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MessageAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MessageAttributes.
    DataNode *node = new DataNode("MessageAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("text", text));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("severity", Severity_ToString(severity)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MessageAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MessageAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MessageAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("text")) != 0)
        SetText(node->AsString());
    if((node = searchNode->GetNode("severity")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetSeverity(Severity(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Severity value;
            if(Severity_FromString(node->AsString(), value))
                SetSeverity(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MessageAttributes::SetText(const std::string &text_)
{
    text = text_;
    Select(0, (void *)&text);
}

void
MessageAttributes::SetSeverity(MessageAttributes::Severity severity_)
{
    severity = severity_;
    Select(1, (void *)&severity);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
MessageAttributes::GetText() const
{
    return text;
}

std::string &
MessageAttributes::GetText()
{
    return text;
}

MessageAttributes::Severity
MessageAttributes::GetSeverity() const
{
    return Severity(severity);
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MessageAttributes::SelectText()
{
    Select(0, (void *)&text);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MessageAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MessageAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "text";
        case 1:  return "severity";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MessageAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MessageAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MessageAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MessageAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MessageAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:16 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MessageAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MessageAttributes &obj = *((const MessageAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (text == obj.text);
        }
        break;
    case 1:
        {  // new scope
        retval = (severity == obj.severity);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

