#include <MaterialAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: MaterialAttributes::MaterialAttributes
//
// Purpose: 
//   Constructor for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MaterialAttributes::MaterialAttributes() : AttributeSubject("bbbbb")
{
    smoothing = false;
    forceMIR = false;
    cleanZonesOnly = false;
    needValidConnectivity = false;
    useNewMIRAlgorithm = true;
}

// ****************************************************************************
// Method: MaterialAttributes::MaterialAttributes
//
// Purpose: 
//   Copy constructor for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MaterialAttributes::MaterialAttributes(const MaterialAttributes &obj) : AttributeSubject("bbbbb")
{
    smoothing = obj.smoothing;
    forceMIR = obj.forceMIR;
    cleanZonesOnly = obj.cleanZonesOnly;
    needValidConnectivity = obj.needValidConnectivity;
    useNewMIRAlgorithm = obj.useNewMIRAlgorithm;

    SelectAll();
}

// ****************************************************************************
// Method: MaterialAttributes::~MaterialAttributes
//
// Purpose: 
//   Destructor for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

MaterialAttributes::~MaterialAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MaterialAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MaterialAttributes::operator = (const MaterialAttributes &obj)
{
    smoothing = obj.smoothing;
    forceMIR = obj.forceMIR;
    cleanZonesOnly = obj.cleanZonesOnly;
    needValidConnectivity = obj.needValidConnectivity;
    useNewMIRAlgorithm = obj.useNewMIRAlgorithm;

    SelectAll();
}

// ****************************************************************************
// Method: MaterialAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MaterialAttributes::operator == (const MaterialAttributes &obj) const
{
    // Create the return value
    return ((smoothing == obj.smoothing) &&
            (forceMIR == obj.forceMIR) &&
            (cleanZonesOnly == obj.cleanZonesOnly) &&
            (needValidConnectivity == obj.needValidConnectivity) &&
            (useNewMIRAlgorithm == obj.useNewMIRAlgorithm));
}

// ****************************************************************************
// Method: MaterialAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MaterialAttributes::operator != (const MaterialAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MaterialAttributes::TypeName
//
// Purpose: 
//   Type name method for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
MaterialAttributes::TypeName() const
{
    return "MaterialAttributes";
}

// ****************************************************************************
// Method: MaterialAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MaterialAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MaterialAttributes *tmp = (const MaterialAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MaterialAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MaterialAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MaterialAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MaterialAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MaterialAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MaterialAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MaterialAttributes(*this);
    else
        retval = new MaterialAttributes;

    return retval;
}

// ****************************************************************************
// Method: MaterialAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MaterialAttributes::SelectAll()
{
    Select(0, (void *)&smoothing);
    Select(1, (void *)&forceMIR);
    Select(2, (void *)&cleanZonesOnly);
    Select(3, (void *)&needValidConnectivity);
    Select(4, (void *)&useNewMIRAlgorithm);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MaterialAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MaterialAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MaterialAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MaterialAttributes.
    DataNode *node = new DataNode("MaterialAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothing", smoothing));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("forceMIR", forceMIR));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cleanZonesOnly", cleanZonesOnly));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("needValidConnectivity", needValidConnectivity));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useNewMIRAlgorithm", useNewMIRAlgorithm));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MaterialAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
MaterialAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MaterialAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("smoothing")) != 0)
        SetSmoothing(node->AsBool());
    if((node = searchNode->GetNode("forceMIR")) != 0)
        SetForceMIR(node->AsBool());
    if((node = searchNode->GetNode("cleanZonesOnly")) != 0)
        SetCleanZonesOnly(node->AsBool());
    if((node = searchNode->GetNode("needValidConnectivity")) != 0)
        SetNeedValidConnectivity(node->AsBool());
    if((node = searchNode->GetNode("useNewMIRAlgorithm")) != 0)
        SetUseNewMIRAlgorithm(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MaterialAttributes::SetSmoothing(bool smoothing_)
{
    smoothing = smoothing_;
    Select(0, (void *)&smoothing);
}

void
MaterialAttributes::SetForceMIR(bool forceMIR_)
{
    forceMIR = forceMIR_;
    Select(1, (void *)&forceMIR);
}

void
MaterialAttributes::SetCleanZonesOnly(bool cleanZonesOnly_)
{
    cleanZonesOnly = cleanZonesOnly_;
    Select(2, (void *)&cleanZonesOnly);
}

void
MaterialAttributes::SetNeedValidConnectivity(bool needValidConnectivity_)
{
    needValidConnectivity = needValidConnectivity_;
    Select(3, (void *)&needValidConnectivity);
}

void
MaterialAttributes::SetUseNewMIRAlgorithm(bool useNewMIRAlgorithm_)
{
    useNewMIRAlgorithm = useNewMIRAlgorithm_;
    Select(4, (void *)&useNewMIRAlgorithm);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
MaterialAttributes::GetSmoothing() const
{
    return smoothing;
}

bool
MaterialAttributes::GetForceMIR() const
{
    return forceMIR;
}

bool
MaterialAttributes::GetCleanZonesOnly() const
{
    return cleanZonesOnly;
}

bool
MaterialAttributes::GetNeedValidConnectivity() const
{
    return needValidConnectivity;
}

bool
MaterialAttributes::GetUseNewMIRAlgorithm() const
{
    return useNewMIRAlgorithm;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MaterialAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MaterialAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Enable interface smoothing";
        case 1:  return "Force interface reconstruction";
        case 2:  return "Clean zones only";
        case 3:  return "Force perfect connectivity";
        case 4:  return "Use new MIR algorithm";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MaterialAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MaterialAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MaterialAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
MaterialAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MaterialAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:15 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
MaterialAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MaterialAttributes &obj = *((const MaterialAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (smoothing == obj.smoothing);
        }
        break;
    case 1:
        {  // new scope
        retval = (forceMIR == obj.forceMIR);
        }
        break;
    case 2:
        {  // new scope
        retval = (cleanZonesOnly == obj.cleanZonesOnly);
        }
        break;
    case 3:
        {  // new scope
        retval = (needValidConnectivity == obj.needValidConnectivity);
        }
        break;
    case 4:
        {  // new scope
        retval = (useNewMIRAlgorithm == obj.useNewMIRAlgorithm);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

