#include <Line.h>
#include <DataNode.h>

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Constructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Line::Line() : AttributeSubject("DDsaiibbsbi"),
    color(0, 0, 0)
{
    point1[0] = 0;
    point1[1] = 0;
    point1[2] = 0;
    point2[0] = 1;
    point2[1] = 1;
    point2[2] = 1;
    lineStyle = 0;
    lineWidth = 0;
    interactive = false;
    reflineLabels = false;
    varName = "default";
    samplingOn = false;
    numSamples = 50;
}

// ****************************************************************************
// Method: Line::Line
//
// Purpose: 
//   Copy constructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Line::Line(const Line &obj) : AttributeSubject("DDsaiibbsbi")
{
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    designator = obj.designator;
    color = obj.color;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    interactive = obj.interactive;
    reflineLabels = obj.reflineLabels;
    varName = obj.varName;
    samplingOn = obj.samplingOn;
    numSamples = obj.numSamples;

    SelectAll();
}

// ****************************************************************************
// Method: Line::~Line
//
// Purpose: 
//   Destructor for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

Line::~Line()
{
    // nothing here
}

// ****************************************************************************
// Method: Line::operator = 
//
// Purpose: 
//   Assignment operator for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
Line::operator = (const Line &obj)
{
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    designator = obj.designator;
    color = obj.color;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    interactive = obj.interactive;
    reflineLabels = obj.reflineLabels;
    varName = obj.varName;
    samplingOn = obj.samplingOn;
    numSamples = obj.numSamples;

    SelectAll();
}

// ****************************************************************************
// Method: Line::operator == 
//
// Purpose: 
//   Comparison operator == for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Line::operator == (const Line &obj) const
{
    int i;

    // Compare the point1 arrays.
    bool point1_equal = true;
    for(i = 0; i < 3 && point1_equal; ++i)
        point1_equal = (point1[i] == obj.point1[i]);

    // Compare the point2 arrays.
    bool point2_equal = true;
    for(i = 0; i < 3 && point2_equal; ++i)
        point2_equal = (point2[i] == obj.point2[i]);

    // Create the return value
    return (point1_equal &&
            point2_equal &&
            (designator == obj.designator) &&
            (color == obj.color) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (interactive == obj.interactive) &&
            (reflineLabels == obj.reflineLabels) &&
            (varName == obj.varName) &&
            (samplingOn == obj.samplingOn) &&
            (numSamples == obj.numSamples));
}

// ****************************************************************************
// Method: Line::operator != 
//
// Purpose: 
//   Comparison operator != for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Line::operator != (const Line &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Line::TypeName
//
// Purpose: 
//   Type name method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
Line::TypeName() const
{
    return "Line";
}

// ****************************************************************************
// Method: Line::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Line::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Line *tmp = (const Line *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Line::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Line::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Line(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Line::NewInstance
//
// Purpose: 
//   NewInstance method for the Line class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Line::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Line(*this);
    else
        retval = new Line;

    return retval;
}

// ****************************************************************************
// Method: Line::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
Line::SelectAll()
{
    Select(0, (void *)point1, 3);
    Select(1, (void *)point2, 3);
    Select(2, (void *)&designator);
    Select(3, (void *)&color);
    Select(4, (void *)&lineStyle);
    Select(5, (void *)&lineWidth);
    Select(6, (void *)&interactive);
    Select(7, (void *)&reflineLabels);
    Select(8, (void *)&varName);
    Select(9, (void *)&samplingOn);
    Select(10, (void *)&numSamples);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Line::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Line::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    Line defaultObject;
    bool addToParent = false;
    // Create a node for Line.
    DataNode *node = new DataNode("Line");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point1", point1, 3));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point2", point2, 3));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("reflineLabels", reflineLabels));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("varName", varName));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplingOn", samplingOn));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numSamples", numSamples));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: Line::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
Line::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("Line");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("point1")) != 0)
        SetPoint1(node->AsDoubleArray());
    if((node = searchNode->GetNode("point2")) != 0)
        SetPoint2(node->AsDoubleArray());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
    if((node = searchNode->GetNode("reflineLabels")) != 0)
        SetReflineLabels(node->AsBool());
    if((node = searchNode->GetNode("varName")) != 0)
        SetVarName(node->AsString());
    if((node = searchNode->GetNode("samplingOn")) != 0)
        SetSamplingOn(node->AsBool());
    if((node = searchNode->GetNode("numSamples")) != 0)
        SetNumSamples(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Line::SetPoint1(const double *point1_)
{
    point1[0] = point1_[0];
    point1[1] = point1_[1];
    point1[2] = point1_[2];
    Select(0, (void *)point1, 3);
}

void
Line::SetPoint2(const double *point2_)
{
    point2[0] = point2_[0];
    point2[1] = point2_[1];
    point2[2] = point2_[2];
    Select(1, (void *)point2, 3);
}

void
Line::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(2, (void *)&designator);
}

void
Line::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(3, (void *)&color);
}

void
Line::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(4, (void *)&lineStyle);
}

void
Line::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(5, (void *)&lineWidth);
}

void
Line::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(6, (void *)&interactive);
}

void
Line::SetReflineLabels(bool reflineLabels_)
{
    reflineLabels = reflineLabels_;
    Select(7, (void *)&reflineLabels);
}

void
Line::SetVarName(const std::string &varName_)
{
    varName = varName_;
    Select(8, (void *)&varName);
}

void
Line::SetSamplingOn(bool samplingOn_)
{
    samplingOn = samplingOn_;
    Select(9, (void *)&samplingOn);
}

void
Line::SetNumSamples(int numSamples_)
{
    numSamples = numSamples_;
    Select(10, (void *)&numSamples);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
Line::GetPoint1() const
{
    return point1;
}

double *
Line::GetPoint1()
{
    return point1;
}

const double *
Line::GetPoint2() const
{
    return point2;
}

double *
Line::GetPoint2()
{
    return point2;
}

const std::string &
Line::GetDesignator() const
{
    return designator;
}

std::string &
Line::GetDesignator()
{
    return designator;
}

const ColorAttribute &
Line::GetColor() const
{
    return color;
}

ColorAttribute &
Line::GetColor()
{
    return color;
}

int
Line::GetLineStyle() const
{
    return lineStyle;
}

int
Line::GetLineWidth() const
{
    return lineWidth;
}

bool
Line::GetInteractive() const
{
    return interactive;
}

bool
Line::GetReflineLabels() const
{
    return reflineLabels;
}

const std::string &
Line::GetVarName() const
{
    return varName;
}

std::string &
Line::GetVarName()
{
    return varName;
}

bool
Line::GetSamplingOn() const
{
    return samplingOn;
}

int
Line::GetNumSamples() const
{
    return numSamples;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Line::SelectPoint1()
{
    Select(0, (void *)point1, 3);
}

void
Line::SelectPoint2()
{
    Select(1, (void *)point2, 3);
}

void
Line::SelectDesignator()
{
    Select(2, (void *)&designator);
}

void
Line::SelectColor()
{
    Select(3, (void *)&color);
}

void
Line::SelectVarName()
{
    Select(8, (void *)&varName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Line::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
Line::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "point1";
        case 1:  return "point2";
        case 2:  return "designator";
        case 3:  return "color";
        case 4:  return "lineStyle";
        case 5:  return "lineWidth";
        case 6:  return "interactive";
        case 7:  return "reflineLabels";
        case 8:  return "varName";
        case 9:  return "samplingOn";
        case 10:  return "numSamples";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Line::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Line::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_doubleArray;
        case 1:  return FieldType_doubleArray;
        case 2:  return FieldType_string;
        case 3:  return FieldType_color;
        case 4:  return FieldType_linestyle;
        case 5:  return FieldType_linewidth;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_string;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Line::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
Line::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "doubleArray";
        case 1:  return "doubleArray";
        case 2:  return "string";
        case 3:  return "color";
        case 4:  return "linestyle";
        case 5:  return "linewidth";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "string";
        case 9:  return "bool";
        case 10:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Line::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Jul 27 09:34:37 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
Line::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const Line &obj = *((const Line*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the point1 arrays.
        bool point1_equal = true;
        for(i = 0; i < 3 && point1_equal; ++i)
            point1_equal = (point1[i] == obj.point1[i]);

        retval = point1_equal;
        }
        break;
    case 1:
        {  // new scope
        // Compare the point2 arrays.
        bool point2_equal = true;
        for(i = 0; i < 3 && point2_equal; ++i)
            point2_equal = (point2[i] == obj.point2[i]);

        retval = point2_equal;
        }
        break;
    case 2:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    case 3:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case 4:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 5:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 6:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    case 7:
        {  // new scope
        retval = (reflineLabels == obj.reflineLabels);
        }
        break;
    case 8:
        {  // new scope
        retval = (varName == obj.varName);
        }
        break;
    case 9:
        {  // new scope
        retval = (samplingOn == obj.samplingOn);
        }
        break;
    case 10:
        {  // new scope
        retval = (numSamples == obj.numSamples);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method:  Line::SetPoint1
//
//  Purpose:
//    A method to set the xyz values of point1. 
//
//  Arguments:
//    x,y,z   the coordinate
//
//  Programmer:  Kathleen Bonnell 
//  Creation:    February 28, 2003 
//
// ****************************************************************************

void
Line::SetPoint1(double x, double y, double z) 
{
    point1[0] = x;
    point1[1] = y;
    point1[2] = z;
    Select(0, (void*)point1, 3);
}

// ****************************************************************************
//  Method:  Line::SetPoint2
//
//  Purpose:
//    A method to set the xyz values of point2. 
//
//  Arguments:
//    x,y,z   the coordinate
//
//  Programmer:  Kathleen Bonnell 
//  Creation:    February 28, 2003 
//
// ****************************************************************************

void
Line::SetPoint2(double x, double y, double z) 
{
    point2[0] = x;
    point2[1] = y;
    point2[2] = z;
    Select(1, (void*)point2, 3);
}

