#include <LightAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for LightAttributes::LightType
//

static const char *LightType_strings[] = {
"Ambient", "Object", "Camera"
};

std::string
LightAttributes::LightType_ToString(LightAttributes::LightType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LightType_strings[index];
}

std::string
LightAttributes::LightType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LightType_strings[index];
}

bool
LightAttributes::LightType_FromString(const std::string &s, LightAttributes::LightType &val)
{
    val = LightAttributes::Ambient;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LightType_strings[i])
        {
            val = (LightType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Constructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes() : AttributeSubject("biDad"),
    color(255, 255, 255)
{
    enabledFlag = false;
    type = Camera;
    direction[0] = 0;
    direction[1] = 0;
    direction[2] = -1;
    brightness = 1;
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Copy constructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes(const LightAttributes &obj) : AttributeSubject("biDad")
{
    enabledFlag = obj.enabledFlag;
    type = obj.type;
    direction[0] = obj.direction[0];
    direction[1] = obj.direction[1];
    direction[2] = obj.direction[2];

    color = obj.color;
    brightness = obj.brightness;

    SelectAll();
}

// ****************************************************************************
// Method: LightAttributes::~LightAttributes
//
// Purpose: 
//   Destructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::~LightAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LightAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
LightAttributes::operator = (const LightAttributes &obj)
{
    enabledFlag = obj.enabledFlag;
    type = obj.type;
    direction[0] = obj.direction[0];
    direction[1] = obj.direction[1];
    direction[2] = obj.direction[2];

    color = obj.color;
    brightness = obj.brightness;

    SelectAll();
}

// ****************************************************************************
// Method: LightAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::operator == (const LightAttributes &obj) const
{
    int i;

    // Compare the direction arrays.
    bool direction_equal = true;
    for(i = 0; i < 3 && direction_equal; ++i)
        direction_equal = (direction[i] == obj.direction[i]);

    // Create the return value
    return ((enabledFlag == obj.enabledFlag) &&
            (type == obj.type) &&
            direction_equal &&
            (color == obj.color) &&
            (brightness == obj.brightness));
}

// ****************************************************************************
// Method: LightAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::operator != (const LightAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LightAttributes::TypeName
//
// Purpose: 
//   Type name method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
LightAttributes::TypeName() const
{
    return "LightAttributes";
}

// ****************************************************************************
// Method: LightAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LightAttributes *tmp = (const LightAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LightAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LightAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LightAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LightAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LightAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LightAttributes(*this);
    else
        retval = new LightAttributes;

    return retval;
}

// ****************************************************************************
// Method: LightAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
LightAttributes::SelectAll()
{
    Select(0, (void *)&enabledFlag);
    Select(1, (void *)&type);
    Select(2, (void *)direction, 3);
    Select(3, (void *)&color);
    Select(4, (void *)&brightness);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LightAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LightAttributes.
    DataNode *node = new DataNode("LightAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabledFlag", enabledFlag));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", LightType_ToString(type)));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("direction", direction, 3));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("brightness", brightness));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LightAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
LightAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LightAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("enabledFlag")) != 0)
        SetEnabledFlag(node->AsBool());
    if((node = searchNode->GetNode("type")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetType(LightType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LightType value;
            if(LightType_FromString(node->AsString(), value))
                SetType(value);
        }
    }
    if((node = searchNode->GetNode("direction")) != 0)
        SetDirection(node->AsDoubleArray());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("brightness")) != 0)
        SetBrightness(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LightAttributes::SetEnabledFlag(bool enabledFlag_)
{
    enabledFlag = enabledFlag_;
    Select(0, (void *)&enabledFlag);
}

void
LightAttributes::SetType(LightAttributes::LightType type_)
{
    type = type_;
    Select(1, (void *)&type);
}

void
LightAttributes::SetDirection(const double *direction_)
{
    direction[0] = direction_[0];
    direction[1] = direction_[1];
    direction[2] = direction_[2];
    Select(2, (void *)direction, 3);
}

void
LightAttributes::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(3, (void *)&color);
}

void
LightAttributes::SetBrightness(double brightness_)
{
    brightness = brightness_;
    Select(4, (void *)&brightness);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
LightAttributes::GetEnabledFlag() const
{
    return enabledFlag;
}

LightAttributes::LightType
LightAttributes::GetType() const
{
    return LightType(type);
}

const double *
LightAttributes::GetDirection() const
{
    return direction;
}

double *
LightAttributes::GetDirection()
{
    return direction;
}

const ColorAttribute &
LightAttributes::GetColor() const
{
    return color;
}

ColorAttribute &
LightAttributes::GetColor()
{
    return color;
}

double
LightAttributes::GetBrightness() const
{
    return brightness;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LightAttributes::SelectDirection()
{
    Select(2, (void *)direction, 3);
}

void
LightAttributes::SelectColor()
{
    Select(3, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
LightAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "enabledFlag";
        case 1:  return "type";
        case 2:  return "direction";
        case 3:  return "color";
        case 4:  return "brightness";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LightAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_enum;
        case 2:  return FieldType_doubleArray;
        case 3:  return FieldType_color;
        case 4:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LightAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
LightAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "enum";
        case 2:  return "doubleArray";
        case 3:  return "color";
        case 4:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const LightAttributes &obj = *((const LightAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (enabledFlag == obj.enabledFlag);
        }
        break;
    case 1:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case 2:
        {  // new scope
        // Compare the direction arrays.
        bool direction_equal = true;
        for(i = 0; i < 3 && direction_equal; ++i)
            direction_equal = (direction[i] == obj.direction[i]);

        retval = direction_equal;
        }
        break;
    case 3:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case 4:
        {  // new scope
        retval = (brightness == obj.brightness);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

