#include <InteractorAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for InteractorAttributes::NavigationMode
//

static const char *NavigationMode_strings[] = {
"Trackball", "Dolly", "Flythrough"
};

std::string
InteractorAttributes::NavigationMode_ToString(InteractorAttributes::NavigationMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return NavigationMode_strings[index];
}

std::string
InteractorAttributes::NavigationMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return NavigationMode_strings[index];
}

bool
InteractorAttributes::NavigationMode_FromString(const std::string &s, InteractorAttributes::NavigationMode &val)
{
    val = InteractorAttributes::Trackball;
    for(int i = 0; i < 3; ++i)
    {
        if(s == NavigationMode_strings[i])
        {
            val = (NavigationMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Constructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes() : AttributeSubject("bbbi")
{
    showGuidelines = true;
    clampSquare = false;
    fillViewportOnZoom = true;
    navigationMode = Trackball;
}

// ****************************************************************************
// Method: InteractorAttributes::InteractorAttributes
//
// Purpose: 
//   Copy constructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::InteractorAttributes(const InteractorAttributes &obj) : AttributeSubject("bbbi")
{
    showGuidelines = obj.showGuidelines;
    clampSquare = obj.clampSquare;
    fillViewportOnZoom = obj.fillViewportOnZoom;
    navigationMode = obj.navigationMode;

    SelectAll();
}

// ****************************************************************************
// Method: InteractorAttributes::~InteractorAttributes
//
// Purpose: 
//   Destructor for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes::~InteractorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: InteractorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

InteractorAttributes& 
InteractorAttributes::operator = (const InteractorAttributes &obj)
{
    if (this == &obj) return *this;
    showGuidelines = obj.showGuidelines;
    clampSquare = obj.clampSquare;
    fillViewportOnZoom = obj.fillViewportOnZoom;
    navigationMode = obj.navigationMode;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: InteractorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::operator == (const InteractorAttributes &obj) const
{
    // Create the return value
    return ((showGuidelines == obj.showGuidelines) &&
            (clampSquare == obj.clampSquare) &&
            (fillViewportOnZoom == obj.fillViewportOnZoom) &&
            (navigationMode == obj.navigationMode));
}

// ****************************************************************************
// Method: InteractorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::operator != (const InteractorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: InteractorAttributes::TypeName
//
// Purpose: 
//   Type name method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
InteractorAttributes::TypeName() const
{
    return "InteractorAttributes";
}

// ****************************************************************************
// Method: InteractorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const InteractorAttributes *tmp = (const InteractorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: InteractorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InteractorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new InteractorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: InteractorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the InteractorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
InteractorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new InteractorAttributes(*this);
    else
        retval = new InteractorAttributes;

    return retval;
}

// ****************************************************************************
// Method: InteractorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
InteractorAttributes::SelectAll()
{
    Select(0, (void *)&showGuidelines);
    Select(1, (void *)&clampSquare);
    Select(2, (void *)&fillViewportOnZoom);
    Select(3, (void *)&navigationMode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InteractorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    InteractorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for InteractorAttributes.
    DataNode *node = new DataNode("InteractorAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showGuidelines", showGuidelines));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("clampSquare", clampSquare));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fillViewportOnZoom", fillViewportOnZoom));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("navigationMode", NavigationMode_ToString(navigationMode)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: InteractorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
InteractorAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("InteractorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("showGuidelines")) != 0)
        SetShowGuidelines(node->AsBool());
    if((node = searchNode->GetNode("clampSquare")) != 0)
        SetClampSquare(node->AsBool());
    if((node = searchNode->GetNode("fillViewportOnZoom")) != 0)
        SetFillViewportOnZoom(node->AsBool());
    if((node = searchNode->GetNode("navigationMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetNavigationMode(NavigationMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            NavigationMode value;
            if(NavigationMode_FromString(node->AsString(), value))
                SetNavigationMode(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
InteractorAttributes::SetShowGuidelines(bool showGuidelines_)
{
    showGuidelines = showGuidelines_;
    Select(0, (void *)&showGuidelines);
}

void
InteractorAttributes::SetClampSquare(bool clampSquare_)
{
    clampSquare = clampSquare_;
    Select(1, (void *)&clampSquare);
}

void
InteractorAttributes::SetFillViewportOnZoom(bool fillViewportOnZoom_)
{
    fillViewportOnZoom = fillViewportOnZoom_;
    Select(2, (void *)&fillViewportOnZoom);
}

void
InteractorAttributes::SetNavigationMode(InteractorAttributes::NavigationMode navigationMode_)
{
    navigationMode = navigationMode_;
    Select(3, (void *)&navigationMode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
InteractorAttributes::GetShowGuidelines() const
{
    return showGuidelines;
}

bool
InteractorAttributes::GetClampSquare() const
{
    return clampSquare;
}

bool
InteractorAttributes::GetFillViewportOnZoom() const
{
    return fillViewportOnZoom;
}

InteractorAttributes::NavigationMode
InteractorAttributes::GetNavigationMode() const
{
    return NavigationMode(navigationMode);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: InteractorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
InteractorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "showGuidelines";
        case 1:  return "clampSquare";
        case 2:  return "fillViewportOnZoom";
        case 3:  return "navigationMode";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InteractorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
InteractorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: InteractorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
InteractorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: InteractorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 11:18:35 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
InteractorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const InteractorAttributes &obj = *((const InteractorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (showGuidelines == obj.showGuidelines);
        }
        break;
    case 1:
        {  // new scope
        retval = (clampSquare == obj.clampSquare);
        }
        break;
    case 2:
        {  // new scope
        retval = (fillViewportOnZoom == obj.fillViewportOnZoom);
        }
        break;
    case 3:
        {  // new scope
        retval = (navigationMode == obj.navigationMode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

