#ifndef HOSTPROFILELIST_H
#define HOSTPROFILELIST_H
#include <state_exports.h>
#include <AttributeSubject.h>
class HostProfile;

// ****************************************************************************
// Class: HostProfileList
//
// Purpose:
//    This class contains a list of host profiles.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API HostProfileList : public AttributeSubject
{
public:
    HostProfileList();
    HostProfileList(const HostProfileList &obj);
    virtual ~HostProfileList();

    virtual void operator = (const HostProfileList &obj);
    virtual bool operator == (const HostProfileList &obj) const;
    virtual bool operator != (const HostProfileList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectProfiles();

    // Property setting methods
    void SetProfiles(const AttributeGroupVector &profiles_);
    void SetActiveProfile(int activeProfile_);

    // Property getting methods
    const AttributeGroupVector &GetProfiles() const;
          AttributeGroupVector &GetProfiles();
    int GetActiveProfile() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddHostProfile(const HostProfile &);
    void ClearHostProfiles();
    void RemoveHostProfile(int i);
    int  GetNumHostProfiles() const;
    HostProfile &GetHostProfile(int i);
    const HostProfile &GetHostProfile(int i) const;

    HostProfile &operator [] (int i);
    const HostProfile &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void MarkHostProfiles();
    void MarkActiveProfile();
    const HostProfile *GetProfileForHost(const std::string &hostName) const;
    const HostProfile *FindMatchingProfileForHost(const std::string &hostName) const;
    std::vector<const HostProfile*> FindAllMatchingProfileForHost(const std::string &hostName) const;
    int GetNumProfilesForHost(const std::string &hostName) const;
    void SetAsActiveProfile(int index);
    void RemoveActiveProfile();
    void ChangeHostForActiveProfile(const std::string &newHost);
protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector profiles;
    int                  activeProfile;
};

#endif
