#include <HostProfileList.h>
#include <DataNode.h>
#include <HostProfile.h>

// ****************************************************************************
// Method: HostProfileList::HostProfileList
//
// Purpose: 
//   Constructor for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfileList::HostProfileList() : AttributeSubject("a*i")
{
    activeProfile = -1;
}

// ****************************************************************************
// Method: HostProfileList::HostProfileList
//
// Purpose: 
//   Copy constructor for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfileList::HostProfileList(const HostProfileList &obj) : AttributeSubject("a*i")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the profiles field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = profiles.begin(); pos != profiles.end(); ++pos)
        delete *pos;
    profiles.clear();
    if(obj.profiles.size() > 0)
        profiles.reserve(obj.profiles.size());
    // Duplicate the profiles from obj.
    for(pos = obj.profiles.begin(); pos != obj.profiles.end(); ++pos)
    {
        HostProfile *oldHostProfile = (HostProfile *)(*pos);
        HostProfile *newHostProfile = new HostProfile(*oldHostProfile);
        profiles.push_back(newHostProfile);
    }

    activeProfile = obj.activeProfile;

    SelectAll();
}

// ****************************************************************************
// Method: HostProfileList::~HostProfileList
//
// Purpose: 
//   Destructor for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfileList::~HostProfileList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the profiles field.
    for(pos = profiles.begin(); pos != profiles.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: HostProfileList::operator = 
//
// Purpose: 
//   Assignment operator for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfileList::operator = (const HostProfileList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the profiles field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = profiles.begin(); pos != profiles.end(); ++pos)
        delete *pos;
    profiles.clear();
    if(obj.profiles.size() > 0)
        profiles.reserve(obj.profiles.size());
    // Duplicate the profiles from obj.
    for(pos = obj.profiles.begin(); pos != obj.profiles.end(); ++pos)
    {
        HostProfile *oldHostProfile = (HostProfile *)(*pos);
        HostProfile *newHostProfile = new HostProfile(*oldHostProfile);
        profiles.push_back(newHostProfile);
    }

    activeProfile = obj.activeProfile;

    SelectAll();
}

// ****************************************************************************
// Method: HostProfileList::operator == 
//
// Purpose: 
//   Comparison operator == for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfileList::operator == (const HostProfileList &obj) const
{
    int i;

    bool profiles_equal = (obj.profiles.size() == profiles.size());
    for(i = 0; (i < profiles.size()) && profiles_equal; ++i)
    {
        // Make references to HostProfile from AttributeGroup *.
        const HostProfile &profiles1 = *((const HostProfile *)(profiles[i]));
        const HostProfile &profiles2 = *((const HostProfile *)(obj.profiles[i]));
        profiles_equal = (profiles1 == profiles2);
    }

    // Create the return value
    return (profiles_equal &&
            (activeProfile == obj.activeProfile));
}

// ****************************************************************************
// Method: HostProfileList::operator != 
//
// Purpose: 
//   Comparison operator != for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfileList::operator != (const HostProfileList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: HostProfileList::TypeName
//
// Purpose: 
//   Type name method for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
HostProfileList::TypeName() const
{
    return "HostProfileList";
}

// ****************************************************************************
// Method: HostProfileList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfileList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const HostProfileList *tmp = (const HostProfileList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: HostProfileList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HostProfileList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new HostProfileList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: HostProfileList::NewInstance
//
// Purpose: 
//   NewInstance method for the HostProfileList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HostProfileList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new HostProfileList(*this);
    else
        retval = new HostProfileList;

    return retval;
}

// ****************************************************************************
// Method: HostProfileList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfileList::SelectAll()
{
    Select(0, (void *)&profiles);
    Select(1, (void *)&activeProfile);
}

// ****************************************************************************
// Method: HostProfileList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
HostProfileList::CreateSubAttributeGroup(int)
{
    return new HostProfile;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HostProfileList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfileList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    HostProfileList defaultObject;
    bool addToParent = false;
    // Create a node for HostProfileList.
    DataNode *node = new DataNode("HostProfileList");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < profiles.size(); ++i)
            profiles[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("activeProfile", activeProfile));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: HostProfileList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 14 09:43:17 PDT 2002
//
// Modifications:
//   Brad Whitlock, Tue Feb 19 14:15:58 PST 2002
//   Modified so that it does not clear the list and it does not permit
//   duplicates.
//
//   Brad Whitlock, Fri Feb 28 10:05:47 PDT 2003
//   I fixed the method so that it allows profiles that already exist in the
//   host profile list to be read in again to overwrite values that are
//   in the existing profile.
//
//   Brad Whitlock, Fri Apr 25 08:08:53 PDT 2003
//   I added code to prevent the host profile from being inserted into the
//   list if the host contains wildcard characters.
//
//   Kathleen Bonnell, Wed Aug 20 10:51:24 PDT 2003 
//   Ensure that activeProfile is in the correct range.
//   
//   Brad Whitlock, Fri Sep 5 15:30:55 PST 2003
//   Prevented more than one profile from being the default profile for a host.
//
// ****************************************************************************

void
HostProfileList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("HostProfileList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;

    // Go through all of the children and construct a new
    // HostProfile for each one of them.
    children = searchNode->GetChildren();
    for(int i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("HostProfile"))
        {
            // Read the data node into a temporary host profile.
            HostProfile temp;
            temp.SetFromNode(children[i]);

            // Continue if the host contains wildcards.
            if(temp.GetHost().find_first_of("*?") != std::string::npos)
                continue;

            // Search for the host profile name in the list. If it is
            // found, then read over it so that values can be replaced.
            AttributeGroupVector::iterator pos;
            bool notFound = true;
            int profileIndex = 0;
            for(int j = 0; j < profiles.size(); ++j)
            {
                HostProfile *p = (HostProfile *)profiles[j];
                if((temp.GetProfileName() == p->GetProfileName()) &&
                   (temp.GetHost() == p->GetHost()))
                {
                    // Read the data node into the current host profile.
                    notFound = false;
                    p->SetFromNode(children[i]);
                    SelectProfiles();
                    profileIndex = j;
                    break;
                }
            }

            // If the host profile was not found, read it into a temporary
            // host profile and add it to the list.
            if(notFound)
            {
                AddHostProfile(temp);
                profileIndex = profiles.size() - 1;
            }

            // If it is the active profile for the host then make
            // sure that the other profiles for the host are not
            // also active.
            if(temp.GetActive())
                SetActiveProfile(profileIndex);
        }
    }

    if((node = searchNode->GetNode("activeProfile")) != 0)
    {
        if (profiles.size() > 0)
        {
            if (node->AsInt() < profiles.size())
                SetActiveProfile(node->AsInt());
            else 
                SetActiveProfile(0);
        }
        else
        {
            SetActiveProfile(-1);
        }
    }
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
HostProfileList::SetActiveProfile(int activeProfile_)
{
    activeProfile = activeProfile_;
    Select(1, (void *)&activeProfile);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
HostProfileList::GetProfiles() const
{
    return profiles;
}

AttributeGroupVector &
HostProfileList::GetProfiles()
{
    return profiles;
}

int
HostProfileList::GetActiveProfile() const
{
    return activeProfile;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
HostProfileList::SelectProfiles()
{
    Select(0, (void *)&profiles);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HostProfileList::AddHostProfile
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfileList::AddHostProfile(const HostProfile &obj)
{
    HostProfile *newHostProfile = new HostProfile(obj);
    profiles.push_back(newHostProfile);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&profiles);
}

// ****************************************************************************
// Method: HostProfileList::ClearHostProfiles
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfileList::ClearHostProfiles()
{
    AttributeGroupVector::iterator pos;

    for(pos = profiles.begin(); pos != profiles.end(); ++pos)
        delete *pos;
    profiles.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&profiles);
}

// ****************************************************************************
// Method: HostProfileList::RemoveHostProfile
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfileList::RemoveHostProfile(int index)
{
    AttributeGroupVector::iterator pos = profiles.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != profiles.end())
    {
        delete *pos;
        profiles.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&profiles);
}

// ****************************************************************************
// Method: HostProfileList::GetNumHostProfiles
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
HostProfileList::GetNumHostProfiles() const
{
    return profiles.size();
}

// ****************************************************************************
// Method: HostProfileList::GetHostProfile
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfile &
HostProfileList::GetHostProfile(int i)
{
    return *((HostProfile *)profiles[i]);
}

// ****************************************************************************
// Method: HostProfileList::GetHostProfile
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const HostProfile &
HostProfileList::GetHostProfile(int i) const
{
    return *((HostProfile *)profiles[i]);
}

// ****************************************************************************
// Method: HostProfileList::operator []
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfile &
HostProfileList::operator [] (int i)
{
    return *((HostProfile *)profiles[i]);
}

// ****************************************************************************
// Method: HostProfileList::operator []
//
// Purpose: 
//   This class contains a list of host profiles.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const HostProfile &
HostProfileList::operator [] (int i) const
{
    return *((HostProfile *)profiles[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HostProfileList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HostProfileList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "profiles";
        case 1:  return "activeProfile";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HostProfileList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
HostProfileList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        case 1:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: HostProfileList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HostProfileList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        case 1:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HostProfileList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:11 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfileList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const HostProfileList &obj = *((const HostProfileList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool profiles_equal = (obj.profiles.size() == profiles.size());
        for(i = 0; (i < profiles.size()) && profiles_equal; ++i)
        {
            // Make references to HostProfile from AttributeGroup *.
            const HostProfile &profiles1 = *((const HostProfile *)(profiles[i]));
            const HostProfile &profiles2 = *((const HostProfile *)(obj.profiles[i]));
            profiles_equal = (profiles1 == profiles2);
        }

        retval = profiles_equal;
        }
        break;
    case 1:
        {  // new scope
        retval = (activeProfile == obj.activeProfile);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

//
// Marking functions. They select a particular attribute without
// having to set it. These types of functions are sometimes useful.
//

void
HostProfileList::MarkHostProfiles()
{
    Select(0, (void *)&profiles);
}

void
HostProfileList::MarkActiveProfile()
{
    Select(1, (void *)&activeProfile);
}

// ****************************************************************************
// Method: HostProfileList::GetProfileForHost
//
// Purpose: 
//   Looks for a host profile having the specified host name.
//
// Arguments:
//   
// Returns:    
//   A pointer to the host profile, or 0.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Wed Sep 20 18:38:53 PST 2000
//
// Modifications:
//   Brad Whitlock, Tue Oct 17 11:23:47 PDT 2000
//   I changed the method so it returns the default profile for the
//   specified host.
//
//    Jeremy Meredith, Tue Jul 17 18:00:10 PDT 2001
//    Reworded "default profile" to be "active profile".
//
// ****************************************************************************
const HostProfile *
HostProfileList::GetProfileForHost(const std::string &hostName) const
{
    const HostProfile *retval = 0;
    bool notfound = true;

    for(int i = 0; (i < profiles.size()) && notfound; ++i)
    {
        retval = ((const HostProfile *)(profiles[i]));
        notfound = (retval->GetHost() != hostName ||
                    !retval->GetActive());
    }

    return notfound ? 0 : retval;
}

// ****************************************************************************
//  Method: HostProfileList::FindMatchingProfileForHost
//
//  Purpose: 
//    Looks for a host profile with a host name pattern
//    matching the specified host name.
//
//  Arguments:
//    hostName    the host name to match with the profile hostname patterns
//   
//  Returns:    
//    A pointer to the host profile, or NULL.
//
//  Programmer: Jeremy Meredith
//  Creation:   February 13, 2002
//
//  Modifications:
//    Jeremy Meredith, Sun Mar  3 21:41:32 PST 2002
//    Added code to look up the fully qualified host name before attempting
//    to find a match.
//
//    Jeremy Meredith, Wed Mar  6 15:27:13 PST 2002
//    Added code to look up the unqualified host name if it didn't find a
//    match for the qualified one.
//
//    Jeremy Meredith, Wed Aug 14 13:03:21 PDT 2002
//    Pulled most logic out to FindAllMatchingProfileForHost.
//
// ****************************************************************************
const HostProfile *
HostProfileList::FindMatchingProfileForHost(const std::string &hostName) const
{
    std::vector<const HostProfile*> profiles =
                                      FindAllMatchingProfileForHost(hostName);

    for (int i=0; i<profiles.size(); i++)
        if (profiles[i]->GetActive())
            return profiles[i];

    return NULL;
}

// ****************************************************************************
//  Method: HostProfileList::FindAllMatchingProfileForHost
//
//  Purpose: 
//    Looks for all host profiles with a host name pattern
//    matching the specified host name.
//
//  Arguments:
//    hostName    the host name to match with the profile hostname patterns
//   
//  Returns:    
//    A list of pointers to the host profiles.
//
//  Programmer: Jeremy Meredith
//  Creation:   August 14, 2002
//
//  Modifications:
//    Brad Whitlock, Tue May 20 11:53:37 PDT 2003
//    I moved these include files to here so we can successfully regenerate
//    the class.
//
// ****************************************************************************
#if defined(_WIN32)
#include <winsock2.h>
#else
#include <netdb.h>
#endif

std::vector<const HostProfile*>
HostProfileList::FindAllMatchingProfileForHost(const std::string &hostName) const
{
    std::vector<const HostProfile*> matches;
    
    // Look up the fully qualified host name
    std::string fqhostName(hostName);
    struct hostent *hostEnt = gethostbyname(fqhostName.c_str());
    if (hostEnt)
        fqhostName = std::string(hostEnt->h_name);

    for(int i = 0; i < profiles.size(); i++)
    {
        const HostProfile *p = (const HostProfile *)(profiles[i]);

        if (p->ProfileMatchesHost(fqhostName))
            matches.push_back(p);
    }

    if (matches.size() == 0)
    {
        for(int i = 0; i < profiles.size(); i++)
        {
            const HostProfile *p = (const HostProfile *)(profiles[i]);

            if (p->ProfileMatchesHost(hostName))
                matches.push_back(p);
        }
    }

    return matches;
}

// ****************************************************************************
// Method: HostProfileList::GetNumProfilesForHost
//
// Purpose: 
//   Returns the number of host profiles for a given host.
//
// Arguments:
//   hostName : The host whose profiles we're counting.
//
// Returns:    
//   The number of host profiles for the specified host.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 17 11:19:07 PDT 2000
//
// Modifications:
//   
// ****************************************************************************

int
HostProfileList::GetNumProfilesForHost(const std::string &hostName) const
{
    int nHosts = 0;

    for(int i = 0; i < profiles.size(); ++i)
    {
        const HostProfile *current = (const HostProfile *)(profiles[i]);
        if(current->GetHost() == hostName)
            ++nHosts;
    }

    return nHosts;
}

// ****************************************************************************
// Method: HostProfileList::SetAsActiveProfile
//
// Purpose: 
//   Sets the specified profile as the active profile for its host.
//
// Arguments:
//   index : The index of the profile to make active for its host.
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct 17 11:32:41 PDT 2000
//
// Modifications:
//    Jeremy Meredith, Tue Jul 17 18:00:10 PDT 2001
//    Reworded "default profile" to be "active profile".
//
//    Kathleen Bonnell, Wed Aug 20 10:57:00 PDT 2003 
//    Ensure index is within correct range. 
//
// ****************************************************************************

void
HostProfileList::SetAsActiveProfile(int index)
{
    if(index < 0 || index >= profiles.size())
        return;

    // Set the specified profile as the active for its host.
    HostProfile &defProfile = this->operator[](index);
    defProfile.SetActive(true);

    // Make sure that all other profiles having the same host
    // are NOT the active profile.
    for(int i = 0; i < profiles.size(); ++i)
    {
        if(i == index)
            continue;

        HostProfile &current = this->operator[](i);
        if(current.GetHost() == defProfile.GetHost())
            current.SetActive(false);
    }
}

// ****************************************************************************
// Method: HostProfileList::RemoveActiveProfile
//
// Purpose: 
//   This method removes the active profile. If possible, another
//   profile for the same host will be made active.
//
// Programmer: Brad Whitlock
// Creation:   Wed Oct 18 09:47:39 PDT 2000
//
// Modifications:
//    Jeremy Meredith, Tue Jul 17 18:00:10 PDT 2001
//    Reworded "default profile" to be "active profile".
//
// ****************************************************************************

void
HostProfileList::RemoveActiveProfile()
{
    if(GetNumHostProfiles() < 1)
        return;

    int i;
    const HostProfile &p = this->operator[](GetActiveProfile());
    std::string oldHost(p.GetHost());

    // Remove the active profile.
    RemoveHostProfile(GetActiveProfile());

    // Go through the list and look for the first profile that has the
    // same host as the one that was deleted. We'll make that the
    // new active profile.
    bool keepGoing = true;
    for(i = 0; i < GetNumHostProfiles() && keepGoing; ++i)
    {
        const HostProfile &current = this->operator[](i);
        if(current.GetHost() == oldHost)
        {
            keepGoing = false;
            SetActiveProfile(i);
        }
    }

    if(!keepGoing)
    {
        // We found a profile having the same host. Now make sure
        // that host profile group has a active profile.
        if(GetProfileForHost(oldHost) == 0)
        {
            SetAsActiveProfile(i - 1);
            MarkHostProfiles();
        }
    }
    else
    {
        // We didn't find another profile having the same host.
        SetActiveProfile((GetNumHostProfiles() > 0) ? 0 : -1);
    }
}

// ****************************************************************************
// Method: HostProfileList::ChangeHostForActiveProfile
//
// Purpose: 
//   Changes the active profile's host to a new hostname and updates
//   the active profile settings for the involved profiles.
//
// Arguments:
//   newHost : The new hostname.
//
// Programmer: Brad Whitlock
// Creation:   Wed Oct 18 10:24:44 PDT 2000
//
// Modifications:
//    Jeremy Meredith, Tue Jul 17 18:00:10 PDT 2001
//    Reworded "default profile" to be "active profile".
//
//    Jeremy Meredith, Wed Feb 27 11:03:55 PST 2002
//    Added a check to make sure the host was changing before doing
//    some logic to reset to the old active profile for the new host.
//
// ****************************************************************************

void
HostProfileList::ChangeHostForActiveProfile(const std::string &newHost)
{
    if(GetActiveProfile() == -1)
        return;

    // Set the host for the active profile.
    HostProfile &p = operator[](GetActiveProfile());
    std::string oldHost(p.GetHost());

    // Don't do anything if the host isn't actually changing
    if (newHost == oldHost)
        return;

    // Keep the old active profile for the new host active
    if (p.GetActive() && GetProfileForHost(newHost))
    {
        p.SetActive(false);
        MarkActiveProfile();
    }
    p.SetHost(newHost);


    // The host name changed; we need to mark the profile list
    // so the profile is put with the right host the next time
    // Notify is called.
    MarkHostProfiles();

    if(GetNumProfilesForHost(oldHost) > 0)
    {
        if(GetProfileForHost(oldHost) == 0)
        {
            // Look through the list and make the first profile
            // for oldHost, the active profile for that host.
            bool notDone = true;
            for(int i = 0; i < GetNumHostProfiles() &&
                notDone; ++i)
            {
                HostProfile &profile = this->operator[](i);
                if(oldHost == profile.GetHost())
                {
                    profile.SetActive(true);
                    notDone = false;
                }
            }
        }
    }

    // If there is no active profile for newHost, make the first
    // profile whose host is newHost the active profile.
    if(GetProfileForHost(newHost) == 0)
    {
        bool notDone = true;
        for(int i = 0; i < GetNumHostProfiles() && notDone; ++i)
        {
            HostProfile &profile = this->operator[](i);
            if(newHost == profile.GetHost())
            {
                profile.SetActive(true);
                notDone = false;
            }
        }
        if(!notDone)
            MarkActiveProfile();
    }
}

