#include <HostProfile.h>
#include <DataNode.h>
#include <Utility.h>

//
// Enum conversion methods for HostProfile::ClientHostDetermination
//

static const char *ClientHostDetermination_strings[] = {
"MachineName", "ManuallySpecified", "ParsedFromSSHCLIENT"
};

std::string
HostProfile::ClientHostDetermination_ToString(HostProfile::ClientHostDetermination t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ClientHostDetermination_strings[index];
}

std::string
HostProfile::ClientHostDetermination_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ClientHostDetermination_strings[index];
}

bool
HostProfile::ClientHostDetermination_FromString(const std::string &s, HostProfile::ClientHostDetermination &val)
{
    val = HostProfile::MachineName;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ClientHostDetermination_strings[i])
        {
            val = (ClientHostDetermination)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: HostProfile::HostProfile
//
// Purpose: 
//   Constructor for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfile::HostProfile() : AttributeSubject("sssiibibsbsbsbsbbbs*bbssbbiis")
{
    profileName = "notset";
    host = "localhost";
    userName = defaultUserName;
    timeout = 480;
    numProcessors = 1;
    numNodesSet = false;
    numNodes = 1;
    partitionSet = false;
    bankSet = false;
    timeLimitSet = false;
    launchMethodSet = false;
    forceStatic = true;
    forceDynamic = false;
    active = false;
    parallel = false;
    launchArgsSet = false;
    shareOneBatchJob = false;
    sshPortSpecified = false;
    sshPort = 22;
    clientHostDetermination = MachineName;
}

// ****************************************************************************
// Method: HostProfile::HostProfile
//
// Purpose: 
//   Copy constructor for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfile::HostProfile(const HostProfile &obj) : AttributeSubject("sssiibibsbsbsbsbbbs*bbssbbiis")
{
    profileName = obj.profileName;
    host = obj.host;
    userName = obj.userName;
    timeout = obj.timeout;
    numProcessors = obj.numProcessors;
    numNodesSet = obj.numNodesSet;
    numNodes = obj.numNodes;
    partitionSet = obj.partitionSet;
    partition = obj.partition;
    bankSet = obj.bankSet;
    bank = obj.bank;
    timeLimitSet = obj.timeLimitSet;
    timeLimit = obj.timeLimit;
    launchMethodSet = obj.launchMethodSet;
    launchMethod = obj.launchMethod;
    forceStatic = obj.forceStatic;
    forceDynamic = obj.forceDynamic;
    active = obj.active;
    arguments = obj.arguments;
    parallel = obj.parallel;
    launchArgsSet = obj.launchArgsSet;
    launchArgs = obj.launchArgs;
    hostAliases = obj.hostAliases;
    shareOneBatchJob = obj.shareOneBatchJob;
    sshPortSpecified = obj.sshPortSpecified;
    sshPort = obj.sshPort;
    clientHostDetermination = obj.clientHostDetermination;
    manualClientHostName = obj.manualClientHostName;

    SelectAll();
}

// ****************************************************************************
// Method: HostProfile::~HostProfile
//
// Purpose: 
//   Destructor for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HostProfile::~HostProfile()
{
    // nothing here
}

// ****************************************************************************
// Method: HostProfile::operator = 
//
// Purpose: 
//   Assignment operator for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfile::operator = (const HostProfile &obj)
{
    profileName = obj.profileName;
    host = obj.host;
    userName = obj.userName;
    timeout = obj.timeout;
    numProcessors = obj.numProcessors;
    numNodesSet = obj.numNodesSet;
    numNodes = obj.numNodes;
    partitionSet = obj.partitionSet;
    partition = obj.partition;
    bankSet = obj.bankSet;
    bank = obj.bank;
    timeLimitSet = obj.timeLimitSet;
    timeLimit = obj.timeLimit;
    launchMethodSet = obj.launchMethodSet;
    launchMethod = obj.launchMethod;
    forceStatic = obj.forceStatic;
    forceDynamic = obj.forceDynamic;
    active = obj.active;
    arguments = obj.arguments;
    parallel = obj.parallel;
    launchArgsSet = obj.launchArgsSet;
    launchArgs = obj.launchArgs;
    hostAliases = obj.hostAliases;
    shareOneBatchJob = obj.shareOneBatchJob;
    sshPortSpecified = obj.sshPortSpecified;
    sshPort = obj.sshPort;
    clientHostDetermination = obj.clientHostDetermination;
    manualClientHostName = obj.manualClientHostName;

    SelectAll();
}

// ****************************************************************************
// Method: HostProfile::operator == 
//
// Purpose: 
//   Comparison operator == for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfile::operator == (const HostProfile &obj) const
{
    // Create the return value
    return ((profileName == obj.profileName) &&
            (host == obj.host) &&
            (userName == obj.userName) &&
            (timeout == obj.timeout) &&
            (numProcessors == obj.numProcessors) &&
            (numNodesSet == obj.numNodesSet) &&
            (numNodes == obj.numNodes) &&
            (partitionSet == obj.partitionSet) &&
            (partition == obj.partition) &&
            (bankSet == obj.bankSet) &&
            (bank == obj.bank) &&
            (timeLimitSet == obj.timeLimitSet) &&
            (timeLimit == obj.timeLimit) &&
            (launchMethodSet == obj.launchMethodSet) &&
            (launchMethod == obj.launchMethod) &&
            (forceStatic == obj.forceStatic) &&
            (forceDynamic == obj.forceDynamic) &&
            (active == obj.active) &&
            (arguments == obj.arguments) &&
            (parallel == obj.parallel) &&
            (launchArgsSet == obj.launchArgsSet) &&
            (launchArgs == obj.launchArgs) &&
            (hostAliases == obj.hostAliases) &&
            (shareOneBatchJob == obj.shareOneBatchJob) &&
            (sshPortSpecified == obj.sshPortSpecified) &&
            (sshPort == obj.sshPort) &&
            (clientHostDetermination == obj.clientHostDetermination) &&
            (manualClientHostName == obj.manualClientHostName));
}

// ****************************************************************************
// Method: HostProfile::operator != 
//
// Purpose: 
//   Comparison operator != for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfile::operator != (const HostProfile &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: HostProfile::TypeName
//
// Purpose: 
//   Type name method for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
HostProfile::TypeName() const
{
    return "HostProfile";
}

// ****************************************************************************
// Method: HostProfile::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfile::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const HostProfile *tmp = (const HostProfile *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: HostProfile::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HostProfile::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new HostProfile(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: HostProfile::NewInstance
//
// Purpose: 
//   NewInstance method for the HostProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HostProfile::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new HostProfile(*this);
    else
        retval = new HostProfile;

    return retval;
}

// ****************************************************************************
// Method: HostProfile::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfile::SelectAll()
{
    Select(0, (void *)&profileName);
    Select(1, (void *)&host);
    Select(2, (void *)&userName);
    Select(3, (void *)&timeout);
    Select(4, (void *)&numProcessors);
    Select(5, (void *)&numNodesSet);
    Select(6, (void *)&numNodes);
    Select(7, (void *)&partitionSet);
    Select(8, (void *)&partition);
    Select(9, (void *)&bankSet);
    Select(10, (void *)&bank);
    Select(11, (void *)&timeLimitSet);
    Select(12, (void *)&timeLimit);
    Select(13, (void *)&launchMethodSet);
    Select(14, (void *)&launchMethod);
    Select(15, (void *)&forceStatic);
    Select(16, (void *)&forceDynamic);
    Select(17, (void *)&active);
    Select(18, (void *)&arguments);
    Select(19, (void *)&parallel);
    Select(20, (void *)&launchArgsSet);
    Select(21, (void *)&launchArgs);
    Select(22, (void *)&hostAliases);
    Select(23, (void *)&shareOneBatchJob);
    Select(24, (void *)&sshPortSpecified);
    Select(25, (void *)&sshPort);
    Select(26, (void *)&clientHostDetermination);
    Select(27, (void *)&manualClientHostName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HostProfile::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfile::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    HostProfile defaultObject;
    bool addToParent = false;
    // Create a node for HostProfile.
    DataNode *node = new DataNode("HostProfile");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("profileName", profileName));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("host", host));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userName", userName));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeout", timeout));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessors", numProcessors));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodesSet", numNodesSet));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodes", numNodes));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("partitionSet", partitionSet));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("partition", partition));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("bankSet", bankSet));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("bank", bank));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeLimitSet", timeLimitSet));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeLimit", timeLimit));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchMethodSet", launchMethodSet));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchMethod", launchMethod));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("forceStatic", forceStatic));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("forceDynamic", forceDynamic));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("active", active));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("arguments", arguments));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallel", parallel));
    }

    if(completeSave || !FieldsEqual(20, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchArgsSet", launchArgsSet));
    }

    if(completeSave || !FieldsEqual(21, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchArgs", launchArgs));
    }

    if(completeSave || !FieldsEqual(22, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hostAliases", hostAliases));
    }

    if(completeSave || !FieldsEqual(23, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("shareOneBatchJob", shareOneBatchJob));
    }

    if(completeSave || !FieldsEqual(24, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sshPortSpecified", sshPortSpecified));
    }

    if(completeSave || !FieldsEqual(25, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sshPort", sshPort));
    }

    if(completeSave || !FieldsEqual(26, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("clientHostDetermination", ClientHostDetermination_ToString(clientHostDetermination)));
    }

    if(completeSave || !FieldsEqual(27, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("manualClientHostName", manualClientHostName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: HostProfile::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HostProfile::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("HostProfile");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("profileName")) != 0)
        SetProfileName(node->AsString());
    if((node = searchNode->GetNode("host")) != 0)
        SetHost(node->AsString());
    if((node = searchNode->GetNode("userName")) != 0)
        SetUserName(node->AsString());
    if((node = searchNode->GetNode("timeout")) != 0)
        SetTimeout(node->AsInt());
    if((node = searchNode->GetNode("numProcessors")) != 0)
        SetNumProcessors(node->AsInt());
    if((node = searchNode->GetNode("numNodesSet")) != 0)
        SetNumNodesSet(node->AsBool());
    if((node = searchNode->GetNode("numNodes")) != 0)
        SetNumNodes(node->AsInt());
    if((node = searchNode->GetNode("partitionSet")) != 0)
        SetPartitionSet(node->AsBool());
    if((node = searchNode->GetNode("partition")) != 0)
        SetPartition(node->AsString());
    if((node = searchNode->GetNode("bankSet")) != 0)
        SetBankSet(node->AsBool());
    if((node = searchNode->GetNode("bank")) != 0)
        SetBank(node->AsString());
    if((node = searchNode->GetNode("timeLimitSet")) != 0)
        SetTimeLimitSet(node->AsBool());
    if((node = searchNode->GetNode("timeLimit")) != 0)
        SetTimeLimit(node->AsString());
    if((node = searchNode->GetNode("launchMethodSet")) != 0)
        SetLaunchMethodSet(node->AsBool());
    if((node = searchNode->GetNode("launchMethod")) != 0)
        SetLaunchMethod(node->AsString());
    if((node = searchNode->GetNode("forceStatic")) != 0)
        SetForceStatic(node->AsBool());
    if((node = searchNode->GetNode("forceDynamic")) != 0)
        SetForceDynamic(node->AsBool());
    if((node = searchNode->GetNode("active")) != 0)
        SetActive(node->AsBool());
    if((node = searchNode->GetNode("arguments")) != 0)
        SetArguments(node->AsStringVector());
    if((node = searchNode->GetNode("parallel")) != 0)
        SetParallel(node->AsBool());
    if((node = searchNode->GetNode("launchArgsSet")) != 0)
        SetLaunchArgsSet(node->AsBool());
    if((node = searchNode->GetNode("launchArgs")) != 0)
        SetLaunchArgs(node->AsString());
    if((node = searchNode->GetNode("hostAliases")) != 0)
        SetHostAliases(node->AsString());
    if((node = searchNode->GetNode("shareOneBatchJob")) != 0)
        SetShareOneBatchJob(node->AsBool());
    if((node = searchNode->GetNode("sshPortSpecified")) != 0)
        SetSshPortSpecified(node->AsBool());
    if((node = searchNode->GetNode("sshPort")) != 0)
        SetSshPort(node->AsInt());
    if((node = searchNode->GetNode("clientHostDetermination")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetClientHostDetermination(ClientHostDetermination(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ClientHostDetermination value;
            if(ClientHostDetermination_FromString(node->AsString(), value))
                SetClientHostDetermination(value);
        }
    }
    if((node = searchNode->GetNode("manualClientHostName")) != 0)
        SetManualClientHostName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
HostProfile::SetProfileName(const std::string &profileName_)
{
    profileName = profileName_;
    Select(0, (void *)&profileName);
}

void
HostProfile::SetHost(const std::string &host_)
{
    host = host_;
    Select(1, (void *)&host);
}

void
HostProfile::SetUserName(const std::string &userName_)
{
    userName = userName_;
    Select(2, (void *)&userName);
}

void
HostProfile::SetTimeout(int timeout_)
{
    timeout = timeout_;
    Select(3, (void *)&timeout);
}

void
HostProfile::SetNumProcessors(int numProcessors_)
{
    numProcessors = numProcessors_;
    Select(4, (void *)&numProcessors);
}

void
HostProfile::SetNumNodesSet(bool numNodesSet_)
{
    numNodesSet = numNodesSet_;
    Select(5, (void *)&numNodesSet);
}

void
HostProfile::SetNumNodes(int numNodes_)
{
    numNodes = numNodes_;
    Select(6, (void *)&numNodes);
}

void
HostProfile::SetPartitionSet(bool partitionSet_)
{
    partitionSet = partitionSet_;
    Select(7, (void *)&partitionSet);
}

void
HostProfile::SetPartition(const std::string &partition_)
{
    partition = partition_;
    Select(8, (void *)&partition);
}

void
HostProfile::SetBankSet(bool bankSet_)
{
    bankSet = bankSet_;
    Select(9, (void *)&bankSet);
}

void
HostProfile::SetBank(const std::string &bank_)
{
    bank = bank_;
    Select(10, (void *)&bank);
}

void
HostProfile::SetTimeLimitSet(bool timeLimitSet_)
{
    timeLimitSet = timeLimitSet_;
    Select(11, (void *)&timeLimitSet);
}

void
HostProfile::SetTimeLimit(const std::string &timeLimit_)
{
    timeLimit = timeLimit_;
    Select(12, (void *)&timeLimit);
}

void
HostProfile::SetLaunchMethodSet(bool launchMethodSet_)
{
    launchMethodSet = launchMethodSet_;
    Select(13, (void *)&launchMethodSet);
}

void
HostProfile::SetLaunchMethod(const std::string &launchMethod_)
{
    launchMethod = launchMethod_;
    Select(14, (void *)&launchMethod);
}

void
HostProfile::SetForceStatic(bool forceStatic_)
{
    forceStatic = forceStatic_;
    Select(15, (void *)&forceStatic);
}

void
HostProfile::SetForceDynamic(bool forceDynamic_)
{
    forceDynamic = forceDynamic_;
    Select(16, (void *)&forceDynamic);
}

void
HostProfile::SetActive(bool active_)
{
    active = active_;
    Select(17, (void *)&active);
}

void
HostProfile::SetArguments(const stringVector &arguments_)
{
    arguments = arguments_;
    Select(18, (void *)&arguments);
}

void
HostProfile::SetParallel(bool parallel_)
{
    parallel = parallel_;
    Select(19, (void *)&parallel);
}

void
HostProfile::SetLaunchArgsSet(bool launchArgsSet_)
{
    launchArgsSet = launchArgsSet_;
    Select(20, (void *)&launchArgsSet);
}

void
HostProfile::SetLaunchArgs(const std::string &launchArgs_)
{
    launchArgs = launchArgs_;
    Select(21, (void *)&launchArgs);
}

void
HostProfile::SetHostAliases(const std::string &hostAliases_)
{
    hostAliases = hostAliases_;
    Select(22, (void *)&hostAliases);
}

void
HostProfile::SetShareOneBatchJob(bool shareOneBatchJob_)
{
    shareOneBatchJob = shareOneBatchJob_;
    Select(23, (void *)&shareOneBatchJob);
}

void
HostProfile::SetSshPortSpecified(bool sshPortSpecified_)
{
    sshPortSpecified = sshPortSpecified_;
    Select(24, (void *)&sshPortSpecified);
}

void
HostProfile::SetSshPort(int sshPort_)
{
    sshPort = sshPort_;
    Select(25, (void *)&sshPort);
}

void
HostProfile::SetClientHostDetermination(HostProfile::ClientHostDetermination clientHostDetermination_)
{
    clientHostDetermination = clientHostDetermination_;
    Select(26, (void *)&clientHostDetermination);
}

void
HostProfile::SetManualClientHostName(const std::string &manualClientHostName_)
{
    manualClientHostName = manualClientHostName_;
    Select(27, (void *)&manualClientHostName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
HostProfile::GetProfileName() const
{
    return profileName;
}

std::string &
HostProfile::GetProfileName()
{
    return profileName;
}

const std::string &
HostProfile::GetHost() const
{
    return host;
}

std::string &
HostProfile::GetHost()
{
    return host;
}

const std::string &
HostProfile::GetUserName() const
{
    return userName;
}

std::string &
HostProfile::GetUserName()
{
    return userName;
}

int
HostProfile::GetTimeout() const
{
    return timeout;
}

int
HostProfile::GetNumProcessors() const
{
    return numProcessors;
}

bool
HostProfile::GetNumNodesSet() const
{
    return numNodesSet;
}

int
HostProfile::GetNumNodes() const
{
    return numNodes;
}

bool
HostProfile::GetPartitionSet() const
{
    return partitionSet;
}

const std::string &
HostProfile::GetPartition() const
{
    return partition;
}

std::string &
HostProfile::GetPartition()
{
    return partition;
}

bool
HostProfile::GetBankSet() const
{
    return bankSet;
}

const std::string &
HostProfile::GetBank() const
{
    return bank;
}

std::string &
HostProfile::GetBank()
{
    return bank;
}

bool
HostProfile::GetTimeLimitSet() const
{
    return timeLimitSet;
}

const std::string &
HostProfile::GetTimeLimit() const
{
    return timeLimit;
}

std::string &
HostProfile::GetTimeLimit()
{
    return timeLimit;
}

bool
HostProfile::GetLaunchMethodSet() const
{
    return launchMethodSet;
}

const std::string &
HostProfile::GetLaunchMethod() const
{
    return launchMethod;
}

std::string &
HostProfile::GetLaunchMethod()
{
    return launchMethod;
}

bool
HostProfile::GetForceStatic() const
{
    return forceStatic;
}

bool
HostProfile::GetForceDynamic() const
{
    return forceDynamic;
}

bool
HostProfile::GetActive() const
{
    return active;
}

const stringVector &
HostProfile::GetArguments() const
{
    return arguments;
}

stringVector &
HostProfile::GetArguments()
{
    return arguments;
}

bool
HostProfile::GetParallel() const
{
    return parallel;
}

bool
HostProfile::GetLaunchArgsSet() const
{
    return launchArgsSet;
}

const std::string &
HostProfile::GetLaunchArgs() const
{
    return launchArgs;
}

std::string &
HostProfile::GetLaunchArgs()
{
    return launchArgs;
}

const std::string &
HostProfile::GetHostAliases() const
{
    return hostAliases;
}

std::string &
HostProfile::GetHostAliases()
{
    return hostAliases;
}

bool
HostProfile::GetShareOneBatchJob() const
{
    return shareOneBatchJob;
}

bool
HostProfile::GetSshPortSpecified() const
{
    return sshPortSpecified;
}

int
HostProfile::GetSshPort() const
{
    return sshPort;
}

HostProfile::ClientHostDetermination
HostProfile::GetClientHostDetermination() const
{
    return ClientHostDetermination(clientHostDetermination);
}

const std::string &
HostProfile::GetManualClientHostName() const
{
    return manualClientHostName;
}

std::string &
HostProfile::GetManualClientHostName()
{
    return manualClientHostName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
HostProfile::SelectProfileName()
{
    Select(0, (void *)&profileName);
}

void
HostProfile::SelectHost()
{
    Select(1, (void *)&host);
}

void
HostProfile::SelectUserName()
{
    Select(2, (void *)&userName);
}

void
HostProfile::SelectPartition()
{
    Select(8, (void *)&partition);
}

void
HostProfile::SelectBank()
{
    Select(10, (void *)&bank);
}

void
HostProfile::SelectTimeLimit()
{
    Select(12, (void *)&timeLimit);
}

void
HostProfile::SelectLaunchMethod()
{
    Select(14, (void *)&launchMethod);
}

void
HostProfile::SelectArguments()
{
    Select(18, (void *)&arguments);
}

void
HostProfile::SelectLaunchArgs()
{
    Select(21, (void *)&launchArgs);
}

void
HostProfile::SelectHostAliases()
{
    Select(22, (void *)&hostAliases);
}

void
HostProfile::SelectManualClientHostName()
{
    Select(27, (void *)&manualClientHostName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HostProfile::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HostProfile::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "profileName";
        case 1:  return "host";
        case 2:  return "userName";
        case 3:  return "timeout";
        case 4:  return "numProcessors";
        case 5:  return "numNodesSet";
        case 6:  return "numNodes";
        case 7:  return "partitionSet";
        case 8:  return "partition";
        case 9:  return "bankSet";
        case 10:  return "bank";
        case 11:  return "timeLimitSet";
        case 12:  return "timeLimit";
        case 13:  return "launchMethodSet";
        case 14:  return "launchMethod";
        case 15:  return "forceStatic";
        case 16:  return "forceDynamic";
        case 17:  return "active";
        case 18:  return "arguments";
        case 19:  return "parallel";
        case 20:  return "launchArgsSet";
        case 21:  return "launchArgs";
        case 22:  return "hostAliases";
        case 23:  return "shareOneBatchJob";
        case 24:  return "SSH port specified";
        case 25:  return "SSH port";
        case 26:  return "Client host determination";
        case 27:  return "Client host name";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HostProfile::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
HostProfile::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_string;
        case 2:  return FieldType_string;
        case 3:  return FieldType_int;
        case 4:  return FieldType_int;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_int;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_string;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_string;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_string;
        case 13:  return FieldType_bool;
        case 14:  return FieldType_string;
        case 15:  return FieldType_bool;
        case 16:  return FieldType_bool;
        case 17:  return FieldType_bool;
        case 18:  return FieldType_stringVector;
        case 19:  return FieldType_bool;
        case 20:  return FieldType_bool;
        case 21:  return FieldType_string;
        case 22:  return FieldType_string;
        case 23:  return FieldType_bool;
        case 24:  return FieldType_bool;
        case 25:  return FieldType_int;
        case 26:  return FieldType_enum;
        case 27:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: HostProfile::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HostProfile::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "string";
        case 2:  return "string";
        case 3:  return "int";
        case 4:  return "int";
        case 5:  return "bool";
        case 6:  return "int";
        case 7:  return "bool";
        case 8:  return "string";
        case 9:  return "bool";
        case 10:  return "string";
        case 11:  return "bool";
        case 12:  return "string";
        case 13:  return "bool";
        case 14:  return "string";
        case 15:  return "bool";
        case 16:  return "bool";
        case 17:  return "bool";
        case 18:  return "stringVector";
        case 19:  return "bool";
        case 20:  return "bool";
        case 21:  return "string";
        case 22:  return "string";
        case 23:  return "bool";
        case 24:  return "bool";
        case 25:  return "int";
        case 26:  return "enum";
        case 27:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HostProfile::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:10 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HostProfile::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const HostProfile &obj = *((const HostProfile*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (profileName == obj.profileName);
        }
        break;
    case 1:
        {  // new scope
        retval = (host == obj.host);
        }
        break;
    case 2:
        {  // new scope
        retval = (userName == obj.userName);
        }
        break;
    case 3:
        {  // new scope
        retval = (timeout == obj.timeout);
        }
        break;
    case 4:
        {  // new scope
        retval = (numProcessors == obj.numProcessors);
        }
        break;
    case 5:
        {  // new scope
        retval = (numNodesSet == obj.numNodesSet);
        }
        break;
    case 6:
        {  // new scope
        retval = (numNodes == obj.numNodes);
        }
        break;
    case 7:
        {  // new scope
        retval = (partitionSet == obj.partitionSet);
        }
        break;
    case 8:
        {  // new scope
        retval = (partition == obj.partition);
        }
        break;
    case 9:
        {  // new scope
        retval = (bankSet == obj.bankSet);
        }
        break;
    case 10:
        {  // new scope
        retval = (bank == obj.bank);
        }
        break;
    case 11:
        {  // new scope
        retval = (timeLimitSet == obj.timeLimitSet);
        }
        break;
    case 12:
        {  // new scope
        retval = (timeLimit == obj.timeLimit);
        }
        break;
    case 13:
        {  // new scope
        retval = (launchMethodSet == obj.launchMethodSet);
        }
        break;
    case 14:
        {  // new scope
        retval = (launchMethod == obj.launchMethod);
        }
        break;
    case 15:
        {  // new scope
        retval = (forceStatic == obj.forceStatic);
        }
        break;
    case 16:
        {  // new scope
        retval = (forceDynamic == obj.forceDynamic);
        }
        break;
    case 17:
        {  // new scope
        retval = (active == obj.active);
        }
        break;
    case 18:
        {  // new scope
        retval = (arguments == obj.arguments);
        }
        break;
    case 19:
        {  // new scope
        retval = (parallel == obj.parallel);
        }
        break;
    case 20:
        {  // new scope
        retval = (launchArgsSet == obj.launchArgsSet);
        }
        break;
    case 21:
        {  // new scope
        retval = (launchArgs == obj.launchArgs);
        }
        break;
    case 22:
        {  // new scope
        retval = (hostAliases == obj.hostAliases);
        }
        break;
    case 23:
        {  // new scope
        retval = (shareOneBatchJob == obj.shareOneBatchJob);
        }
        break;
    case 24:
        {  // new scope
        retval = (sshPortSpecified == obj.sshPortSpecified);
        }
        break;
    case 25:
        {  // new scope
        retval = (sshPort == obj.sshPort);
        }
        break;
    case 26:
        {  // new scope
        retval = (clientHostDetermination == obj.clientHostDetermination);
        }
        break;
    case 27:
        {  // new scope
        retval = (manualClientHostName == obj.manualClientHostName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

std::string HostProfile::defaultUserName("notset");

// ****************************************************************************
//  Method:  SplitHostPattern
//
//  Purpose:
//    Returns the host name pattern split into strings by whitespace or commas.
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 13, 2002
//
// ****************************************************************************
std::vector<std::string>
HostProfile::SplitHostPattern(const std::string &host)
{
    std::vector<std::string> vec;
    std::string              name = "";

    for (int i=0; i<host.length(); i++)
    {
        if (host[i] == ' '  || host[i] == '\t' || host[i] == ',')
        {
            if (!name.empty())
            {
                vec.push_back(name);
                name = "";
            }
            continue;
        }
        else
        {
            name += host[i];
        }
    }
    if (!name.empty())
    {
        vec.push_back(name);
        name = "";
    }

    return vec;
}

// ****************************************************************************
//  Method:  ProfileMatchesHost
//
//  Purpose:
//    True if a hostname matches the host name pattern in the profile.
//
//  Arguments:
//    h          the hostname to compare with this profile
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 13, 2002
//
//  Modifications:
//    Jeremy Meredith, Mon Apr 14 10:06:34 PDT 2003
//    Added matching of host aliases.
//
// ****************************************************************************
bool
HostProfile::ProfileMatchesHost(const std::string &h) const
{
    std::vector<std::string> patterns = SplitHostPattern(host);
    bool match = false;
    int i;

    // Try to match the actual host name
    for (i = 0; i < patterns.size() && !match; i++)
    {
         match = WildcardStringMatch(patterns[i], h);
    }

    // Now match any aliases
    std::vector<std::string> aliases = SplitHostPattern(hostAliases);
    for (i = 0; i < aliases.size() && !match; i++)
    {
         match = WildcardStringMatch(aliases[i], h);
    }

    return match;
}

// ****************************************************************************
//  Method:  GetShortHostname
//
//  Purpose:
//    Returns a shortened version of the hostname.
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 13, 2002
//
// ****************************************************************************
std::string
HostProfile::GetShortHostname() const
{
    return GetShortHostname(host);
}

// ****************************************************************************
//  Method:  GetShortHostname
//
//  Purpose:
//    Returns a shortened version of the hostname.
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 13, 2002
//
//  Modifications:
//    Jeremy Meredith, Mon Apr 14 14:35:07 PDT 2003
//    Added ability to append a common suffix from patterns.
//
//    Jeremy Meredith, Fri Nov 14 10:37:59 PST 2003
//    Removed the suffix for now, and stop at the first dot.
//
// ****************************************************************************
std::string
HostProfile::GetShortHostname(const std::string &host)
{
    std::vector<std::string> patterns = SplitHostPattern(host);
    std::string              prefix = "";
    std::string              suffix = "";
    std::string              shortname;

    if (patterns.empty())
        return "";

    // find the minimum length of any string
    int l = patterns[0].length();
    for (int i = 1; i < patterns.size(); i++)
    {
        if (patterns[i].length() < l)
            l = patterns[i].length();
    }

    // find a common prefix
    for (int p = 0; p < l; p++)
    {
        char c = patterns[0][p];
        for (int i = 1; i < patterns.size() && c != '\0'; i++)
        {
            if (patterns[i][p] != c)
                c = '\0';
        }
        if (c=='\0' || c=='.')
            break;
        if (c != '*' && c != '?')
            prefix += c;
    }

    // find a common suffix, too
    for (int s = 0; s < l - prefix.length() - 1 && patterns.size() > 1; s++)
    {
        char c = patterns[0][l-1-s];
        for (int i = 1; i < patterns.size() && c != '\0'; i++)
        {
            if (patterns[i][l-1-s] != c)
                c = '\0';
        }
        if (!c)
            break;
        if (c != '*' && c != '?')
            suffix = c + suffix;
    }

    // combine the short name
    //shortname = prefix + suffix;
    shortname = prefix;
    if (prefix.empty())
        return patterns[0];
    else
        return shortname;
}

// ****************************************************************************
//  Method:  GetDefaultUserName
//
//  Purpose:
//    Returns the default user name.
//
//  Programmer:  Brad Whitlock
//  Creation:    Thu Apr 11 15:13:46 PST 2002
//
// ****************************************************************************

const std::string &
HostProfile::GetDefaultUserName()
{
    return defaultUserName;
}

// ****************************************************************************
//  Method:  SetDefaultUserName
//
//  Purpose:
//    Returns the default user name.
//
//  Programmer:  Brad Whitlock
//  Creation:    Thu Apr 11 15:13:46 PST 2002
//
// ****************************************************************************

void
HostProfile::SetDefaultUserName(const std::string &n)
{
    defaultUserName = n;
}

