#ifndef GLOBALLINEOUTATTRIBUTES_H
#define GLOBALLINEOUTATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: GlobalLineoutAttributes
//
// Purpose:
//    This file contains global attributes controlling Lineouts.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

class STATE_API GlobalLineoutAttributes : public AttributeSubject
{
public:
    enum CurveOptions
    {
        UpdateCurve,
        CreateCurve
    };
    enum ColorOptions
    {
        RepeatColor,
        CreateColor
    };

    GlobalLineoutAttributes();
    GlobalLineoutAttributes(const GlobalLineoutAttributes &obj);
    virtual ~GlobalLineoutAttributes();

    virtual GlobalLineoutAttributes& operator = (const GlobalLineoutAttributes &obj);
    virtual bool operator == (const GlobalLineoutAttributes &obj) const;
    virtual bool operator != (const GlobalLineoutAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetDynamic(bool Dynamic_);
    void SetCreateWindow(bool createWindow_);
    void SetWindowId(int windowId_);
    void SetSamplingOn(bool samplingOn_);
    void SetNumSamples(int numSamples_);
    void SetCreateReflineLabels(bool createReflineLabels_);
    void SetCurveOption(CurveOptions curveOption_);
    void SetColorOption(ColorOptions colorOption_);

    // Property getting methods
    bool GetDynamic() const;
    bool GetCreateWindow() const;
    int  GetWindowId() const;
    bool GetSamplingOn() const;
    int  GetNumSamples() const;
    bool GetCreateReflineLabels() const;
    CurveOptions GetCurveOption() const;
    ColorOptions GetColorOption() const;

    // Enum conversion functions
    static std::string CurveOptions_ToString(CurveOptions);
    static bool CurveOptions_FromString(const std::string &, CurveOptions &);
protected:
    static std::string CurveOptions_ToString(int);
public:
    static std::string ColorOptions_ToString(ColorOptions);
    static bool ColorOptions_FromString(const std::string &, ColorOptions &);
protected:
    static std::string ColorOptions_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    bool Dynamic;
    bool createWindow;
    int  windowId;
    bool samplingOn;
    int  numSamples;
    bool createReflineLabels;
    int  curveOption;
    int  colorOption;
};

#endif
