#include <GlobalLineoutAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for GlobalLineoutAttributes::CurveOptions
//

static const char *CurveOptions_strings[] = {
"UpdateCurve", "CreateCurve"};

std::string
GlobalLineoutAttributes::CurveOptions_ToString(GlobalLineoutAttributes::CurveOptions t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return CurveOptions_strings[index];
}

std::string
GlobalLineoutAttributes::CurveOptions_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return CurveOptions_strings[index];
}

bool
GlobalLineoutAttributes::CurveOptions_FromString(const std::string &s, GlobalLineoutAttributes::CurveOptions &val)
{
    val = GlobalLineoutAttributes::UpdateCurve;
    for(int i = 0; i < 2; ++i)
    {
        if(s == CurveOptions_strings[i])
        {
            val = (CurveOptions)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for GlobalLineoutAttributes::ColorOptions
//

static const char *ColorOptions_strings[] = {
"RepeatColor", "CreateColor"};

std::string
GlobalLineoutAttributes::ColorOptions_ToString(GlobalLineoutAttributes::ColorOptions t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ColorOptions_strings[index];
}

std::string
GlobalLineoutAttributes::ColorOptions_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ColorOptions_strings[index];
}

bool
GlobalLineoutAttributes::ColorOptions_FromString(const std::string &s, GlobalLineoutAttributes::ColorOptions &val)
{
    val = GlobalLineoutAttributes::RepeatColor;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ColorOptions_strings[i])
        {
            val = (ColorOptions)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::GlobalLineoutAttributes
//
// Purpose: 
//   Constructor for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

GlobalLineoutAttributes::GlobalLineoutAttributes() : AttributeSubject("bbibibii")
{
    Dynamic = false;
    createWindow = true;
    windowId = 2;
    samplingOn = false;
    numSamples = 50;
    createReflineLabels = false;
    curveOption = UpdateCurve;
    colorOption = RepeatColor;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::GlobalLineoutAttributes
//
// Purpose: 
//   Copy constructor for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

GlobalLineoutAttributes::GlobalLineoutAttributes(const GlobalLineoutAttributes &obj) : AttributeSubject("bbibibii")
{
    Dynamic = obj.Dynamic;
    createWindow = obj.createWindow;
    windowId = obj.windowId;
    samplingOn = obj.samplingOn;
    numSamples = obj.numSamples;
    createReflineLabels = obj.createReflineLabels;
    curveOption = obj.curveOption;
    colorOption = obj.colorOption;

    SelectAll();
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::~GlobalLineoutAttributes
//
// Purpose: 
//   Destructor for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

GlobalLineoutAttributes::~GlobalLineoutAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

GlobalLineoutAttributes& 
GlobalLineoutAttributes::operator = (const GlobalLineoutAttributes &obj)
{
    if (this == &obj) return *this;
    Dynamic = obj.Dynamic;
    createWindow = obj.createWindow;
    windowId = obj.windowId;
    samplingOn = obj.samplingOn;
    numSamples = obj.numSamples;
    createReflineLabels = obj.createReflineLabels;
    curveOption = obj.curveOption;
    colorOption = obj.colorOption;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalLineoutAttributes::operator == (const GlobalLineoutAttributes &obj) const
{
    // Create the return value
    return ((Dynamic == obj.Dynamic) &&
            (createWindow == obj.createWindow) &&
            (windowId == obj.windowId) &&
            (samplingOn == obj.samplingOn) &&
            (numSamples == obj.numSamples) &&
            (createReflineLabels == obj.createReflineLabels) &&
            (curveOption == obj.curveOption) &&
            (colorOption == obj.colorOption));
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalLineoutAttributes::operator != (const GlobalLineoutAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::TypeName
//
// Purpose: 
//   Type name method for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
GlobalLineoutAttributes::TypeName() const
{
    return "GlobalLineoutAttributes";
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalLineoutAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const GlobalLineoutAttributes *tmp = (const GlobalLineoutAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalLineoutAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new GlobalLineoutAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the GlobalLineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalLineoutAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new GlobalLineoutAttributes(*this);
    else
        retval = new GlobalLineoutAttributes;

    return retval;
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

void
GlobalLineoutAttributes::SelectAll()
{
    Select(0, (void *)&Dynamic);
    Select(1, (void *)&createWindow);
    Select(2, (void *)&windowId);
    Select(3, (void *)&samplingOn);
    Select(4, (void *)&numSamples);
    Select(5, (void *)&createReflineLabels);
    Select(6, (void *)&curveOption);
    Select(7, (void *)&colorOption);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
GlobalLineoutAttributes::SetDynamic(bool Dynamic_)
{
    Dynamic = Dynamic_;
    Select(0, (void *)&Dynamic);
}

void
GlobalLineoutAttributes::SetCreateWindow(bool createWindow_)
{
    createWindow = createWindow_;
    Select(1, (void *)&createWindow);
}

void
GlobalLineoutAttributes::SetWindowId(int windowId_)
{
    windowId = windowId_;
    Select(2, (void *)&windowId);
}

void
GlobalLineoutAttributes::SetSamplingOn(bool samplingOn_)
{
    samplingOn = samplingOn_;
    Select(3, (void *)&samplingOn);
}

void
GlobalLineoutAttributes::SetNumSamples(int numSamples_)
{
    numSamples = numSamples_;
    Select(4, (void *)&numSamples);
}

void
GlobalLineoutAttributes::SetCreateReflineLabels(bool createReflineLabels_)
{
    createReflineLabels = createReflineLabels_;
    Select(5, (void *)&createReflineLabels);
}

void
GlobalLineoutAttributes::SetCurveOption(GlobalLineoutAttributes::CurveOptions curveOption_)
{
    curveOption = curveOption_;
    Select(6, (void *)&curveOption);
}

void
GlobalLineoutAttributes::SetColorOption(GlobalLineoutAttributes::ColorOptions colorOption_)
{
    colorOption = colorOption_;
    Select(7, (void *)&colorOption);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
GlobalLineoutAttributes::GetDynamic() const
{
    return Dynamic;
}

bool
GlobalLineoutAttributes::GetCreateWindow() const
{
    return createWindow;
}

int
GlobalLineoutAttributes::GetWindowId() const
{
    return windowId;
}

bool
GlobalLineoutAttributes::GetSamplingOn() const
{
    return samplingOn;
}

int
GlobalLineoutAttributes::GetNumSamples() const
{
    return numSamples;
}

bool
GlobalLineoutAttributes::GetCreateReflineLabels() const
{
    return createReflineLabels;
}

GlobalLineoutAttributes::CurveOptions
GlobalLineoutAttributes::GetCurveOption() const
{
    return CurveOptions(curveOption);
}

GlobalLineoutAttributes::ColorOptions
GlobalLineoutAttributes::GetColorOption() const
{
    return ColorOptions(colorOption);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GlobalLineoutAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalLineoutAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Dynamic";
        case 1:  return "createWindow";
        case 2:  return "windowId";
        case 3:  return "samplingOn";
        case 4:  return "numSamples";
        case 5:  return "createReflineLabels";
        case 6:  return "curveOption";
        case 7:  return "colorOption";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
GlobalLineoutAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_int;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_int;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_enum;
        case 7:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalLineoutAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "int";
        case 3:  return "bool";
        case 4:  return "int";
        case 5:  return "bool";
        case 6:  return "enum";
        case 7:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalLineoutAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Feb 3 15:56:31 PST 2005
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalLineoutAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const GlobalLineoutAttributes &obj = *((const GlobalLineoutAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (Dynamic == obj.Dynamic);
        }
        break;
    case 1:
        {  // new scope
        retval = (createWindow == obj.createWindow);
        }
        break;
    case 2:
        {  // new scope
        retval = (windowId == obj.windowId);
        }
        break;
    case 3:
        {  // new scope
        retval = (samplingOn == obj.samplingOn);
        }
        break;
    case 4:
        {  // new scope
        retval = (numSamples == obj.numSamples);
        }
        break;
    case 5:
        {  // new scope
        retval = (createReflineLabels == obj.createReflineLabels);
        }
        break;
    case 6:
        {  // new scope
        retval = (curveOption == obj.curveOption);
        }
        break;
    case 7:
        {  // new scope
        retval = (colorOption == obj.colorOption);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

