#ifndef GLOBALATTRIBUTES_H
#define GLOBALATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: GlobalAttributes
//
// Purpose:
//    This class contains attributes associated with the main window.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API GlobalAttributes : public AttributeSubject
{
public:
    GlobalAttributes();
    GlobalAttributes(const GlobalAttributes &obj);
    virtual ~GlobalAttributes();

    virtual void operator = (const GlobalAttributes &obj);
    virtual bool operator == (const GlobalAttributes &obj) const;
    virtual bool operator != (const GlobalAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSources();
    void SelectWindows();

    // Property setting methods
    void SetSources(const stringVector &sources_);
    void SetWindows(const intVector &windows_);
    void SetActiveWindow(int activeWindow_);
    void SetIconifiedFlag(bool iconifiedFlag_);
    void SetAutoUpdateFlag(bool autoUpdateFlag_);
    void SetReplacePlots(bool replacePlots_);
    void SetApplyOperator(bool applyOperator_);
    void SetExecuting(bool executing_);
    void SetWindowLayout(int windowLayout_);
    void SetMakeDefaultConfirm(bool makeDefaultConfirm_);
    void SetCloneWindowOnFirstRef(bool cloneWindowOnFirstRef_);
    void SetMaintainView(bool maintainView_);
    void SetMaintainData(bool maintainData_);
    void SetAutomaticallyAddOperator(bool automaticallyAddOperator_);

    // Property getting methods
    const stringVector &GetSources() const;
          stringVector &GetSources();
    const intVector    &GetWindows() const;
          intVector    &GetWindows();
    int                GetActiveWindow() const;
    bool               GetIconifiedFlag() const;
    bool               GetAutoUpdateFlag() const;
    bool               GetReplacePlots() const;
    bool               GetApplyOperator() const;
    bool               GetExecuting() const;
    int                GetWindowLayout() const;
    bool               GetMakeDefaultConfirm() const;
    bool               GetCloneWindowOnFirstRef() const;
    bool               GetMaintainView() const;
    bool               GetMaintainData() const;
    bool               GetAutomaticallyAddOperator() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    stringVector sources;
    intVector    windows;
    int          activeWindow;
    bool         iconifiedFlag;
    bool         autoUpdateFlag;
    bool         replacePlots;
    bool         applyOperator;
    bool         executing;
    int          windowLayout;
    bool         makeDefaultConfirm;
    bool         cloneWindowOnFirstRef;
    bool         maintainView;
    bool         maintainData;
    bool         automaticallyAddOperator;
};

#endif
