#include <GlobalAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Constructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes() : AttributeSubject("s*i*ibbbbbibbbbb")
{
    activeWindow = 1;
    iconifiedFlag = false;
    autoUpdateFlag = false;
    replacePlots = false;
    applyOperator = true;
    executing = false;
    windowLayout = 1;
    makeDefaultConfirm = true;
    cloneWindowOnFirstRef = false;
    maintainView = false;
    maintainData = false;
    automaticallyAddOperator = false;
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Copy constructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes(const GlobalAttributes &obj) : AttributeSubject("s*i*ibbbbbibbbbb")
{
    sources = obj.sources;
    windows = obj.windows;
    activeWindow = obj.activeWindow;
    iconifiedFlag = obj.iconifiedFlag;
    autoUpdateFlag = obj.autoUpdateFlag;
    replacePlots = obj.replacePlots;
    applyOperator = obj.applyOperator;
    executing = obj.executing;
    windowLayout = obj.windowLayout;
    makeDefaultConfirm = obj.makeDefaultConfirm;
    cloneWindowOnFirstRef = obj.cloneWindowOnFirstRef;
    maintainView = obj.maintainView;
    maintainData = obj.maintainData;
    automaticallyAddOperator = obj.automaticallyAddOperator;

    SelectAll();
}

// ****************************************************************************
// Method: GlobalAttributes::~GlobalAttributes
//
// Purpose: 
//   Destructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::~GlobalAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: GlobalAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
GlobalAttributes::operator = (const GlobalAttributes &obj)
{
    sources = obj.sources;
    windows = obj.windows;
    activeWindow = obj.activeWindow;
    iconifiedFlag = obj.iconifiedFlag;
    autoUpdateFlag = obj.autoUpdateFlag;
    replacePlots = obj.replacePlots;
    applyOperator = obj.applyOperator;
    executing = obj.executing;
    windowLayout = obj.windowLayout;
    makeDefaultConfirm = obj.makeDefaultConfirm;
    cloneWindowOnFirstRef = obj.cloneWindowOnFirstRef;
    maintainView = obj.maintainView;
    maintainData = obj.maintainData;
    automaticallyAddOperator = obj.automaticallyAddOperator;

    SelectAll();
}

// ****************************************************************************
// Method: GlobalAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::operator == (const GlobalAttributes &obj) const
{
    // Create the return value
    return ((sources == obj.sources) &&
            (windows == obj.windows) &&
            (activeWindow == obj.activeWindow) &&
            (iconifiedFlag == obj.iconifiedFlag) &&
            (autoUpdateFlag == obj.autoUpdateFlag) &&
            (replacePlots == obj.replacePlots) &&
            (applyOperator == obj.applyOperator) &&
            (executing == obj.executing) &&
            (windowLayout == obj.windowLayout) &&
            (makeDefaultConfirm == obj.makeDefaultConfirm) &&
            (cloneWindowOnFirstRef == obj.cloneWindowOnFirstRef) &&
            (maintainView == obj.maintainView) &&
            (maintainData == obj.maintainData) &&
            (automaticallyAddOperator == obj.automaticallyAddOperator));
}

// ****************************************************************************
// Method: GlobalAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::operator != (const GlobalAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: GlobalAttributes::TypeName
//
// Purpose: 
//   Type name method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
GlobalAttributes::TypeName() const
{
    return "GlobalAttributes";
}

// ****************************************************************************
// Method: GlobalAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const GlobalAttributes *tmp = (const GlobalAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: GlobalAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new GlobalAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: GlobalAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new GlobalAttributes(*this);
    else
        retval = new GlobalAttributes;

    return retval;
}

// ****************************************************************************
// Method: GlobalAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
GlobalAttributes::SelectAll()
{
    Select(0, (void *)&sources);
    Select(1, (void *)&windows);
    Select(2, (void *)&activeWindow);
    Select(3, (void *)&iconifiedFlag);
    Select(4, (void *)&autoUpdateFlag);
    Select(5, (void *)&replacePlots);
    Select(6, (void *)&applyOperator);
    Select(7, (void *)&executing);
    Select(8, (void *)&windowLayout);
    Select(9, (void *)&makeDefaultConfirm);
    Select(10, (void *)&cloneWindowOnFirstRef);
    Select(11, (void *)&maintainView);
    Select(12, (void *)&maintainData);
    Select(13, (void *)&automaticallyAddOperator);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GlobalAttributes::CreateNode
//
// Purpose: 
//   Creates a node called "GlobalAttributes" that has all of the 
//   GlobalAttributes in it.
//
// Arguments:
//   parentNode   : The node under which the globalAtts node is created.
//   completeSave : Tells the method to save all fields even if they are not
//                  different.
//   forceAdd     : Tells the method to add a node to the parent node.
//
// Notes:
//   Only a handful of the attributes that this object contains are
//   made persistent. Other values are not good to save out since they
//   would have to update the state in other state objects in order to
//   work properly. Eventually, we might do that.
//
// Programmer: Brad Whitlock
// Creation:   Thu Sep 28 13:02:04 PST 2000
//
// Modifications:
//   Brad Whitlock, Mon Sep 16 14:50:20 PST 2002
//   I added the window layout.
//
//   Brad Whitlock, Mon Nov 4 13:51:39 PST 2002
//   I added makeDefaultConfirmation.
//
//   Eric Brugger, Thu Mar 13 14:05:40 PST 2003
//   I added cloneWindowOnFirstRef.
//
//   Brad Whitlock, Thu Mar 20 10:19:35 PDT 2003
//   I removed maintainView and maintainData.
//
//   Eric Brugger, Fri Apr 18 10:27:53 PDT 2003
//   I added maintainView.
//
//   Brad Whitlock, Tue May 20 10:43:27 PDT 2003
//   I made it made it save only what differs from the defaults.
//
//   Brad Whitlock, Wed Dec 17 12:09:40 PDT 2003
//   I added a completeSave flag.
//
//   Brad Whitlock, Fri Jan 23 16:16:02 PST 2004
//   I changed the numbering due to a change in attribute ordering.
//
//   Eric Brugger, Tue Mar 30 08:39:07 PST 2004
//   I added maintainData.
//
//   Brad Whitlock, Thu Aug 5 16:48:46 PST 2004
//   I added automaticallyAddOperator.
//
// ****************************************************************************

bool
GlobalAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    bool addToParent = false;
    GlobalAttributes defaultObject;

    // Create a node for GlobalAttributes.
    DataNode *node = new DataNode("GlobalAttributes");

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoUpdateFlag", autoUpdateFlag));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("replacePlots", replacePlots));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("applyOperator", applyOperator));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowLayout", windowLayout));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("makeDefaultConfirm", makeDefaultConfirm));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cloneWindowOnFirstRef",
                                    cloneWindowOnFirstRef));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maintainView", maintainView));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maintainData", maintainData));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("automaticallyAddOperator",
            automaticallyAddOperator));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: GlobalAttributes::SetFromNode
//
// Purpose: 
//   Looks for a node called "GlobalAttributes" under the parentNode. If
//   it is found, then it looks for various properties and sets the
//   object's attributes accordingly.
//
// Arguments:
//   parentNode : The node to start looking for "GlobalAttributes".
//
// Notes:
//   Only a handful of the attributes that this object contains are
//   made persistent. Other values are not good to save out since they
//   would have to update the state in other state objects in order to
//   work properly. Eventually, we might do that.
//
// Programmer: Brad Whitlock
// Creation:   Thu Sep 28 13:02:57 PST 2000
//
// Modifications:
//   Brad Whitlock, Mon Sep 16 14:51:35 PST 2002
//   I added the window layout.
//
//   Brad Whitlock, Mon Nov 4 13:52:32 PST 2002
//   I added makeDefaultConfirm.
//
//   Eric Brugger, Thu Mar 13 14:05:40 PST 2003
//   I added cloneWindowOnFirstRef.
//
//   Brad Whitlock, Thu Mar 20 10:19:35 PDT 2003
//   I removed maintainView and maintainData.
//
//   Eric Brugger, Fri Apr 18 10:27:53 PDT 2003
//   I added maintainView.
//
//   Eric Brugger, Tue Mar 30 08:39:07 PST 2004
//   I added maintainData.
//
//   Brad Whitlock, Thu Aug 5 16:51:14 PST 2004
//   I added automaticallyAddOperator.
//
// ****************************************************************************

void
GlobalAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("GlobalAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("autoUpdateFlag")) != 0)
        SetAutoUpdateFlag(node->AsBool());
    if((node = searchNode->GetNode("replacePlots")) != 0)
        SetReplacePlots(node->AsBool());
    if((node = searchNode->GetNode("applyOperator")) != 0)
        SetApplyOperator(node->AsBool());
    if((node = searchNode->GetNode("windowLayout")) != 0)
        SetWindowLayout(node->AsInt());
    if((node = searchNode->GetNode("makeDefaultConfirm")) != 0)
        SetMakeDefaultConfirm(node->AsBool());
    if((node = searchNode->GetNode("cloneWindowOnFirstRef")) != 0)
        SetCloneWindowOnFirstRef(node->AsBool());
    if((node = searchNode->GetNode("maintainView")) != 0)
        SetMaintainView(node->AsBool());
    if((node = searchNode->GetNode("maintainData")) != 0)
        SetMaintainData(node->AsBool());
    if((node = searchNode->GetNode("automaticallyAddOperator")) != 0)
        SetAutomaticallyAddOperator(node->AsBool());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
GlobalAttributes::SetSources(const stringVector &sources_)
{
    sources = sources_;
    Select(0, (void *)&sources);
}

void
GlobalAttributes::SetWindows(const intVector &windows_)
{
    windows = windows_;
    Select(1, (void *)&windows);
}

void
GlobalAttributes::SetActiveWindow(int activeWindow_)
{
    activeWindow = activeWindow_;
    Select(2, (void *)&activeWindow);
}

void
GlobalAttributes::SetIconifiedFlag(bool iconifiedFlag_)
{
    iconifiedFlag = iconifiedFlag_;
    Select(3, (void *)&iconifiedFlag);
}

void
GlobalAttributes::SetAutoUpdateFlag(bool autoUpdateFlag_)
{
    autoUpdateFlag = autoUpdateFlag_;
    Select(4, (void *)&autoUpdateFlag);
}

void
GlobalAttributes::SetReplacePlots(bool replacePlots_)
{
    replacePlots = replacePlots_;
    Select(5, (void *)&replacePlots);
}

void
GlobalAttributes::SetApplyOperator(bool applyOperator_)
{
    applyOperator = applyOperator_;
    Select(6, (void *)&applyOperator);
}

void
GlobalAttributes::SetExecuting(bool executing_)
{
    executing = executing_;
    Select(7, (void *)&executing);
}

void
GlobalAttributes::SetWindowLayout(int windowLayout_)
{
    windowLayout = windowLayout_;
    Select(8, (void *)&windowLayout);
}

void
GlobalAttributes::SetMakeDefaultConfirm(bool makeDefaultConfirm_)
{
    makeDefaultConfirm = makeDefaultConfirm_;
    Select(9, (void *)&makeDefaultConfirm);
}

void
GlobalAttributes::SetCloneWindowOnFirstRef(bool cloneWindowOnFirstRef_)
{
    cloneWindowOnFirstRef = cloneWindowOnFirstRef_;
    Select(10, (void *)&cloneWindowOnFirstRef);
}

void
GlobalAttributes::SetMaintainView(bool maintainView_)
{
    maintainView = maintainView_;
    Select(11, (void *)&maintainView);
}

void
GlobalAttributes::SetMaintainData(bool maintainData_)
{
    maintainData = maintainData_;
    Select(12, (void *)&maintainData);
}

void
GlobalAttributes::SetAutomaticallyAddOperator(bool automaticallyAddOperator_)
{
    automaticallyAddOperator = automaticallyAddOperator_;
    Select(13, (void *)&automaticallyAddOperator);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
GlobalAttributes::GetSources() const
{
    return sources;
}

stringVector &
GlobalAttributes::GetSources()
{
    return sources;
}

const intVector &
GlobalAttributes::GetWindows() const
{
    return windows;
}

intVector &
GlobalAttributes::GetWindows()
{
    return windows;
}

int
GlobalAttributes::GetActiveWindow() const
{
    return activeWindow;
}

bool
GlobalAttributes::GetIconifiedFlag() const
{
    return iconifiedFlag;
}

bool
GlobalAttributes::GetAutoUpdateFlag() const
{
    return autoUpdateFlag;
}

bool
GlobalAttributes::GetReplacePlots() const
{
    return replacePlots;
}

bool
GlobalAttributes::GetApplyOperator() const
{
    return applyOperator;
}

bool
GlobalAttributes::GetExecuting() const
{
    return executing;
}

int
GlobalAttributes::GetWindowLayout() const
{
    return windowLayout;
}

bool
GlobalAttributes::GetMakeDefaultConfirm() const
{
    return makeDefaultConfirm;
}

bool
GlobalAttributes::GetCloneWindowOnFirstRef() const
{
    return cloneWindowOnFirstRef;
}

bool
GlobalAttributes::GetMaintainView() const
{
    return maintainView;
}

bool
GlobalAttributes::GetMaintainData() const
{
    return maintainData;
}

bool
GlobalAttributes::GetAutomaticallyAddOperator() const
{
    return automaticallyAddOperator;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
GlobalAttributes::SelectSources()
{
    Select(0, (void *)&sources);
}

void
GlobalAttributes::SelectWindows()
{
    Select(1, (void *)&windows);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GlobalAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Sources";
        case 1:  return "windows";
        case 2:  return "activeWindow";
        case 3:  return "iconifiedFlag";
        case 4:  return "autoUpdateFlag";
        case 5:  return "replacePlots";
        case 6:  return "applyOperator";
        case 7:  return "executing";
        case 8:  return "windowLayout";
        case 9:  return "makeDefaultConfirm";
        case 10:  return "cloneWindowOnFirstRef";
        case 11:  return "maintainView";
        case 12:  return "maintainData";
        case 13:  return "automaticallyAddOperator";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
GlobalAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_stringVector;
        case 1:  return FieldType_intVector;
        case 2:  return FieldType_int;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_int;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: GlobalAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "stringVector";
        case 1:  return "intVector";
        case 2:  return "int";
        case 3:  return "bool";
        case 4:  return "bool";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "int";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "bool";
        case 12:  return "bool";
        case 13:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Aug 5 16:52:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const GlobalAttributes &obj = *((const GlobalAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (sources == obj.sources);
        }
        break;
    case 1:
        {  // new scope
        retval = (windows == obj.windows);
        }
        break;
    case 2:
        {  // new scope
        retval = (activeWindow == obj.activeWindow);
        }
        break;
    case 3:
        {  // new scope
        retval = (iconifiedFlag == obj.iconifiedFlag);
        }
        break;
    case 4:
        {  // new scope
        retval = (autoUpdateFlag == obj.autoUpdateFlag);
        }
        break;
    case 5:
        {  // new scope
        retval = (replacePlots == obj.replacePlots);
        }
        break;
    case 6:
        {  // new scope
        retval = (applyOperator == obj.applyOperator);
        }
        break;
    case 7:
        {  // new scope
        retval = (executing == obj.executing);
        }
        break;
    case 8:
        {  // new scope
        retval = (windowLayout == obj.windowLayout);
        }
        break;
    case 9:
        {  // new scope
        retval = (makeDefaultConfirm == obj.makeDefaultConfirm);
        }
        break;
    case 10:
        {  // new scope
        retval = (cloneWindowOnFirstRef == obj.cloneWindowOnFirstRef);
        }
        break;
    case 11:
        {  // new scope
        retval = (maintainView == obj.maintainView);
        }
        break;
    case 12:
        {  // new scope
        retval = (maintainData == obj.maintainData);
        }
        break;
    case 13:
        {  // new scope
        retval = (automaticallyAddOperator == obj.automaticallyAddOperator);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

