#ifndef EXPRESSIONLIST_H
#define EXPRESSIONLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>
class Expression;

// ****************************************************************************
// Class: ExpressionList
//
// Purpose:
//    This class contains a list of expressions and some functions to manipulate them.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Aug 25 08:23:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API ExpressionList : public AttributeSubject
{
public:
    ExpressionList();
    ExpressionList(const ExpressionList &obj);
    virtual ~ExpressionList();

    virtual void operator = (const ExpressionList &obj);
    virtual bool operator == (const ExpressionList &obj) const;
    virtual bool operator != (const ExpressionList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectExpressions();

    // Property setting methods
    void SetExpressions(const AttributeGroupVector &expressions_);

    // Property getting methods
    const AttributeGroupVector &GetExpressions() const;
          AttributeGroupVector &GetExpressions();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddExpression(const Expression &);
    void ClearExpressions();
    void RemoveExpression(int i);
    int  GetNumExpressions() const;
    Expression &GetExpression(int i);
    const Expression &GetExpression(int i) const;

    Expression &operator [] (int i);
    const Expression &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    Expression *operator[](const char *);
    const stringVector GetAllVarNames(const std::string &dbN) const;
protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector expressions;
};

#endif
