#include <Expression.h>
#include <DataNode.h>

//
// Enum conversion methods for Expression::ExprType
//

static const char *ExprType_strings[] = {
"Unknown", "ScalarMeshVar", "VectorMeshVar", 
"TensorMeshVar", "SymmetricTensorMeshVar", "Mesh", 
"Material", "Species"};

std::string
Expression::ExprType_ToString(Expression::ExprType t)
{
    int index = int(t);
    if(index < 0 || index >= 8) index = 0;
    return ExprType_strings[index];
}

std::string
Expression::ExprType_ToString(int t)
{
    int index = (t < 0 || t >= 8) ? 0 : t;
    return ExprType_strings[index];
}

bool
Expression::ExprType_FromString(const std::string &s, Expression::ExprType &val)
{
    val = Expression::Unknown;
    for(int i = 0; i < 8; ++i)
    {
        if(s == ExprType_strings[i])
        {
            val = (ExprType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: Expression::Expression
//
// Purpose: 
//   Constructor for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

Expression::Expression() : AttributeSubject("ssbibs")
{
    name = "notset";
    definition = "notset";
    hidden = false;
    type = ScalarMeshVar;
    fromDB = false;
    dbName = "__none__";
}

// ****************************************************************************
// Method: Expression::Expression
//
// Purpose: 
//   Copy constructor for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

Expression::Expression(const Expression &obj) : AttributeSubject("ssbibs")
{
    name = obj.name;
    definition = obj.definition;
    hidden = obj.hidden;
    type = obj.type;
    fromDB = obj.fromDB;
    dbName = obj.dbName;

    SelectAll();
}

// ****************************************************************************
// Method: Expression::~Expression
//
// Purpose: 
//   Destructor for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

Expression::~Expression()
{
    // nothing here
}

// ****************************************************************************
// Method: Expression::operator = 
//
// Purpose: 
//   Assignment operator for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
Expression::operator = (const Expression &obj)
{
    name = obj.name;
    definition = obj.definition;
    hidden = obj.hidden;
    type = obj.type;
    fromDB = obj.fromDB;
    dbName = obj.dbName;

    SelectAll();
}

// ****************************************************************************
// Method: Expression::operator == 
//
// Purpose: 
//   Comparison operator == for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
Expression::operator == (const Expression &obj) const
{
    // Create the return value
    return ((name == obj.name) &&
            (definition == obj.definition) &&
            (hidden == obj.hidden) &&
            (type == obj.type) &&
            (fromDB == obj.fromDB) &&
            (dbName == obj.dbName));
}

// ****************************************************************************
// Method: Expression::operator != 
//
// Purpose: 
//   Comparison operator != for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
Expression::operator != (const Expression &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Expression::TypeName
//
// Purpose: 
//   Type name method for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
Expression::TypeName() const
{
    return "Expression";
}

// ****************************************************************************
// Method: Expression::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
Expression::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Expression *tmp = (const Expression *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Expression::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Expression::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Expression(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Expression::NewInstance
//
// Purpose: 
//   NewInstance method for the Expression class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Expression::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Expression(*this);
    else
        retval = new Expression;

    return retval;
}

// ****************************************************************************
// Method: Expression::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
Expression::SelectAll()
{
    Select(0, (void *)&name);
    Select(1, (void *)&definition);
    Select(2, (void *)&hidden);
    Select(3, (void *)&type);
    Select(4, (void *)&fromDB);
    Select(5, (void *)&dbName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Expression::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
Expression::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    Expression defaultObject;
    bool addToParent = false;
    // Create a node for Expression.
    DataNode *node = new DataNode("Expression");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("definition", definition));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hidden", hidden));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", ExprType_ToString(type)));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fromDB", fromDB));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("dbName", dbName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: Expression::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
Expression::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("Expression");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsString());
    if((node = searchNode->GetNode("definition")) != 0)
        SetDefinition(node->AsString());
    if((node = searchNode->GetNode("hidden")) != 0)
        SetHidden(node->AsBool());
    if((node = searchNode->GetNode("type")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 8)
                SetType(ExprType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ExprType value;
            if(ExprType_FromString(node->AsString(), value))
                SetType(value);
        }
    }
    if((node = searchNode->GetNode("fromDB")) != 0)
        SetFromDB(node->AsBool());
    if((node = searchNode->GetNode("dbName")) != 0)
        SetDbName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Expression::SetName(const std::string &name_)
{
    name = name_;
    Select(0, (void *)&name);
}

void
Expression::SetDefinition(const std::string &definition_)
{
    definition = definition_;
    Select(1, (void *)&definition);
}

void
Expression::SetHidden(bool hidden_)
{
    hidden = hidden_;
    Select(2, (void *)&hidden);
}

void
Expression::SetType(Expression::ExprType type_)
{
    type = type_;
    Select(3, (void *)&type);
}

void
Expression::SetFromDB(bool fromDB_)
{
    fromDB = fromDB_;
    Select(4, (void *)&fromDB);
}

void
Expression::SetDbName(const std::string &dbName_)
{
    dbName = dbName_;
    Select(5, (void *)&dbName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
Expression::GetName() const
{
    return name;
}

std::string &
Expression::GetName()
{
    return name;
}

const std::string &
Expression::GetDefinition() const
{
    return definition;
}

std::string &
Expression::GetDefinition()
{
    return definition;
}

bool
Expression::GetHidden() const
{
    return hidden;
}

Expression::ExprType
Expression::GetType() const
{
    return ExprType(type);
}

bool
Expression::GetFromDB() const
{
    return fromDB;
}

const std::string &
Expression::GetDbName() const
{
    return dbName;
}

std::string &
Expression::GetDbName()
{
    return dbName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Expression::SelectName()
{
    Select(0, (void *)&name);
}

void
Expression::SelectDefinition()
{
    Select(1, (void *)&definition);
}

void
Expression::SelectDbName()
{
    Select(5, (void *)&dbName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Expression::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
Expression::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "name";
        case 1:  return "definition";
        case 2:  return "hidden";
        case 3:  return "type";
        case 4:  return "fromDB";
        case 5:  return "dbName";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Expression::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Expression::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_string;
        case 1:  return FieldType_string;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_enum;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Expression::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
Expression::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "string";
        case 1:  return "string";
        case 2:  return "bool";
        case 3:  return "enum";
        case 4:  return "bool";
        case 5:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Expression::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
Expression::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Expression &obj = *((const Expression*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case 1:
        {  // new scope
        retval = (definition == obj.definition);
        }
        break;
    case 2:
        {  // new scope
        retval = (hidden == obj.hidden);
        }
        break;
    case 3:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case 4:
        {  // new scope
        retval = (fromDB == obj.fromDB);
        }
        break;
    case 5:
        {  // new scope
        retval = (dbName == obj.dbName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method:  Expression::GetNumTypes
//
//  Programmer:  ?
//  Creation:    ?
//
//  Modifications:
//    Jeremy Meredith, Sun Oct 10 22:58:21 PDT 2004
//    Changed it to 8 to reflect the current number of actual expressions.
//
// ****************************************************************************
const int
Expression::GetNumTypes()
{
    return 8;
}

const char *
Expression::GetTypeString(const Expression::ExprType t)
{
    switch(t)
    {
    case ScalarMeshVar:
        return "Scalar Mesh Variable";
    case VectorMeshVar:
        return "Vector Mesh Variable";
    case TensorMeshVar:
        return "Tensor Mesh Variable";
    case SymmetricTensorMeshVar:
        return "Symmetric Tensor Mesh Variable";
    case Mesh:
        return "Mesh";
    case Material:
        return "Material";
    case Species:
        return "Species";
    default:
        return "Unknown Type";
    }
}

const Expression::ExprType
Expression::GetTypeId(const std::string s)
{
    if (s == "Scalar Mesh Variable")
        return ScalarMeshVar;
    else if (s == "Vector Mesh Variable")
        return VectorMeshVar;
    else if (s == "Tensor Mesh Variable")
        return TensorMeshVar;
    else if (s == "Symmetric Tensor Mesh Variable")
        return SymmetricTensorMeshVar;
    else if (s == "Mesh")
        return Mesh;
    else if (s == "Material")
        return Material;
    else if (s == "Species")
        return Species;
    else
        return Unknown;
}

