#ifndef ENGINELIST_H
#define ENGINELIST_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: EngineList
//
// Purpose:
//    This class contains a list of host names on which engines are running.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API EngineList : public AttributeSubject
{
public:
    EngineList();
    EngineList(const EngineList &obj);
    virtual ~EngineList();

    virtual void operator = (const EngineList &obj);
    virtual bool operator == (const EngineList &obj) const;
    virtual bool operator != (const EngineList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectEngines();
    void SelectNumProcessors();
    void SelectNumNodes();
    void SelectLoadBalancing();
    void SelectSimulationName();

    // Property setting methods
    void SetEngines(const stringVector &engines_);
    void SetNumProcessors(const intVector &numProcessors_);
    void SetNumNodes(const intVector &numNodes_);
    void SetLoadBalancing(const intVector &loadBalancing_);
    void SetSimulationName(const stringVector &simulationName_);

    // Property getting methods
    const stringVector &GetEngines() const;
          stringVector &GetEngines();
    const intVector    &GetNumProcessors() const;
          intVector    &GetNumProcessors();
    const intVector    &GetNumNodes() const;
          intVector    &GetNumNodes();
    const intVector    &GetLoadBalancing() const;
          intVector    &GetLoadBalancing();
    const stringVector &GetSimulationName() const;
          stringVector &GetSimulationName();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    stringVector engines;
    intVector    numProcessors;
    intVector    numNodes;
    intVector    loadBalancing;
    stringVector simulationName;
};

#endif
