#include <EngineList.h>
#include <DataNode.h>

// ****************************************************************************
// Method: EngineList::EngineList
//
// Purpose: 
//   Constructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

EngineList::EngineList() : AttributeSubject("s*i*i*i*s*")
{
}

// ****************************************************************************
// Method: EngineList::EngineList
//
// Purpose: 
//   Copy constructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

EngineList::EngineList(const EngineList &obj) : AttributeSubject("s*i*i*i*s*")
{
    engines = obj.engines;
    numProcessors = obj.numProcessors;
    numNodes = obj.numNodes;
    loadBalancing = obj.loadBalancing;
    simulationName = obj.simulationName;

    SelectAll();
}

// ****************************************************************************
// Method: EngineList::~EngineList
//
// Purpose: 
//   Destructor for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

EngineList::~EngineList()
{
    // nothing here
}

// ****************************************************************************
// Method: EngineList::operator = 
//
// Purpose: 
//   Assignment operator for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
EngineList::operator = (const EngineList &obj)
{
    engines = obj.engines;
    numProcessors = obj.numProcessors;
    numNodes = obj.numNodes;
    loadBalancing = obj.loadBalancing;
    simulationName = obj.simulationName;

    SelectAll();
}

// ****************************************************************************
// Method: EngineList::operator == 
//
// Purpose: 
//   Comparison operator == for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::operator == (const EngineList &obj) const
{
    // Create the return value
    return ((engines == obj.engines) &&
            (numProcessors == obj.numProcessors) &&
            (numNodes == obj.numNodes) &&
            (loadBalancing == obj.loadBalancing) &&
            (simulationName == obj.simulationName));
}

// ****************************************************************************
// Method: EngineList::operator != 
//
// Purpose: 
//   Comparison operator != for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::operator != (const EngineList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: EngineList::TypeName
//
// Purpose: 
//   Type name method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
EngineList::TypeName() const
{
    return "EngineList";
}

// ****************************************************************************
// Method: EngineList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const EngineList *tmp = (const EngineList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: EngineList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new EngineList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: EngineList::NewInstance
//
// Purpose: 
//   NewInstance method for the EngineList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
EngineList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new EngineList(*this);
    else
        retval = new EngineList;

    return retval;
}

// ****************************************************************************
// Method: EngineList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
EngineList::SelectAll()
{
    Select(0, (void *)&engines);
    Select(1, (void *)&numProcessors);
    Select(2, (void *)&numNodes);
    Select(3, (void *)&loadBalancing);
    Select(4, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    EngineList defaultObject;
    bool addToParent = false;
    // Create a node for EngineList.
    DataNode *node = new DataNode("EngineList");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("engines", engines));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessors", numProcessors));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodes", numNodes));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("loadBalancing", loadBalancing));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("simulationName", simulationName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: EngineList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
EngineList::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("EngineList");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("engines")) != 0)
        SetEngines(node->AsStringVector());
    if((node = searchNode->GetNode("numProcessors")) != 0)
        SetNumProcessors(node->AsIntVector());
    if((node = searchNode->GetNode("numNodes")) != 0)
        SetNumNodes(node->AsIntVector());
    if((node = searchNode->GetNode("loadBalancing")) != 0)
        SetLoadBalancing(node->AsIntVector());
    if((node = searchNode->GetNode("simulationName")) != 0)
        SetSimulationName(node->AsStringVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineList::SetEngines(const stringVector &engines_)
{
    engines = engines_;
    Select(0, (void *)&engines);
}

void
EngineList::SetNumProcessors(const intVector &numProcessors_)
{
    numProcessors = numProcessors_;
    Select(1, (void *)&numProcessors);
}

void
EngineList::SetNumNodes(const intVector &numNodes_)
{
    numNodes = numNodes_;
    Select(2, (void *)&numNodes);
}

void
EngineList::SetLoadBalancing(const intVector &loadBalancing_)
{
    loadBalancing = loadBalancing_;
    Select(3, (void *)&loadBalancing);
}

void
EngineList::SetSimulationName(const stringVector &simulationName_)
{
    simulationName = simulationName_;
    Select(4, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
EngineList::GetEngines() const
{
    return engines;
}

stringVector &
EngineList::GetEngines()
{
    return engines;
}

const intVector &
EngineList::GetNumProcessors() const
{
    return numProcessors;
}

intVector &
EngineList::GetNumProcessors()
{
    return numProcessors;
}

const intVector &
EngineList::GetNumNodes() const
{
    return numNodes;
}

intVector &
EngineList::GetNumNodes()
{
    return numNodes;
}

const intVector &
EngineList::GetLoadBalancing() const
{
    return loadBalancing;
}

intVector &
EngineList::GetLoadBalancing()
{
    return loadBalancing;
}

const stringVector &
EngineList::GetSimulationName() const
{
    return simulationName;
}

stringVector &
EngineList::GetSimulationName()
{
    return simulationName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
EngineList::SelectEngines()
{
    Select(0, (void *)&engines);
}

void
EngineList::SelectNumProcessors()
{
    Select(1, (void *)&numProcessors);
}

void
EngineList::SelectNumNodes()
{
    Select(2, (void *)&numNodes);
}

void
EngineList::SelectLoadBalancing()
{
    Select(3, (void *)&loadBalancing);
}

void
EngineList::SelectSimulationName()
{
    Select(4, (void *)&simulationName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: EngineList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "engines";
        case 1:  return "numProcessors";
        case 2:  return "numNodes";
        case 3:  return "loadBalancing";
        case 4:  return "simulationName";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
EngineList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_stringVector;
        case 1:  return FieldType_intVector;
        case 2:  return FieldType_intVector;
        case 3:  return FieldType_intVector;
        case 4:  return FieldType_stringVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: EngineList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
EngineList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "stringVector";
        case 1:  return "intVector";
        case 2:  return "intVector";
        case 3:  return "intVector";
        case 4:  return "stringVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: EngineList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 18:04:03 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
EngineList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const EngineList &obj = *((const EngineList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (engines == obj.engines);
        }
        break;
    case 1:
        {  // new scope
        retval = (numProcessors == obj.numProcessors);
        }
        break;
    case 2:
        {  // new scope
        retval = (numNodes == obj.numNodes);
        }
        break;
    case 3:
        {  // new scope
        retval = (loadBalancing == obj.loadBalancing);
        }
        break;
    case 4:
        {  // new scope
        retval = (simulationName == obj.simulationName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

