#ifndef DATABASECORRELATIONLIST_H
#define DATABASECORRELATIONLIST_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>
class DatabaseCorrelation;
#include <visitstream.h>

// ****************************************************************************
// Class: DatabaseCorrelationList
//
// Purpose:
//    This class contains the database correlations that we know about.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

class STATE_API DatabaseCorrelationList : public AttributeSubject
{
public:
    enum WhenToCorrelate
    {
        CorrelateAlways,
        CorrelateNever,
        CorrelateOnlyIfSameLength
    };

    DatabaseCorrelationList();
    DatabaseCorrelationList(const DatabaseCorrelationList &obj);
    virtual ~DatabaseCorrelationList();

    virtual void operator = (const DatabaseCorrelationList &obj);
    virtual bool operator == (const DatabaseCorrelationList &obj) const;
    virtual bool operator != (const DatabaseCorrelationList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCorrelations();

    // Property setting methods
    void SetCorrelations(const AttributeGroupVector &correlations_);
    void SetNeedPermission(bool needPermission_);
    void SetDefaultCorrelationMethod(int defaultCorrelationMethod_);
    void SetWhenToCorrelate(WhenToCorrelate whenToCorrelate_);

    // Property getting methods
    const AttributeGroupVector &GetCorrelations() const;
          AttributeGroupVector &GetCorrelations();
    bool GetNeedPermission() const;
    int  GetDefaultCorrelationMethod() const;
    WhenToCorrelate GetWhenToCorrelate() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddDatabaseCorrelation(const DatabaseCorrelation &);
    void ClearDatabaseCorrelations();
    void RemoveDatabaseCorrelation(int i);
    int  GetNumDatabaseCorrelations() const;
    DatabaseCorrelation &GetDatabaseCorrelation(int i);
    const DatabaseCorrelation &GetDatabaseCorrelation(int i) const;

    DatabaseCorrelation &operator [] (int i);
    const DatabaseCorrelation &operator [] (int i) const;

    // Enum conversion functions
    static std::string WhenToCorrelate_ToString(WhenToCorrelate);
    static bool WhenToCorrelate_FromString(const std::string &, WhenToCorrelate &);
protected:
    static std::string WhenToCorrelate_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    DatabaseCorrelation *FindCorrelation(const std::string &name) const;
    bool RemoveCorrelation(const std::string &name);
protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector correlations;
    bool                 needPermission;
    int                  defaultCorrelationMethod;
    int                  whenToCorrelate;
};

ostream &operator <<(ostream &, const DatabaseCorrelationList &cL);

#endif
