#include <DatabaseCorrelationList.h>
#include <DataNode.h>
#include <DatabaseCorrelation.h>

//
// Enum conversion methods for DatabaseCorrelationList::WhenToCorrelate
//

static const char *WhenToCorrelate_strings[] = {
"CorrelateAlways", "CorrelateNever", "CorrelateOnlyIfSameLength"
};

std::string
DatabaseCorrelationList::WhenToCorrelate_ToString(DatabaseCorrelationList::WhenToCorrelate t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return WhenToCorrelate_strings[index];
}

std::string
DatabaseCorrelationList::WhenToCorrelate_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return WhenToCorrelate_strings[index];
}

bool
DatabaseCorrelationList::WhenToCorrelate_FromString(const std::string &s, DatabaseCorrelationList::WhenToCorrelate &val)
{
    val = DatabaseCorrelationList::CorrelateAlways;
    for(int i = 0; i < 3; ++i)
    {
        if(s == WhenToCorrelate_strings[i])
        {
            val = (WhenToCorrelate)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Constructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList() : AttributeSubject("a*bii")
{
    needPermission = true;
    defaultCorrelationMethod = 0;
    whenToCorrelate = CorrelateOnlyIfSameLength;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::DatabaseCorrelationList
//
// Purpose: 
//   Copy constructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::DatabaseCorrelationList(const DatabaseCorrelationList &obj) : AttributeSubject("a*bii")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the correlations field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
    correlations.clear();
    if(obj.correlations.size() > 0)
        correlations.reserve(obj.correlations.size());
    // Duplicate the correlations from obj.
    for(pos = obj.correlations.begin(); pos != obj.correlations.end(); ++pos)
    {
        DatabaseCorrelation *oldDatabaseCorrelation = (DatabaseCorrelation *)(*pos);
        DatabaseCorrelation *newDatabaseCorrelation = new DatabaseCorrelation(*oldDatabaseCorrelation);
        correlations.push_back(newDatabaseCorrelation);
    }

    needPermission = obj.needPermission;
    defaultCorrelationMethod = obj.defaultCorrelationMethod;
    whenToCorrelate = obj.whenToCorrelate;

    SelectAll();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::~DatabaseCorrelationList
//
// Purpose: 
//   Destructor for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelationList::~DatabaseCorrelationList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the correlations field.
    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator = 
//
// Purpose: 
//   Assignment operator for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::operator = (const DatabaseCorrelationList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the correlations field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
    correlations.clear();
    if(obj.correlations.size() > 0)
        correlations.reserve(obj.correlations.size());
    // Duplicate the correlations from obj.
    for(pos = obj.correlations.begin(); pos != obj.correlations.end(); ++pos)
    {
        DatabaseCorrelation *oldDatabaseCorrelation = (DatabaseCorrelation *)(*pos);
        DatabaseCorrelation *newDatabaseCorrelation = new DatabaseCorrelation(*oldDatabaseCorrelation);
        correlations.push_back(newDatabaseCorrelation);
    }

    needPermission = obj.needPermission;
    defaultCorrelationMethod = obj.defaultCorrelationMethod;
    whenToCorrelate = obj.whenToCorrelate;

    SelectAll();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator == 
//
// Purpose: 
//   Comparison operator == for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::operator == (const DatabaseCorrelationList &obj) const
{
    int i;

    bool correlations_equal = (obj.correlations.size() == correlations.size());
    for(i = 0; (i < correlations.size()) && correlations_equal; ++i)
    {
        // Make references to DatabaseCorrelation from AttributeGroup *.
        const DatabaseCorrelation &correlations1 = *((const DatabaseCorrelation *)(correlations[i]));
        const DatabaseCorrelation &correlations2 = *((const DatabaseCorrelation *)(obj.correlations[i]));
        correlations_equal = (correlations1 == correlations2);
    }

    // Create the return value
    return (correlations_equal &&
            (needPermission == obj.needPermission) &&
            (defaultCorrelationMethod == obj.defaultCorrelationMethod) &&
            (whenToCorrelate == obj.whenToCorrelate));
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator != 
//
// Purpose: 
//   Comparison operator != for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::operator != (const DatabaseCorrelationList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DatabaseCorrelationList::TypeName
//
// Purpose: 
//   Type name method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
DatabaseCorrelationList::TypeName() const
{
    return "DatabaseCorrelationList";
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DatabaseCorrelationList *tmp = (const DatabaseCorrelationList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DatabaseCorrelationList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DatabaseCorrelationList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::NewInstance
//
// Purpose: 
//   NewInstance method for the DatabaseCorrelationList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DatabaseCorrelationList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DatabaseCorrelationList(*this);
    else
        retval = new DatabaseCorrelationList;

    return retval;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::SelectAll()
{
    Select(0, (void *)&correlations);
    Select(1, (void *)&needPermission);
    Select(2, (void *)&defaultCorrelationMethod);
    Select(3, (void *)&whenToCorrelate);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
DatabaseCorrelationList::CreateSubAttributeGroup(int)
{
    return new DatabaseCorrelation;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Mar 1 16:55:46 PST 2004
//
// Modifications:
//   Brad Whitlock, Thu Mar 25 16:45:47 PST 2004
//   I modified the code so the correlation list is only saved when
//   completeSave is true.
//
// ****************************************************************************

bool
DatabaseCorrelationList::CreateNode(DataNode *parentNode, bool completeSave, bool)
{
    if(parentNode == 0)
        return false;

    // Only save the correlations on a complete save.
    DataNode *node = new DataNode("DatabaseCorrelationList");
    if(completeSave)
    {
        for(int i = 0; i < correlations.size(); ++i)
            correlations[i]->CreateNode(node, completeSave, true);
    }

    node->AddNode(new DataNode("needPermission", needPermission));
    node->AddNode(new DataNode("defaultCorrelationMethod", defaultCorrelationMethod));
    node->AddNode(new DataNode("whenToCorrelate", WhenToCorrelate_ToString(whenToCorrelate)));

    // Add the node to the parent node.
    parentNode->AddNode(node);

    return true;
}
// ****************************************************************************
// Method: DatabaseCorrelationList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DatabaseCorrelationList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    // Clear all the DatabaseCorrelations.
    ClearDatabaseCorrelations();

    // Go through all of the children and construct a new
    // DatabaseCorrelation for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("DatabaseCorrelation"))
        {
            DatabaseCorrelation temp;
            temp.SetFromNode(children[i]);
            AddDatabaseCorrelation(temp);
        }
    }

    if((node = searchNode->GetNode("needPermission")) != 0)
        SetNeedPermission(node->AsBool());
    if((node = searchNode->GetNode("defaultCorrelationMethod")) != 0)
        SetDefaultCorrelationMethod(node->AsInt());
    if((node = searchNode->GetNode("whenToCorrelate")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetWhenToCorrelate(WhenToCorrelate(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            WhenToCorrelate value;
            if(WhenToCorrelate_FromString(node->AsString(), value))
                SetWhenToCorrelate(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DatabaseCorrelationList::SetNeedPermission(bool needPermission_)
{
    needPermission = needPermission_;
    Select(1, (void *)&needPermission);
}

void
DatabaseCorrelationList::SetDefaultCorrelationMethod(int defaultCorrelationMethod_)
{
    defaultCorrelationMethod = defaultCorrelationMethod_;
    Select(2, (void *)&defaultCorrelationMethod);
}

void
DatabaseCorrelationList::SetWhenToCorrelate(DatabaseCorrelationList::WhenToCorrelate whenToCorrelate_)
{
    whenToCorrelate = whenToCorrelate_;
    Select(3, (void *)&whenToCorrelate);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
DatabaseCorrelationList::GetCorrelations() const
{
    return correlations;
}

AttributeGroupVector &
DatabaseCorrelationList::GetCorrelations()
{
    return correlations;
}

bool
DatabaseCorrelationList::GetNeedPermission() const
{
    return needPermission;
}

int
DatabaseCorrelationList::GetDefaultCorrelationMethod() const
{
    return defaultCorrelationMethod;
}

DatabaseCorrelationList::WhenToCorrelate
DatabaseCorrelationList::GetWhenToCorrelate() const
{
    return WhenToCorrelate(whenToCorrelate);
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DatabaseCorrelationList::SelectCorrelations()
{
    Select(0, (void *)&correlations);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::AddDatabaseCorrelation
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::AddDatabaseCorrelation(const DatabaseCorrelation &obj)
{
    DatabaseCorrelation *newDatabaseCorrelation = new DatabaseCorrelation(obj);
    correlations.push_back(newDatabaseCorrelation);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::ClearDatabaseCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::ClearDatabaseCorrelations()
{
    AttributeGroupVector::iterator pos;

    for(pos = correlations.begin(); pos != correlations.end(); ++pos)
        delete *pos;
    correlations.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::RemoveDatabaseCorrelation
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
DatabaseCorrelationList::RemoveDatabaseCorrelation(int index)
{
    AttributeGroupVector::iterator pos = correlations.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != correlations.end())
    {
        delete *pos;
        correlations.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&correlations);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetNumDatabaseCorrelations
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
DatabaseCorrelationList::GetNumDatabaseCorrelations() const
{
    return correlations.size();
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetDatabaseCorrelation
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelation &
DatabaseCorrelationList::GetDatabaseCorrelation(int i)
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetDatabaseCorrelation
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const DatabaseCorrelation &
DatabaseCorrelationList::GetDatabaseCorrelation(int i) const
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator []
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

DatabaseCorrelation &
DatabaseCorrelationList::operator [] (int i)
{
    return *((DatabaseCorrelation *)correlations[i]);
}

// ****************************************************************************
// Method: DatabaseCorrelationList::operator []
//
// Purpose: 
//   This class contains the database correlations that we know about.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const DatabaseCorrelation &
DatabaseCorrelationList::operator [] (int i) const
{
    return *((DatabaseCorrelation *)correlations[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
DatabaseCorrelationList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Database correlations";
        case 1:  return "Need permission to create a correlation";
        case 2:  return "The correlation method used by default.";
        case 3:  return "When VisIt should correlate databases";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DatabaseCorrelationList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_int;
        case 3:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
DatabaseCorrelationList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        case 1:  return "bool";
        case 2:  return "int";
        case 3:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DatabaseCorrelationList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Mar 25 16:47:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const DatabaseCorrelationList &obj = *((const DatabaseCorrelationList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool correlations_equal = (obj.correlations.size() == correlations.size());
        for(i = 0; (i < correlations.size()) && correlations_equal; ++i)
        {
            // Make references to DatabaseCorrelation from AttributeGroup *.
            const DatabaseCorrelation &correlations1 = *((const DatabaseCorrelation *)(correlations[i]));
            const DatabaseCorrelation &correlations2 = *((const DatabaseCorrelation *)(obj.correlations[i]));
            correlations_equal = (correlations1 == correlations2);
        }

        retval = correlations_equal;
        }
        break;
    case 1:
        {  // new scope
        retval = (needPermission == obj.needPermission);
        }
        break;
    case 2:
        {  // new scope
        retval = (defaultCorrelationMethod == obj.defaultCorrelationMethod);
        }
        break;
    case 3:
        {  // new scope
        retval = (whenToCorrelate == obj.whenToCorrelate);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

DatabaseCorrelation *
DatabaseCorrelationList::FindCorrelation(const std::string &name) const
{
    DatabaseCorrelation *retval = 0;

    for(int i = 0; i < correlations.size(); ++i)
    {
        DatabaseCorrelation *c = (DatabaseCorrelation *)correlations[i];
        if(name == c->GetName())
        {
            retval = c;
            break;
        } 
    }

    return retval;
}

ostream &
operator << (ostream &os, const DatabaseCorrelationList &cL)
{
   os << "{";
   for(int i = 0; i < cL.GetNumDatabaseCorrelations(); ++i)
   {
      os << cL[i] << ", " << endl;
   }
   os << "}";    
   return os;
}

// ****************************************************************************
// Method: DatabaseCorrelationList::RemoveCorrelation
//
// Purpose: 
//   Removes the named correlation from the list.
//
// Arguments:
//   name : The name of the correlation to remove.
//
// Programmer: Brad Whitlock
// Creation:   Sun Jan 25 02:29:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
DatabaseCorrelationList::RemoveCorrelation(const std::string &name)
{
    int delIndex = -1;
    for(int i = 0; i < GetNumDatabaseCorrelations(); ++i)
    {
       const DatabaseCorrelation &c = GetDatabaseCorrelation(i);
       if(c.GetName() == name)
       {
           delIndex = i;
           break;
       }
    }

    if(delIndex >= 0)
       RemoveDatabaseCorrelation(delIndex);

    return (delIndex>=0);
}

