#ifndef COLORATTRIBUTELIST_H
#define COLORATTRIBUTELIST_H
#include <state_exports.h>
#include <AttributeSubject.h>
class ColorAttribute;

// ****************************************************************************
// Class: ColorAttributeList
//
// Purpose:
//    This class contains a list of ColorAttributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API ColorAttributeList : public AttributeSubject
{
public:
    ColorAttributeList();
    ColorAttributeList(const ColorAttributeList &obj);
    virtual ~ColorAttributeList();

    virtual void operator = (const ColorAttributeList &obj);
    virtual bool operator == (const ColorAttributeList &obj) const;
    virtual bool operator != (const ColorAttributeList &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColors();

    // Property setting methods
    void SetColors(const AttributeGroupVector &colors_);

    // Property getting methods
    const AttributeGroupVector &GetColors() const;
          AttributeGroupVector &GetColors();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddColorAttribute(const ColorAttribute &);
    void ClearColorAttributes();
    void RemoveColorAttribute(int i);
    int  GetNumColorAttributes() const;
    ColorAttribute &GetColorAttribute(int i);
    const ColorAttribute &GetColorAttribute(int i) const;

    ColorAttribute &operator [] (int i);
    const ColorAttribute &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector colors;
};

#endif
