#include <ColorAttributeList.h>
#include <DataNode.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Method: ColorAttributeList::ColorAttributeList
//
// Purpose: 
//   Constructor for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ColorAttributeList::ColorAttributeList() : AttributeSubject("a*")
{
}

// ****************************************************************************
// Method: ColorAttributeList::ColorAttributeList
//
// Purpose: 
//   Copy constructor for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ColorAttributeList::ColorAttributeList(const ColorAttributeList &obj) : AttributeSubject("a*")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the colors field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = colors.begin(); pos != colors.end(); ++pos)
        delete *pos;
    colors.clear();
    if(obj.colors.size() > 0)
        colors.reserve(obj.colors.size());
    // Duplicate the colors from obj.
    for(pos = obj.colors.begin(); pos != obj.colors.end(); ++pos)
    {
        ColorAttribute *oldColorAttribute = (ColorAttribute *)(*pos);
        ColorAttribute *newColorAttribute = new ColorAttribute(*oldColorAttribute);
        colors.push_back(newColorAttribute);
    }


    SelectAll();
}

// ****************************************************************************
// Method: ColorAttributeList::~ColorAttributeList
//
// Purpose: 
//   Destructor for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ColorAttributeList::~ColorAttributeList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the colors field.
    for(pos = colors.begin(); pos != colors.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: ColorAttributeList::operator = 
//
// Purpose: 
//   Assignment operator for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::operator = (const ColorAttributeList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the colors field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = colors.begin(); pos != colors.end(); ++pos)
        delete *pos;
    colors.clear();
    if(obj.colors.size() > 0)
        colors.reserve(obj.colors.size());
    // Duplicate the colors from obj.
    for(pos = obj.colors.begin(); pos != obj.colors.end(); ++pos)
    {
        ColorAttribute *oldColorAttribute = (ColorAttribute *)(*pos);
        ColorAttribute *newColorAttribute = new ColorAttribute(*oldColorAttribute);
        colors.push_back(newColorAttribute);
    }


    SelectAll();
}

// ****************************************************************************
// Method: ColorAttributeList::operator == 
//
// Purpose: 
//   Comparison operator == for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttributeList::operator == (const ColorAttributeList &obj) const
{
    int i;

    bool colors_equal = (obj.colors.size() == colors.size());
    for(i = 0; (i < colors.size()) && colors_equal; ++i)
    {
        // Make references to ColorAttribute from AttributeGroup *.
        const ColorAttribute &colors1 = *((const ColorAttribute *)(colors[i]));
        const ColorAttribute &colors2 = *((const ColorAttribute *)(obj.colors[i]));
        colors_equal = (colors1 == colors2);
    }

    // Create the return value
    return (colors_equal);
}

// ****************************************************************************
// Method: ColorAttributeList::operator != 
//
// Purpose: 
//   Comparison operator != for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttributeList::operator != (const ColorAttributeList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ColorAttributeList::TypeName
//
// Purpose: 
//   Type name method for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
ColorAttributeList::TypeName() const
{
    return "ColorAttributeList";
}

// ****************************************************************************
// Method: ColorAttributeList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttributeList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ColorAttributeList *tmp = (const ColorAttributeList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ColorAttributeList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ColorAttributeList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ColorAttributeList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ColorAttributeList::NewInstance
//
// Purpose: 
//   NewInstance method for the ColorAttributeList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ColorAttributeList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ColorAttributeList(*this);
    else
        retval = new ColorAttributeList;

    return retval;
}

// ****************************************************************************
// Method: ColorAttributeList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::SelectAll()
{
    Select(0, (void *)&colors);
}

// ****************************************************************************
// Method: ColorAttributeList::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
ColorAttributeList::CreateSubAttributeGroup(int)
{
    return new ColorAttribute;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttributeList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttributeList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ColorAttributeList defaultObject;
    bool addToParent = false;
    // Create a node for ColorAttributeList.
    DataNode *node = new DataNode("ColorAttributeList");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < colors.size(); ++i)
            colors[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ColorAttributeList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ColorAttributeList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    // Clear all the ColorAttributes.
    ClearColorAttributes();

    // Go through all of the children and construct a new
    // ColorAttribute for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("ColorAttribute"))
        {
            ColorAttribute temp;
            temp.SetFromNode(children[i]);
            AddColorAttribute(temp);
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
ColorAttributeList::GetColors() const
{
    return colors;
}

AttributeGroupVector &
ColorAttributeList::GetColors()
{
    return colors;
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttributeList::AddColorAttribute
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::AddColorAttribute(const ColorAttribute &obj)
{
    ColorAttribute *newColorAttribute = new ColorAttribute(obj);
    colors.push_back(newColorAttribute);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&colors);
}

// ****************************************************************************
// Method: ColorAttributeList::ClearColorAttributes
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::ClearColorAttributes()
{
    AttributeGroupVector::iterator pos;

    for(pos = colors.begin(); pos != colors.end(); ++pos)
        delete *pos;
    colors.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&colors);
}

// ****************************************************************************
// Method: ColorAttributeList::RemoveColorAttribute
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttributeList::RemoveColorAttribute(int index)
{
    AttributeGroupVector::iterator pos = colors.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != colors.end())
    {
        delete *pos;
        colors.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&colors);
}

// ****************************************************************************
// Method: ColorAttributeList::GetNumColorAttributes
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
ColorAttributeList::GetNumColorAttributes() const
{
    return colors.size();
}

// ****************************************************************************
// Method: ColorAttributeList::GetColorAttribute
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute &
ColorAttributeList::GetColorAttribute(int i)
{
    return *((ColorAttribute *)colors[i]);
}

// ****************************************************************************
// Method: ColorAttributeList::GetColorAttribute
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const ColorAttribute &
ColorAttributeList::GetColorAttribute(int i) const
{
    return *((ColorAttribute *)colors[i]);
}

// ****************************************************************************
// Method: ColorAttributeList::operator []
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute &
ColorAttributeList::operator [] (int i)
{
    return *((ColorAttribute *)colors[i]);
}

// ****************************************************************************
// Method: ColorAttributeList::operator []
//
// Purpose: 
//   This class contains a list of ColorAttributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const ColorAttribute &
ColorAttributeList::operator [] (int i) const
{
    return *((ColorAttribute *)colors[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttributeList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ColorAttributeList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "colors";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ColorAttributeList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ColorAttributeList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ColorAttributeList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
ColorAttributeList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ColorAttributeList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:24:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttributeList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ColorAttributeList &obj = *((const ColorAttributeList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool colors_equal = (obj.colors.size() == colors.size());
        for(i = 0; (i < colors.size()) && colors_equal; ++i)
        {
            // Make references to ColorAttribute from AttributeGroup *.
            const ColorAttribute &colors1 = *((const ColorAttribute *)(colors[i]));
            const ColorAttribute &colors2 = *((const ColorAttribute *)(obj.colors[i]));
            colors_equal = (colors1 == colors2);
        }

        retval = colors_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

