#include <ColorAttribute.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ColorAttribute::ColorAttribute
//
// Purpose: 
//   Constructor for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute::ColorAttribute() : AttributeSubject("U")
{
    color[0] = 0;
    color[1] = 0;
    color[2] = 0;
    color[3] = 255;
}

// ****************************************************************************
// Method: ColorAttribute::ColorAttribute
//
// Purpose: 
//   Copy constructor for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute::ColorAttribute(const ColorAttribute &obj) : AttributeSubject("U")
{
    int i;

    for(i = 0; i < 4; ++i)
        color[i] = obj.color[i];


    SelectAll();
}

// ****************************************************************************
// Method: ColorAttribute::~ColorAttribute
//
// Purpose: 
//   Destructor for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute::~ColorAttribute()
{
    // nothing here
}

// ****************************************************************************
// Method: ColorAttribute::operator = 
//
// Purpose: 
//   Assignment operator for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttribute::operator = (const ColorAttribute &obj)
{
    int i;

    for(i = 0; i < 4; ++i)
        color[i] = obj.color[i];


    SelectAll();
}

// ****************************************************************************
// Method: ColorAttribute::operator == 
//
// Purpose: 
//   Comparison operator == for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttribute::operator == (const ColorAttribute &obj) const
{
    int i;

    // Compare the color arrays.
    bool color_equal = true;
    for(i = 0; i < 4 && color_equal; ++i)
        color_equal = (color[i] == obj.color[i]);

    // Create the return value
    return (color_equal);
}

// ****************************************************************************
// Method: ColorAttribute::operator != 
//
// Purpose: 
//   Comparison operator != for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttribute::operator != (const ColorAttribute &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ColorAttribute::TypeName
//
// Purpose: 
//   Type name method for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
ColorAttribute::TypeName() const
{
    return "ColorAttribute";
}

// ****************************************************************************
// Method: ColorAttribute::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttribute::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ColorAttribute *tmp = (const ColorAttribute *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ColorAttribute::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ColorAttribute::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ColorAttribute(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ColorAttribute::NewInstance
//
// Purpose: 
//   NewInstance method for the ColorAttribute class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ColorAttribute::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ColorAttribute(*this);
    else
        retval = new ColorAttribute;

    return retval;
}

// ****************************************************************************
// Method: ColorAttribute::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttribute::SelectAll()
{
    Select(0, (void *)color, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttribute::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Jul 23 11:29:38 PDT 2003
//
// Modifications:
//   Brad Whitlock, Fri Oct 3 10:13:43 PDT 2003
//   I made it always save to the parentNode.
//
//   Brad Whitlock, Wed Dec 17 12:09:19 PDT 2003
//   I changed the method prototype.
//
// ****************************************************************************

bool
ColorAttribute::CreateNode(DataNode *parentNode, bool, bool)
{
    if(parentNode == 0)
        return false;

    // Create a node for ColorAttribute.
    DataNode *node = new DataNode("ColorAttribute");
    node->AddNode(new DataNode("color", color, 4));
    parentNode->AddNode(node);

    return true;
}
// ****************************************************************************
// Method: ColorAttribute::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
ColorAttribute::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ColorAttribute");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("color")) != 0)
        SetColor(node->AsUnsignedCharArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ColorAttribute::SetColor(const unsigned char *color_)
{
    color[0] = color_[0];
    color[1] = color_[1];
    color[2] = color_[2];
    color[3] = color_[3];
    Select(0, (void *)color, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const unsigned char *
ColorAttribute::GetColor() const
{
    return color;
}

unsigned char *
ColorAttribute::GetColor()
{
    return color;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttribute::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ColorAttribute::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "color";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ColorAttribute::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ColorAttribute::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_ucharArray;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ColorAttribute::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ColorAttribute::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "ucharArray";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ColorAttribute::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu May 27 08:09:05 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ColorAttribute::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ColorAttribute &obj = *((const ColorAttribute*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        // Compare the color arrays.
        bool color_equal = true;
        for(i = 0; i < 4 && color_equal; ++i)
            color_equal = (color[i] == obj.color[i]);

        retval = color_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ColorAttribute::ColorAttribute
//
// Purpose: 
//   Constructor for the ColorAttribute class.
//
// Note:       Autogenerated by classwriter.
//
// Programmer: classwriter
// Creation:   Fri Feb 23 13:08:21 PST 2001
//
// Modifications:
//   
// ****************************************************************************

ColorAttribute::ColorAttribute(int red, int green, int blue, int alpha) :
    AttributeSubject("U")
{
    color[0] = (unsigned char)(red & 255);
    color[1] = (unsigned char)(green & 255);
    color[2] = (unsigned char)(blue & 255);
    color[3] = (unsigned char)(alpha & 255);
}

void
ColorAttribute::SetRgb(int red, int green, int blue)
{
    color[0] = (unsigned char)red;
    color[1] = (unsigned char)green;
    color[2] = (unsigned char)blue;
}

void
ColorAttribute::SetRgba(int red, int green, int blue, int alpha)
{
    color[0] = (unsigned char)red;
    color[1] = (unsigned char)green;
    color[2] = (unsigned char)blue;
    color[3] = (unsigned char)alpha;
}

void
ColorAttribute::GetRgba(double c[4]) const
{
    c[0] = double(color[0]) / 255.;
    c[1] = double(color[1]) / 255.;
    c[2] = double(color[2]) / 255.;
    c[3] = double(color[3]) / 255.;
}

void
ColorAttribute::SetRed(int red)
{
    color[0] = (unsigned char)(red & 255);
}

void
ColorAttribute::SetGreen(int green)
{
    color[1] = (unsigned char)(green & 255);
}

void
ColorAttribute::SetBlue(int blue)
{
    color[2] = (unsigned char)(blue & 255);
}

void
ColorAttribute::SetAlpha(int alpha)
{
    color[3] = (unsigned char)(alpha & 255);
}

int
ColorAttribute::Red() const
{
    return (int)color[0];
}

int
ColorAttribute::Green() const
{
    return (int)color[1];
}

int
ColorAttribute::Blue() const
{
    return (int)color[2];
}

int
ColorAttribute::Alpha() const
{
    return (int)color[3];
}

void ColorAttribute::SetRgba2(double c[4])
{
    color[0] = (unsigned char) (c[0] * 255.);
    color[1] = (unsigned char) (c[1] * 255.);
    color[2] = (unsigned char) (c[2] * 255.);
    color[3] = (unsigned char) (c[3] * 255.);
}

