#ifndef APPEARANCEATTRIBUTES_H
#define APPEARANCEATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: AppearanceAttributes
//
// Purpose:
//    This class contains the GUI/viewer appearance attributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:57 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class STATE_API AppearanceAttributes : public AttributeSubject
{
public:
    AppearanceAttributes();
    AppearanceAttributes(const AppearanceAttributes &obj);
    virtual ~AppearanceAttributes();

    virtual void operator = (const AppearanceAttributes &obj);
    virtual bool operator == (const AppearanceAttributes &obj) const;
    virtual bool operator != (const AppearanceAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectBackground();
    void SelectForeground();
    void SelectFontDescription();
    void SelectStyle();

    // Property setting methods
    void SetBackground(const std::string &background_);
    void SetForeground(const std::string &foreground_);
    void SetFontDescription(const std::string &fontDescription_);
    void SetStyle(const std::string &style_);
    void SetOrientation(int orientation_);

    // Property getting methods
    const std::string &GetBackground() const;
          std::string &GetBackground();
    const std::string &GetForeground() const;
          std::string &GetForeground();
    const std::string &GetFontDescription() const;
          std::string &GetFontDescription();
    const std::string &GetStyle() const;
          std::string &GetStyle();
    int               GetOrientation() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void InitializeStyle();
private:
    std::string background;
    std::string foreground;
    std::string fontDescription;
    std::string style;
    int         orientation;
};

#endif
