#include <AnnotationObjectList.h>
#include <DataNode.h>
#include <AnnotationObject.h>

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Constructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList() : AttributeSubject("a*")
{
}

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Copy constructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList(const AnnotationObjectList &obj) : AttributeSubject("a*")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the annotation field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
    annotation.clear();
    if(obj.annotation.size() > 0)
        annotation.reserve(obj.annotation.size());
    // Duplicate the annotation from obj.
    for(pos = obj.annotation.begin(); pos != obj.annotation.end(); ++pos)
    {
        AnnotationObject *oldAnnotationObject = (AnnotationObject *)(*pos);
        AnnotationObject *newAnnotationObject = new AnnotationObject(*oldAnnotationObject);
        annotation.push_back(newAnnotationObject);
    }


    SelectAll();
}

// ****************************************************************************
// Method: AnnotationObjectList::~AnnotationObjectList
//
// Purpose: 
//   Destructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::~AnnotationObjectList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the annotation field.
    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: AnnotationObjectList::operator = 
//
// Purpose: 
//   Assignment operator for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::operator = (const AnnotationObjectList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the annotation field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
    annotation.clear();
    if(obj.annotation.size() > 0)
        annotation.reserve(obj.annotation.size());
    // Duplicate the annotation from obj.
    for(pos = obj.annotation.begin(); pos != obj.annotation.end(); ++pos)
    {
        AnnotationObject *oldAnnotationObject = (AnnotationObject *)(*pos);
        AnnotationObject *newAnnotationObject = new AnnotationObject(*oldAnnotationObject);
        annotation.push_back(newAnnotationObject);
    }


    SelectAll();
}

// ****************************************************************************
// Method: AnnotationObjectList::operator == 
//
// Purpose: 
//   Comparison operator == for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::operator == (const AnnotationObjectList &obj) const
{
    int i;

    bool annotation_equal = (obj.annotation.size() == annotation.size());
    for(i = 0; (i < annotation.size()) && annotation_equal; ++i)
    {
        // Make references to AnnotationObject from AttributeGroup *.
        const AnnotationObject &annotation1 = *((const AnnotationObject *)(annotation[i]));
        const AnnotationObject &annotation2 = *((const AnnotationObject *)(obj.annotation[i]));
        annotation_equal = (annotation1 == annotation2);
    }

    // Create the return value
    return (annotation_equal);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator != 
//
// Purpose: 
//   Comparison operator != for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::operator != (const AnnotationObjectList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnnotationObjectList::TypeName
//
// Purpose: 
//   Type name method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnnotationObjectList::TypeName() const
{
    return "AnnotationObjectList";
}

// ****************************************************************************
// Method: AnnotationObjectList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnnotationObjectList *tmp = (const AnnotationObjectList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnnotationObjectList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObjectList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnnotationObjectList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnnotationObjectList::NewInstance
//
// Purpose: 
//   NewInstance method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObjectList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnnotationObjectList(*this);
    else
        retval = new AnnotationObjectList;

    return retval;
}

// ****************************************************************************
// Method: AnnotationObjectList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::SelectAll()
{
    Select(0, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::CreateSubAttributeGroup
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
AnnotationObjectList::CreateSubAttributeGroup(int)
{
    return new AnnotationObject;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnnotationObjectList defaultObject;
    bool addToParent = false;
    // Create a node for AnnotationObjectList.
    DataNode *node = new DataNode("AnnotationObjectList");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        for(int i = 0; i < annotation.size(); ++i)
            annotation[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnnotationObjectList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationObjectList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    // Clear all the AnnotationObjects.
    ClearAnnotationObjects();

    // Go through all of the children and construct a new
    // AnnotationObject for each one of them.
    children = searchNode->GetChildren();
    for(i = 0; i < searchNode->GetNumChildren(); ++i)
    {
        if(children[i]->GetKey() == std::string("AnnotationObject"))
        {
            AnnotationObject temp;
            temp.SetFromNode(children[i]);
            AddAnnotationObject(temp);
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
AnnotationObjectList::GetAnnotation() const
{
    return annotation;
}

AttributeGroupVector &
AnnotationObjectList::GetAnnotation()
{
    return annotation;
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::AddAnnotationObject
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::AddAnnotationObject(const AnnotationObject &obj)
{
    AnnotationObject *newAnnotationObject = new AnnotationObject(obj);
    annotation.push_back(newAnnotationObject);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::ClearAnnotationObjects
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::ClearAnnotationObjects()
{
    AttributeGroupVector::iterator pos;

    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
    annotation.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::RemoveAnnotationObject
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::RemoveAnnotationObject(int index)
{
    AttributeGroupVector::iterator pos = annotation.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != annotation.end())
    {
        delete *pos;
        annotation.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::GetNumAnnotationObjects
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
AnnotationObjectList::GetNumAnnotationObjects() const
{
    return annotation.size();
}

// ****************************************************************************
// Method: AnnotationObjectList::GetAnnotationObject
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject &
AnnotationObjectList::GetAnnotationObject(int i)
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::GetAnnotationObject
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const AnnotationObject &
AnnotationObjectList::GetAnnotationObject(int i) const
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator []
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject &
AnnotationObjectList::operator [] (int i)
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator []
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const AnnotationObject &
AnnotationObjectList::operator [] (int i) const
{
    return *((AnnotationObject *)annotation[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObjectList::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Annotation";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnnotationObjectList::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObjectList::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:23:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const AnnotationObjectList &obj = *((const AnnotationObjectList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool annotation_equal = (obj.annotation.size() == annotation.size());
        for(i = 0; (i < annotation.size()) && annotation_equal; ++i)
        {
            // Make references to AnnotationObject from AttributeGroup *.
            const AnnotationObject &annotation1 = *((const AnnotationObject *)(annotation[i]));
            const AnnotationObject &annotation2 = *((const AnnotationObject *)(obj.annotation[i]));
            annotation_equal = (annotation1 == annotation2);
        }

        retval = annotation_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

