#include <AnnotationObject.h>
#include <DataNode.h>

//
// Enum conversion methods for AnnotationObject::AnnotationType
//

static const char *AnnotationType_strings[] = {
"Text2D", "Text3D", "TimeSlider", 
"Arrow2D", "Arrow3D", "Box", 
"Image"};

std::string
AnnotationObject::AnnotationType_ToString(AnnotationObject::AnnotationType t)
{
    int index = int(t);
    if(index < 0 || index >= 7) index = 0;
    return AnnotationType_strings[index];
}

std::string
AnnotationObject::AnnotationType_ToString(int t)
{
    int index = (t < 0 || t >= 7) ? 0 : t;
    return AnnotationType_strings[index];
}

bool
AnnotationObject::AnnotationType_FromString(const std::string &s, AnnotationObject::AnnotationType &val)
{
    val = AnnotationObject::Text2D;
    for(int i = 0; i < 7; ++i)
    {
        if(s == AnnotationType_strings[i])
        {
            val = (AnnotationType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationObject::FontFamily
//

static const char *FontFamily_strings[] = {
"Arial", "Courier", "Times"
};

std::string
AnnotationObject::FontFamily_ToString(AnnotationObject::FontFamily t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return FontFamily_strings[index];
}

std::string
AnnotationObject::FontFamily_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return FontFamily_strings[index];
}

bool
AnnotationObject::FontFamily_FromString(const std::string &s, AnnotationObject::FontFamily &val)
{
    val = AnnotationObject::Arial;
    for(int i = 0; i < 3; ++i)
    {
        if(s == FontFamily_strings[i])
        {
            val = (FontFamily)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose: 
//   Constructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject::AnnotationObject() : AttributeSubject("ibbFFabaas*ibbbfis"),
    textColor(), color1(), 
    color2()
{
    objectType = Text2D;
    visible = false;
    active = false;
    position[0] = 0;
    position[1] = 0;
    position[2] = 0;
    position2[0] = 0;
    position2[1] = 0;
    position2[2] = 0;
    useForegroundForTextColor = true;
    fontFamily = Arial;
    fontBold = false;
    fontItalic = false;
    fontShadow = false;
    floatAttribute1 = 0;
    intAttribute1 = 0;
    timeFormat = "%g";
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose: 
//   Copy constructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject::AnnotationObject(const AnnotationObject &obj) : AttributeSubject("ibbFFabaas*ibbbfis")
{
    objectType = obj.objectType;
    visible = obj.visible;
    active = obj.active;
    position[0] = obj.position[0];
    position[1] = obj.position[1];
    position[2] = obj.position[2];

    position2[0] = obj.position2[0];
    position2[1] = obj.position2[1];
    position2[2] = obj.position2[2];

    textColor = obj.textColor;
    useForegroundForTextColor = obj.useForegroundForTextColor;
    color1 = obj.color1;
    color2 = obj.color2;
    text = obj.text;
    fontFamily = obj.fontFamily;
    fontBold = obj.fontBold;
    fontItalic = obj.fontItalic;
    fontShadow = obj.fontShadow;
    floatAttribute1 = obj.floatAttribute1;
    intAttribute1 = obj.intAttribute1;
    timeFormat = obj.timeFormat;

    SelectAll();
}

// ****************************************************************************
// Method: AnnotationObject::~AnnotationObject
//
// Purpose: 
//   Destructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject::~AnnotationObject()
{
    // nothing here
}

// ****************************************************************************
// Method: AnnotationObject::operator = 
//
// Purpose: 
//   Assignment operator for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject& 
AnnotationObject::operator = (const AnnotationObject &obj)
{
    if (this == &obj) return *this;
    objectType = obj.objectType;
    visible = obj.visible;
    active = obj.active;
    position[0] = obj.position[0];
    position[1] = obj.position[1];
    position[2] = obj.position[2];

    position2[0] = obj.position2[0];
    position2[1] = obj.position2[1];
    position2[2] = obj.position2[2];

    textColor = obj.textColor;
    useForegroundForTextColor = obj.useForegroundForTextColor;
    color1 = obj.color1;
    color2 = obj.color2;
    text = obj.text;
    fontFamily = obj.fontFamily;
    fontBold = obj.fontBold;
    fontItalic = obj.fontItalic;
    fontShadow = obj.fontShadow;
    floatAttribute1 = obj.floatAttribute1;
    intAttribute1 = obj.intAttribute1;
    timeFormat = obj.timeFormat;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AnnotationObject::operator == 
//
// Purpose: 
//   Comparison operator == for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObject::operator == (const AnnotationObject &obj) const
{
    int i;

    // Compare the position arrays.
    bool position_equal = true;
    for(i = 0; i < 3 && position_equal; ++i)
        position_equal = (position[i] == obj.position[i]);

    // Compare the position2 arrays.
    bool position2_equal = true;
    for(i = 0; i < 3 && position2_equal; ++i)
        position2_equal = (position2[i] == obj.position2[i]);

    // Create the return value
    return ((objectType == obj.objectType) &&
            (visible == obj.visible) &&
            (active == obj.active) &&
            position_equal &&
            position2_equal &&
            (textColor == obj.textColor) &&
            (useForegroundForTextColor == obj.useForegroundForTextColor) &&
            (color1 == obj.color1) &&
            (color2 == obj.color2) &&
            (text == obj.text) &&
            (fontFamily == obj.fontFamily) &&
            (fontBold == obj.fontBold) &&
            (fontItalic == obj.fontItalic) &&
            (fontShadow == obj.fontShadow) &&
            (floatAttribute1 == obj.floatAttribute1) &&
            (intAttribute1 == obj.intAttribute1) &&
            (timeFormat == obj.timeFormat));
}

// ****************************************************************************
// Method: AnnotationObject::operator != 
//
// Purpose: 
//   Comparison operator != for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObject::operator != (const AnnotationObject &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnnotationObject::TypeName
//
// Purpose: 
//   Type name method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnnotationObject::TypeName() const
{
    return "AnnotationObject";
}

// ****************************************************************************
// Method: AnnotationObject::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObject::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnnotationObject *tmp = (const AnnotationObject *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnnotationObject::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObject::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnnotationObject(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnnotationObject::NewInstance
//
// Purpose: 
//   NewInstance method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObject::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnnotationObject(*this);
    else
        retval = new AnnotationObject;

    return retval;
}

// ****************************************************************************
// Method: AnnotationObject::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObject::SelectAll()
{
    Select(0, (void *)&objectType);
    Select(1, (void *)&visible);
    Select(2, (void *)&active);
    Select(3, (void *)position, 3);
    Select(4, (void *)position2, 3);
    Select(5, (void *)&textColor);
    Select(6, (void *)&useForegroundForTextColor);
    Select(7, (void *)&color1);
    Select(8, (void *)&color2);
    Select(9, (void *)&text);
    Select(10, (void *)&fontFamily);
    Select(11, (void *)&fontBold);
    Select(12, (void *)&fontItalic);
    Select(13, (void *)&fontShadow);
    Select(14, (void *)&floatAttribute1);
    Select(15, (void *)&intAttribute1);
    Select(16, (void *)&timeFormat);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObject::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObject::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnnotationObject defaultObject;
    bool addToParent = false;
    // Create a node for AnnotationObject.
    DataNode *node = new DataNode("AnnotationObject");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("objectType", AnnotationType_ToString(objectType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("active", active));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("position", position, 3));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("position2", position2, 3));
    }

        DataNode *textColorNode = new DataNode("textColor");
        if(textColor.CreateNode(textColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(textColorNode);
        }
        else
            delete textColorNode;
    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useForegroundForTextColor", useForegroundForTextColor));
    }

        DataNode *color1Node = new DataNode("color1");
        if(color1.CreateNode(color1Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(color1Node);
        }
        else
            delete color1Node;
        DataNode *color2Node = new DataNode("color2");
        if(color2.CreateNode(color2Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(color2Node);
        }
        else
            delete color2Node;
    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("text", text));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontFamily", FontFamily_ToString(fontFamily)));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontBold", fontBold));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontItalic", fontItalic));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontShadow", fontShadow));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("floatAttribute1", floatAttribute1));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("intAttribute1", intAttribute1));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeFormat", timeFormat));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnnotationObject::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObject::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationObject");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("objectType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 7)
                SetObjectType(AnnotationType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            AnnotationType value;
            if(AnnotationType_FromString(node->AsString(), value))
                SetObjectType(value);
        }
    }
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("active")) != 0)
        SetActive(node->AsBool());
    if((node = searchNode->GetNode("position")) != 0)
        SetPosition(node->AsFloatArray());
    if((node = searchNode->GetNode("position2")) != 0)
        SetPosition2(node->AsFloatArray());
    if((node = searchNode->GetNode("textColor")) != 0)
        textColor.SetFromNode(node);
    if((node = searchNode->GetNode("useForegroundForTextColor")) != 0)
        SetUseForegroundForTextColor(node->AsBool());
    if((node = searchNode->GetNode("color1")) != 0)
        color1.SetFromNode(node);
    if((node = searchNode->GetNode("color2")) != 0)
        color2.SetFromNode(node);
    if((node = searchNode->GetNode("text")) != 0)
        SetText(node->AsStringVector());
    if((node = searchNode->GetNode("fontFamily")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetFontFamily(FontFamily(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            FontFamily value;
            if(FontFamily_FromString(node->AsString(), value))
                SetFontFamily(value);
        }
    }
    if((node = searchNode->GetNode("fontBold")) != 0)
        SetFontBold(node->AsBool());
    if((node = searchNode->GetNode("fontItalic")) != 0)
        SetFontItalic(node->AsBool());
    if((node = searchNode->GetNode("fontShadow")) != 0)
        SetFontShadow(node->AsBool());
    if((node = searchNode->GetNode("floatAttribute1")) != 0)
        SetFloatAttribute1(node->AsFloat());
    if((node = searchNode->GetNode("intAttribute1")) != 0)
        SetIntAttribute1(node->AsInt());
    if((node = searchNode->GetNode("timeFormat")) != 0)
        SetTimeFormat(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationObject::SetObjectType(AnnotationObject::AnnotationType objectType_)
{
    objectType = objectType_;
    Select(0, (void *)&objectType);
}

void
AnnotationObject::SetVisible(bool visible_)
{
    visible = visible_;
    Select(1, (void *)&visible);
}

void
AnnotationObject::SetActive(bool active_)
{
    active = active_;
    Select(2, (void *)&active);
}

void
AnnotationObject::SetPosition(const float *position_)
{
    position[0] = position_[0];
    position[1] = position_[1];
    position[2] = position_[2];
    Select(3, (void *)position, 3);
}

void
AnnotationObject::SetPosition2(const float *position2_)
{
    position2[0] = position2_[0];
    position2[1] = position2_[1];
    position2[2] = position2_[2];
    Select(4, (void *)position2, 3);
}

void
AnnotationObject::SetTextColor(const ColorAttribute &textColor_)
{
    textColor = textColor_;
    Select(5, (void *)&textColor);
}

void
AnnotationObject::SetUseForegroundForTextColor(bool useForegroundForTextColor_)
{
    useForegroundForTextColor = useForegroundForTextColor_;
    Select(6, (void *)&useForegroundForTextColor);
}

void
AnnotationObject::SetColor1(const ColorAttribute &color1_)
{
    color1 = color1_;
    Select(7, (void *)&color1);
}

void
AnnotationObject::SetColor2(const ColorAttribute &color2_)
{
    color2 = color2_;
    Select(8, (void *)&color2);
}

void
AnnotationObject::SetText(const stringVector &text_)
{
    text = text_;
    Select(9, (void *)&text);
}

void
AnnotationObject::SetFontFamily(AnnotationObject::FontFamily fontFamily_)
{
    fontFamily = fontFamily_;
    Select(10, (void *)&fontFamily);
}

void
AnnotationObject::SetFontBold(bool fontBold_)
{
    fontBold = fontBold_;
    Select(11, (void *)&fontBold);
}

void
AnnotationObject::SetFontItalic(bool fontItalic_)
{
    fontItalic = fontItalic_;
    Select(12, (void *)&fontItalic);
}

void
AnnotationObject::SetFontShadow(bool fontShadow_)
{
    fontShadow = fontShadow_;
    Select(13, (void *)&fontShadow);
}

void
AnnotationObject::SetFloatAttribute1(float floatAttribute1_)
{
    floatAttribute1 = floatAttribute1_;
    Select(14, (void *)&floatAttribute1);
}

void
AnnotationObject::SetIntAttribute1(int intAttribute1_)
{
    intAttribute1 = intAttribute1_;
    Select(15, (void *)&intAttribute1);
}

void
AnnotationObject::SetTimeFormat(const std::string &timeFormat_)
{
    timeFormat = timeFormat_;
    Select(16, (void *)&timeFormat);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

AnnotationObject::AnnotationType
AnnotationObject::GetObjectType() const
{
    return AnnotationType(objectType);
}

bool
AnnotationObject::GetVisible() const
{
    return visible;
}

bool
AnnotationObject::GetActive() const
{
    return active;
}

const float *
AnnotationObject::GetPosition() const
{
    return position;
}

float *
AnnotationObject::GetPosition()
{
    return position;
}

const float *
AnnotationObject::GetPosition2() const
{
    return position2;
}

float *
AnnotationObject::GetPosition2()
{
    return position2;
}

const ColorAttribute &
AnnotationObject::GetTextColor() const
{
    return textColor;
}

ColorAttribute &
AnnotationObject::GetTextColor()
{
    return textColor;
}

bool
AnnotationObject::GetUseForegroundForTextColor() const
{
    return useForegroundForTextColor;
}

const ColorAttribute &
AnnotationObject::GetColor1() const
{
    return color1;
}

ColorAttribute &
AnnotationObject::GetColor1()
{
    return color1;
}

const ColorAttribute &
AnnotationObject::GetColor2() const
{
    return color2;
}

ColorAttribute &
AnnotationObject::GetColor2()
{
    return color2;
}

const stringVector &
AnnotationObject::GetText() const
{
    return text;
}

stringVector &
AnnotationObject::GetText()
{
    return text;
}

AnnotationObject::FontFamily
AnnotationObject::GetFontFamily() const
{
    return FontFamily(fontFamily);
}

bool
AnnotationObject::GetFontBold() const
{
    return fontBold;
}

bool
AnnotationObject::GetFontItalic() const
{
    return fontItalic;
}

bool
AnnotationObject::GetFontShadow() const
{
    return fontShadow;
}

float
AnnotationObject::GetFloatAttribute1() const
{
    return floatAttribute1;
}

int
AnnotationObject::GetIntAttribute1() const
{
    return intAttribute1;
}

const std::string &
AnnotationObject::GetTimeFormat() const
{
    return timeFormat;
}

std::string &
AnnotationObject::GetTimeFormat()
{
    return timeFormat;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationObject::SelectPosition()
{
    Select(3, (void *)position, 3);
}

void
AnnotationObject::SelectPosition2()
{
    Select(4, (void *)position2, 3);
}

void
AnnotationObject::SelectTextColor()
{
    Select(5, (void *)&textColor);
}

void
AnnotationObject::SelectColor1()
{
    Select(7, (void *)&color1);
}

void
AnnotationObject::SelectColor2()
{
    Select(8, (void *)&color2);
}

void
AnnotationObject::SelectText()
{
    Select(9, (void *)&text);
}

void
AnnotationObject::SelectTimeFormat()
{
    Select(16, (void *)&timeFormat);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObject::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObject::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "ObjectType";
        case 1:  return "Visible";
        case 2:  return "Active";
        case 3:  return "Position";
        case 4:  return "Position2";
        case 5:  return "Text color";
        case 6:  return "Use foreground for text color";
        case 7:  return "Color 1";
        case 8:  return "Color 2";
        case 9:  return "Text";
        case 10:  return "Font family";
        case 11:  return "Bold";
        case 12:  return "Italic";
        case 13:  return "Shadow";
        case 14:  return "Float attribute 1";
        case 15:  return "Integer attribute 1";
        case 16:  return "timeFormat";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObject::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnnotationObject::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_floatArray;
        case 4:  return FieldType_floatArray;
        case 5:  return FieldType_color;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_color;
        case 8:  return FieldType_color;
        case 9:  return FieldType_stringVector;
        case 10:  return FieldType_enum;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_bool;
        case 14:  return FieldType_float;
        case 15:  return FieldType_int;
        case 16:  return FieldType_string;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnnotationObject::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObject::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "floatArray";
        case 4:  return "floatArray";
        case 5:  return "color";
        case 6:  return "bool";
        case 7:  return "color";
        case 8:  return "color";
        case 9:  return "stringVector";
        case 10:  return "enum";
        case 11:  return "bool";
        case 12:  return "bool";
        case 13:  return "bool";
        case 14:  return "float";
        case 15:  return "int";
        case 16:  return "string";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObject::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:10:28 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObject::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const AnnotationObject &obj = *((const AnnotationObject*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (objectType == obj.objectType);
        }
        break;
    case 1:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case 2:
        {  // new scope
        retval = (active == obj.active);
        }
        break;
    case 3:
        {  // new scope
        // Compare the position arrays.
        bool position_equal = true;
        for(i = 0; i < 3 && position_equal; ++i)
            position_equal = (position[i] == obj.position[i]);

        retval = position_equal;
        }
        break;
    case 4:
        {  // new scope
        // Compare the position2 arrays.
        bool position2_equal = true;
        for(i = 0; i < 3 && position2_equal; ++i)
            position2_equal = (position2[i] == obj.position2[i]);

        retval = position2_equal;
        }
        break;
    case 5:
        {  // new scope
        retval = (textColor == obj.textColor);
        }
        break;
    case 6:
        {  // new scope
        retval = (useForegroundForTextColor == obj.useForegroundForTextColor);
        }
        break;
    case 7:
        {  // new scope
        retval = (color1 == obj.color1);
        }
        break;
    case 8:
        {  // new scope
        retval = (color2 == obj.color2);
        }
        break;
    case 9:
        {  // new scope
        retval = (text == obj.text);
        }
        break;
    case 10:
        {  // new scope
        retval = (fontFamily == obj.fontFamily);
        }
        break;
    case 11:
        {  // new scope
        retval = (fontBold == obj.fontBold);
        }
        break;
    case 12:
        {  // new scope
        retval = (fontItalic == obj.fontItalic);
        }
        break;
    case 13:
        {  // new scope
        retval = (fontShadow == obj.fontShadow);
        }
        break;
    case 14:
        {  // new scope
        retval = (floatAttribute1 == obj.floatAttribute1);
        }
        break;
    case 15:
        {  // new scope
        retval = (intAttribute1 == obj.intAttribute1);
        }
        break;
    case 16:
        {  // new scope
        retval = (timeFormat == obj.timeFormat);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

