#include <AnnotationAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for AnnotationAttributes::Ticks
//

static const char *Ticks_strings[] = {
"Off", "Bottom", "Left", 
"BottomLeft", "All"};

std::string
AnnotationAttributes::Ticks_ToString(AnnotationAttributes::Ticks t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return Ticks_strings[index];
}

std::string
AnnotationAttributes::Ticks_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return Ticks_strings[index];
}

bool
AnnotationAttributes::Ticks_FromString(const std::string &s, AnnotationAttributes::Ticks &val)
{
    val = AnnotationAttributes::Off;
    for(int i = 0; i < 5; ++i)
    {
        if(s == Ticks_strings[i])
        {
            val = (Ticks)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationAttributes::Location
//

static const char *Location_strings[] = {
"Inside", "Outside", "Both"
};

std::string
AnnotationAttributes::Location_ToString(AnnotationAttributes::Location t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Location_strings[index];
}

std::string
AnnotationAttributes::Location_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Location_strings[index];
}

bool
AnnotationAttributes::Location_FromString(const std::string &s, AnnotationAttributes::Location &val)
{
    val = AnnotationAttributes::Inside;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Location_strings[i])
        {
            val = (Location)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationAttributes::Axes
//

static const char *Axes_strings[] = {
"ClosestTriad", "FurthestTriad", "OutsideEdges", 
"StaticTriad", "StaticEdges"};

std::string
AnnotationAttributes::Axes_ToString(AnnotationAttributes::Axes t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return Axes_strings[index];
}

std::string
AnnotationAttributes::Axes_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return Axes_strings[index];
}

bool
AnnotationAttributes::Axes_FromString(const std::string &s, AnnotationAttributes::Axes &val)
{
    val = AnnotationAttributes::ClosestTriad;
    for(int i = 0; i < 5; ++i)
    {
        if(s == Axes_strings[i])
        {
            val = (Axes)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationAttributes::GradientStyle
//

static const char *GradientStyle_strings[] = {
"TopToBottom", "BottomToTop", "LeftToRight", 
"RightToLeft", "Radial"};

std::string
AnnotationAttributes::GradientStyle_ToString(AnnotationAttributes::GradientStyle t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return GradientStyle_strings[index];
}

std::string
AnnotationAttributes::GradientStyle_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return GradientStyle_strings[index];
}

bool
AnnotationAttributes::GradientStyle_FromString(const std::string &s, AnnotationAttributes::GradientStyle &val)
{
    val = AnnotationAttributes::TopToBottom;
    for(int i = 0; i < 5; ++i)
    {
        if(s == GradientStyle_strings[i])
        {
            val = (GradientStyle)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationAttributes::BackgroundMode
//

static const char *BackgroundMode_strings[] = {
"Solid", "Gradient"};

std::string
AnnotationAttributes::BackgroundMode_ToString(AnnotationAttributes::BackgroundMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return BackgroundMode_strings[index];
}

std::string
AnnotationAttributes::BackgroundMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return BackgroundMode_strings[index];
}

bool
AnnotationAttributes::BackgroundMode_FromString(const std::string &s, AnnotationAttributes::BackgroundMode &val)
{
    val = AnnotationAttributes::Solid;
    for(int i = 0; i < 2; ++i)
    {
        if(s == BackgroundMode_strings[i])
        {
            val = (BackgroundMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AnnotationAttributes::AnnotationAttributes
//
// Purpose: 
//   Constructor for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AnnotationAttributes::AnnotationAttributes() : AttributeSubject("bbbbbbbbbddddddddddddiiiiibbbbbbbbbbbbbbbddddddddddddddddddiiiiibbaaiaaibbb"),
    backgroundColor(255, 255, 255), foregroundColor(0, 0, 0), 
    gradientColor1(0, 0, 255), gradientColor2(0, 0, 0)
{
    axesFlag2D = true;
    axesAutoSetTicks2D = true;
    labelAutoSetScaling2D = true;
    xAxisLabels2D = true;
    yAxisLabels2D = true;
    xAxisTitle2D = true;
    yAxisTitle2D = true;
    xGridLines2D = false;
    yGridLines2D = false;
    xMajorTickMinimum2D = 0;
    yMajorTickMinimum2D = 0;
    xMajorTickMaximum2D = 1;
    yMajorTickMaximum2D = 1;
    xMajorTickSpacing2D = 0.2;
    yMajorTickSpacing2D = 0.2;
    xMinorTickSpacing2D = 0.02;
    yMinorTickSpacing2D = 0.02;
    xLabelFontHeight2D = 0.02;
    yLabelFontHeight2D = 0.02;
    xTitleFontHeight2D = 0.02;
    yTitleFontHeight2D = 0.02;
    xLabelScaling2D = 0;
    yLabelScaling2D = 0;
    axesLineWidth2D = 0;
    axesTickLocation2D = Outside;
    axesTicks2D = BottomLeft;
    axesFlag = true;
    axesAutoSetTicks = true;
    labelAutoSetScaling = true;
    xAxisLabels = true;
    yAxisLabels = true;
    zAxisLabels = true;
    xAxisTitle = true;
    yAxisTitle = true;
    zAxisTitle = true;
    xGridLines = false;
    yGridLines = false;
    zGridLines = false;
    xAxisTicks = true;
    yAxisTicks = true;
    zAxisTicks = true;
    xMajorTickMinimum = 0;
    yMajorTickMinimum = 0;
    zMajorTickMinimum = 0;
    xMajorTickMaximum = 1;
    yMajorTickMaximum = 1;
    zMajorTickMaximum = 1;
    xMajorTickSpacing = 0.2;
    yMajorTickSpacing = 0.2;
    zMajorTickSpacing = 0.2;
    xMinorTickSpacing = 0.02;
    yMinorTickSpacing = 0.02;
    zMinorTickSpacing = 0.02;
    xLabelFontHeight = 0.02;
    yLabelFontHeight = 0.02;
    zLabelFontHeight = 0.02;
    xTitleFontHeight = 0.02;
    yTitleFontHeight = 0.02;
    zTitleFontHeight = 0.02;
    xLabelScaling = 0;
    yLabelScaling = 0;
    zLabelScaling = 0;
    axesTickLocation = Inside;
    axesType = ClosestTriad;
    triadFlag = true;
    bboxFlag = true;
    gradientBackgroundStyle = Radial;
    backgroundMode = Solid;
    userInfoFlag = true;
    databaseInfoFlag = true;
    legendInfoFlag = true;
}

// ****************************************************************************
// Method: AnnotationAttributes::AnnotationAttributes
//
// Purpose: 
//   Copy constructor for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AnnotationAttributes::AnnotationAttributes(const AnnotationAttributes &obj) : AttributeSubject("bbbbbbbbbddddddddddddiiiiibbbbbbbbbbbbbbbddddddddddddddddddiiiiibbaaiaaibbb")
{
    axesFlag2D = obj.axesFlag2D;
    axesAutoSetTicks2D = obj.axesAutoSetTicks2D;
    labelAutoSetScaling2D = obj.labelAutoSetScaling2D;
    xAxisLabels2D = obj.xAxisLabels2D;
    yAxisLabels2D = obj.yAxisLabels2D;
    xAxisTitle2D = obj.xAxisTitle2D;
    yAxisTitle2D = obj.yAxisTitle2D;
    xGridLines2D = obj.xGridLines2D;
    yGridLines2D = obj.yGridLines2D;
    xMajorTickMinimum2D = obj.xMajorTickMinimum2D;
    yMajorTickMinimum2D = obj.yMajorTickMinimum2D;
    xMajorTickMaximum2D = obj.xMajorTickMaximum2D;
    yMajorTickMaximum2D = obj.yMajorTickMaximum2D;
    xMajorTickSpacing2D = obj.xMajorTickSpacing2D;
    yMajorTickSpacing2D = obj.yMajorTickSpacing2D;
    xMinorTickSpacing2D = obj.xMinorTickSpacing2D;
    yMinorTickSpacing2D = obj.yMinorTickSpacing2D;
    xLabelFontHeight2D = obj.xLabelFontHeight2D;
    yLabelFontHeight2D = obj.yLabelFontHeight2D;
    xTitleFontHeight2D = obj.xTitleFontHeight2D;
    yTitleFontHeight2D = obj.yTitleFontHeight2D;
    xLabelScaling2D = obj.xLabelScaling2D;
    yLabelScaling2D = obj.yLabelScaling2D;
    axesLineWidth2D = obj.axesLineWidth2D;
    axesTickLocation2D = obj.axesTickLocation2D;
    axesTicks2D = obj.axesTicks2D;
    axesFlag = obj.axesFlag;
    axesAutoSetTicks = obj.axesAutoSetTicks;
    labelAutoSetScaling = obj.labelAutoSetScaling;
    xAxisLabels = obj.xAxisLabels;
    yAxisLabels = obj.yAxisLabels;
    zAxisLabels = obj.zAxisLabels;
    xAxisTitle = obj.xAxisTitle;
    yAxisTitle = obj.yAxisTitle;
    zAxisTitle = obj.zAxisTitle;
    xGridLines = obj.xGridLines;
    yGridLines = obj.yGridLines;
    zGridLines = obj.zGridLines;
    xAxisTicks = obj.xAxisTicks;
    yAxisTicks = obj.yAxisTicks;
    zAxisTicks = obj.zAxisTicks;
    xMajorTickMinimum = obj.xMajorTickMinimum;
    yMajorTickMinimum = obj.yMajorTickMinimum;
    zMajorTickMinimum = obj.zMajorTickMinimum;
    xMajorTickMaximum = obj.xMajorTickMaximum;
    yMajorTickMaximum = obj.yMajorTickMaximum;
    zMajorTickMaximum = obj.zMajorTickMaximum;
    xMajorTickSpacing = obj.xMajorTickSpacing;
    yMajorTickSpacing = obj.yMajorTickSpacing;
    zMajorTickSpacing = obj.zMajorTickSpacing;
    xMinorTickSpacing = obj.xMinorTickSpacing;
    yMinorTickSpacing = obj.yMinorTickSpacing;
    zMinorTickSpacing = obj.zMinorTickSpacing;
    xLabelFontHeight = obj.xLabelFontHeight;
    yLabelFontHeight = obj.yLabelFontHeight;
    zLabelFontHeight = obj.zLabelFontHeight;
    xTitleFontHeight = obj.xTitleFontHeight;
    yTitleFontHeight = obj.yTitleFontHeight;
    zTitleFontHeight = obj.zTitleFontHeight;
    xLabelScaling = obj.xLabelScaling;
    yLabelScaling = obj.yLabelScaling;
    zLabelScaling = obj.zLabelScaling;
    axesTickLocation = obj.axesTickLocation;
    axesType = obj.axesType;
    triadFlag = obj.triadFlag;
    bboxFlag = obj.bboxFlag;
    backgroundColor = obj.backgroundColor;
    foregroundColor = obj.foregroundColor;
    gradientBackgroundStyle = obj.gradientBackgroundStyle;
    gradientColor1 = obj.gradientColor1;
    gradientColor2 = obj.gradientColor2;
    backgroundMode = obj.backgroundMode;
    userInfoFlag = obj.userInfoFlag;
    databaseInfoFlag = obj.databaseInfoFlag;
    legendInfoFlag = obj.legendInfoFlag;

    SelectAll();
}

// ****************************************************************************
// Method: AnnotationAttributes::~AnnotationAttributes
//
// Purpose: 
//   Destructor for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AnnotationAttributes::~AnnotationAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AnnotationAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AnnotationAttributes& 
AnnotationAttributes::operator = (const AnnotationAttributes &obj)
{
    if (this == &obj) return *this;
    axesFlag2D = obj.axesFlag2D;
    axesAutoSetTicks2D = obj.axesAutoSetTicks2D;
    labelAutoSetScaling2D = obj.labelAutoSetScaling2D;
    xAxisLabels2D = obj.xAxisLabels2D;
    yAxisLabels2D = obj.yAxisLabels2D;
    xAxisTitle2D = obj.xAxisTitle2D;
    yAxisTitle2D = obj.yAxisTitle2D;
    xGridLines2D = obj.xGridLines2D;
    yGridLines2D = obj.yGridLines2D;
    xMajorTickMinimum2D = obj.xMajorTickMinimum2D;
    yMajorTickMinimum2D = obj.yMajorTickMinimum2D;
    xMajorTickMaximum2D = obj.xMajorTickMaximum2D;
    yMajorTickMaximum2D = obj.yMajorTickMaximum2D;
    xMajorTickSpacing2D = obj.xMajorTickSpacing2D;
    yMajorTickSpacing2D = obj.yMajorTickSpacing2D;
    xMinorTickSpacing2D = obj.xMinorTickSpacing2D;
    yMinorTickSpacing2D = obj.yMinorTickSpacing2D;
    xLabelFontHeight2D = obj.xLabelFontHeight2D;
    yLabelFontHeight2D = obj.yLabelFontHeight2D;
    xTitleFontHeight2D = obj.xTitleFontHeight2D;
    yTitleFontHeight2D = obj.yTitleFontHeight2D;
    xLabelScaling2D = obj.xLabelScaling2D;
    yLabelScaling2D = obj.yLabelScaling2D;
    axesLineWidth2D = obj.axesLineWidth2D;
    axesTickLocation2D = obj.axesTickLocation2D;
    axesTicks2D = obj.axesTicks2D;
    axesFlag = obj.axesFlag;
    axesAutoSetTicks = obj.axesAutoSetTicks;
    labelAutoSetScaling = obj.labelAutoSetScaling;
    xAxisLabels = obj.xAxisLabels;
    yAxisLabels = obj.yAxisLabels;
    zAxisLabels = obj.zAxisLabels;
    xAxisTitle = obj.xAxisTitle;
    yAxisTitle = obj.yAxisTitle;
    zAxisTitle = obj.zAxisTitle;
    xGridLines = obj.xGridLines;
    yGridLines = obj.yGridLines;
    zGridLines = obj.zGridLines;
    xAxisTicks = obj.xAxisTicks;
    yAxisTicks = obj.yAxisTicks;
    zAxisTicks = obj.zAxisTicks;
    xMajorTickMinimum = obj.xMajorTickMinimum;
    yMajorTickMinimum = obj.yMajorTickMinimum;
    zMajorTickMinimum = obj.zMajorTickMinimum;
    xMajorTickMaximum = obj.xMajorTickMaximum;
    yMajorTickMaximum = obj.yMajorTickMaximum;
    zMajorTickMaximum = obj.zMajorTickMaximum;
    xMajorTickSpacing = obj.xMajorTickSpacing;
    yMajorTickSpacing = obj.yMajorTickSpacing;
    zMajorTickSpacing = obj.zMajorTickSpacing;
    xMinorTickSpacing = obj.xMinorTickSpacing;
    yMinorTickSpacing = obj.yMinorTickSpacing;
    zMinorTickSpacing = obj.zMinorTickSpacing;
    xLabelFontHeight = obj.xLabelFontHeight;
    yLabelFontHeight = obj.yLabelFontHeight;
    zLabelFontHeight = obj.zLabelFontHeight;
    xTitleFontHeight = obj.xTitleFontHeight;
    yTitleFontHeight = obj.yTitleFontHeight;
    zTitleFontHeight = obj.zTitleFontHeight;
    xLabelScaling = obj.xLabelScaling;
    yLabelScaling = obj.yLabelScaling;
    zLabelScaling = obj.zLabelScaling;
    axesTickLocation = obj.axesTickLocation;
    axesType = obj.axesType;
    triadFlag = obj.triadFlag;
    bboxFlag = obj.bboxFlag;
    backgroundColor = obj.backgroundColor;
    foregroundColor = obj.foregroundColor;
    gradientBackgroundStyle = obj.gradientBackgroundStyle;
    gradientColor1 = obj.gradientColor1;
    gradientColor2 = obj.gradientColor2;
    backgroundMode = obj.backgroundMode;
    userInfoFlag = obj.userInfoFlag;
    databaseInfoFlag = obj.databaseInfoFlag;
    legendInfoFlag = obj.legendInfoFlag;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AnnotationAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationAttributes::operator == (const AnnotationAttributes &obj) const
{
    // Create the return value
    return ((axesFlag2D == obj.axesFlag2D) &&
            (axesAutoSetTicks2D == obj.axesAutoSetTicks2D) &&
            (labelAutoSetScaling2D == obj.labelAutoSetScaling2D) &&
            (xAxisLabels2D == obj.xAxisLabels2D) &&
            (yAxisLabels2D == obj.yAxisLabels2D) &&
            (xAxisTitle2D == obj.xAxisTitle2D) &&
            (yAxisTitle2D == obj.yAxisTitle2D) &&
            (xGridLines2D == obj.xGridLines2D) &&
            (yGridLines2D == obj.yGridLines2D) &&
            (xMajorTickMinimum2D == obj.xMajorTickMinimum2D) &&
            (yMajorTickMinimum2D == obj.yMajorTickMinimum2D) &&
            (xMajorTickMaximum2D == obj.xMajorTickMaximum2D) &&
            (yMajorTickMaximum2D == obj.yMajorTickMaximum2D) &&
            (xMajorTickSpacing2D == obj.xMajorTickSpacing2D) &&
            (yMajorTickSpacing2D == obj.yMajorTickSpacing2D) &&
            (xMinorTickSpacing2D == obj.xMinorTickSpacing2D) &&
            (yMinorTickSpacing2D == obj.yMinorTickSpacing2D) &&
            (xLabelFontHeight2D == obj.xLabelFontHeight2D) &&
            (yLabelFontHeight2D == obj.yLabelFontHeight2D) &&
            (xTitleFontHeight2D == obj.xTitleFontHeight2D) &&
            (yTitleFontHeight2D == obj.yTitleFontHeight2D) &&
            (xLabelScaling2D == obj.xLabelScaling2D) &&
            (yLabelScaling2D == obj.yLabelScaling2D) &&
            (axesLineWidth2D == obj.axesLineWidth2D) &&
            (axesTickLocation2D == obj.axesTickLocation2D) &&
            (axesTicks2D == obj.axesTicks2D) &&
            (axesFlag == obj.axesFlag) &&
            (axesAutoSetTicks == obj.axesAutoSetTicks) &&
            (labelAutoSetScaling == obj.labelAutoSetScaling) &&
            (xAxisLabels == obj.xAxisLabels) &&
            (yAxisLabels == obj.yAxisLabels) &&
            (zAxisLabels == obj.zAxisLabels) &&
            (xAxisTitle == obj.xAxisTitle) &&
            (yAxisTitle == obj.yAxisTitle) &&
            (zAxisTitle == obj.zAxisTitle) &&
            (xGridLines == obj.xGridLines) &&
            (yGridLines == obj.yGridLines) &&
            (zGridLines == obj.zGridLines) &&
            (xAxisTicks == obj.xAxisTicks) &&
            (yAxisTicks == obj.yAxisTicks) &&
            (zAxisTicks == obj.zAxisTicks) &&
            (xMajorTickMinimum == obj.xMajorTickMinimum) &&
            (yMajorTickMinimum == obj.yMajorTickMinimum) &&
            (zMajorTickMinimum == obj.zMajorTickMinimum) &&
            (xMajorTickMaximum == obj.xMajorTickMaximum) &&
            (yMajorTickMaximum == obj.yMajorTickMaximum) &&
            (zMajorTickMaximum == obj.zMajorTickMaximum) &&
            (xMajorTickSpacing == obj.xMajorTickSpacing) &&
            (yMajorTickSpacing == obj.yMajorTickSpacing) &&
            (zMajorTickSpacing == obj.zMajorTickSpacing) &&
            (xMinorTickSpacing == obj.xMinorTickSpacing) &&
            (yMinorTickSpacing == obj.yMinorTickSpacing) &&
            (zMinorTickSpacing == obj.zMinorTickSpacing) &&
            (xLabelFontHeight == obj.xLabelFontHeight) &&
            (yLabelFontHeight == obj.yLabelFontHeight) &&
            (zLabelFontHeight == obj.zLabelFontHeight) &&
            (xTitleFontHeight == obj.xTitleFontHeight) &&
            (yTitleFontHeight == obj.yTitleFontHeight) &&
            (zTitleFontHeight == obj.zTitleFontHeight) &&
            (xLabelScaling == obj.xLabelScaling) &&
            (yLabelScaling == obj.yLabelScaling) &&
            (zLabelScaling == obj.zLabelScaling) &&
            (axesTickLocation == obj.axesTickLocation) &&
            (axesType == obj.axesType) &&
            (triadFlag == obj.triadFlag) &&
            (bboxFlag == obj.bboxFlag) &&
            (backgroundColor == obj.backgroundColor) &&
            (foregroundColor == obj.foregroundColor) &&
            (gradientBackgroundStyle == obj.gradientBackgroundStyle) &&
            (gradientColor1 == obj.gradientColor1) &&
            (gradientColor2 == obj.gradientColor2) &&
            (backgroundMode == obj.backgroundMode) &&
            (userInfoFlag == obj.userInfoFlag) &&
            (databaseInfoFlag == obj.databaseInfoFlag) &&
            (legendInfoFlag == obj.legendInfoFlag));
}

// ****************************************************************************
// Method: AnnotationAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationAttributes::operator != (const AnnotationAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnnotationAttributes::TypeName
//
// Purpose: 
//   Type name method for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnnotationAttributes::TypeName() const
{
    return "AnnotationAttributes";
}

// ****************************************************************************
// Method: AnnotationAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnnotationAttributes *tmp = (const AnnotationAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnnotationAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnnotationAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnnotationAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AnnotationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnnotationAttributes(*this);
    else
        retval = new AnnotationAttributes;

    return retval;
}

// ****************************************************************************
// Method: AnnotationAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationAttributes::SelectAll()
{
    Select(0, (void *)&axesFlag2D);
    Select(1, (void *)&axesAutoSetTicks2D);
    Select(2, (void *)&labelAutoSetScaling2D);
    Select(3, (void *)&xAxisLabels2D);
    Select(4, (void *)&yAxisLabels2D);
    Select(5, (void *)&xAxisTitle2D);
    Select(6, (void *)&yAxisTitle2D);
    Select(7, (void *)&xGridLines2D);
    Select(8, (void *)&yGridLines2D);
    Select(9, (void *)&xMajorTickMinimum2D);
    Select(10, (void *)&yMajorTickMinimum2D);
    Select(11, (void *)&xMajorTickMaximum2D);
    Select(12, (void *)&yMajorTickMaximum2D);
    Select(13, (void *)&xMajorTickSpacing2D);
    Select(14, (void *)&yMajorTickSpacing2D);
    Select(15, (void *)&xMinorTickSpacing2D);
    Select(16, (void *)&yMinorTickSpacing2D);
    Select(17, (void *)&xLabelFontHeight2D);
    Select(18, (void *)&yLabelFontHeight2D);
    Select(19, (void *)&xTitleFontHeight2D);
    Select(20, (void *)&yTitleFontHeight2D);
    Select(21, (void *)&xLabelScaling2D);
    Select(22, (void *)&yLabelScaling2D);
    Select(23, (void *)&axesLineWidth2D);
    Select(24, (void *)&axesTickLocation2D);
    Select(25, (void *)&axesTicks2D);
    Select(26, (void *)&axesFlag);
    Select(27, (void *)&axesAutoSetTicks);
    Select(28, (void *)&labelAutoSetScaling);
    Select(29, (void *)&xAxisLabels);
    Select(30, (void *)&yAxisLabels);
    Select(31, (void *)&zAxisLabels);
    Select(32, (void *)&xAxisTitle);
    Select(33, (void *)&yAxisTitle);
    Select(34, (void *)&zAxisTitle);
    Select(35, (void *)&xGridLines);
    Select(36, (void *)&yGridLines);
    Select(37, (void *)&zGridLines);
    Select(38, (void *)&xAxisTicks);
    Select(39, (void *)&yAxisTicks);
    Select(40, (void *)&zAxisTicks);
    Select(41, (void *)&xMajorTickMinimum);
    Select(42, (void *)&yMajorTickMinimum);
    Select(43, (void *)&zMajorTickMinimum);
    Select(44, (void *)&xMajorTickMaximum);
    Select(45, (void *)&yMajorTickMaximum);
    Select(46, (void *)&zMajorTickMaximum);
    Select(47, (void *)&xMajorTickSpacing);
    Select(48, (void *)&yMajorTickSpacing);
    Select(49, (void *)&zMajorTickSpacing);
    Select(50, (void *)&xMinorTickSpacing);
    Select(51, (void *)&yMinorTickSpacing);
    Select(52, (void *)&zMinorTickSpacing);
    Select(53, (void *)&xLabelFontHeight);
    Select(54, (void *)&yLabelFontHeight);
    Select(55, (void *)&zLabelFontHeight);
    Select(56, (void *)&xTitleFontHeight);
    Select(57, (void *)&yTitleFontHeight);
    Select(58, (void *)&zTitleFontHeight);
    Select(59, (void *)&xLabelScaling);
    Select(60, (void *)&yLabelScaling);
    Select(61, (void *)&zLabelScaling);
    Select(62, (void *)&axesTickLocation);
    Select(63, (void *)&axesType);
    Select(64, (void *)&triadFlag);
    Select(65, (void *)&bboxFlag);
    Select(66, (void *)&backgroundColor);
    Select(67, (void *)&foregroundColor);
    Select(68, (void *)&gradientBackgroundStyle);
    Select(69, (void *)&gradientColor1);
    Select(70, (void *)&gradientColor2);
    Select(71, (void *)&backgroundMode);
    Select(72, (void *)&userInfoFlag);
    Select(73, (void *)&databaseInfoFlag);
    Select(74, (void *)&legendInfoFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnnotationAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AnnotationAttributes.
    DataNode *node = new DataNode("AnnotationAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesFlag2D", axesFlag2D));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesAutoSetTicks2D", axesAutoSetTicks2D));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("labelAutoSetScaling2D", labelAutoSetScaling2D));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAxisLabels2D", xAxisLabels2D));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisLabels2D", yAxisLabels2D));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAxisTitle2D", xAxisTitle2D));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisTitle2D", yAxisTitle2D));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xGridLines2D", xGridLines2D));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yGridLines2D", yGridLines2D));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickMinimum2D", xMajorTickMinimum2D));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickMinimum2D", yMajorTickMinimum2D));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickMaximum2D", xMajorTickMaximum2D));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickMaximum2D", yMajorTickMaximum2D));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickSpacing2D", xMajorTickSpacing2D));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickSpacing2D", yMajorTickSpacing2D));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMinorTickSpacing2D", xMinorTickSpacing2D));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMinorTickSpacing2D", yMinorTickSpacing2D));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xLabelFontHeight2D", xLabelFontHeight2D));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yLabelFontHeight2D", yLabelFontHeight2D));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xTitleFontHeight2D", xTitleFontHeight2D));
    }

    if(completeSave || !FieldsEqual(20, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yTitleFontHeight2D", yTitleFontHeight2D));
    }

    if(completeSave || !FieldsEqual(21, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xLabelScaling2D", xLabelScaling2D));
    }

    if(completeSave || !FieldsEqual(22, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yLabelScaling2D", yLabelScaling2D));
    }

    if(completeSave || !FieldsEqual(23, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesLineWidth2D", axesLineWidth2D));
    }

    if(completeSave || !FieldsEqual(24, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesTickLocation2D", Location_ToString(axesTickLocation2D)));
    }

    if(completeSave || !FieldsEqual(25, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesTicks2D", Ticks_ToString(axesTicks2D)));
    }

    if(completeSave || !FieldsEqual(26, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesFlag", axesFlag));
    }

    if(completeSave || !FieldsEqual(27, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesAutoSetTicks", axesAutoSetTicks));
    }

    if(completeSave || !FieldsEqual(28, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("labelAutoSetScaling", labelAutoSetScaling));
    }

    if(completeSave || !FieldsEqual(29, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAxisLabels", xAxisLabels));
    }

    if(completeSave || !FieldsEqual(30, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisLabels", yAxisLabels));
    }

    if(completeSave || !FieldsEqual(31, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zAxisLabels", zAxisLabels));
    }

    if(completeSave || !FieldsEqual(32, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAxisTitle", xAxisTitle));
    }

    if(completeSave || !FieldsEqual(33, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisTitle", yAxisTitle));
    }

    if(completeSave || !FieldsEqual(34, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zAxisTitle", zAxisTitle));
    }

    if(completeSave || !FieldsEqual(35, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xGridLines", xGridLines));
    }

    if(completeSave || !FieldsEqual(36, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yGridLines", yGridLines));
    }

    if(completeSave || !FieldsEqual(37, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zGridLines", zGridLines));
    }

    if(completeSave || !FieldsEqual(38, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xAxisTicks", xAxisTicks));
    }

    if(completeSave || !FieldsEqual(39, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisTicks", yAxisTicks));
    }

    if(completeSave || !FieldsEqual(40, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zAxisTicks", zAxisTicks));
    }

    if(completeSave || !FieldsEqual(41, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickMinimum", xMajorTickMinimum));
    }

    if(completeSave || !FieldsEqual(42, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickMinimum", yMajorTickMinimum));
    }

    if(completeSave || !FieldsEqual(43, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMajorTickMinimum", zMajorTickMinimum));
    }

    if(completeSave || !FieldsEqual(44, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickMaximum", xMajorTickMaximum));
    }

    if(completeSave || !FieldsEqual(45, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickMaximum", yMajorTickMaximum));
    }

    if(completeSave || !FieldsEqual(46, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMajorTickMaximum", zMajorTickMaximum));
    }

    if(completeSave || !FieldsEqual(47, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMajorTickSpacing", xMajorTickSpacing));
    }

    if(completeSave || !FieldsEqual(48, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMajorTickSpacing", yMajorTickSpacing));
    }

    if(completeSave || !FieldsEqual(49, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMajorTickSpacing", zMajorTickSpacing));
    }

    if(completeSave || !FieldsEqual(50, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xMinorTickSpacing", xMinorTickSpacing));
    }

    if(completeSave || !FieldsEqual(51, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yMinorTickSpacing", yMinorTickSpacing));
    }

    if(completeSave || !FieldsEqual(52, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zMinorTickSpacing", zMinorTickSpacing));
    }

    if(completeSave || !FieldsEqual(53, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xLabelFontHeight", xLabelFontHeight));
    }

    if(completeSave || !FieldsEqual(54, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yLabelFontHeight", yLabelFontHeight));
    }

    if(completeSave || !FieldsEqual(55, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zLabelFontHeight", zLabelFontHeight));
    }

    if(completeSave || !FieldsEqual(56, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xTitleFontHeight", xTitleFontHeight));
    }

    if(completeSave || !FieldsEqual(57, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yTitleFontHeight", yTitleFontHeight));
    }

    if(completeSave || !FieldsEqual(58, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zTitleFontHeight", zTitleFontHeight));
    }

    if(completeSave || !FieldsEqual(59, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xLabelScaling", xLabelScaling));
    }

    if(completeSave || !FieldsEqual(60, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yLabelScaling", yLabelScaling));
    }

    if(completeSave || !FieldsEqual(61, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zLabelScaling", zLabelScaling));
    }

    if(completeSave || !FieldsEqual(62, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesTickLocation", Location_ToString(axesTickLocation)));
    }

    if(completeSave || !FieldsEqual(63, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axesType", Axes_ToString(axesType)));
    }

    if(completeSave || !FieldsEqual(64, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("triadFlag", triadFlag));
    }

    if(completeSave || !FieldsEqual(65, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("bboxFlag", bboxFlag));
    }

        DataNode *backgroundColorNode = new DataNode("backgroundColor");
        if(backgroundColor.CreateNode(backgroundColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(backgroundColorNode);
        }
        else
            delete backgroundColorNode;
        DataNode *foregroundColorNode = new DataNode("foregroundColor");
        if(foregroundColor.CreateNode(foregroundColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(foregroundColorNode);
        }
        else
            delete foregroundColorNode;
    if(completeSave || !FieldsEqual(68, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradientBackgroundStyle", GradientStyle_ToString(gradientBackgroundStyle)));
    }

        DataNode *gradientColor1Node = new DataNode("gradientColor1");
        if(gradientColor1.CreateNode(gradientColor1Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(gradientColor1Node);
        }
        else
            delete gradientColor1Node;
        DataNode *gradientColor2Node = new DataNode("gradientColor2");
        if(gradientColor2.CreateNode(gradientColor2Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(gradientColor2Node);
        }
        else
            delete gradientColor2Node;
    if(completeSave || !FieldsEqual(71, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backgroundMode", BackgroundMode_ToString(backgroundMode)));
    }

    if(completeSave || !FieldsEqual(72, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userInfoFlag", userInfoFlag));
    }

    if(completeSave || !FieldsEqual(73, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("databaseInfoFlag", databaseInfoFlag));
    }

    if(completeSave || !FieldsEqual(74, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendInfoFlag", legendInfoFlag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnnotationAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("axesFlag2D")) != 0)
        SetAxesFlag2D(node->AsBool());
    if((node = searchNode->GetNode("axesAutoSetTicks2D")) != 0)
        SetAxesAutoSetTicks2D(node->AsBool());
    if((node = searchNode->GetNode("labelAutoSetScaling2D")) != 0)
        SetLabelAutoSetScaling2D(node->AsBool());
    if((node = searchNode->GetNode("xAxisLabels2D")) != 0)
        SetXAxisLabels2D(node->AsBool());
    if((node = searchNode->GetNode("yAxisLabels2D")) != 0)
        SetYAxisLabels2D(node->AsBool());
    if((node = searchNode->GetNode("xAxisTitle2D")) != 0)
        SetXAxisTitle2D(node->AsBool());
    if((node = searchNode->GetNode("yAxisTitle2D")) != 0)
        SetYAxisTitle2D(node->AsBool());
    if((node = searchNode->GetNode("xGridLines2D")) != 0)
        SetXGridLines2D(node->AsBool());
    if((node = searchNode->GetNode("yGridLines2D")) != 0)
        SetYGridLines2D(node->AsBool());
    if((node = searchNode->GetNode("xMajorTickMinimum2D")) != 0)
        SetXMajorTickMinimum2D(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickMinimum2D")) != 0)
        SetYMajorTickMinimum2D(node->AsDouble());
    if((node = searchNode->GetNode("xMajorTickMaximum2D")) != 0)
        SetXMajorTickMaximum2D(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickMaximum2D")) != 0)
        SetYMajorTickMaximum2D(node->AsDouble());
    if((node = searchNode->GetNode("xMajorTickSpacing2D")) != 0)
        SetXMajorTickSpacing2D(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickSpacing2D")) != 0)
        SetYMajorTickSpacing2D(node->AsDouble());
    if((node = searchNode->GetNode("xMinorTickSpacing2D")) != 0)
        SetXMinorTickSpacing2D(node->AsDouble());
    if((node = searchNode->GetNode("yMinorTickSpacing2D")) != 0)
        SetYMinorTickSpacing2D(node->AsDouble());
    if((node = searchNode->GetNode("xLabelFontHeight2D")) != 0)
        SetXLabelFontHeight2D(node->AsDouble());
    if((node = searchNode->GetNode("yLabelFontHeight2D")) != 0)
        SetYLabelFontHeight2D(node->AsDouble());
    if((node = searchNode->GetNode("xTitleFontHeight2D")) != 0)
        SetXTitleFontHeight2D(node->AsDouble());
    if((node = searchNode->GetNode("yTitleFontHeight2D")) != 0)
        SetYTitleFontHeight2D(node->AsDouble());
    if((node = searchNode->GetNode("xLabelScaling2D")) != 0)
        SetXLabelScaling2D(node->AsInt());
    if((node = searchNode->GetNode("yLabelScaling2D")) != 0)
        SetYLabelScaling2D(node->AsInt());
    if((node = searchNode->GetNode("axesLineWidth2D")) != 0)
        SetAxesLineWidth2D(node->AsInt());
    if((node = searchNode->GetNode("axesTickLocation2D")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetAxesTickLocation2D(Location(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Location value;
            if(Location_FromString(node->AsString(), value))
                SetAxesTickLocation2D(value);
        }
    }
    if((node = searchNode->GetNode("axesTicks2D")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetAxesTicks2D(Ticks(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Ticks value;
            if(Ticks_FromString(node->AsString(), value))
                SetAxesTicks2D(value);
        }
    }
    if((node = searchNode->GetNode("axesFlag")) != 0)
        SetAxesFlag(node->AsBool());
    if((node = searchNode->GetNode("axesAutoSetTicks")) != 0)
        SetAxesAutoSetTicks(node->AsBool());
    if((node = searchNode->GetNode("labelAutoSetScaling")) != 0)
        SetLabelAutoSetScaling(node->AsBool());
    if((node = searchNode->GetNode("xAxisLabels")) != 0)
        SetXAxisLabels(node->AsBool());
    if((node = searchNode->GetNode("yAxisLabels")) != 0)
        SetYAxisLabels(node->AsBool());
    if((node = searchNode->GetNode("zAxisLabels")) != 0)
        SetZAxisLabels(node->AsBool());
    if((node = searchNode->GetNode("xAxisTitle")) != 0)
        SetXAxisTitle(node->AsBool());
    if((node = searchNode->GetNode("yAxisTitle")) != 0)
        SetYAxisTitle(node->AsBool());
    if((node = searchNode->GetNode("zAxisTitle")) != 0)
        SetZAxisTitle(node->AsBool());
    if((node = searchNode->GetNode("xGridLines")) != 0)
        SetXGridLines(node->AsBool());
    if((node = searchNode->GetNode("yGridLines")) != 0)
        SetYGridLines(node->AsBool());
    if((node = searchNode->GetNode("zGridLines")) != 0)
        SetZGridLines(node->AsBool());
    if((node = searchNode->GetNode("xAxisTicks")) != 0)
        SetXAxisTicks(node->AsBool());
    if((node = searchNode->GetNode("yAxisTicks")) != 0)
        SetYAxisTicks(node->AsBool());
    if((node = searchNode->GetNode("zAxisTicks")) != 0)
        SetZAxisTicks(node->AsBool());
    if((node = searchNode->GetNode("xMajorTickMinimum")) != 0)
        SetXMajorTickMinimum(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickMinimum")) != 0)
        SetYMajorTickMinimum(node->AsDouble());
    if((node = searchNode->GetNode("zMajorTickMinimum")) != 0)
        SetZMajorTickMinimum(node->AsDouble());
    if((node = searchNode->GetNode("xMajorTickMaximum")) != 0)
        SetXMajorTickMaximum(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickMaximum")) != 0)
        SetYMajorTickMaximum(node->AsDouble());
    if((node = searchNode->GetNode("zMajorTickMaximum")) != 0)
        SetZMajorTickMaximum(node->AsDouble());
    if((node = searchNode->GetNode("xMajorTickSpacing")) != 0)
        SetXMajorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("yMajorTickSpacing")) != 0)
        SetYMajorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("zMajorTickSpacing")) != 0)
        SetZMajorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("xMinorTickSpacing")) != 0)
        SetXMinorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("yMinorTickSpacing")) != 0)
        SetYMinorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("zMinorTickSpacing")) != 0)
        SetZMinorTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("xLabelFontHeight")) != 0)
        SetXLabelFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("yLabelFontHeight")) != 0)
        SetYLabelFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("zLabelFontHeight")) != 0)
        SetZLabelFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("xTitleFontHeight")) != 0)
        SetXTitleFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("yTitleFontHeight")) != 0)
        SetYTitleFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("zTitleFontHeight")) != 0)
        SetZTitleFontHeight(node->AsDouble());
    if((node = searchNode->GetNode("xLabelScaling")) != 0)
        SetXLabelScaling(node->AsInt());
    if((node = searchNode->GetNode("yLabelScaling")) != 0)
        SetYLabelScaling(node->AsInt());
    if((node = searchNode->GetNode("zLabelScaling")) != 0)
        SetZLabelScaling(node->AsInt());
    if((node = searchNode->GetNode("axesTickLocation")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetAxesTickLocation(Location(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Location value;
            if(Location_FromString(node->AsString(), value))
                SetAxesTickLocation(value);
        }
    }
    if((node = searchNode->GetNode("axesType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetAxesType(Axes(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Axes value;
            if(Axes_FromString(node->AsString(), value))
                SetAxesType(value);
        }
    }
    if((node = searchNode->GetNode("triadFlag")) != 0)
        SetTriadFlag(node->AsBool());
    if((node = searchNode->GetNode("bboxFlag")) != 0)
        SetBboxFlag(node->AsBool());
    if((node = searchNode->GetNode("backgroundColor")) != 0)
        backgroundColor.SetFromNode(node);
    if((node = searchNode->GetNode("foregroundColor")) != 0)
        foregroundColor.SetFromNode(node);
    if((node = searchNode->GetNode("gradientBackgroundStyle")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetGradientBackgroundStyle(GradientStyle(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            GradientStyle value;
            if(GradientStyle_FromString(node->AsString(), value))
                SetGradientBackgroundStyle(value);
        }
    }
    if((node = searchNode->GetNode("gradientColor1")) != 0)
        gradientColor1.SetFromNode(node);
    if((node = searchNode->GetNode("gradientColor2")) != 0)
        gradientColor2.SetFromNode(node);
    if((node = searchNode->GetNode("backgroundMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetBackgroundMode(BackgroundMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            BackgroundMode value;
            if(BackgroundMode_FromString(node->AsString(), value))
                SetBackgroundMode(value);
        }
    }
    if((node = searchNode->GetNode("userInfoFlag")) != 0)
        SetUserInfoFlag(node->AsBool());
    if((node = searchNode->GetNode("databaseInfoFlag")) != 0)
        SetDatabaseInfoFlag(node->AsBool());
    if((node = searchNode->GetNode("legendInfoFlag")) != 0)
        SetLegendInfoFlag(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationAttributes::SetAxesFlag2D(bool axesFlag2D_)
{
    axesFlag2D = axesFlag2D_;
    Select(0, (void *)&axesFlag2D);
}

void
AnnotationAttributes::SetAxesAutoSetTicks2D(bool axesAutoSetTicks2D_)
{
    axesAutoSetTicks2D = axesAutoSetTicks2D_;
    Select(1, (void *)&axesAutoSetTicks2D);
}

void
AnnotationAttributes::SetLabelAutoSetScaling2D(bool labelAutoSetScaling2D_)
{
    labelAutoSetScaling2D = labelAutoSetScaling2D_;
    Select(2, (void *)&labelAutoSetScaling2D);
}

void
AnnotationAttributes::SetXAxisLabels2D(bool xAxisLabels2D_)
{
    xAxisLabels2D = xAxisLabels2D_;
    Select(3, (void *)&xAxisLabels2D);
}

void
AnnotationAttributes::SetYAxisLabels2D(bool yAxisLabels2D_)
{
    yAxisLabels2D = yAxisLabels2D_;
    Select(4, (void *)&yAxisLabels2D);
}

void
AnnotationAttributes::SetXAxisTitle2D(bool xAxisTitle2D_)
{
    xAxisTitle2D = xAxisTitle2D_;
    Select(5, (void *)&xAxisTitle2D);
}

void
AnnotationAttributes::SetYAxisTitle2D(bool yAxisTitle2D_)
{
    yAxisTitle2D = yAxisTitle2D_;
    Select(6, (void *)&yAxisTitle2D);
}

void
AnnotationAttributes::SetXGridLines2D(bool xGridLines2D_)
{
    xGridLines2D = xGridLines2D_;
    Select(7, (void *)&xGridLines2D);
}

void
AnnotationAttributes::SetYGridLines2D(bool yGridLines2D_)
{
    yGridLines2D = yGridLines2D_;
    Select(8, (void *)&yGridLines2D);
}

void
AnnotationAttributes::SetXMajorTickMinimum2D(double xMajorTickMinimum2D_)
{
    xMajorTickMinimum2D = xMajorTickMinimum2D_;
    Select(9, (void *)&xMajorTickMinimum2D);
}

void
AnnotationAttributes::SetYMajorTickMinimum2D(double yMajorTickMinimum2D_)
{
    yMajorTickMinimum2D = yMajorTickMinimum2D_;
    Select(10, (void *)&yMajorTickMinimum2D);
}

void
AnnotationAttributes::SetXMajorTickMaximum2D(double xMajorTickMaximum2D_)
{
    xMajorTickMaximum2D = xMajorTickMaximum2D_;
    Select(11, (void *)&xMajorTickMaximum2D);
}

void
AnnotationAttributes::SetYMajorTickMaximum2D(double yMajorTickMaximum2D_)
{
    yMajorTickMaximum2D = yMajorTickMaximum2D_;
    Select(12, (void *)&yMajorTickMaximum2D);
}

void
AnnotationAttributes::SetXMajorTickSpacing2D(double xMajorTickSpacing2D_)
{
    xMajorTickSpacing2D = xMajorTickSpacing2D_;
    Select(13, (void *)&xMajorTickSpacing2D);
}

void
AnnotationAttributes::SetYMajorTickSpacing2D(double yMajorTickSpacing2D_)
{
    yMajorTickSpacing2D = yMajorTickSpacing2D_;
    Select(14, (void *)&yMajorTickSpacing2D);
}

void
AnnotationAttributes::SetXMinorTickSpacing2D(double xMinorTickSpacing2D_)
{
    xMinorTickSpacing2D = xMinorTickSpacing2D_;
    Select(15, (void *)&xMinorTickSpacing2D);
}

void
AnnotationAttributes::SetYMinorTickSpacing2D(double yMinorTickSpacing2D_)
{
    yMinorTickSpacing2D = yMinorTickSpacing2D_;
    Select(16, (void *)&yMinorTickSpacing2D);
}

void
AnnotationAttributes::SetXLabelFontHeight2D(double xLabelFontHeight2D_)
{
    xLabelFontHeight2D = xLabelFontHeight2D_;
    Select(17, (void *)&xLabelFontHeight2D);
}

void
AnnotationAttributes::SetYLabelFontHeight2D(double yLabelFontHeight2D_)
{
    yLabelFontHeight2D = yLabelFontHeight2D_;
    Select(18, (void *)&yLabelFontHeight2D);
}

void
AnnotationAttributes::SetXTitleFontHeight2D(double xTitleFontHeight2D_)
{
    xTitleFontHeight2D = xTitleFontHeight2D_;
    Select(19, (void *)&xTitleFontHeight2D);
}

void
AnnotationAttributes::SetYTitleFontHeight2D(double yTitleFontHeight2D_)
{
    yTitleFontHeight2D = yTitleFontHeight2D_;
    Select(20, (void *)&yTitleFontHeight2D);
}

void
AnnotationAttributes::SetXLabelScaling2D(int xLabelScaling2D_)
{
    xLabelScaling2D = xLabelScaling2D_;
    Select(21, (void *)&xLabelScaling2D);
}

void
AnnotationAttributes::SetYLabelScaling2D(int yLabelScaling2D_)
{
    yLabelScaling2D = yLabelScaling2D_;
    Select(22, (void *)&yLabelScaling2D);
}

void
AnnotationAttributes::SetAxesLineWidth2D(int axesLineWidth2D_)
{
    axesLineWidth2D = axesLineWidth2D_;
    Select(23, (void *)&axesLineWidth2D);
}

void
AnnotationAttributes::SetAxesTickLocation2D(AnnotationAttributes::Location axesTickLocation2D_)
{
    axesTickLocation2D = axesTickLocation2D_;
    Select(24, (void *)&axesTickLocation2D);
}

void
AnnotationAttributes::SetAxesTicks2D(AnnotationAttributes::Ticks axesTicks2D_)
{
    axesTicks2D = axesTicks2D_;
    Select(25, (void *)&axesTicks2D);
}

void
AnnotationAttributes::SetAxesFlag(bool axesFlag_)
{
    axesFlag = axesFlag_;
    Select(26, (void *)&axesFlag);
}

void
AnnotationAttributes::SetAxesAutoSetTicks(bool axesAutoSetTicks_)
{
    axesAutoSetTicks = axesAutoSetTicks_;
    Select(27, (void *)&axesAutoSetTicks);
}

void
AnnotationAttributes::SetLabelAutoSetScaling(bool labelAutoSetScaling_)
{
    labelAutoSetScaling = labelAutoSetScaling_;
    Select(28, (void *)&labelAutoSetScaling);
}

void
AnnotationAttributes::SetXAxisLabels(bool xAxisLabels_)
{
    xAxisLabels = xAxisLabels_;
    Select(29, (void *)&xAxisLabels);
}

void
AnnotationAttributes::SetYAxisLabels(bool yAxisLabels_)
{
    yAxisLabels = yAxisLabels_;
    Select(30, (void *)&yAxisLabels);
}

void
AnnotationAttributes::SetZAxisLabels(bool zAxisLabels_)
{
    zAxisLabels = zAxisLabels_;
    Select(31, (void *)&zAxisLabels);
}

void
AnnotationAttributes::SetXAxisTitle(bool xAxisTitle_)
{
    xAxisTitle = xAxisTitle_;
    Select(32, (void *)&xAxisTitle);
}

void
AnnotationAttributes::SetYAxisTitle(bool yAxisTitle_)
{
    yAxisTitle = yAxisTitle_;
    Select(33, (void *)&yAxisTitle);
}

void
AnnotationAttributes::SetZAxisTitle(bool zAxisTitle_)
{
    zAxisTitle = zAxisTitle_;
    Select(34, (void *)&zAxisTitle);
}

void
AnnotationAttributes::SetXGridLines(bool xGridLines_)
{
    xGridLines = xGridLines_;
    Select(35, (void *)&xGridLines);
}

void
AnnotationAttributes::SetYGridLines(bool yGridLines_)
{
    yGridLines = yGridLines_;
    Select(36, (void *)&yGridLines);
}

void
AnnotationAttributes::SetZGridLines(bool zGridLines_)
{
    zGridLines = zGridLines_;
    Select(37, (void *)&zGridLines);
}

void
AnnotationAttributes::SetXAxisTicks(bool xAxisTicks_)
{
    xAxisTicks = xAxisTicks_;
    Select(38, (void *)&xAxisTicks);
}

void
AnnotationAttributes::SetYAxisTicks(bool yAxisTicks_)
{
    yAxisTicks = yAxisTicks_;
    Select(39, (void *)&yAxisTicks);
}

void
AnnotationAttributes::SetZAxisTicks(bool zAxisTicks_)
{
    zAxisTicks = zAxisTicks_;
    Select(40, (void *)&zAxisTicks);
}

void
AnnotationAttributes::SetXMajorTickMinimum(double xMajorTickMinimum_)
{
    xMajorTickMinimum = xMajorTickMinimum_;
    Select(41, (void *)&xMajorTickMinimum);
}

void
AnnotationAttributes::SetYMajorTickMinimum(double yMajorTickMinimum_)
{
    yMajorTickMinimum = yMajorTickMinimum_;
    Select(42, (void *)&yMajorTickMinimum);
}

void
AnnotationAttributes::SetZMajorTickMinimum(double zMajorTickMinimum_)
{
    zMajorTickMinimum = zMajorTickMinimum_;
    Select(43, (void *)&zMajorTickMinimum);
}

void
AnnotationAttributes::SetXMajorTickMaximum(double xMajorTickMaximum_)
{
    xMajorTickMaximum = xMajorTickMaximum_;
    Select(44, (void *)&xMajorTickMaximum);
}

void
AnnotationAttributes::SetYMajorTickMaximum(double yMajorTickMaximum_)
{
    yMajorTickMaximum = yMajorTickMaximum_;
    Select(45, (void *)&yMajorTickMaximum);
}

void
AnnotationAttributes::SetZMajorTickMaximum(double zMajorTickMaximum_)
{
    zMajorTickMaximum = zMajorTickMaximum_;
    Select(46, (void *)&zMajorTickMaximum);
}

void
AnnotationAttributes::SetXMajorTickSpacing(double xMajorTickSpacing_)
{
    xMajorTickSpacing = xMajorTickSpacing_;
    Select(47, (void *)&xMajorTickSpacing);
}

void
AnnotationAttributes::SetYMajorTickSpacing(double yMajorTickSpacing_)
{
    yMajorTickSpacing = yMajorTickSpacing_;
    Select(48, (void *)&yMajorTickSpacing);
}

void
AnnotationAttributes::SetZMajorTickSpacing(double zMajorTickSpacing_)
{
    zMajorTickSpacing = zMajorTickSpacing_;
    Select(49, (void *)&zMajorTickSpacing);
}

void
AnnotationAttributes::SetXMinorTickSpacing(double xMinorTickSpacing_)
{
    xMinorTickSpacing = xMinorTickSpacing_;
    Select(50, (void *)&xMinorTickSpacing);
}

void
AnnotationAttributes::SetYMinorTickSpacing(double yMinorTickSpacing_)
{
    yMinorTickSpacing = yMinorTickSpacing_;
    Select(51, (void *)&yMinorTickSpacing);
}

void
AnnotationAttributes::SetZMinorTickSpacing(double zMinorTickSpacing_)
{
    zMinorTickSpacing = zMinorTickSpacing_;
    Select(52, (void *)&zMinorTickSpacing);
}

void
AnnotationAttributes::SetXLabelFontHeight(double xLabelFontHeight_)
{
    xLabelFontHeight = xLabelFontHeight_;
    Select(53, (void *)&xLabelFontHeight);
}

void
AnnotationAttributes::SetYLabelFontHeight(double yLabelFontHeight_)
{
    yLabelFontHeight = yLabelFontHeight_;
    Select(54, (void *)&yLabelFontHeight);
}

void
AnnotationAttributes::SetZLabelFontHeight(double zLabelFontHeight_)
{
    zLabelFontHeight = zLabelFontHeight_;
    Select(55, (void *)&zLabelFontHeight);
}

void
AnnotationAttributes::SetXTitleFontHeight(double xTitleFontHeight_)
{
    xTitleFontHeight = xTitleFontHeight_;
    Select(56, (void *)&xTitleFontHeight);
}

void
AnnotationAttributes::SetYTitleFontHeight(double yTitleFontHeight_)
{
    yTitleFontHeight = yTitleFontHeight_;
    Select(57, (void *)&yTitleFontHeight);
}

void
AnnotationAttributes::SetZTitleFontHeight(double zTitleFontHeight_)
{
    zTitleFontHeight = zTitleFontHeight_;
    Select(58, (void *)&zTitleFontHeight);
}

void
AnnotationAttributes::SetXLabelScaling(int xLabelScaling_)
{
    xLabelScaling = xLabelScaling_;
    Select(59, (void *)&xLabelScaling);
}

void
AnnotationAttributes::SetYLabelScaling(int yLabelScaling_)
{
    yLabelScaling = yLabelScaling_;
    Select(60, (void *)&yLabelScaling);
}

void
AnnotationAttributes::SetZLabelScaling(int zLabelScaling_)
{
    zLabelScaling = zLabelScaling_;
    Select(61, (void *)&zLabelScaling);
}

void
AnnotationAttributes::SetAxesTickLocation(AnnotationAttributes::Location axesTickLocation_)
{
    axesTickLocation = axesTickLocation_;
    Select(62, (void *)&axesTickLocation);
}

void
AnnotationAttributes::SetAxesType(AnnotationAttributes::Axes axesType_)
{
    axesType = axesType_;
    Select(63, (void *)&axesType);
}

void
AnnotationAttributes::SetTriadFlag(bool triadFlag_)
{
    triadFlag = triadFlag_;
    Select(64, (void *)&triadFlag);
}

void
AnnotationAttributes::SetBboxFlag(bool bboxFlag_)
{
    bboxFlag = bboxFlag_;
    Select(65, (void *)&bboxFlag);
}

void
AnnotationAttributes::SetBackgroundColor(const ColorAttribute &backgroundColor_)
{
    backgroundColor = backgroundColor_;
    Select(66, (void *)&backgroundColor);
}

void
AnnotationAttributes::SetForegroundColor(const ColorAttribute &foregroundColor_)
{
    foregroundColor = foregroundColor_;
    Select(67, (void *)&foregroundColor);
}

void
AnnotationAttributes::SetGradientBackgroundStyle(AnnotationAttributes::GradientStyle gradientBackgroundStyle_)
{
    gradientBackgroundStyle = gradientBackgroundStyle_;
    Select(68, (void *)&gradientBackgroundStyle);
}

void
AnnotationAttributes::SetGradientColor1(const ColorAttribute &gradientColor1_)
{
    gradientColor1 = gradientColor1_;
    Select(69, (void *)&gradientColor1);
}

void
AnnotationAttributes::SetGradientColor2(const ColorAttribute &gradientColor2_)
{
    gradientColor2 = gradientColor2_;
    Select(70, (void *)&gradientColor2);
}

void
AnnotationAttributes::SetBackgroundMode(AnnotationAttributes::BackgroundMode backgroundMode_)
{
    backgroundMode = backgroundMode_;
    Select(71, (void *)&backgroundMode);
}

void
AnnotationAttributes::SetUserInfoFlag(bool userInfoFlag_)
{
    userInfoFlag = userInfoFlag_;
    Select(72, (void *)&userInfoFlag);
}

void
AnnotationAttributes::SetDatabaseInfoFlag(bool databaseInfoFlag_)
{
    databaseInfoFlag = databaseInfoFlag_;
    Select(73, (void *)&databaseInfoFlag);
}

void
AnnotationAttributes::SetLegendInfoFlag(bool legendInfoFlag_)
{
    legendInfoFlag = legendInfoFlag_;
    Select(74, (void *)&legendInfoFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AnnotationAttributes::GetAxesFlag2D() const
{
    return axesFlag2D;
}

bool
AnnotationAttributes::GetAxesAutoSetTicks2D() const
{
    return axesAutoSetTicks2D;
}

bool
AnnotationAttributes::GetLabelAutoSetScaling2D() const
{
    return labelAutoSetScaling2D;
}

bool
AnnotationAttributes::GetXAxisLabels2D() const
{
    return xAxisLabels2D;
}

bool
AnnotationAttributes::GetYAxisLabels2D() const
{
    return yAxisLabels2D;
}

bool
AnnotationAttributes::GetXAxisTitle2D() const
{
    return xAxisTitle2D;
}

bool
AnnotationAttributes::GetYAxisTitle2D() const
{
    return yAxisTitle2D;
}

bool
AnnotationAttributes::GetXGridLines2D() const
{
    return xGridLines2D;
}

bool
AnnotationAttributes::GetYGridLines2D() const
{
    return yGridLines2D;
}

double
AnnotationAttributes::GetXMajorTickMinimum2D() const
{
    return xMajorTickMinimum2D;
}

double
AnnotationAttributes::GetYMajorTickMinimum2D() const
{
    return yMajorTickMinimum2D;
}

double
AnnotationAttributes::GetXMajorTickMaximum2D() const
{
    return xMajorTickMaximum2D;
}

double
AnnotationAttributes::GetYMajorTickMaximum2D() const
{
    return yMajorTickMaximum2D;
}

double
AnnotationAttributes::GetXMajorTickSpacing2D() const
{
    return xMajorTickSpacing2D;
}

double
AnnotationAttributes::GetYMajorTickSpacing2D() const
{
    return yMajorTickSpacing2D;
}

double
AnnotationAttributes::GetXMinorTickSpacing2D() const
{
    return xMinorTickSpacing2D;
}

double
AnnotationAttributes::GetYMinorTickSpacing2D() const
{
    return yMinorTickSpacing2D;
}

double
AnnotationAttributes::GetXLabelFontHeight2D() const
{
    return xLabelFontHeight2D;
}

double
AnnotationAttributes::GetYLabelFontHeight2D() const
{
    return yLabelFontHeight2D;
}

double
AnnotationAttributes::GetXTitleFontHeight2D() const
{
    return xTitleFontHeight2D;
}

double
AnnotationAttributes::GetYTitleFontHeight2D() const
{
    return yTitleFontHeight2D;
}

int
AnnotationAttributes::GetXLabelScaling2D() const
{
    return xLabelScaling2D;
}

int
AnnotationAttributes::GetYLabelScaling2D() const
{
    return yLabelScaling2D;
}

int
AnnotationAttributes::GetAxesLineWidth2D() const
{
    return axesLineWidth2D;
}

AnnotationAttributes::Location
AnnotationAttributes::GetAxesTickLocation2D() const
{
    return Location(axesTickLocation2D);
}

AnnotationAttributes::Ticks
AnnotationAttributes::GetAxesTicks2D() const
{
    return Ticks(axesTicks2D);
}

bool
AnnotationAttributes::GetAxesFlag() const
{
    return axesFlag;
}

bool
AnnotationAttributes::GetAxesAutoSetTicks() const
{
    return axesAutoSetTicks;
}

bool
AnnotationAttributes::GetLabelAutoSetScaling() const
{
    return labelAutoSetScaling;
}

bool
AnnotationAttributes::GetXAxisLabels() const
{
    return xAxisLabels;
}

bool
AnnotationAttributes::GetYAxisLabels() const
{
    return yAxisLabels;
}

bool
AnnotationAttributes::GetZAxisLabels() const
{
    return zAxisLabels;
}

bool
AnnotationAttributes::GetXAxisTitle() const
{
    return xAxisTitle;
}

bool
AnnotationAttributes::GetYAxisTitle() const
{
    return yAxisTitle;
}

bool
AnnotationAttributes::GetZAxisTitle() const
{
    return zAxisTitle;
}

bool
AnnotationAttributes::GetXGridLines() const
{
    return xGridLines;
}

bool
AnnotationAttributes::GetYGridLines() const
{
    return yGridLines;
}

bool
AnnotationAttributes::GetZGridLines() const
{
    return zGridLines;
}

bool
AnnotationAttributes::GetXAxisTicks() const
{
    return xAxisTicks;
}

bool
AnnotationAttributes::GetYAxisTicks() const
{
    return yAxisTicks;
}

bool
AnnotationAttributes::GetZAxisTicks() const
{
    return zAxisTicks;
}

double
AnnotationAttributes::GetXMajorTickMinimum() const
{
    return xMajorTickMinimum;
}

double
AnnotationAttributes::GetYMajorTickMinimum() const
{
    return yMajorTickMinimum;
}

double
AnnotationAttributes::GetZMajorTickMinimum() const
{
    return zMajorTickMinimum;
}

double
AnnotationAttributes::GetXMajorTickMaximum() const
{
    return xMajorTickMaximum;
}

double
AnnotationAttributes::GetYMajorTickMaximum() const
{
    return yMajorTickMaximum;
}

double
AnnotationAttributes::GetZMajorTickMaximum() const
{
    return zMajorTickMaximum;
}

double
AnnotationAttributes::GetXMajorTickSpacing() const
{
    return xMajorTickSpacing;
}

double
AnnotationAttributes::GetYMajorTickSpacing() const
{
    return yMajorTickSpacing;
}

double
AnnotationAttributes::GetZMajorTickSpacing() const
{
    return zMajorTickSpacing;
}

double
AnnotationAttributes::GetXMinorTickSpacing() const
{
    return xMinorTickSpacing;
}

double
AnnotationAttributes::GetYMinorTickSpacing() const
{
    return yMinorTickSpacing;
}

double
AnnotationAttributes::GetZMinorTickSpacing() const
{
    return zMinorTickSpacing;
}

double
AnnotationAttributes::GetXLabelFontHeight() const
{
    return xLabelFontHeight;
}

double
AnnotationAttributes::GetYLabelFontHeight() const
{
    return yLabelFontHeight;
}

double
AnnotationAttributes::GetZLabelFontHeight() const
{
    return zLabelFontHeight;
}

double
AnnotationAttributes::GetXTitleFontHeight() const
{
    return xTitleFontHeight;
}

double
AnnotationAttributes::GetYTitleFontHeight() const
{
    return yTitleFontHeight;
}

double
AnnotationAttributes::GetZTitleFontHeight() const
{
    return zTitleFontHeight;
}

int
AnnotationAttributes::GetXLabelScaling() const
{
    return xLabelScaling;
}

int
AnnotationAttributes::GetYLabelScaling() const
{
    return yLabelScaling;
}

int
AnnotationAttributes::GetZLabelScaling() const
{
    return zLabelScaling;
}

AnnotationAttributes::Location
AnnotationAttributes::GetAxesTickLocation() const
{
    return Location(axesTickLocation);
}

AnnotationAttributes::Axes
AnnotationAttributes::GetAxesType() const
{
    return Axes(axesType);
}

bool
AnnotationAttributes::GetTriadFlag() const
{
    return triadFlag;
}

bool
AnnotationAttributes::GetBboxFlag() const
{
    return bboxFlag;
}

const ColorAttribute &
AnnotationAttributes::GetBackgroundColor() const
{
    return backgroundColor;
}

ColorAttribute &
AnnotationAttributes::GetBackgroundColor()
{
    return backgroundColor;
}

const ColorAttribute &
AnnotationAttributes::GetForegroundColor() const
{
    return foregroundColor;
}

ColorAttribute &
AnnotationAttributes::GetForegroundColor()
{
    return foregroundColor;
}

AnnotationAttributes::GradientStyle
AnnotationAttributes::GetGradientBackgroundStyle() const
{
    return GradientStyle(gradientBackgroundStyle);
}

const ColorAttribute &
AnnotationAttributes::GetGradientColor1() const
{
    return gradientColor1;
}

ColorAttribute &
AnnotationAttributes::GetGradientColor1()
{
    return gradientColor1;
}

const ColorAttribute &
AnnotationAttributes::GetGradientColor2() const
{
    return gradientColor2;
}

ColorAttribute &
AnnotationAttributes::GetGradientColor2()
{
    return gradientColor2;
}

AnnotationAttributes::BackgroundMode
AnnotationAttributes::GetBackgroundMode() const
{
    return BackgroundMode(backgroundMode);
}

bool
AnnotationAttributes::GetUserInfoFlag() const
{
    return userInfoFlag;
}

bool
AnnotationAttributes::GetDatabaseInfoFlag() const
{
    return databaseInfoFlag;
}

bool
AnnotationAttributes::GetLegendInfoFlag() const
{
    return legendInfoFlag;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationAttributes::SelectBackgroundColor()
{
    Select(66, (void *)&backgroundColor);
}

void
AnnotationAttributes::SelectForegroundColor()
{
    Select(67, (void *)&foregroundColor);
}

void
AnnotationAttributes::SelectGradientColor1()
{
    Select(69, (void *)&gradientColor1);
}

void
AnnotationAttributes::SelectGradientColor2()
{
    Select(70, (void *)&gradientColor2);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "axesFlag2D";
        case 1:  return "axesAutoSetTicks2D";
        case 2:  return "labelAutoSetScaling2D";
        case 3:  return "xAxisLabels2D";
        case 4:  return "yAxisLabels2D";
        case 5:  return "xAxisTitle2D";
        case 6:  return "yAxisTitle2D";
        case 7:  return "xGridLines2D";
        case 8:  return "yGridLines2D";
        case 9:  return "xMajorTickMinimum2D";
        case 10:  return "yMajorTickMinimum2D";
        case 11:  return "xMajorTickMaximum2D";
        case 12:  return "yMajorTickMaximum2D";
        case 13:  return "xMajorTickSpacing2D";
        case 14:  return "yMajorTickSpacing2D";
        case 15:  return "xMinorTickSpacing2D";
        case 16:  return "yMinorTickSpacing2D";
        case 17:  return "xLabelFontHeight2D";
        case 18:  return "yLabelFontHeight2D";
        case 19:  return "xTitleFontHeight2D";
        case 20:  return "yTitleFontHeight2D";
        case 21:  return "xLabelScaling2D";
        case 22:  return "yLabelScaling2D";
        case 23:  return "axesLineWidth2D";
        case 24:  return "axesTickLocation2D";
        case 25:  return "axesTicks2D";
        case 26:  return "axesFlag";
        case 27:  return "axesAutoSetTicks";
        case 28:  return "labelAutoSetScaling";
        case 29:  return "xAxisLabels";
        case 30:  return "yAxisLabels";
        case 31:  return "zAxisLabels";
        case 32:  return "xAxisTitle";
        case 33:  return "yAxisTitle";
        case 34:  return "zAxisTitle";
        case 35:  return "xGridLines";
        case 36:  return "yGridLines";
        case 37:  return "zGridLines";
        case 38:  return "xAxisTicks";
        case 39:  return "yAxisTicks";
        case 40:  return "zAxisTicks";
        case 41:  return "xMajorTickMinimum";
        case 42:  return "yMajorTickMinimum";
        case 43:  return "zMajorTickMinimum";
        case 44:  return "xMajorTickMaximum";
        case 45:  return "yMajorTickMaximum";
        case 46:  return "zMajorTickMaximum";
        case 47:  return "xMajorTickSpacing";
        case 48:  return "yMajorTickSpacing";
        case 49:  return "zMajorTickSpacing";
        case 50:  return "xMinorTickSpacing";
        case 51:  return "yMinorTickSpacing";
        case 52:  return "zMinorTickSpacing";
        case 53:  return "xLabelFontHeight";
        case 54:  return "yLabelFontHeight";
        case 55:  return "zLabelFontHeight";
        case 56:  return "xTitleFontHeight";
        case 57:  return "yTitleFontHeight";
        case 58:  return "zTitleFontHeight";
        case 59:  return "xLabelScaling";
        case 60:  return "yLabelScaling";
        case 61:  return "zLabelScaling";
        case 62:  return "axesTickLocation";
        case 63:  return "axesType";
        case 64:  return "triadFlag";
        case 65:  return "bboxFlag";
        case 66:  return "backgroundColor";
        case 67:  return "foregroundColor";
        case 68:  return "gradientBackgroundStyle";
        case 69:  return "gradientColor1";
        case 70:  return "gradientColor2";
        case 71:  return "backgroundMode";
        case 72:  return "userInfoFlag";
        case 73:  return "databaseInfoFlag";
        case 74:  return "legendInfoFlag";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnnotationAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_bool;
        case 9:  return FieldType_double;
        case 10:  return FieldType_double;
        case 11:  return FieldType_double;
        case 12:  return FieldType_double;
        case 13:  return FieldType_double;
        case 14:  return FieldType_double;
        case 15:  return FieldType_double;
        case 16:  return FieldType_double;
        case 17:  return FieldType_double;
        case 18:  return FieldType_double;
        case 19:  return FieldType_double;
        case 20:  return FieldType_double;
        case 21:  return FieldType_int;
        case 22:  return FieldType_int;
        case 23:  return FieldType_linewidth;
        case 24:  return FieldType_enum;
        case 25:  return FieldType_enum;
        case 26:  return FieldType_bool;
        case 27:  return FieldType_bool;
        case 28:  return FieldType_bool;
        case 29:  return FieldType_bool;
        case 30:  return FieldType_bool;
        case 31:  return FieldType_bool;
        case 32:  return FieldType_bool;
        case 33:  return FieldType_bool;
        case 34:  return FieldType_bool;
        case 35:  return FieldType_bool;
        case 36:  return FieldType_bool;
        case 37:  return FieldType_bool;
        case 38:  return FieldType_bool;
        case 39:  return FieldType_bool;
        case 40:  return FieldType_bool;
        case 41:  return FieldType_double;
        case 42:  return FieldType_double;
        case 43:  return FieldType_double;
        case 44:  return FieldType_double;
        case 45:  return FieldType_double;
        case 46:  return FieldType_double;
        case 47:  return FieldType_double;
        case 48:  return FieldType_double;
        case 49:  return FieldType_double;
        case 50:  return FieldType_double;
        case 51:  return FieldType_double;
        case 52:  return FieldType_double;
        case 53:  return FieldType_double;
        case 54:  return FieldType_double;
        case 55:  return FieldType_double;
        case 56:  return FieldType_double;
        case 57:  return FieldType_double;
        case 58:  return FieldType_double;
        case 59:  return FieldType_int;
        case 60:  return FieldType_int;
        case 61:  return FieldType_int;
        case 62:  return FieldType_enum;
        case 63:  return FieldType_enum;
        case 64:  return FieldType_bool;
        case 65:  return FieldType_bool;
        case 66:  return FieldType_color;
        case 67:  return FieldType_color;
        case 68:  return FieldType_enum;
        case 69:  return FieldType_color;
        case 70:  return FieldType_color;
        case 71:  return FieldType_enum;
        case 72:  return FieldType_bool;
        case 73:  return FieldType_bool;
        case 74:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnnotationAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "bool";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "bool";
        case 9:  return "double";
        case 10:  return "double";
        case 11:  return "double";
        case 12:  return "double";
        case 13:  return "double";
        case 14:  return "double";
        case 15:  return "double";
        case 16:  return "double";
        case 17:  return "double";
        case 18:  return "double";
        case 19:  return "double";
        case 20:  return "double";
        case 21:  return "int";
        case 22:  return "int";
        case 23:  return "linewidth";
        case 24:  return "enum";
        case 25:  return "enum";
        case 26:  return "bool";
        case 27:  return "bool";
        case 28:  return "bool";
        case 29:  return "bool";
        case 30:  return "bool";
        case 31:  return "bool";
        case 32:  return "bool";
        case 33:  return "bool";
        case 34:  return "bool";
        case 35:  return "bool";
        case 36:  return "bool";
        case 37:  return "bool";
        case 38:  return "bool";
        case 39:  return "bool";
        case 40:  return "bool";
        case 41:  return "double";
        case 42:  return "double";
        case 43:  return "double";
        case 44:  return "double";
        case 45:  return "double";
        case 46:  return "double";
        case 47:  return "double";
        case 48:  return "double";
        case 49:  return "double";
        case 50:  return "double";
        case 51:  return "double";
        case 52:  return "double";
        case 53:  return "double";
        case 54:  return "double";
        case 55:  return "double";
        case 56:  return "double";
        case 57:  return "double";
        case 58:  return "double";
        case 59:  return "int";
        case 60:  return "int";
        case 61:  return "int";
        case 62:  return "enum";
        case 63:  return "enum";
        case 64:  return "bool";
        case 65:  return "bool";
        case 66:  return "color";
        case 67:  return "color";
        case 68:  return "enum";
        case 69:  return "color";
        case 70:  return "color";
        case 71:  return "enum";
        case 72:  return "bool";
        case 73:  return "bool";
        case 74:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Nov 11 16:31:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AnnotationAttributes &obj = *((const AnnotationAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (axesFlag2D == obj.axesFlag2D);
        }
        break;
    case 1:
        {  // new scope
        retval = (axesAutoSetTicks2D == obj.axesAutoSetTicks2D);
        }
        break;
    case 2:
        {  // new scope
        retval = (labelAutoSetScaling2D == obj.labelAutoSetScaling2D);
        }
        break;
    case 3:
        {  // new scope
        retval = (xAxisLabels2D == obj.xAxisLabels2D);
        }
        break;
    case 4:
        {  // new scope
        retval = (yAxisLabels2D == obj.yAxisLabels2D);
        }
        break;
    case 5:
        {  // new scope
        retval = (xAxisTitle2D == obj.xAxisTitle2D);
        }
        break;
    case 6:
        {  // new scope
        retval = (yAxisTitle2D == obj.yAxisTitle2D);
        }
        break;
    case 7:
        {  // new scope
        retval = (xGridLines2D == obj.xGridLines2D);
        }
        break;
    case 8:
        {  // new scope
        retval = (yGridLines2D == obj.yGridLines2D);
        }
        break;
    case 9:
        {  // new scope
        retval = (xMajorTickMinimum2D == obj.xMajorTickMinimum2D);
        }
        break;
    case 10:
        {  // new scope
        retval = (yMajorTickMinimum2D == obj.yMajorTickMinimum2D);
        }
        break;
    case 11:
        {  // new scope
        retval = (xMajorTickMaximum2D == obj.xMajorTickMaximum2D);
        }
        break;
    case 12:
        {  // new scope
        retval = (yMajorTickMaximum2D == obj.yMajorTickMaximum2D);
        }
        break;
    case 13:
        {  // new scope
        retval = (xMajorTickSpacing2D == obj.xMajorTickSpacing2D);
        }
        break;
    case 14:
        {  // new scope
        retval = (yMajorTickSpacing2D == obj.yMajorTickSpacing2D);
        }
        break;
    case 15:
        {  // new scope
        retval = (xMinorTickSpacing2D == obj.xMinorTickSpacing2D);
        }
        break;
    case 16:
        {  // new scope
        retval = (yMinorTickSpacing2D == obj.yMinorTickSpacing2D);
        }
        break;
    case 17:
        {  // new scope
        retval = (xLabelFontHeight2D == obj.xLabelFontHeight2D);
        }
        break;
    case 18:
        {  // new scope
        retval = (yLabelFontHeight2D == obj.yLabelFontHeight2D);
        }
        break;
    case 19:
        {  // new scope
        retval = (xTitleFontHeight2D == obj.xTitleFontHeight2D);
        }
        break;
    case 20:
        {  // new scope
        retval = (yTitleFontHeight2D == obj.yTitleFontHeight2D);
        }
        break;
    case 21:
        {  // new scope
        retval = (xLabelScaling2D == obj.xLabelScaling2D);
        }
        break;
    case 22:
        {  // new scope
        retval = (yLabelScaling2D == obj.yLabelScaling2D);
        }
        break;
    case 23:
        {  // new scope
        retval = (axesLineWidth2D == obj.axesLineWidth2D);
        }
        break;
    case 24:
        {  // new scope
        retval = (axesTickLocation2D == obj.axesTickLocation2D);
        }
        break;
    case 25:
        {  // new scope
        retval = (axesTicks2D == obj.axesTicks2D);
        }
        break;
    case 26:
        {  // new scope
        retval = (axesFlag == obj.axesFlag);
        }
        break;
    case 27:
        {  // new scope
        retval = (axesAutoSetTicks == obj.axesAutoSetTicks);
        }
        break;
    case 28:
        {  // new scope
        retval = (labelAutoSetScaling == obj.labelAutoSetScaling);
        }
        break;
    case 29:
        {  // new scope
        retval = (xAxisLabels == obj.xAxisLabels);
        }
        break;
    case 30:
        {  // new scope
        retval = (yAxisLabels == obj.yAxisLabels);
        }
        break;
    case 31:
        {  // new scope
        retval = (zAxisLabels == obj.zAxisLabels);
        }
        break;
    case 32:
        {  // new scope
        retval = (xAxisTitle == obj.xAxisTitle);
        }
        break;
    case 33:
        {  // new scope
        retval = (yAxisTitle == obj.yAxisTitle);
        }
        break;
    case 34:
        {  // new scope
        retval = (zAxisTitle == obj.zAxisTitle);
        }
        break;
    case 35:
        {  // new scope
        retval = (xGridLines == obj.xGridLines);
        }
        break;
    case 36:
        {  // new scope
        retval = (yGridLines == obj.yGridLines);
        }
        break;
    case 37:
        {  // new scope
        retval = (zGridLines == obj.zGridLines);
        }
        break;
    case 38:
        {  // new scope
        retval = (xAxisTicks == obj.xAxisTicks);
        }
        break;
    case 39:
        {  // new scope
        retval = (yAxisTicks == obj.yAxisTicks);
        }
        break;
    case 40:
        {  // new scope
        retval = (zAxisTicks == obj.zAxisTicks);
        }
        break;
    case 41:
        {  // new scope
        retval = (xMajorTickMinimum == obj.xMajorTickMinimum);
        }
        break;
    case 42:
        {  // new scope
        retval = (yMajorTickMinimum == obj.yMajorTickMinimum);
        }
        break;
    case 43:
        {  // new scope
        retval = (zMajorTickMinimum == obj.zMajorTickMinimum);
        }
        break;
    case 44:
        {  // new scope
        retval = (xMajorTickMaximum == obj.xMajorTickMaximum);
        }
        break;
    case 45:
        {  // new scope
        retval = (yMajorTickMaximum == obj.yMajorTickMaximum);
        }
        break;
    case 46:
        {  // new scope
        retval = (zMajorTickMaximum == obj.zMajorTickMaximum);
        }
        break;
    case 47:
        {  // new scope
        retval = (xMajorTickSpacing == obj.xMajorTickSpacing);
        }
        break;
    case 48:
        {  // new scope
        retval = (yMajorTickSpacing == obj.yMajorTickSpacing);
        }
        break;
    case 49:
        {  // new scope
        retval = (zMajorTickSpacing == obj.zMajorTickSpacing);
        }
        break;
    case 50:
        {  // new scope
        retval = (xMinorTickSpacing == obj.xMinorTickSpacing);
        }
        break;
    case 51:
        {  // new scope
        retval = (yMinorTickSpacing == obj.yMinorTickSpacing);
        }
        break;
    case 52:
        {  // new scope
        retval = (zMinorTickSpacing == obj.zMinorTickSpacing);
        }
        break;
    case 53:
        {  // new scope
        retval = (xLabelFontHeight == obj.xLabelFontHeight);
        }
        break;
    case 54:
        {  // new scope
        retval = (yLabelFontHeight == obj.yLabelFontHeight);
        }
        break;
    case 55:
        {  // new scope
        retval = (zLabelFontHeight == obj.zLabelFontHeight);
        }
        break;
    case 56:
        {  // new scope
        retval = (xTitleFontHeight == obj.xTitleFontHeight);
        }
        break;
    case 57:
        {  // new scope
        retval = (yTitleFontHeight == obj.yTitleFontHeight);
        }
        break;
    case 58:
        {  // new scope
        retval = (zTitleFontHeight == obj.zTitleFontHeight);
        }
        break;
    case 59:
        {  // new scope
        retval = (xLabelScaling == obj.xLabelScaling);
        }
        break;
    case 60:
        {  // new scope
        retval = (yLabelScaling == obj.yLabelScaling);
        }
        break;
    case 61:
        {  // new scope
        retval = (zLabelScaling == obj.zLabelScaling);
        }
        break;
    case 62:
        {  // new scope
        retval = (axesTickLocation == obj.axesTickLocation);
        }
        break;
    case 63:
        {  // new scope
        retval = (axesType == obj.axesType);
        }
        break;
    case 64:
        {  // new scope
        retval = (triadFlag == obj.triadFlag);
        }
        break;
    case 65:
        {  // new scope
        retval = (bboxFlag == obj.bboxFlag);
        }
        break;
    case 66:
        {  // new scope
        retval = (backgroundColor == obj.backgroundColor);
        }
        break;
    case 67:
        {  // new scope
        retval = (foregroundColor == obj.foregroundColor);
        }
        break;
    case 68:
        {  // new scope
        retval = (gradientBackgroundStyle == obj.gradientBackgroundStyle);
        }
        break;
    case 69:
        {  // new scope
        retval = (gradientColor1 == obj.gradientColor1);
        }
        break;
    case 70:
        {  // new scope
        retval = (gradientColor2 == obj.gradientColor2);
        }
        break;
    case 71:
        {  // new scope
        retval = (backgroundMode == obj.backgroundMode);
        }
        break;
    case 72:
        {  // new scope
        retval = (userInfoFlag == obj.userInfoFlag);
        }
        break;
    case 73:
        {  // new scope
        retval = (databaseInfoFlag == obj.databaseInfoFlag);
        }
        break;
    case 74:
        {  // new scope
        retval = (legendInfoFlag == obj.legendInfoFlag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// Returns a "discernible" background color. If the background mode
// is Solid, the returned value is just the background color. If the
// background mode is Gradient, the returned color is an average of
// the two gradient colors
const ColorAttribute AnnotationAttributes::GetDiscernibleBackgroundColor() const
{
    ColorAttribute retval;
    double bg[4];

    if (GetBackgroundMode() == Solid)
    {
        GetBackgroundColor().GetRgba(bg);
    }
    else
    {
        double gbg1[4], gbg2[4];

        GetGradientColor1().GetRgba(gbg1);
        GetGradientColor2().GetRgba(gbg2);

        bg[0] = (gbg1[0] + gbg2[0]) * 0.5;
        bg[1] = (gbg1[1] + gbg2[1]) * 0.5;
        bg[2] = (gbg1[2] + gbg2[2]) * 0.5;
        bg[3] = (gbg1[3] + gbg2[3]) * 0.5;
    }

    retval.SetRgba2(bg);

    return retval;
}

