#include <AnimationAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for AnimationAttributes::PlaybackMode
//

static const char *PlaybackMode_strings[] = {
"Looping", "PlayOnce", "Swing"
};

std::string
AnimationAttributes::PlaybackMode_ToString(AnimationAttributes::PlaybackMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return PlaybackMode_strings[index];
}

std::string
AnimationAttributes::PlaybackMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return PlaybackMode_strings[index];
}

bool
AnimationAttributes::PlaybackMode_FromString(const std::string &s, AnimationAttributes::PlaybackMode &val)
{
    val = AnimationAttributes::Looping;
    for(int i = 0; i < 3; ++i)
    {
        if(s == PlaybackMode_strings[i])
        {
            val = (PlaybackMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Constructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes() : AttributeSubject("bii")
{
    pipelineCachingMode = false;
    timeout = 1;
    playbackMode = Looping;
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Copy constructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes(const AnimationAttributes &obj) : AttributeSubject("bii")
{
    pipelineCachingMode = obj.pipelineCachingMode;
    timeout = obj.timeout;
    playbackMode = obj.playbackMode;

    SelectAll();
}

// ****************************************************************************
// Method: AnimationAttributes::~AnimationAttributes
//
// Purpose: 
//   Destructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::~AnimationAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AnimationAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes& 
AnimationAttributes::operator = (const AnimationAttributes &obj)
{
    if (this == &obj) return *this;
    pipelineCachingMode = obj.pipelineCachingMode;
    timeout = obj.timeout;
    playbackMode = obj.playbackMode;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AnimationAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::operator == (const AnimationAttributes &obj) const
{
    // Create the return value
    return ((pipelineCachingMode == obj.pipelineCachingMode) &&
            (timeout == obj.timeout) &&
            (playbackMode == obj.playbackMode));
}

// ****************************************************************************
// Method: AnimationAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::operator != (const AnimationAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnimationAttributes::TypeName
//
// Purpose: 
//   Type name method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnimationAttributes::TypeName() const
{
    return "AnimationAttributes";
}

// ****************************************************************************
// Method: AnimationAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnimationAttributes *tmp = (const AnimationAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnimationAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnimationAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnimationAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnimationAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnimationAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnimationAttributes(*this);
    else
        retval = new AnimationAttributes;

    return retval;
}

// ****************************************************************************
// Method: AnimationAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
AnimationAttributes::SelectAll()
{
    Select(0, (void *)&pipelineCachingMode);
    Select(1, (void *)&timeout);
    Select(2, (void *)&playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnimationAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AnimationAttributes.
    DataNode *node = new DataNode("AnimationAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pipelineCachingMode", pipelineCachingMode));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeout", timeout));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("playbackMode", PlaybackMode_ToString(playbackMode)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnimationAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

void
AnimationAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnimationAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("pipelineCachingMode")) != 0)
        SetPipelineCachingMode(node->AsBool());
    if((node = searchNode->GetNode("timeout")) != 0)
        SetTimeout(node->AsInt());
    if((node = searchNode->GetNode("playbackMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetPlaybackMode(PlaybackMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PlaybackMode value;
            if(PlaybackMode_FromString(node->AsString(), value))
                SetPlaybackMode(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AnimationAttributes::SetPipelineCachingMode(bool pipelineCachingMode_)
{
    pipelineCachingMode = pipelineCachingMode_;
    Select(0, (void *)&pipelineCachingMode);
}

void
AnimationAttributes::SetTimeout(int timeout_)
{
    timeout = timeout_;
    Select(1, (void *)&timeout);
}

void
AnimationAttributes::SetPlaybackMode(AnimationAttributes::PlaybackMode playbackMode_)
{
    playbackMode = playbackMode_;
    Select(2, (void *)&playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AnimationAttributes::GetPipelineCachingMode() const
{
    return pipelineCachingMode;
}

int
AnimationAttributes::GetTimeout() const
{
    return timeout;
}

AnimationAttributes::PlaybackMode
AnimationAttributes::GetPlaybackMode() const
{
    return PlaybackMode(playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
AnimationAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "pipelineCachingMode";
        case 1:  return "timeout";
        case 2:  return "playbackMode";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnimationAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnimationAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_int;
        case 2:  return FieldType_enum;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnimationAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

std::string
AnimationAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "int";
        case 2:  return "enum";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnimationAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Jan 13 08:12:06 PDT 2005
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AnimationAttributes &obj = *((const AnimationAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (pipelineCachingMode == obj.pipelineCachingMode);
        }
        break;
    case 1:
        {  // new scope
        retval = (timeout == obj.timeout);
        }
        break;
    case 2:
        {  // new scope
        retval = (playbackMode == obj.playbackMode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::ProcessOldVersions
//
// Purpose: 
//   This method creates modifies a DataNode representation of the object
//   so it conforms to the newest representation of the object, which can
//   can be read back in.
//
// Programmer: Kathleen Bonnell 
// Creation:   January 12, 2005 
//
// Modifications:
//
// ****************************************************************************
void
AnimationAttributes::ProcessOldVersions(DataNode *parentNode,
                                       const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnimationAttributes");
    if(searchNode == 0)
        return;

    DataNode *pcNode = searchNode->GetNode("pipelineCachingMode");
    if (pcNode == 0)
        return;

    if (VersionLessThan(configVersion, "1.1.5"))
        searchNode->RemoveNode("pipelineCachingMode");
}

