#ifndef MinimalFEM_VTPWriter_h
#define MinimalFEM_VTPWriter_h

#include "MinimalFEM/XMLWriter.h"

#include <Eigen/Core>
#include <fstream>
#include <sstream>
#include <string>

namespace minimalfem
{

class VTPWriter
{
protected:
  std::ofstream m_outStream;
  XMLWriter m_xmlWriter;
  int m_numPoints;
  std::size_t m_numPolys;

public:
  VTPWriter(std::string outfile);
  ~VTPWriter();

  void beginPolyData(int numberPoints, int numberPolygons);
  void writeNodes(Eigen::VectorXf& nodesX, Eigen::VectorXf& nodesY);
  // void writePolys(int conn[])
  void writePolys(Eigen::VectorXi& conn);
  void writeDisplacementData(Eigen::VectorXf& displacement);
  void writeStressData(Eigen::VectorXf& stress);
  void endPolyData();
};

} // namespace minimalfem

#endif
