/*MinimalFEM

Author: Stanislav Pidhorskyi (Podgorskiy)
stanislav@podgorskiy.com
stpidhorskyi@mix.wvu.edu

The source code available here: https://github.com/podgorskiy/MinimalFEM/

The MIT License (MIT)

Copyright (c) 2015 Stanislav Pidhorskyi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.*/

#include "MinimalFEM/MinimalFEM.h"

#include <cctype>
#include <iostream>
#include <string>
#include <algorithm>

int main(int argc, char* argv[])
{
  if (argc < 3 || argc > 4)
  {
    std::cout << "usage: " << argv[0] << " <input file> <output file> <format(optional)>\n";
    return 1;
  }
  std::string inputFilename(argv[1]);
  std::string outputFilename(argv[2]);
  std::string format = "out";
  if (argc == 4)
  {
    format = argv[3];
    std::transform(format.begin(), format.end(), format.begin(), ::tolower);
    if (!(format == "out" || format == "vtp"))
    {
      std::cerr << "Unknown format: " << format << "\n\n";
      std::cerr << "Available formats:\n";
      std::cerr << "\t- out\n";
      std::cerr << "\t- vtp\n";
      return 1;
    }
  }

  return minimalfem::Solver(inputFilename, outputFilename, format);
}
