#[MinimalFEM](https://github.com/podgorskiy/MinimalFEM)
============================================================================

A minimal implementation of FEM.

![image1](https://raw.githubusercontent.com/podgorskiy/MinimalFEM/master/example.png)

## Build

Using CMake to build...

```
mkdir build
cd build
cmake -G Ninja ../
ninja
```

## Usage

#### Example using MinimalFEM only

```
MinimalFEM case.inp case.out
<MinimalFEM-source-path>/scripts/PostProcess.py case.inp case.out
eog initial.png  # View the initial conditions
eog deformed.png # View the deformed result
```

#### Example using ParaView

```
MinimalFEM case.inp case.vtp vtp
```

Open the output `cast.vtp` in ParaView directly

## Exported Targets

Export MinimalFEM::MinimalFEM as a library. It contains a public interface which defines the function `minimalfem::Solver`

```c++
int minimalfem::Solver(std::string inputFilename, std::string outputFilename, std::string format);
```

### Supported Output formats

#### MinimalFEM `out` format:

Contains stress values at each node. Requires the `inp` file for post-processing because it does not contain connectivity/spatial infomation.

#### VTK `vtp` format:

Contains both stress and connectivity infomation about the simulation. It can be post-processed by itself. It is natively recognized by ParaView and VTK readers.

## License

MinimalFEM is licensed under the MIT License.
