#ifndef MinimalFEM_XMLWriter_hpp
#define MinimalFEM_XMLWriter_hpp

#include <ostream>
#include <stack>
#include <string>

namespace minimalfem
{

class XMLWriter
{
public:
  XMLWriter(std::ostream& os);
  ~XMLWriter();

  XMLWriter& openElt(const char* tag);
  XMLWriter& closeElt();
  XMLWriter& closeAll();
  XMLWriter& attr(const char* key, const char* val);
  XMLWriter& attr(const char* key, std::string val);
  XMLWriter& content(const char* val);
  XMLWriter& writeContentLine(const char* val);

private:
  std::ostream& os;
  bool tag_open;
  bool new_line;
  std::stack<std::string> elt_stack;

  void closeTag();
  void indent();
  void write_escape(const char* str);
};

} // namespace minimalfem

#endif
