/*
 * Copyright (C) 2021 Alyssa Rosenzweig
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "agx_formats.h"

const enum agx_format
agx_vertex_format[PIPE_FORMAT_COUNT] = {
   [PIPE_FORMAT_R32_FLOAT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32_SINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32_UINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32_FLOAT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32_SINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32_UINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32_FLOAT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32_UINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32_SINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32A32_FLOAT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32A32_UINT] = AGX_FORMAT_I32,
   [PIPE_FORMAT_R32G32B32A32_SINT] = AGX_FORMAT_I32,

   [PIPE_FORMAT_R8_UNORM] = AGX_FORMAT_U8NORM,
   [PIPE_FORMAT_R8G8_UNORM] = AGX_FORMAT_U8NORM,
   [PIPE_FORMAT_R8G8B8_UNORM] = AGX_FORMAT_U8NORM,
   [PIPE_FORMAT_R8G8B8A8_UNORM] = AGX_FORMAT_U8NORM,

   [PIPE_FORMAT_R8_SNORM] = AGX_FORMAT_S8NORM,
   [PIPE_FORMAT_R8G8_SNORM] = AGX_FORMAT_S8NORM,
   [PIPE_FORMAT_R8G8B8_SNORM] = AGX_FORMAT_S8NORM,
   [PIPE_FORMAT_R8G8B8A8_SNORM] = AGX_FORMAT_S8NORM,

   [PIPE_FORMAT_R16_UNORM] = AGX_FORMAT_U16NORM,
   [PIPE_FORMAT_R16G16_UNORM] = AGX_FORMAT_U16NORM,
   [PIPE_FORMAT_R16G16B16_UNORM] = AGX_FORMAT_U16NORM,
   [PIPE_FORMAT_R16G16B16A16_UNORM] = AGX_FORMAT_U16NORM,

   [PIPE_FORMAT_R16_SNORM] = AGX_FORMAT_S16NORM,
   [PIPE_FORMAT_R16G16_SNORM] = AGX_FORMAT_S16NORM,
   [PIPE_FORMAT_R16G16B16_SNORM] = AGX_FORMAT_S16NORM,
   [PIPE_FORMAT_R16G16B16A16_SNORM] = AGX_FORMAT_S16NORM,
};
