// Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
// Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
// other details. No copyright assignment is required to contribute to Conduit.

//-----------------------------------------------------------------------------
///
/// file: conduit_blueprint_table_examples.cpp
///
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// std lib includes
//-----------------------------------------------------------------------------
// std lib includes will go here

//-----------------------------------------------------------------------------
// conduit includes
//-----------------------------------------------------------------------------
#include "conduit_blueprint_table_examples.hpp"

//-----------------------------------------------------------------------------
// -- begin conduit:: --
//-----------------------------------------------------------------------------
namespace conduit
{

//-----------------------------------------------------------------------------
// -- begin conduit::blueprint --
//-----------------------------------------------------------------------------
namespace blueprint
{

//-----------------------------------------------------------------------------
// -- begin conduit::table --
//-----------------------------------------------------------------------------
namespace table
{

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/// Methods that generate example tables.
//-----------------------------------------------------------------------------
namespace examples
{

void basic(conduit::index_t nx,
           conduit::index_t ny,
           conduit::index_t nz,
           conduit::Node &res)
{
    res.reset();
    nx = (nx < 1) ? 1 : nx;
    ny = (ny < 1) ? 1 : ny;
    nz = (nz < 1) ? 1 : nz;
    res["description"] = "This table was generated by conduit::blueprint::table::examples::basic.";
    const index_t npts = nx * ny * nz;

    // Allocate points
    {
        Schema s;
        s["x"].set(DataType::c_double(npts, sizeof(double)*0, sizeof(double)*3));
        s["y"].set(DataType::c_double(npts, sizeof(double)*1, sizeof(double)*3));
        s["z"].set(DataType::c_double(npts, sizeof(double)*2, sizeof(double)*3));
        res["values/points"].set(s);
    }

    // Set points
    {
        double *points = static_cast<double*>(res["values/points"].element_ptr(0));
        double *p = points;
        for(index_t k = 0; k < nz; k++)
        {
            for(index_t j = 0; j < ny; j++)
            {
                for(index_t i = 0; i < nx; i++)
                {
                    *p++ = static_cast<double>(i);
                    *p++ = static_cast<double>(j);
                    *p++ = static_cast<double>(k);
                }
            }
        }
    }

    // Create point_data
    {
        res["values/point_data"].set(DataType::c_int(npts));
        int *point_data = static_cast<int*>(res["values/point_data"].element_ptr(0));
        int *p = point_data;
        for(index_t i = 0; i < npts; i++)
        {
            *p++ = static_cast<int>(i);
        }
    }
}

//-----------------------------------------------------------------------------
}
//-----------------------------------------------------------------------------
// -- end conduit::blueprint::table::examples --
//-----------------------------------------------------------------------------

}
//-----------------------------------------------------------------------------
// -- end conduit::table --
//-----------------------------------------------------------------------------

}
//-----------------------------------------------------------------------------
// -- end conduit::blueprint --
//-----------------------------------------------------------------------------

}
//-----------------------------------------------------------------------------
// -- end conduit:: --
//-----------------------------------------------------------------------------
