macro(assert_get_targets_equal expected)
  get_targets(result ${ARGN})
  # One day, we may want to sort-then-compare.
  # It would be easy if we added a LISTEQUAL binary test.
  if(NOT result STREQUAL "${expected}")
    message(SEND_ERROR "${CMAKE_CURRENT_LIST_LINE}: get_targets(${ARGN}) == ${result}; expected ${expected}")
  endif()
endmacro()

set(export_set export1)

# Start with no targets.
assert_get_targets_equal("" EXPORT ${export_set})

# Add one target to the export set.
add_library(target1 INTERFACE)
install(TARGETS target1 EXPORT ${export_set})

assert_get_targets_equal("target1" EXPORT ${export_set})

# Create a target but to not add it to the export set yet.
add_library(target2 INTERFACE)

assert_get_targets_equal("target1" EXPORT ${export_set})

# Add the second target to the export set.
install(TARGETS target2 EXPORT ${export_set})

assert_get_targets_equal("target1;target2" EXPORT ${export_set})
