macro(assert_get_targets_equal expected)
  get_targets(result ${ARGN})
  list(JOIN ARGN " " args)
  if(NOT result STREQUAL "${expected}")
    message(SEND_ERROR "${CMAKE_CURRENT_LIST_LINE}: get_targets(${args}) == ${result}; expected ${expected}")
  endif()
endmacro()

assert_get_targets_equal("" DIRECTORY ${CMAKE_SOURCE_DIR})
assert_get_targets_equal("" DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})
assert_get_targets_equal("")

add_library(foo INTERFACE)

assert_get_targets_equal("foo" DIRECTORY ${CMAKE_SOURCE_DIR})
assert_get_targets_equal("foo" DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})
assert_get_targets_equal("foo")

add_subdirectory(subdir1)

assert_get_targets_equal("foo;subdir1_foo" DIRECTORY ${CMAKE_SOURCE_DIR})
assert_get_targets_equal("foo;subdir1_foo" DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})
assert_get_targets_equal("foo;subdir1_foo")
assert_get_targets_equal("subdir1_foo" DIRECTORY subdir1)
assert_get_targets_equal("subdir1_foo" DIRECTORY ${CMAKE_SOURCE_DIR}/subdir1)
assert_get_targets_equal("subdir1_foo" DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/subdir1)
