/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmGetTargetsCommand_h
#define cmGetTargetsCommand_h

// REVIEWER: Why is this necessary?
#include "cmConfigure.h" // IWYU pragma: keep

#include <string>
#include <vector>

#include "cmCommand.h"

class cmExecutionStatus;

/** \class cmGetTargetsCommand
 * \brief Returns a lists of targets
 *
 * get_targets(<variable> EXPORT <export>)
 *
 * cmGetTargetsCommand has one mode of operation for now:
 *
 * - Return the targets added to an export set.
 */
class cmGetTargetsCommand : public cmCommand
{
private:
  using args_t = std::vector<std::string>;

public:
  /**
   * This is a virtual constructor for the command.
   */
  cmCommand* Clone() override { return new cmGetTargetsCommand; }

  /**
   * This is called when the command is first encountered in
   * the CMakeLists.txt file.
   */
  bool InitialPass(args_t const& args, cmExecutionStatus& status) override;

private:
  bool GetTargetsFromDirectory(args_t const& args);
  bool GetTargetsFromExportSet(args_t const& args);
};

#endif
