/*=========================================================================

  Program:   ParaView
  Module:    vtkPVEnvironmentInformationHelper.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkPVEnvironmentInformationHelper - Helper object that can
// be used to obtain information about an environment.
// .SECTION Description
// vtkPVEnvironmentInformationHelper can be used to get values of environment
// variables.

#ifndef vtkPVEnvironmentInformationHelper_h
#define vtkPVEnvironmentInformationHelper_h

#include "vtkPVClientServerCoreDefaultModule.h" //needed for exports
#include "vtkObject.h"

class VTKPVCLIENTSERVERCOREDEFAULT_EXPORT vtkPVEnvironmentInformationHelper : public vtkObject
{
public:
  static vtkPVEnvironmentInformationHelper* New();
  vtkTypeMacro(vtkPVEnvironmentInformationHelper, vtkObject);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Get/Set the environment variable that we want to get the value of
  vtkSetStringMacro(Variable);
  vtkGetStringMacro(Variable);

protected:
  vtkPVEnvironmentInformationHelper();
  ~vtkPVEnvironmentInformationHelper();

  char* Variable;

private:
  vtkPVEnvironmentInformationHelper(const vtkPVEnvironmentInformationHelper&) VTK_DELETE_FUNCTION;
  void operator=(const vtkPVEnvironmentInformationHelper&) VTK_DELETE_FUNCTION;
};


#endif

