/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#include "stdafx.h"
#include "patient/conditions/SEAorticStenosis.h"
#include "properties/SEScalar0To1.h"
PROTO_PUSH
#include "bind/cdm/PatientConditions.pb.h"
PROTO_POP

SEAorticStenosis::SEAorticStenosis() : SEPatientCondition()
{
	m_Severity = nullptr;
}

SEAorticStenosis::~SEAorticStenosis()
{
	Clear();
}

void SEAorticStenosis::Clear()
{
	SEPatientCondition::Clear();
	SAFE_DELETE(m_Severity);
}

bool SEAorticStenosis::IsValid() const
{
	return SEPatientCondition::IsValid() && HasSeverity();
}

void SEAorticStenosis::Load(const cdm::AorticStenosisData& src, SEAorticStenosis& dst)
{
	SEAorticStenosis::Serialize(src, dst);
}
void SEAorticStenosis::Serialize(const cdm::AorticStenosisData& src, SEAorticStenosis& dst)
{
	SEPatientCondition::Serialize(src.patientcondition(), dst);
	if (src.has_severity())
		SEScalar0To1::Load(src.severity(), dst.GetSeverity());
}

cdm::AorticStenosisData* SEAorticStenosis::Unload(const SEAorticStenosis& src)
{
	cdm::AorticStenosisData* dst = new cdm::AorticStenosisData();
	SEAorticStenosis::Serialize(src, *dst);
	return dst;
}
void SEAorticStenosis::Serialize(const SEAorticStenosis& src, cdm::AorticStenosisData& dst)
{
	SEPatientCondition::Serialize(src, *dst.mutable_patientcondition());
	if (src.HasSeverity())
		dst.set_allocated_severity(SEScalar0To1::Unload(*src.m_Severity));
}

bool SEAorticStenosis::HasSeverity() const
{
	return m_Severity == nullptr ? false : m_Severity->IsValid();
}

SEScalar0To1& SEAorticStenosis::GetSeverity()
{
	if (m_Severity == nullptr)
		m_Severity = new SEScalar0To1();
	return *m_Severity;
}

void SEAorticStenosis::ToString(std::ostream &str) const
{
	str << "Patient Condition : Aortic Stenosis";
	if (HasComment())
		str << "\n\tComment: " << m_Comment;
	str << "\n\tSeverity: "; HasSeverity() ? str << m_Severity : str << "NaN";
	str << std::flush;
}