/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#include "stdafx.h"
#include "patient/conditions/SEAorticRegurgitation.h"
#include "properties/SEScalar0To1.h"
PROTO_PUSH
#include "bind/cdm/PatientConditions.pb.h"
PROTO_POP

SEAorticRegurgitation::SEAorticRegurgitation() : SEPatientCondition()
{
	m_Severity = nullptr;
}

SEAorticRegurgitation::~SEAorticRegurgitation()
{
	Clear();
}

void SEAorticRegurgitation::Clear()
{
	SEPatientCondition::Clear();
	SAFE_DELETE(m_Severity);
}

bool SEAorticRegurgitation::IsValid() const
{
	return SEPatientCondition::IsValid() && HasSeverity();
}

void SEAorticRegurgitation::Load(const cdm::AorticRegurgitationData& src, SEAorticRegurgitation& dst)
{
	SEAorticRegurgitation::Serialize(src, dst);
}
void SEAorticRegurgitation::Serialize(const cdm::AorticRegurgitationData& src, SEAorticRegurgitation& dst)
{
	SEPatientCondition::Serialize(src.patientcondition(), dst);
	if (src.has_severity())
		SEScalar0To1::Load(src.severity(), dst.GetSeverity());
}

cdm::AorticRegurgitationData* SEAorticRegurgitation::Unload(const SEAorticRegurgitation& src)
{
	cdm::AorticRegurgitationData* dst = new cdm::AorticRegurgitationData();
	SEAorticRegurgitation::Serialize(src, *dst);
	return dst;
}
void SEAorticRegurgitation::Serialize(const SEAorticRegurgitation& src, cdm::AorticRegurgitationData& dst)
{
	SEPatientCondition::Serialize(src, *dst.mutable_patientcondition());
	if (src.HasSeverity())
		dst.set_allocated_severity(SEScalar0To1::Unload(*src.m_Severity));
}

bool SEAorticRegurgitation::HasSeverity() const
{
	return m_Severity == nullptr ? false : m_Severity->IsValid();
}

SEScalar0To1& SEAorticRegurgitation::GetSeverity()
{
	if (m_Severity == nullptr)
		m_Severity = new SEScalar0To1();
	return *m_Severity;
}

void SEAorticRegurgitation::ToString(std::ostream &str) const
{
	str << "Patient Condition : Aortic Regurgitation";
	if (HasComment())
		str << "\n\tComment: " << m_Comment;
	str << "\n\tSeverity: "; HasSeverity() ? str << m_Severity : str << "NaN";
	str << std::flush;
}