//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2019 Sandia Corporation.
//  Copyright 2019 UT-Battelle, LLC.
//  Copyright 2019 Los Alamos National Security.
//
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================

#ifndef vtkmLookupTable_h
#define vtkmLookupTable_h

#include "vtkCommonCoreModule.h" // For export macro
#include "vtkLookupTable.h"

namespace internal
{
VTK_ABI_NAMESPACE_BEGIN

struct VtkmTables;

VTK_ABI_NAMESPACE_END
} // internal

VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkmLookupTable : public vtkLookupTable
{
public:
  static vtkmLookupTable* New();

  vtkTypeMacro(vtkmLookupTable, vtkLookupTable);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void Build() override;

  using Superclass::MapScalars;
  vtkUnsignedCharArray* MapScalars(
    vtkAbstractArray* scalars, int colorMode, int component, int outputFormat = VTK_RGBA) override;

  const internal::VtkmTables& GetVtkmTables() const;

protected:
  vtkmLookupTable();
  ~vtkmLookupTable() override;

  void MapScalarsThroughTable2(void* input, unsigned char* output, int inputDataType,
    int numberOfValues, int inputIncrement, int outputFormat) override;

private:
  vtkmLookupTable(const vtkmLookupTable&) = delete;
  void operator=(const vtkmLookupTable&) = delete;

  struct InternalMembers;
  std::unique_ptr<InternalMembers> Detail;
};
VTK_ABI_NAMESPACE_END

#endif // vtkmLookupTable_h
