/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmConfigureTemplate_h
#define cmConfigureTemplate_h

#include <cmConfigure.h> // IWYU pragma: keep

#include <cmsys/RegularExpression.hxx>

#include <map>
#include <string>
#include <vector>

#include "cmNewLineStyle.h"
#include "cmState.h"
#include "cmake.h"

class cmConfigureTemplate
{
public:
  cmConfigureTemplate();
  virtual ~cmConfigureTemplate();

  void SetWarnUninitialized(bool warnUninitialized);
  void SetCheckSystemVars(bool checkSystemVars);

  void SetOverrides(std::map<std::string, std::string> const& overrides);

  virtual cmake::MessageType ExpandVariablesInString(
    cmState::Snapshot stateSnapshot, std::string& errorstr,
    std::string& source, bool escapeQuotes, bool noEscapes, bool atOnly,
    const char* filename, long line, bool removeEmpty, bool replaceAt,
    std::map<std::string, const char*>* substitutions,
    std::vector<std::string>& uninitializedSubstitutions) const;

  cmake::MessageType ConfigureString(
    cmState::Snapshot stateSnapshot, std::string const& input,
    std::string& errorstr, std::string& source, bool escapeQuotes, bool atOnly,
    const char* filename, long line,
    std::map<std::string, const char*>* substitutions,
    std::vector<std::string>& uninitializedSubstitutions) const;

  cmake::MessageType ConfigureFile(
    cmState::Snapshot stateSnapshot, std::string const& outFile,
    std::string const& inFile, bool escapeQuotes, bool atOnly,
    const cmNewLineStyle& newLine, std::string& errorstr,
    std::map<std::string, const char*>* substitutions,
    std::vector<std::string>& uninitializedSubstitutions) const;

private:
  cmState::Snapshot StateSnapshot;
  mutable cmsys::RegularExpression cmNamedCurly;
  mutable cmsys::RegularExpression cmDefineRegex;
  mutable cmsys::RegularExpression cmDefine01Regex;

  bool WarnUninitialized;
  bool CheckSystemVars;

  std::map<std::string, std::string> Overrides;

  const char* GetDefinition(cmState::Snapshot stateSnapshot,
                            std::string const& name) const;
};

#endif
