/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmCMP0053ConfigureTemplate_h
#define cmCMP0053ConfigureTemplate_h

#include "cmConfigureTemplate.h"
#include "cmMakefile.h"

class cmCMP0053ConfigureTemplate : public cmConfigureTemplate
{
public:
  cmCMP0053ConfigureTemplate(cmMakefile const* mf);

  cmake::MessageType ExpandVariablesInString(
    cmState::Snapshot stateSnapshot, std::string& errorstr,
    std::string& source, bool escapeQuotes, bool noEscapes, bool atOnly,
    const char* filename, long line, bool removeEmpty, bool replaceAt,
    std::map<std::string, const char*>* substitutions,
    std::vector<std::string>& uninitializedSubstitutions) const CM_OVERRIDE;

private:
  cmMakefile const* MF;

  cmake::MessageType ExpandVariablesInStringOld(
    std::string& errorstr, std::string& source, bool escapeQuotes,
    bool noEscapes, bool atOnly, const char* filename, long line,
    bool removeEmpty, bool replaceAt) const;

  mutable cmsys::RegularExpression cmAtVarRegex;
};

#endif
