
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

cmake_path(CMAKE_PATH path "/x/y/z/../../a/d")
if (NOT path STREQUAL "/x/y/z/../../a/d")
  list (APPEND errors "'${path}' instead of '/x/y/z/../../a/d'")
endif()
cmake_path(CMAKE_PATH path NORMALIZE "/x/y/z/../../a/d")
if (NOT path STREQUAL "/x/a/d")
  list (APPEND errors "'${path}' instead of '/x/a/d'")
endif()

if (WIN32)
  cmake_path(CMAKE_PATH path "/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "/x/y/z/../../a/d")
    list (APPEND errors "'${path}' instead of '/x/y/z/../../a/d'")
  endif()
  cmake_path(CMAKE_PATH path NORMALIZE "/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "/x/a/d")
    list (APPEND errors "'${path}' instead of '/x/a/d'")
  endif()

  cmake_path(CMAKE_PATH path "//?/c:/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "c:/x/y/z/../../a/d")
    list (APPEND errors "'${path}' instead of 'c:/x/y/z/../../a/d'")
  endif()
  cmake_path(CMAKE_PATH path NORMALIZE "//?/c:/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "c:/x/a/d")
    list (APPEND errors "'${path}' instead of 'c:/x/a/d'")
  endif()

  cmake_path(CMAKE_PATH path "\\\\?\\UNC/host/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "//host/x/y/z/../../a/d")
    list (APPEND errors "'${path}' instead of '//host/x/y/z/../../a/d'")
  endif()
  cmake_path(CMAKE_PATH path NORMALIZE "\\\\?\\UNC\\host/x\\y/z\\..\\../a/d")
  if (NOT path STREQUAL "//host/x/a/d")
    list (APPEND errors "'${path}' instead of '//host/x/a/d'")
  endif()
endif()

check_errors (CMAKE_PATH ${errors})
