//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2014 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
//  Copyright 2014 UT-Battelle, LLC.
//  Copyright 2014 Los Alamos National Security.
//
//  Under the terms of Contract DE-NA0003525 with NTESS,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by FunctionInterfaceDetailPost.h.in

#ifndef vtk_m_internal_FunctionInterfaceDetailPost_h
#define vtk_m_internal_FunctionInterfaceDetailPost_h

#if !defined(vtk_m_internal_FunctionInterface_h) && !defined(VTKM_TEST_HEADER_BUILD)
#error FunctionInterfaceDetailPre.h must be included from FunctionInterface.h
#endif

#include <vtkm/internal/FunctionInterface.h>

#if VTKM_MAX_FUNCTION_PARAMETERS != 10
#error Mismatch of maximum parameters between FunctionInterfaceDatailPre.h.in and FunctionInterfaceDetailPost.h.in
#endif


namespace vtkm
{
namespace internal
{

namespace detail
{

//============================================================================

// clang-format off

template<typename Transform,
         typename R>
struct FunctionInterfaceStaticTransformType<R(), Transform>
{
  typedef R(type)(
        );
};

template<typename Transform,
         typename R,
         typename P1>
struct FunctionInterfaceStaticTransformType<R(P1), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2>
struct FunctionInterfaceStaticTransformType<R(P1,P2), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5,P6), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type,
        typename Transform::template ReturnType<P6,6>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5,P6,P7), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type,
        typename Transform::template ReturnType<P6,6>::type,
        typename Transform::template ReturnType<P7,7>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5,P6,P7,P8), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type,
        typename Transform::template ReturnType<P6,6>::type,
        typename Transform::template ReturnType<P7,7>::type,
        typename Transform::template ReturnType<P8,8>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5,P6,P7,P8,P9), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type,
        typename Transform::template ReturnType<P6,6>::type,
        typename Transform::template ReturnType<P7,7>::type,
        typename Transform::template ReturnType<P8,8>::type,
        typename Transform::template ReturnType<P9,9>::type
        );
};

template<typename Transform,
         typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
struct FunctionInterfaceStaticTransformType<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10), Transform>
{
  typedef R(type)(
        typename Transform::template ReturnType<P1,1>::type,
        typename Transform::template ReturnType<P2,2>::type,
        typename Transform::template ReturnType<P3,3>::type,
        typename Transform::template ReturnType<P4,4>::type,
        typename Transform::template ReturnType<P5,5>::type,
        typename Transform::template ReturnType<P6,6>::type,
        typename Transform::template ReturnType<P7,7>::type,
        typename Transform::template ReturnType<P8,8>::type,
        typename Transform::template ReturnType<P9,9>::type,
        typename Transform::template ReturnType<P10,10>::type
        );
};


// clang-format on

} // namespace detail

//============================================================================

// clang-format off

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R>
VTKM_EXEC_CONT
FunctionInterface<R()>
make_FunctionInterface(
  )
{
  detail::ParameterContainer<R()> container =
    {
    };

  return FunctionInterface<R()>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1>
VTKM_EXEC_CONT
FunctionInterface<R(P1)>
make_FunctionInterface(
  const P1& p1
  )
{
  detail::ParameterContainer<R(P1)> container =
    {
    p1
    };

  return FunctionInterface<R(P1)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2
  )
{
  detail::ParameterContainer<R(P1,P2)> container =
    {
    p1,
    p2
    };

  return FunctionInterface<R(P1,P2)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3
  )
{
  detail::ParameterContainer<R(P1,P2,P3)> container =
    {
    p1,
    p2,
    p3
    };

  return FunctionInterface<R(P1,P2,P3)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4)> container =
    {
    p1,
    p2,
    p3,
    p4
    };

  return FunctionInterface<R(P1,P2,P3,P4)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5,P6)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5,
  const P6& p6
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5,P6)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5,
    p6
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5,P6)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5,
  const P6& p6,
  const P7& p7
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5,
    p6,
    p7
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5,
  const P6& p6,
  const P7& p7,
  const P8& p8
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5,
    p6,
    p7,
    p8
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5,
  const P6& p6,
  const P7& p7,
  const P8& p8,
  const P9& p9
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5,
    p6,
    p7,
    p8,
    p9
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9)>{container};
}

/// \brief Create a \c FunctionInterface
///
/// \c make_FunctionInterface is a function that takes a variable number of
/// arguments and returns a \c FunctionInterface object containing these
/// objects. Since the return type for the function signature is not specified,
/// you must always specify it as a template parameter
///
/// \code{.cpp}
/// vtkm::internal::FunctionInterface<void(int,double,char)> functionInterface =
///     vtkm::internal::make_FunctionInterface<void>(1, 2.5, 'a');
/// \endcode
///
VTKM_SUPPRESS_EXEC_WARNINGS
template<typename R,
         typename P1,
         typename P2,
         typename P3,
         typename P4,
         typename P5,
         typename P6,
         typename P7,
         typename P8,
         typename P9,
         typename P10>
VTKM_EXEC_CONT
FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>
make_FunctionInterface(
  const P1& p1,
  const P2& p2,
  const P3& p3,
  const P4& p4,
  const P5& p5,
  const P6& p6,
  const P7& p7,
  const P8& p8,
  const P9& p9,
  const P10& p10
  )
{
  detail::ParameterContainer<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> container =
    {
    p1,
    p2,
    p3,
    p4,
    p5,
    p6,
    p7,
    p8,
    p9,
    p10
    };

  return FunctionInterface<R(P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)>{container};
}


// clang-format off

}
} // namespace vtkm::internal

#endif //vtk_m_internal_FunctionInterfaceDetailPost_h
