/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   =========================================================================*/

#include "imstkTetMeshToPointCH.h"

#include "imstkCollidingObject.h"
#include "imstkCollisionData.h"
#include "imstkDeformableObject.h"

#include "imstkGeometry.h"
#include "imstkMesh.h"
#include "imstkVolumetricMesh.h"
#include "imstkTetrahedralMesh.h"

#include <g3log/g3log.hpp>

namespace imstk
{

void
TetMeshToPointCH::handleCollision()
{
    if (m_object->getCollidingGeometry()->getType() == Geometry::Type::TetrahedralMesh)
    {
        auto & removedElem = std::dynamic_pointer_cast<Mesh>(m_object->getCollidingGeometry())->getRemovedElems();
        auto & removedElemStatus = removedElem.first;
        removedElemStatus = false;
        auto & removedElemIds = removedElem.second;
        const auto & removedTetId = m_colData.PTColData.tetId; // Get the recently touched tet id
        if (m_colData.PTColData.touchStatus)
        {
            if (std::find(removedElemIds.begin(), removedElemIds.end(), removedTetId) == removedElemIds.end())
            {
                removedElemIds.push_back(removedTetId);
                removedElemStatus = true;
            }
        }
        // Attach data to the mesh
        std::dynamic_pointer_cast<Mesh>(m_object->getCollidingGeometry())->setRemovedElems(removedElem);
    }
}

} //imstk
