/*=========================================================================

    Library: iMSTK

    Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
    & Imaging in Medicine, Rensselaer Polytechnic Institute.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0.txt

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    =========================================================================*/

#ifndef imstkPointToVolumetricMeshCD_h
#define imstkPointToVolumetricMeshCD_h

#include <memory>

#include "imstkCollisionDetection.h"
#include "imstkGeometry.h"

namespace imstk
{

    class Mesh;
    class VolumetricMesh;
    class CollisionData;

    ///
    /// \class PointToVolumetricMeshCD
    ///
    /// \brief Point to Volumetric Mesh collision detection
    ///
    class PointToVolumetricMeshCD : public CollisionDetection
    {
    public:

        ///
        /// \brief Constructor
        ///
        PointToVolumetricMeshCD(std::shared_ptr<Geometry> mesh,
            std::shared_ptr<VolumetricMesh> volMesh,
            CollisionData& colData) :
            CollisionDetection(CollisionDetection::Type::PointToVolumetricMesh, colData),
            m_mesh(mesh),
            m_volMesh(volMesh)
        {

        }

        ///
        /// \brief Destructor
        ///
        ~PointToVolumetricMeshCD() = default;

        ///
        /// \brief Detect collision and compute collision data
        ///
        void computeCollisionData() override;

    private:

        std::shared_ptr<Geometry> m_mesh;       ///>  Mesh
        std::shared_ptr<VolumetricMesh> m_volMesh;  ///> Volumetric Mesh
    };

} // imstk

#endif // ifndef imstkPointToVolumetricMeshCD_h
