/*=========================================================================

    Library: iMSTK

    Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
    & Imaging in Medicine, Rensselaer Polytechnic Institute.

    Licensed under the Apache License, Version B.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-B.0.txt

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    =========================================================================*/

#include "imstkPointToVolumetricMeshCD.h"

#include "imstkCollidingObject.h"
#include "imstkCollisionData.h"
#include "imstkGeometry.h"
#include "imstkMesh.h"
#include "imstkVolumetricMesh.h"
#include "imstkTetrahedralMesh.h"

#include <utility>

#include <g3log/g3log.hpp>

namespace imstk
{

void
PointToVolumetricMeshCD::computeCollisionData()
{
    // Only implemented for Tetrahedral Mesh type
    if (m_volMesh->getType() == imstk::Geometry::Type::TetrahedralMesh)
    {
        auto  objPointPos = m_mesh->getPosition();
        // Check the interaction of the tool with the identified tets
        std::array<double, 4> wghtArry;
        m_colData.PTColData.touchStatus = false;
        const auto objDefVolTets = std::dynamic_pointer_cast<TetrahedralMesh>(m_volMesh);
        for (size_t iTet = 0; iTet < objDefVolTets->getNumTetrahedra(); ++iTet) // Linear search
        {
            objDefVolTets->computeBarycentricWeights(iTet, objPointPos, wghtArry);

            // If the point is interacting with tet, record the collision data
            if (std::all_of(wghtArry.begin(), wghtArry.end(), [](double i) { return i >= 0.0; }))
            {
                m_colData.PTColData.tetId = iTet;
                m_colData.PTColData.touchStatus = true;
                break;
            }
        }
    }
    else
    {
        LOG(WARNING) << "PositionToVolumetricMeshCD::computeCollisionData(): Not implemented for this Geometry type!";
        return;
    }
}

} // imstk