/*=========================================================================

   Library: iMSTK

   Copyright (c) Kitware, Inc. & Center for Modeling, Simulation,
   & Imaging in Medicine, Rensselaer Polytechnic Institute.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0.txt

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

=========================================================================*/

#ifndef imstkLineSegmentToPlaneCD_h
#define imstkLineSegmentToPlaneCD_h

#include <vector>

#include "imstkCollisionDetection.h"
#include "imstkCollisionData.h"
#include "imstkPointSet.h"
#include "imstkPlane.h"
#include "imstkMath.h"

namespace imstk
{
class DeviceTracker;

///
/// \class LineSegmentToPlaneCD
///
/// \brief Line segment to plane collision
///
class LineSegmentToPlaneCD : public CollisionDetection
{
public:

	///
	/// \brief Constructor
	///
    LineSegmentToPlaneCD(std::shared_ptr<Plane>& plane,
		std::shared_ptr<DeviceTracker> tracker,
		Vec3d startPoint,
        Vec3d endPoint,
		CollisionData& colData) :
		CollisionDetection(CollisionDetection::Type::LineSegmentToPlane,
			colData),
		m_tracker(tracker),
        m_startPoint(startPoint),
        m_endPoint(endPoint),
        m_plane(plane)
	{        
        m_colData.clearAll();
    }

	///
	/// \brief Destructor
	///
    ~LineSegmentToPlaneCD() { m_colData.clearAll(); };

	///
	/// \brief Detect collision and compute collision data
	///
    void computeCollisionData();

private:
    Vec3d m_startPoint, m_endPoint;
    Vec3d m_currentStartPoint, m_currentEndPoint;

    std::shared_ptr<Plane> m_plane;
    std::shared_ptr<DeviceTracker> m_tracker;
};
}

#endif // ifndef imstkPointSetToNeedleCD_h
